/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.geneticsresequenced.util;

import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u0019\u001a\u00020\t2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u0011J\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0 2\u0006\u0010\u001e\u001a\u00020\u00112\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\"J\u0014\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&R\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006("}, d2={"Ldev/aaronhowser/mods/geneticsresequenced/util/OtherUtil;", "", "<init>", "()V", "modResource", "Lnet/minecraft/resources/ResourceLocation;", "path", "", "itemStack", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/level/ItemLike;", "getItemStack", "(Lnet/minecraft/world/level/ItemLike;)Lnet/minecraft/world/item/ItemStack;", "getEntityType", "Lnet/minecraft/world/entity/EntityType;", "resourceLocation", "getLookedAtEntity", "Lnet/minecraft/world/entity/Entity;", "livingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "getPotionContents", "Lnet/minecraft/world/item/alchemy/PotionContents;", "getPotion", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/alchemy/Potion;", "getPotionStack", "potion", "getEnchantmentRegistry", "Lnet/minecraft/core/Registry;", "Lnet/minecraft/world/item/enchantment/Enchantment;", "entity", "getEnchantHolder", "Lnet/minecraft/core/Holder$Reference;", "enchantment", "Lnet/minecraft/resources/ResourceKey;", "componentList", "Lnet/minecraft/network/chat/MutableComponent;", "components", "", "Lnet/minecraft/network/chat/Component;", "geneticsresequenced-1.21.1"})
public final class OtherUtil {
    @NotNull
    public static final OtherUtil INSTANCE = new OtherUtil();

    private OtherUtil() {
    }

    @NotNull
    public final ResourceLocation modResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"geneticsresequenced", (String)path);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        return resourceLocation;
    }

    @NotNull
    public final ItemStack getItemStack(@NotNull ItemLike $this$itemStack) {
        Intrinsics.checkNotNullParameter((Object)$this$itemStack, (String)"<this>");
        ItemStack itemStack = $this$itemStack.asItem().getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
        return itemStack;
    }

    @NotNull
    public final EntityType<?> getEntityType(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
        Object object = BuiltInRegistries.ENTITY_TYPE.get(resourceLocation);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        EntityType entityType = (EntityType)object;
        if (entityType == EntityType.PIG && !Intrinsics.areEqual((Object)resourceLocation, (Object)BuiltInRegistries.ENTITY_TYPE.getDefaultKey())) {
            throw new IllegalArgumentException("Unknown entity type: " + resourceLocation);
        }
        return entityType;
    }

    @Nullable
    public final Entity getLookedAtEntity(@NotNull LivingEntity livingEntity) {
        EntityHitResult entityHitResult;
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        double reach = livingEntity.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
        EntityHitResult entityHitResult2 = entityHitResult = ProjectileUtil.getEntityHitResult((Entity)((Entity)livingEntity), (Vec3)livingEntity.getEyePosition(), (Vec3)livingEntity.getEyePosition().add(livingEntity.getLookAngle().scale(reach)), (AABB)livingEntity.getBoundingBox().inflate(reach), OtherUtil::getLookedAtEntity$lambda$0, (double)reach);
        return entityHitResult2 != null ? entityHitResult2.getEntity() : null;
    }

    @Nullable
    public final PotionContents getPotionContents(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        return (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
    }

    @Nullable
    public final Holder<Potion> getPotion(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Object object = this.getPotionContents(itemStack);
        return object != null && (object = object.potion()) != null ? (Holder)OptionalsKt.getOrNull((Optional)object) : null;
    }

    @NotNull
    public final ItemStack getPotionStack(@NotNull Holder<Potion> potion) {
        Intrinsics.checkNotNullParameter(potion, (String)"potion");
        ItemStack itemStack = PotionContents.createItemStack((Item)Items.POTION, potion);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"createItemStack(...)");
        return itemStack;
    }

    @NotNull
    public final Registry<Enchantment> getEnchantmentRegistry(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Registry registry = entity.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        return registry;
    }

    @NotNull
    public final Holder.Reference<Enchantment> getEnchantHolder(@NotNull Entity entity, @NotNull ResourceKey<Enchantment> enchantment) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(enchantment, (String)"enchantment");
        Holder.Reference reference = this.getEnchantmentRegistry(entity).getHolderOrThrow(enchantment);
        Intrinsics.checkNotNullExpressionValue((Object)reference, (String)"getHolderOrThrow(...)");
        return reference;
    }

    @NotNull
    public final MutableComponent componentList(@NotNull List<? extends Component> components) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        MutableComponent mutableComponent = Component.empty();
        for (Component component : components) {
            mutableComponent.append("\u2022 ").append(component);
            if (Intrinsics.areEqual((Object)component, (Object)CollectionsKt.last(components))) continue;
            mutableComponent.append("\n");
        }
        Intrinsics.checkNotNull((Object)mutableComponent);
        return mutableComponent;
    }

    private static final boolean getLookedAtEntity$lambda$0(Entity it) {
        return true;
    }
}

