/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.search;

import java.util.ArrayList;
import java.util.List;

public final class QueryStringSplitter {
    private QueryStringSplitter() {
    }

    public static List<String> split(String query) {
        ArrayList<String> terms = new ArrayList<String>();
        StringBuilder currentTerm = new StringBuilder();
        boolean insideQuotes = false;
        int i = 0;
        while (i < query.length()) {
            char ch = query.charAt(i);
            if (ch == '\"' || ch == '\'') {
                if (insideQuotes) {
                    terms.add(currentTerm.toString());
                    currentTerm.setLength(0);
                    insideQuotes = false;
                } else {
                    insideQuotes = true;
                }
                ++i;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                if (insideQuotes) {
                    currentTerm.append(ch);
                } else if (!currentTerm.isEmpty()) {
                    terms.add(currentTerm.toString());
                    currentTerm.setLength(0);
                }
                ++i;
                continue;
            }
            currentTerm.append(ch);
            ++i;
        }
        if (!currentTerm.isEmpty()) {
            terms.add(currentTerm.toString());
        }
        return terms;
    }
}

