/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.facetset;

import guideme.internal.shaded.lucene.document.IntPoint;
import guideme.internal.shaded.lucene.facet.FacetCountsWithFilterQuery;
import guideme.internal.shaded.lucene.facet.FacetResult;
import guideme.internal.shaded.lucene.facet.FacetsCollector;
import guideme.internal.shaded.lucene.facet.LabelAndValue;
import guideme.internal.shaded.lucene.facet.facetset.FacetSetDecoder;
import guideme.internal.shaded.lucene.facet.facetset.FacetSetMatcher;
import guideme.internal.shaded.lucene.index.BinaryDocValues;
import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.PriorityQueue;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MatchingFacetSetsCounts
extends FacetCountsWithFilterQuery {
    private final FacetSetMatcher[] facetSetMatchers;
    private final int[] counts;
    private final String field;
    private final FacetSetDecoder facetSetDecoder;
    private final int totCount;

    public MatchingFacetSetsCounts(String field, FacetsCollector hits, FacetSetDecoder facetSetDecoder, FacetSetMatcher ... facetSetMatchers) throws IOException {
        this(field, hits, facetSetDecoder, (Query)null, facetSetMatchers);
    }

    public MatchingFacetSetsCounts(String field, FacetsCollector hits, FacetSetDecoder facetSetDecoder, Query fastMatchQuery, FacetSetMatcher ... facetSetMatchers) throws IOException {
        super(fastMatchQuery);
        if (facetSetMatchers == null || facetSetMatchers.length == 0) {
            throw new IllegalArgumentException("facetSetMatchers cannot be null or empty");
        }
        if (MatchingFacetSetsCounts.areFacetSetMatcherDimensionsInconsistent(facetSetMatchers)) {
            throw new IllegalArgumentException("All facet set matchers must be the same dimensionality");
        }
        this.field = field;
        this.facetSetDecoder = facetSetDecoder;
        this.facetSetMatchers = facetSetMatchers;
        this.counts = new int[facetSetMatchers.length];
        this.totCount = this.count(field, hits.getMatchingDocs());
    }

    private int count(String field, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        int totCount = 0;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            BinaryDocValues binaryDocValues;
            DocIdSetIterator it = this.createIterator(hits, binaryDocValues = DocValues.getBinary(hits.context().reader(), field));
            if (it == null) continue;
            long[] dimValues = null;
            int expectedNumDims = -1;
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                boolean shouldCountDoc = false;
                BytesRef bytesRef = binaryDocValues.binaryValue();
                byte[] packedValue = bytesRef.bytes;
                int numDims = IntPoint.decodeDimension(packedValue, 0);
                if (expectedNumDims == -1) {
                    expectedNumDims = numDims;
                    dimValues = new long[numDims];
                } else assert (numDims == expectedNumDims) : "Expected (" + expectedNumDims + ") dimensions, found (" + numDims + ") for doc (" + doc + ")";
                int start = 4;
                while (start < bytesRef.length) {
                    start += this.facetSetDecoder.decode(bytesRef, start, dimValues);
                    for (int j = 0; j < this.facetSetMatchers.length; ++j) {
                        if (!this.facetSetMatchers[j].matches(dimValues)) continue;
                        int n = j;
                        this.counts[n] = this.counts[n] + 1;
                        shouldCountDoc = true;
                    }
                }
                if (shouldCountDoc) {
                    ++totCount;
                }
                doc = it.nextDoc();
            }
        }
        return totCount;
    }

    @Override
    public FacetResult getAllChildren(String dim, String ... path) throws IOException {
        if (!this.field.equals(dim)) {
            throw new IllegalArgumentException("invalid dim \"" + dim + "\"; should be \"" + this.field + "\"");
        }
        if (path != null && path.length != 0) {
            throw new IllegalArgumentException("path.length should be 0");
        }
        LabelAndValue[] labelValues = new LabelAndValue[this.counts.length];
        for (int i = 0; i < this.counts.length; ++i) {
            labelValues[i] = new LabelAndValue(this.facetSetMatchers[i].label, this.counts[i]);
        }
        return new FacetResult(dim, path, this.totCount, labelValues, labelValues.length);
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        MatchingFacetSetsCounts.validateTopN(topN);
        topN = Math.min(topN, this.counts.length);
        PriorityQueue<Entry> pq = new PriorityQueue<Entry>(this, topN, () -> new Entry("", 0)){

            @Override
            protected boolean lessThan(Entry a, Entry b) {
                return MatchingFacetSetsCounts.compare(a.count, b.count, a.label, b.label) < 0;
            }
        };
        int childCount = 0;
        Entry reuse = (Entry)pq.top();
        for (int i = 0; i < this.counts.length; ++i) {
            int count = this.counts[i];
            if (count <= 0) continue;
            ++childCount;
            String label = this.facetSetMatchers[i].label;
            if (MatchingFacetSetsCounts.compare(reuse.count, count, reuse.label, label) >= 0) continue;
            reuse.label = label;
            reuse.count = count;
            reuse = (Entry)pq.updateTop();
        }
        while (childCount < pq.size()) {
            pq.pop();
        }
        LabelAndValue[] labelValues = new LabelAndValue[Math.min(topN, childCount)];
        for (int i = pq.size() - 1; i >= 0; --i) {
            Entry e = (Entry)pq.pop();
            labelValues[i] = new LabelAndValue(e.label, e.count);
        }
        return new FacetResult(dim, path, this.totCount, labelValues, childCount);
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        MatchingFacetSetsCounts.validateTopN(topN);
        return Collections.singletonList(this.getTopChildren(topN, this.field, new String[0]));
    }

    private static boolean areFacetSetMatcherDimensionsInconsistent(FacetSetMatcher[] facetSetMatchers) {
        int dims = facetSetMatchers[0].dims;
        return Arrays.stream(facetSetMatchers).anyMatch(facetSetMatcher -> facetSetMatcher.dims != dims);
    }

    private static int compare(int count1, int count2, String label1, String label2) {
        int cmp = Integer.compare(count1, count2);
        if (cmp == 0) {
            cmp = label2.compareTo(label1);
        }
        return cmp;
    }

    private static final class Entry {
        String label;
        int count;

        Entry(String label, int count) {
            this.label = label;
            this.count = count;
        }
    }
}

