/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.snowball;

import guideme.internal.shaded.snowball.Among;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;

public class SnowballProgram
implements Serializable {
    static final long serialVersionUID = 2016072500L;
    private char[] current;
    protected int cursor;
    protected int length;
    protected int limit;
    protected int limit_backward;
    protected int bra;
    protected int ket;

    protected SnowballProgram() {
        this.setCurrent("");
    }

    public void setCurrent(String value) {
        this.setCurrent(value.toCharArray(), value.length());
    }

    public String getCurrent() {
        return new String(this.current, 0, this.length);
    }

    public void setCurrent(char[] text, int length) {
        this.current = text;
        this.cursor = 0;
        this.length = this.limit = length;
        this.limit_backward = 0;
        this.bra = this.cursor;
        this.ket = this.limit;
    }

    public char[] getCurrentBuffer() {
        return this.current;
    }

    public int getCurrentBufferLength() {
        return this.length;
    }

    public SnowballProgram(SnowballProgram other) {
        this.current = other.current;
        this.cursor = other.cursor;
        this.length = other.length;
        this.limit = other.limit;
        this.limit_backward = other.limit_backward;
        this.bra = other.bra;
        this.ket = other.ket;
    }

    protected void copy_from(SnowballProgram other) {
        this.current = other.current;
        this.cursor = other.cursor;
        this.length = other.length;
        this.limit = other.limit;
        this.limit_backward = other.limit_backward;
        this.bra = other.bra;
        this.ket = other.ket;
    }

    protected boolean in_grouping(char[] s, int min, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current[this.cursor];
        if (ch > max || ch < min) {
            return false;
        }
        if ((s[(ch = (char)(ch - min)) >> 3] & 1 << (ch & 7)) == 0) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    protected boolean in_grouping_b(char[] s, int min, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current[this.cursor - 1];
        if (ch > max || ch < min) {
            return false;
        }
        if ((s[(ch = (char)(ch - min)) >> 3] & 1 << (ch & 7)) == 0) {
            return false;
        }
        --this.cursor;
        return true;
    }

    protected boolean out_grouping(char[] s, int min, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.current[this.cursor];
        if (ch > max || ch < min) {
            ++this.cursor;
            return true;
        }
        if ((s[(ch = (char)(ch - min)) >> 3] & 1 << (ch & 7)) == 0) {
            ++this.cursor;
            return true;
        }
        return false;
    }

    protected boolean out_grouping_b(char[] s, int min, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.current[this.cursor - 1];
        if (ch > max || ch < min) {
            --this.cursor;
            return true;
        }
        if ((s[(ch = (char)(ch - min)) >> 3] & 1 << (ch & 7)) == 0) {
            --this.cursor;
            return true;
        }
        return false;
    }

    protected boolean eq_s(CharSequence s) {
        if (this.limit - this.cursor < s.length()) {
            return false;
        }
        for (int i = 0; i != s.length(); ++i) {
            if (this.current[this.cursor + i] == s.charAt(i)) continue;
            return false;
        }
        this.cursor += s.length();
        return true;
    }

    protected boolean eq_s_b(CharSequence s) {
        if (this.cursor - this.limit_backward < s.length()) {
            return false;
        }
        for (int i = 0; i != s.length(); ++i) {
            if (this.current[this.cursor - s.length() + i] == s.charAt(i)) continue;
            return false;
        }
        this.cursor -= s.length();
        return true;
    }

    protected int find_among(Among[] v) {
        Among w;
        int i = 0;
        int j = v.length;
        int c = this.cursor;
        int l = this.limit;
        int common_i = 0;
        int common_j = 0;
        boolean first_key_inspected = false;
        while (true) {
            int k = i + (j - i >> 1);
            int diff = 0;
            int common = common_i < common_j ? common_i : common_j;
            Among w2 = v[k];
            for (int i2 = common; i2 < w2.s.length; ++i2) {
                if (c + common == l) {
                    diff = -1;
                    break;
                }
                diff = this.current[c + common] - w2.s[i2];
                if (diff != 0) break;
                ++common;
            }
            if (diff < 0) {
                j = k;
                common_j = common;
            } else {
                i = k;
                common_i = common;
            }
            if (j - i > 1) continue;
            if (i > 0 || j == i || first_key_inspected) break;
            first_key_inspected = true;
        }
        do {
            w = v[i];
            if (common_i < w.s.length) continue;
            this.cursor = c + w.s.length;
            if (w.method == null) {
                return w.result;
            }
            boolean res = false;
            try {
                res = w.method.invokeExact(this);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
            this.cursor = c + w.s.length;
            if (!res) continue;
            return w.result;
        } while ((i = w.substring_i) >= 0);
        return 0;
    }

    protected int find_among_b(Among[] v) {
        Among w;
        int i = 0;
        int j = v.length;
        int c = this.cursor;
        int lb = this.limit_backward;
        int common_i = 0;
        int common_j = 0;
        boolean first_key_inspected = false;
        while (true) {
            int k = i + (j - i >> 1);
            int diff = 0;
            int common = common_i < common_j ? common_i : common_j;
            Among w2 = v[k];
            for (int i2 = w2.s.length - 1 - common; i2 >= 0; --i2) {
                if (c - common == lb) {
                    diff = -1;
                    break;
                }
                diff = this.current[c - 1 - common] - w2.s[i2];
                if (diff != 0) break;
                ++common;
            }
            if (diff < 0) {
                j = k;
                common_j = common;
            } else {
                i = k;
                common_i = common;
            }
            if (j - i > 1) continue;
            if (i > 0 || j == i || first_key_inspected) break;
            first_key_inspected = true;
        }
        do {
            w = v[i];
            if (common_i < w.s.length) continue;
            this.cursor = c - w.s.length;
            if (w.method == null) {
                return w.result;
            }
            boolean res = false;
            try {
                res = w.method.invokeExact(this);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new UndeclaredThrowableException(e);
            }
            this.cursor = c - w.s.length;
            if (!res) continue;
            return w.result;
        } while ((i = w.substring_i) >= 0);
        return 0;
    }

    protected int replace_s(int c_bra, int c_ket, CharSequence s) {
        int adjustment = s.length() - (c_ket - c_bra);
        int newLength = this.length + adjustment;
        if (newLength > this.current.length) {
            this.current = Arrays.copyOf(this.current, newLength);
        }
        if (adjustment != 0 && c_ket < this.length) {
            System.arraycopy(this.current, c_ket, this.current, c_bra + s.length(), this.length - c_ket);
        }
        for (int i = 0; i < s.length(); ++i) {
            this.current[c_bra + i] = s.charAt(i);
        }
        this.length += adjustment;
        this.limit += adjustment;
        if (this.cursor >= c_ket) {
            this.cursor += adjustment;
        } else if (this.cursor > c_bra) {
            this.cursor = c_bra;
        }
        return adjustment;
    }

    protected void slice_check() {
        assert (this.bra >= 0) : "bra=" + this.bra;
        assert (this.bra <= this.ket) : "bra=" + this.bra + ",ket=" + this.ket;
        assert (this.limit <= this.length) : "limit=" + this.limit + ",length=" + this.length;
        assert (this.ket <= this.limit) : "ket=" + this.ket + ",limit=" + this.limit;
    }

    protected void slice_from(CharSequence s) {
        this.slice_check();
        this.replace_s(this.bra, this.ket, s);
    }

    protected void slice_del() {
        this.slice_from("");
    }

    protected void insert(int c_bra, int c_ket, CharSequence s) {
        int adjustment = this.replace_s(c_bra, c_ket, s);
        if (c_bra <= this.bra) {
            this.bra += adjustment;
        }
        if (c_bra <= this.ket) {
            this.ket += adjustment;
        }
    }

    protected void slice_to(StringBuilder s) {
        this.slice_check();
        int len = this.ket - this.bra;
        s.setLength(0);
        s.append(this.current, this.bra, len);
    }

    protected void assign_to(StringBuilder s) {
        s.setLength(0);
        s.append(this.current, 0, this.limit);
    }
}

