/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks.trims;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.handcrafted.common.blocks.base.Hammerable;
import earth.terrarium.handcrafted.common.blocks.base.SimpleBlock;
import earth.terrarium.handcrafted.common.blocks.base.properties.TrimProperty;
import earth.terrarium.handcrafted.common.constants.ConstantComponents;
import earth.terrarium.handcrafted.common.registry.ModSoundEvents;
import earth.terrarium.handcrafted.common.utils.TooltipUtils;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CornerTrimBlock
extends SimpleBlock
implements Hammerable {
    public static final MapCodec<CornerTrimBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("wood").forGetter(CornerTrimBlock::isWood), (App)CornerTrimBlock.propertiesCodec()).apply((Applicative)instance, CornerTrimBlock::new));
    public static final EnumProperty<TrimProperty> SHAPE = EnumProperty.create((String)"trim", TrimProperty.class);
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final VoxelShape NORMAL_TOP_NORTH = Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)8.0), Block.box((double)4.0, (double)8.0, (double)10.0, (double)12.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)2.0, (double)6.0, (double)4.0, (double)14.0, (double)12.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape NORMAL_TOP_EAST = Stream.of(Block.box((double)8.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0), Block.box((double)0.0, (double)8.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0), Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), Block.box((double)6.0, (double)6.0, (double)2.0, (double)12.0, (double)12.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape NORMAL_TOP_SOUTH = Stream.of(Block.box((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)6.0, (double)12.0), Block.box((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)12.0, (double)6.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0), Block.box((double)2.0, (double)6.0, (double)6.0, (double)14.0, (double)12.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape NORMAL_TOP_WEST = Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)8.0, (double)6.0, (double)12.0), Block.box((double)10.0, (double)8.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)6.0, (double)2.0, (double)10.0, (double)12.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape NORMAL_BOTTOM_NORTH = Stream.of(Block.box((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)8.0), Block.box((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)2.0, (double)4.0, (double)4.0, (double)14.0, (double)10.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape NORMAL_BOTTOM_EAST = Stream.of(Block.box((double)8.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.box((double)0.0, (double)4.0, (double)4.0, (double)6.0, (double)8.0, (double)12.0), Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0), Block.box((double)6.0, (double)4.0, (double)2.0, (double)12.0, (double)10.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape NORMAL_BOTTOM_SOUTH = Stream.of(Block.box((double)4.0, (double)10.0, (double)8.0, (double)12.0, (double)16.0, (double)12.0), Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)8.0, (double)6.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)12.0), Block.box((double)2.0, (double)4.0, (double)6.0, (double)14.0, (double)10.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape NORMAL_BOTTOM_WEST = Stream.of(Block.box((double)4.0, (double)10.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0), Block.box((double)10.0, (double)4.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)4.0, (double)4.0, (double)2.0, (double)10.0, (double)10.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THICC_TOP_NORTH = Stream.of(Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)6.0, (double)8.0), Block.box((double)0.0, (double)8.0, (double)10.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)6.0, (double)4.0, (double)16.0, (double)12.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THICC_TOP_EAST = Stream.of(Block.box((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)6.0, (double)16.0), Block.box((double)0.0, (double)8.0, (double)0.0, (double)6.0, (double)12.0, (double)16.0), Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), Block.box((double)6.0, (double)6.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THICC_TOP_SOUTH = Stream.of(Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)6.0, (double)12.0), Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)6.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0), Block.box((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)12.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THICC_TOP_WEST = Stream.of(Block.box((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)6.0, (double)16.0), Block.box((double)10.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)6.0, (double)0.0, (double)10.0, (double)12.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THICC_BOTTOM_NORTH = Stream.of(Block.box((double)0.0, (double)10.0, (double)4.0, (double)16.0, (double)16.0, (double)8.0), Block.box((double)0.0, (double)4.0, (double)10.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)10.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THICC_BOTTOM_EAST = Stream.of(Block.box((double)8.0, (double)10.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)6.0, (double)8.0, (double)16.0), Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0), Block.box((double)6.0, (double)4.0, (double)0.0, (double)12.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THICC_BOTTOM_SOUTH = Stream.of(Block.box((double)0.0, (double)10.0, (double)8.0, (double)16.0, (double)16.0, (double)12.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)6.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)12.0), Block.box((double)0.0, (double)4.0, (double)6.0, (double)16.0, (double)10.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THICC_BOTTOM_WEST = Stream.of(Block.box((double)4.0, (double)10.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), Block.box((double)10.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)4.0, (double)4.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THIN_TOP_NORTH = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)12.0, (double)6.0), Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)12.0, (double)16.0), Block.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)12.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THIN_TOP_EAST = Stream.of(Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), Block.box((double)10.0, (double)0.0, (double)6.0, (double)12.0, (double)12.0, (double)10.0), Block.box((double)0.0, (double)10.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0), Block.box((double)6.0, (double)6.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THIN_TOP_SOUTH = Stream.of(Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0), Block.box((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)12.0, (double)12.0), Block.box((double)6.0, (double)10.0, (double)0.0, (double)10.0, (double)12.0, (double)10.0), Block.box((double)4.0, (double)6.0, (double)6.0, (double)12.0, (double)12.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THIN_TOP_WEST = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)0.0, (double)6.0, (double)6.0, (double)12.0, (double)10.0), Block.box((double)6.0, (double)10.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0), Block.box((double)4.0, (double)6.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THIN_BOTTOM_NORTH = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0), Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)6.0, (double)4.0, (double)4.0, (double)10.0, (double)16.0, (double)6.0), Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)16.0), Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THIN_BOTTOM_EAST = Stream.of(Block.box((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0), Block.box((double)10.0, (double)4.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0), Block.box((double)0.0, (double)4.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.box((double)6.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THIN_BOTTOM_SOUTH = Stream.of(Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)12.0), Block.box((double)6.0, (double)4.0, (double)10.0, (double)10.0, (double)16.0, (double)12.0), Block.box((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)6.0, (double)10.0), Block.box((double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)10.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape THIN_BOTTOM_WEST = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), Block.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)4.0, (double)4.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0), Block.box((double)6.0, (double)4.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0), Block.box((double)4.0, (double)4.0, (double)4.0, (double)10.0, (double)10.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private final boolean wood;

    public CornerTrimBlock(boolean wood, BlockBehaviour.Properties properties) {
        super(properties);
        this.wood = wood;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)TrimProperty.NORMAL))).setValue(HALF, (Comparable)Half.BOTTOM)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SHAPE, HALF, WATERLOGGED});
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(pos);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && context.getClickLocation().y - (double)pos.getY() > 0.5) ? Half.BOTTOM : Half.TOP))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    @Override
    public void onHammer(Level level, BlockPos pos, BlockState state, Direction side, Player user, Vec3 hitPos) {
        level.setBlockAndUpdate(pos, (BlockState)state.cycle(SHAPE));
        level.playSound(null, pos, this.wood ? (SoundEvent)ModSoundEvents.HAMMER_WOOD.get() : (SoundEvent)ModSoundEvents.HAMMER_STONE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean isWood() {
        return this.wood;
    }

    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return switch ((Half)state.getValue(HALF)) {
            default -> throw new MatchException(null, null);
            case Half.TOP -> {
                switch ((TrimProperty)((Object)state.getValue(SHAPE))) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORMAL: {
                        switch ((Direction)state.getValue((Property)FACING)) {
                            case EAST: {
                                yield NORMAL_TOP_EAST;
                            }
                            case SOUTH: {
                                yield NORMAL_TOP_SOUTH;
                            }
                            case WEST: {
                                yield NORMAL_TOP_WEST;
                            }
                        }
                        yield NORMAL_TOP_NORTH;
                    }
                    case THIN: {
                        switch ((Direction)state.getValue((Property)FACING)) {
                            case EAST: {
                                yield THIN_TOP_EAST;
                            }
                            case SOUTH: {
                                yield THIN_TOP_SOUTH;
                            }
                            case WEST: {
                                yield THIN_TOP_WEST;
                            }
                        }
                        yield THIN_TOP_NORTH;
                    }
                    case THICC: 
                }
                switch ((Direction)state.getValue((Property)FACING)) {
                    case EAST: {
                        yield THICC_TOP_EAST;
                    }
                    case SOUTH: {
                        yield THICC_TOP_SOUTH;
                    }
                    case WEST: {
                        yield THICC_TOP_WEST;
                    }
                }
                yield THICC_TOP_NORTH;
            }
            case Half.BOTTOM -> {
                switch ((TrimProperty)((Object)state.getValue(SHAPE))) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case NORMAL: {
                        switch ((Direction)state.getValue((Property)FACING)) {
                            case EAST: {
                                yield NORMAL_BOTTOM_EAST;
                            }
                            case SOUTH: {
                                yield NORMAL_BOTTOM_SOUTH;
                            }
                            case WEST: {
                                yield NORMAL_BOTTOM_WEST;
                            }
                        }
                        yield NORMAL_BOTTOM_NORTH;
                    }
                    case THIN: {
                        switch ((Direction)state.getValue((Property)FACING)) {
                            case EAST: {
                                yield THIN_BOTTOM_EAST;
                            }
                            case SOUTH: {
                                yield THIN_BOTTOM_SOUTH;
                            }
                            case WEST: {
                                yield THIN_BOTTOM_WEST;
                            }
                        }
                        yield THIN_BOTTOM_NORTH;
                    }
                    case THICC: 
                }
                switch ((Direction)state.getValue((Property)FACING)) {
                    case EAST: {
                        yield THICC_BOTTOM_EAST;
                    }
                    case SOUTH: {
                        yield THICC_BOTTOM_SOUTH;
                    }
                    case WEST: {
                        yield THICC_BOTTOM_WEST;
                    }
                }
                yield THICC_BOTTOM_NORTH;
            }
        };
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        TooltipUtils.addDescriptionComponent(tooltipComponents, ConstantComponents.HAMMER_USE_SHAPE);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

