/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.connected.CTDyable;
import net.joefoxe.hexerei.block.connected.Waxed;
import net.joefoxe.hexerei.block.custom.ConnectingCarpetDyed;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbility;

public class ConnectingCarpetStairs
extends CarpetBlock
implements Waxed,
CTDyable {
    public static final BooleanProperty RIGHT = BooleanProperty.create((String)"right");
    public static final BooleanProperty LEFT = BooleanProperty.create((String)"left");
    public static BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final EnumProperty<North> NORTH = EnumProperty.create((String)"north", North.class);
    public static final EnumProperty<South> SOUTH = EnumProperty.create((String)"south", South.class);
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.create((String)"color", DyeColor.class);
    public Block parentBlock;
    protected static final VoxelShape VOXEL_SHAPE = Stream.of(Block.box((double)8.0, (double)0.0, (double)2.0, (double)16.0, (double)1.0, (double)14.0), Block.box((double)7.0, (double)-7.0, (double)2.0, (double)8.0, (double)0.0, (double)14.0), Block.box((double)-1.0, (double)-16.0, (double)2.0, (double)0.0, (double)-8.0, (double)14.0), Block.box((double)0.0, (double)-8.0, (double)2.0, (double)8.0, (double)-7.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE90 = Stream.of(Block.box((double)0.0, (double)0.0, (double)2.0, (double)8.0, (double)1.0, (double)14.0), Block.box((double)8.0, (double)-7.0, (double)2.0, (double)9.0, (double)0.0, (double)14.0), Block.box((double)16.0, (double)-16.0, (double)2.0, (double)17.0, (double)-8.0, (double)14.0), Block.box((double)8.0, (double)-8.0, (double)2.0, (double)16.0, (double)-7.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE180 = Stream.of(Block.box((double)2.0, (double)0.0, (double)8.0, (double)14.0, (double)1.0, (double)16.0), Block.box((double)2.0, (double)-7.0, (double)7.0, (double)14.0, (double)0.0, (double)8.0), Block.box((double)2.0, (double)-16.0, (double)-1.0, (double)14.0, (double)-8.0, (double)0.0), Block.box((double)2.0, (double)-8.0, (double)0.0, (double)14.0, (double)-7.0, (double)8.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE270 = Stream.of(Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)1.0, (double)8.0), Block.box((double)2.0, (double)-7.0, (double)8.0, (double)14.0, (double)0.0, (double)9.0), Block.box((double)2.0, (double)-16.0, (double)16.0, (double)14.0, (double)-8.0, (double)17.0), Block.box((double)2.0, (double)-8.0, (double)8.0, (double)14.0, (double)-7.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE_LEFT = Stream.of(Block.box((double)8.0, (double)0.0, (double)2.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)7.0, (double)-7.0, (double)2.0, (double)8.0, (double)0.0, (double)16.0), Block.box((double)-1.0, (double)-16.0, (double)2.0, (double)0.0, (double)-8.0, (double)16.0), Block.box((double)0.0, (double)-8.0, (double)2.0, (double)8.0, (double)-7.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE90_LEFT = Stream.of(Block.box((double)0.0, (double)0.0, (double)2.0, (double)8.0, (double)1.0, (double)16.0), Block.box((double)8.0, (double)-7.0, (double)2.0, (double)9.0, (double)0.0, (double)16.0), Block.box((double)16.0, (double)-16.0, (double)2.0, (double)17.0, (double)-8.0, (double)16.0), Block.box((double)8.0, (double)-8.0, (double)2.0, (double)16.0, (double)-7.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE180_LEFT = Stream.of(Block.box((double)2.0, (double)0.0, (double)8.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)2.0, (double)-7.0, (double)7.0, (double)16.0, (double)0.0, (double)8.0), Block.box((double)2.0, (double)-16.0, (double)-1.0, (double)16.0, (double)-8.0, (double)0.0), Block.box((double)2.0, (double)-8.0, (double)0.0, (double)16.0, (double)-7.0, (double)8.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE270_LEFT = Stream.of(Block.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)8.0), Block.box((double)2.0, (double)-7.0, (double)8.0, (double)16.0, (double)0.0, (double)9.0), Block.box((double)2.0, (double)-16.0, (double)16.0, (double)16.0, (double)-8.0, (double)17.0), Block.box((double)2.0, (double)-8.0, (double)8.0, (double)16.0, (double)-7.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE_RIGHT = Stream.of(Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)14.0), Block.box((double)7.0, (double)-7.0, (double)0.0, (double)8.0, (double)0.0, (double)14.0), Block.box((double)-1.0, (double)-16.0, (double)0.0, (double)0.0, (double)-8.0, (double)14.0), Block.box((double)0.0, (double)-8.0, (double)0.0, (double)8.0, (double)-7.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE90_RIGHT = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)1.0, (double)14.0), Block.box((double)8.0, (double)-7.0, (double)0.0, (double)9.0, (double)0.0, (double)14.0), Block.box((double)16.0, (double)-16.0, (double)0.0, (double)17.0, (double)-8.0, (double)14.0), Block.box((double)8.0, (double)-8.0, (double)0.0, (double)16.0, (double)-7.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE180_RIGHT = Stream.of(Block.box((double)0.0, (double)0.0, (double)8.0, (double)14.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)-7.0, (double)7.0, (double)14.0, (double)0.0, (double)8.0), Block.box((double)0.0, (double)-16.0, (double)-1.0, (double)14.0, (double)-8.0, (double)0.0), Block.box((double)0.0, (double)-8.0, (double)0.0, (double)14.0, (double)-7.0, (double)8.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE270_RIGHT = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)1.0, (double)8.0), Block.box((double)0.0, (double)-7.0, (double)8.0, (double)14.0, (double)0.0, (double)9.0), Block.box((double)0.0, (double)-16.0, (double)16.0, (double)14.0, (double)-8.0, (double)17.0), Block.box((double)0.0, (double)-8.0, (double)8.0, (double)14.0, (double)-7.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE_FULL = Stream.of(Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)7.0, (double)-7.0, (double)0.0, (double)8.0, (double)0.0, (double)16.0), Block.box((double)-1.0, (double)-16.0, (double)0.0, (double)0.0, (double)-8.0, (double)16.0), Block.box((double)0.0, (double)-8.0, (double)0.0, (double)8.0, (double)-7.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE90_FULL = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)1.0, (double)16.0), Block.box((double)8.0, (double)-7.0, (double)0.0, (double)9.0, (double)0.0, (double)16.0), Block.box((double)16.0, (double)-16.0, (double)0.0, (double)17.0, (double)-8.0, (double)16.0), Block.box((double)8.0, (double)-8.0, (double)0.0, (double)16.0, (double)-7.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE180_FULL = Stream.of(Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)-7.0, (double)7.0, (double)16.0, (double)0.0, (double)8.0), Block.box((double)0.0, (double)-16.0, (double)-1.0, (double)16.0, (double)-8.0, (double)0.0), Block.box((double)0.0, (double)-8.0, (double)0.0, (double)16.0, (double)-7.0, (double)8.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE270_FULL = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)8.0), Block.box((double)0.0, (double)-7.0, (double)8.0, (double)16.0, (double)0.0, (double)9.0), Block.box((double)0.0, (double)-16.0, (double)16.0, (double)16.0, (double)-8.0, (double)17.0), Block.box((double)0.0, (double)-8.0, (double)8.0, (double)16.0, (double)-7.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE_THICK_N = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)11.0), Block.box((double)0.0, (double)-8.0, (double)8.0, (double)16.0, (double)0.0, (double)11.0), Block.box((double)0.0, (double)-8.0, (double)11.0, (double)16.0, (double)-5.0, (double)19.0), Block.box((double)0.0, (double)-16.0, (double)16.0, (double)16.0, (double)-8.0, (double)19.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE_THICK_E = Stream.of(Block.box((double)5.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)5.0, (double)-8.0, (double)0.0, (double)8.0, (double)0.0, (double)16.0), Block.box((double)-3.0, (double)-8.0, (double)0.0, (double)5.0, (double)-5.0, (double)16.0), Block.box((double)-3.0, (double)-16.0, (double)0.0, (double)0.0, (double)-8.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE_THICK_S = Stream.of(Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)0.0, (double)-8.0, (double)5.0, (double)16.0, (double)0.0, (double)8.0), Block.box((double)0.0, (double)-8.0, (double)-3.0, (double)16.0, (double)-5.0, (double)5.0), Block.box((double)0.0, (double)-16.0, (double)-3.0, (double)16.0, (double)-8.0, (double)0.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape VOXEL_SHAPE_THICK_W = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)11.0, (double)3.0, (double)16.0), Block.box((double)8.0, (double)-8.0, (double)0.0, (double)11.0, (double)0.0, (double)16.0), Block.box((double)11.0, (double)-8.0, (double)0.0, (double)19.0, (double)-5.0, (double)16.0), Block.box((double)16.0, (double)-16.0, (double)0.0, (double)19.0, (double)-8.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    @Override
    public DyeColor getDyeColor(BlockState blockState) {
        if (blockState.hasProperty(COLOR)) {
            return (DyeColor)blockState.getValue(COLOR);
        }
        return DyeColor.WHITE;
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        boolean east = (Boolean)pState.getValue((Property)EAST);
        boolean west = (Boolean)pState.getValue((Property)WEST);
        North northState = (North)((Object)pState.getValue(NORTH));
        South southState = (South)((Object)pState.getValue(SOUTH));
        boolean north = northState == North.ALL || northState == North.JUST_NORTH || northState == North.NORTH_AND_NORTH_EAST || northState == North.NORTH_AND_NORTH_WEST;
        boolean north_east = northState == North.ALL || northState == North.JUST_NORTH_EAST || northState == North.NORTH_AND_NORTH_EAST || northState == North.NORTH_EAST_AND_NORTH_WEST;
        boolean north_west = northState == North.ALL || northState == North.JUST_NORTH_WEST || northState == North.NORTH_AND_NORTH_WEST || northState == North.NORTH_EAST_AND_NORTH_WEST;
        boolean south = southState == South.ALL || southState == South.JUST_SOUTH || southState == South.SOUTH_AND_SOUTH_EAST || southState == South.SOUTH_AND_SOUTH_WEST;
        boolean south_east = southState == South.ALL || southState == South.JUST_SOUTH_EAST || southState == South.SOUTH_AND_SOUTH_EAST || southState == South.SOUTH_EAST_AND_SOUTH_WEST;
        boolean south_west = southState == South.ALL || southState == South.JUST_SOUTH_WEST || southState == South.SOUTH_AND_SOUTH_WEST || southState == South.SOUTH_EAST_AND_SOUTH_WEST;
        switch (pRot) {
            case NONE: {
                return pState;
            }
            case CLOCKWISE_90: {
                North northTemp = North.NONE;
                South southTemp = South.NONE;
                if (south_east && east && north_east) {
                    southTemp = South.ALL;
                } else if (!south_east && east && north_east) {
                    southTemp = South.SOUTH_AND_SOUTH_EAST;
                } else if (south_east && east) {
                    southTemp = South.SOUTH_AND_SOUTH_WEST;
                } else if (south_east && north_east) {
                    southTemp = South.SOUTH_EAST_AND_SOUTH_WEST;
                } else if (!south_east && east) {
                    southTemp = South.JUST_SOUTH;
                } else if (!south_east && north_east) {
                    southTemp = South.JUST_SOUTH_EAST;
                } else if (south_east) {
                    southTemp = South.JUST_SOUTH_WEST;
                }
                if (south_west && west && north_west) {
                    northTemp = North.ALL;
                } else if (!south_west && west && north_west) {
                    northTemp = North.NORTH_AND_NORTH_EAST;
                } else if (south_west && west) {
                    northTemp = North.NORTH_AND_NORTH_WEST;
                } else if (south_west && north_west) {
                    northTemp = North.NORTH_EAST_AND_NORTH_WEST;
                } else if (!south_west && west) {
                    northTemp = North.JUST_NORTH;
                } else if (!south_west && north_west) {
                    northTemp = North.JUST_NORTH_EAST;
                } else if (south_west) {
                    northTemp = North.JUST_NORTH_WEST;
                }
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)EAST, (Comparable)Boolean.valueOf(north))).setValue((Property)WEST, (Comparable)Boolean.valueOf(south))).setValue(NORTH, (Comparable)((Object)northTemp))).setValue(SOUTH, (Comparable)((Object)southTemp));
            }
            case CLOCKWISE_180: {
                North northTemp = North.NONE;
                South southTemp = South.NONE;
                if (north && north_east && north_west) {
                    southTemp = South.ALL;
                } else if (north && north_west) {
                    southTemp = South.SOUTH_AND_SOUTH_EAST;
                } else if (north && north_east) {
                    southTemp = South.SOUTH_AND_SOUTH_WEST;
                } else if (north_west && north_east) {
                    southTemp = South.SOUTH_EAST_AND_SOUTH_WEST;
                } else if (!north_west && !north_east && north) {
                    southTemp = South.JUST_SOUTH;
                } else if (north_west) {
                    southTemp = South.JUST_SOUTH_EAST;
                } else if (north_east) {
                    southTemp = South.JUST_SOUTH_WEST;
                }
                if (south && south_east && south_west) {
                    northTemp = North.ALL;
                } else if (south && south_west) {
                    northTemp = North.NORTH_AND_NORTH_EAST;
                } else if (south && south_east) {
                    northTemp = North.NORTH_AND_NORTH_WEST;
                } else if (south_west && south_east) {
                    northTemp = North.NORTH_EAST_AND_NORTH_WEST;
                } else if (!south_west && !south_east && south) {
                    northTemp = North.JUST_NORTH;
                } else if (south_west) {
                    northTemp = North.JUST_NORTH_EAST;
                } else if (south_east) {
                    northTemp = North.JUST_NORTH_WEST;
                }
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)EAST, (Comparable)Boolean.valueOf(west))).setValue((Property)WEST, (Comparable)Boolean.valueOf(east))).setValue(NORTH, (Comparable)((Object)northTemp))).setValue(SOUTH, (Comparable)((Object)southTemp));
            }
            case COUNTERCLOCKWISE_90: {
                North northTemp = North.NONE;
                South southTemp = South.NONE;
                if (north_west && west && south_west) {
                    southTemp = South.ALL;
                } else if (!north_west && west && south_west) {
                    southTemp = South.SOUTH_AND_SOUTH_EAST;
                } else if (north_west && west) {
                    southTemp = South.SOUTH_AND_SOUTH_WEST;
                } else if (north_west && south_west) {
                    southTemp = South.SOUTH_EAST_AND_SOUTH_WEST;
                } else if (!north_west && west) {
                    southTemp = South.JUST_SOUTH;
                } else if (!north_west && south_west) {
                    southTemp = South.JUST_SOUTH_EAST;
                } else if (north_west) {
                    southTemp = South.JUST_SOUTH_WEST;
                }
                if (north_east && east && south_east) {
                    northTemp = North.ALL;
                } else if (!north_east && east && south_east) {
                    northTemp = North.NORTH_AND_NORTH_EAST;
                } else if (north_east && east) {
                    northTemp = North.NORTH_AND_NORTH_WEST;
                } else if (north_east && south_east) {
                    northTemp = North.NORTH_EAST_AND_NORTH_WEST;
                } else if (!north_east && east) {
                    northTemp = North.JUST_NORTH;
                } else if (!north_east && south_east) {
                    northTemp = North.JUST_NORTH_EAST;
                } else if (north_east) {
                    northTemp = North.JUST_NORTH_WEST;
                }
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)EAST, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(north))).setValue(NORTH, (Comparable)((Object)northTemp))).setValue(SOUTH, (Comparable)((Object)southTemp));
            }
        }
        return pState;
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_152918_, BlockPos p_152919_, CollisionContext p_152920_) {
        if (state.hasProperty((Property)StairBlock.FACING)) {
            if (state.getValue((Property)StairBlock.FACING) == Direction.NORTH) {
                return VOXEL_SHAPE_THICK_N;
            }
            if (state.getValue((Property)StairBlock.FACING) == Direction.EAST) {
                return VOXEL_SHAPE_THICK_E;
            }
            if (state.getValue((Property)StairBlock.FACING) == Direction.SOUTH) {
                return VOXEL_SHAPE_THICK_S;
            }
            if (state.getValue((Property)StairBlock.FACING) == Direction.WEST) {
                return VOXEL_SHAPE_THICK_W;
            }
        }
        return VOXEL_SHAPE_THICK_N;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (state.hasProperty((Property)StairBlock.FACING)) {
            if (state.getValue((Property)StairBlock.FACING) == Direction.NORTH) {
                boolean left = (Boolean)state.getValue((Property)LEFT);
                boolean right = (Boolean)state.getValue((Property)RIGHT);
                if (left && !right) {
                    return VOXEL_SHAPE270_RIGHT;
                }
                if (!left && right) {
                    return VOXEL_SHAPE270_LEFT;
                }
                if (!left) {
                    return VOXEL_SHAPE270;
                }
                return VOXEL_SHAPE270_FULL;
            }
            if (state.getValue((Property)StairBlock.FACING) == Direction.EAST) {
                boolean left = (Boolean)state.getValue((Property)LEFT);
                boolean right = (Boolean)state.getValue((Property)RIGHT);
                if (left && !right) {
                    return VOXEL_SHAPE_RIGHT;
                }
                if (!left && right) {
                    return VOXEL_SHAPE_LEFT;
                }
                if (!left) {
                    return VOXEL_SHAPE;
                }
                return VOXEL_SHAPE_FULL;
            }
            if (state.getValue((Property)StairBlock.FACING) == Direction.SOUTH) {
                boolean left = (Boolean)state.getValue((Property)LEFT);
                boolean right = (Boolean)state.getValue((Property)RIGHT);
                if (left && !right) {
                    return VOXEL_SHAPE180_LEFT;
                }
                if (!left && right) {
                    return VOXEL_SHAPE180_RIGHT;
                }
                if (!left) {
                    return VOXEL_SHAPE180;
                }
                return VOXEL_SHAPE180_FULL;
            }
            if (state.getValue((Property)StairBlock.FACING) == Direction.WEST) {
                boolean left = (Boolean)state.getValue((Property)LEFT);
                boolean right = (Boolean)state.getValue((Property)RIGHT);
                if (left && !right) {
                    return VOXEL_SHAPE90_LEFT;
                }
                if (!left && right) {
                    return VOXEL_SHAPE90_RIGHT;
                }
                if (!left) {
                    return VOXEL_SHAPE90;
                }
                return VOXEL_SHAPE90_FULL;
            }
        }
        return VOXEL_SHAPE;
    }

    public static boolean checkLeft(BlockState stateIn, BlockPos currentPos, LevelAccessor worldIn) {
        if (stateIn.hasProperty((Property)StairBlock.FACING) && stateIn.hasProperty(COLOR)) {
            if (stateIn.getValue((Property)StairBlock.FACING) == Direction.NORTH) {
                return worldIn.getBlockState(currentPos.west()).getBlock() == stateIn.getBlock() && worldIn.getBlockState(currentPos.west()).getValue((Property)StairBlock.FACING) == stateIn.getValue((Property)StairBlock.FACING) && worldIn.getBlockState(currentPos.west()).getValue(COLOR) == stateIn.getValue(COLOR);
            }
            if (stateIn.getValue((Property)StairBlock.FACING) == Direction.EAST) {
                return worldIn.getBlockState(currentPos.north()).getBlock() == stateIn.getBlock() && worldIn.getBlockState(currentPos.north()).getValue((Property)StairBlock.FACING) == stateIn.getValue((Property)StairBlock.FACING) && worldIn.getBlockState(currentPos.north()).getValue(COLOR) == stateIn.getValue(COLOR);
            }
            if (stateIn.getValue((Property)StairBlock.FACING) == Direction.SOUTH) {
                return worldIn.getBlockState(currentPos.east()).getBlock() == stateIn.getBlock() && worldIn.getBlockState(currentPos.east()).getValue((Property)StairBlock.FACING) == stateIn.getValue((Property)StairBlock.FACING) && worldIn.getBlockState(currentPos.east()).getValue(COLOR) == stateIn.getValue(COLOR);
            }
            if (stateIn.getValue((Property)StairBlock.FACING) == Direction.WEST) {
                return worldIn.getBlockState(currentPos.south()).getBlock() == stateIn.getBlock() && worldIn.getBlockState(currentPos.south()).getValue((Property)StairBlock.FACING) == stateIn.getValue((Property)StairBlock.FACING) && worldIn.getBlockState(currentPos.south()).getValue(COLOR) == stateIn.getValue(COLOR);
            }
        }
        return false;
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pParams) {
        List drops = super.getDrops(pState, pParams);
        if (!pState.hasProperty(COLOR)) {
            return drops;
        }
        ArrayList<ItemStack> updated_drops = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            if (stack.getItem() == ((ConnectingCarpetDyed)ModBlocks.INFUSED_FABRIC_CARPET.get()).asItem() || stack.getItem() == ((ConnectingCarpetDyed)ModBlocks.WAXED_INFUSED_FABRIC_CARPET.get()).asItem()) {
                DyeColor color = (DyeColor)pState.getValue(COLOR);
                CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                tag.putString("color", color.getName());
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
            updated_drops.add(stack);
        }
        return updated_drops;
    }

    public boolean checkRight(BlockState stateIn, BlockPos currentPos, LevelAccessor worldIn) {
        if (stateIn.hasProperty((Property)StairBlock.FACING)) {
            if (stateIn.getValue((Property)StairBlock.FACING) == Direction.NORTH) {
                return worldIn.getBlockState(currentPos.east()).getBlock() == stateIn.getBlock() && worldIn.getBlockState(currentPos.east()).getValue((Property)StairBlock.FACING) == stateIn.getValue((Property)StairBlock.FACING) && worldIn.getBlockState(currentPos.east()).getValue(COLOR) == stateIn.getValue(COLOR);
            }
            if (stateIn.getValue((Property)StairBlock.FACING) == Direction.EAST) {
                return worldIn.getBlockState(currentPos.south()).getBlock() == stateIn.getBlock() && worldIn.getBlockState(currentPos.south()).getValue((Property)StairBlock.FACING) == stateIn.getValue((Property)StairBlock.FACING) && worldIn.getBlockState(currentPos.south()).getValue(COLOR) == stateIn.getValue(COLOR);
            }
            if (stateIn.getValue((Property)StairBlock.FACING) == Direction.SOUTH) {
                return worldIn.getBlockState(currentPos.west()).getBlock() == stateIn.getBlock() && worldIn.getBlockState(currentPos.west()).getValue((Property)StairBlock.FACING) == stateIn.getValue((Property)StairBlock.FACING) && worldIn.getBlockState(currentPos.west()).getValue(COLOR) == stateIn.getValue(COLOR);
            }
            if (stateIn.getValue((Property)StairBlock.FACING) == Direction.WEST) {
                return worldIn.getBlockState(currentPos.north()).getBlock() == stateIn.getBlock() && worldIn.getBlockState(currentPos.north()).getValue((Property)StairBlock.FACING) == stateIn.getValue((Property)StairBlock.FACING) && worldIn.getBlockState(currentPos.north()).getValue(COLOR) == stateIn.getValue(COLOR);
            }
        }
        return false;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            DyeColor dyecolor = dyeItem.getDyeColor();
            if (this.getDyeColor(state) == dyecolor) {
                return ItemInteractionResult.FAIL;
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
            }
            BlockState newBlockstate = (BlockState)((BlockState)((BlockState)((BlockState)level.getBlockState(pos).setValue((Property)StairBlock.FACING, (Comparable)((Direction)level.getBlockState(pos.below()).getValue((Property)StairBlock.FACING)))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(this.checkRight(state, pos, (LevelAccessor)level)))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(ConnectingCarpetStairs.checkLeft(state, pos, (LevelAccessor)level)))).setValue(COLOR, (Comparable)dyecolor);
            if (state.getBlock() == ModBlocks.INFUSED_FABRIC_CARPET_ORNATE_STAIRS.get()) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.GOLD_NUGGET));
                newBlockstate = (BlockState)((ConnectingCarpetStairs)ModBlocks.INFUSED_FABRIC_CARPET_STAIRS.get()).defaultBlockState().setValue(COLOR, (Comparable)dyecolor);
            }
            level.setBlockAndUpdate(pos, newBlockstate);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newBlockstate));
            level.levelEvent(player, 3003, pos, 0);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (stack.getItem() == Items.GOLD_NUGGET) {
            if (state.getBlock() == ModBlocks.INFUSED_FABRIC_CARPET_ORNATE_STAIRS.get()) {
                return ItemInteractionResult.FAIL;
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, pos, stack);
            }
            BlockState newBlockstate = ((ConnectingCarpetStairs)ModBlocks.INFUSED_FABRIC_CARPET_ORNATE_STAIRS.get()).defaultBlockState();
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            level.setBlockAndUpdate(pos, newBlockstate);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newBlockstate));
            level.levelEvent(player, 3004, pos, 0);
            level.playSound(player, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.getUnWaxed(state, context, itemAbility).setValue((Property)StairBlock.FACING, (Comparable)((Direction)state.getValue((Property)StairBlock.FACING)))).setValue((Property)RIGHT, (Comparable)((Boolean)state.getValue((Property)RIGHT)))).setValue((Property)LEFT, (Comparable)((Boolean)state.getValue((Property)LEFT)))).setValue(COLOR, (Comparable)((DyeColor)state.getValue(COLOR)));
    }

    public ConnectingCarpetStairs(BlockBehaviour.Properties pProperties) {
        super(pProperties.noOcclusion());
        this.parentBlock = this;
    }

    public ConnectingCarpetStairs(BlockBehaviour.Properties pProperties, Block block) {
        super(pProperties.noOcclusion());
        this.parentBlock = block;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = this.parentBlock.asItem().getDefaultInstance();
        DyeColor color = this.getDyeColor(state);
        if (color != DyeColor.WHITE) {
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            tag.putString("color", color.getName());
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return stack;
    }

    protected BlockState updateCorners(BlockGetter world, BlockPos pos, BlockState state) {
        BlockState bs_north = world.getBlockState(pos.north());
        BlockState bs_north_east = world.getBlockState(pos.north().east());
        BlockState bs_north_west = world.getBlockState(pos.north().west());
        BlockState bs_east = world.getBlockState(pos.east());
        BlockState bs_south = world.getBlockState(pos.south());
        BlockState bs_south_east = world.getBlockState(pos.south().east());
        BlockState bs_south_west = world.getBlockState(pos.south().west());
        BlockState bs_west = world.getBlockState(pos.west());
        North north = North.NONE;
        South south = South.NONE;
        if (bs_north.getBlock() == this) {
            north = North.JUST_NORTH;
            if (bs_north_west.getBlock() == this && bs_north_east.getBlock() != this) {
                north = North.NORTH_AND_NORTH_WEST;
            }
            if (bs_north_west.getBlock() != this && bs_north_east.getBlock() == this) {
                north = North.NORTH_AND_NORTH_EAST;
            }
            if (bs_north_west.getBlock() == this && bs_north_east.getBlock() == this) {
                north = North.ALL;
            }
        } else {
            if (bs_north_west.getBlock() == this && bs_north_east.getBlock() != this) {
                north = North.JUST_NORTH_WEST;
            }
            if (bs_north_west.getBlock() != this && bs_north_east.getBlock() == this) {
                north = North.JUST_NORTH_EAST;
            }
        }
        if (bs_south.getBlock() == this) {
            south = South.JUST_SOUTH;
            if (bs_south_west.getBlock() == this && bs_south_east.getBlock() != this) {
                south = South.SOUTH_AND_SOUTH_WEST;
            }
            if (bs_south_west.getBlock() != this && bs_south_east.getBlock() == this) {
                south = South.SOUTH_AND_SOUTH_EAST;
            }
            if (bs_south_west.getBlock() == this && bs_south_east.getBlock() == this) {
                south = South.ALL;
            }
        } else {
            if (bs_south_west.getBlock() == this && bs_south_east.getBlock() != this) {
                south = South.JUST_SOUTH_WEST;
            }
            if (bs_south_west.getBlock() != this && bs_south_east.getBlock() == this) {
                south = South.JUST_SOUTH_EAST;
            }
        }
        boolean east = bs_east.getBlock() == this;
        boolean west = bs_west.getBlock() == this;
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue(SOUTH, (Comparable)((Object)south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    public RenderShape getRenderShape(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level iblockreader = context.getLevel();
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        Level level = context.getLevel();
        if (level.getBlockState(pos.below()).getBlock() instanceof StairBlock && level.getBlockState(pos.below()).getValue((Property)StairBlock.HALF) == Half.BOTTOM) {
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            String colorName = tag.contains("color") ? tag.getString("color") : "";
            DyeColor color = DyeColor.byName((String)colorName, (DyeColor)DyeColor.WHITE);
            return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)((Direction)level.getBlockState(pos.below()).getValue((Property)StairBlock.FACING)))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(this.checkRight(state, pos, (LevelAccessor)level)))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(ConnectingCarpetStairs.checkLeft(state, pos, (LevelAccessor)level)))).setValue(COLOR, (Comparable)color);
        }
        return this.defaultBlockState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{StairBlock.FACING, RIGHT, LEFT, COLOR});
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (world.getBlockState(pos.below()).getBlock() instanceof StairBlock && world.getBlockState(pos.below()).getValue((Property)StairBlock.HALF) == Half.BOTTOM) {
            return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)((Direction)world.getBlockState(pos.below()).getValue((Property)StairBlock.FACING)))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(this.checkRight(state, pos, world)))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(ConnectingCarpetStairs.checkLeft(state, pos, world)))).setValue(COLOR, (Comparable)((DyeColor)state.getValue(COLOR)));
        }
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : this.defaultBlockState();
    }

    public static enum North implements StringRepresentable
    {
        JUST_NORTH,
        NORTH_AND_NORTH_WEST,
        NORTH_AND_NORTH_EAST,
        JUST_NORTH_WEST,
        JUST_NORTH_EAST,
        NORTH_EAST_AND_NORTH_WEST,
        ALL,
        NONE;


        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "north";
                case 1 -> "north_and_north_west";
                case 2 -> "north_and_north_east";
                case 3 -> "north_west";
                case 4 -> "north_east";
                case 5 -> "north_east_and_north_west";
                case 6 -> "all";
                case 7 -> "none";
            };
        }
    }

    public static enum South implements StringRepresentable
    {
        JUST_SOUTH,
        SOUTH_AND_SOUTH_WEST,
        SOUTH_AND_SOUTH_EAST,
        JUST_SOUTH_WEST,
        JUST_SOUTH_EAST,
        SOUTH_EAST_AND_SOUTH_WEST,
        ALL,
        NONE;


        public String toString() {
            return this.getSerializedName();
        }

        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "south";
                case 1 -> "south_and_south_west";
                case 2 -> "south_and_south_east";
                case 3 -> "south_west";
                case 4 -> "south_east";
                case 5 -> "south_east_and_south_west";
                case 6 -> "all";
                case 7 -> "none";
            };
        }
    }
}

