/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.stream.Stream;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.tileentity.CourierPackageTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CourierPackage
extends BaseEntityBlock
implements ITileEntity<CourierPackageTile>,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<State> STATE = EnumProperty.create((String)"state", State.class);
    public static final MapCodec<CourierPackage> CODEC = CourierPackage.simpleCodec(CourierPackage::new);
    VoxelShape shape_turned = Stream.of(Block.box((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)7.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    VoxelShape shape = Stream.of(Block.box((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)7.0, (double)13.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public CourierPackage(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)super.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue(STATE, (Comparable)((Object)State.SEALED)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CourierPackageTile) {
            CourierPackageTile courierPackageTile = (CourierPackageTile)blockEntity;
            return courierPackageTile.interact(player) ? ItemInteractionResult.SUCCESS : super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> {
            CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            if (data != null && data.contains("Items") && !data.copyTag().getList("Items", 10).isEmpty()) {
                te.loadFromTag(data.copyTag(), (HolderLookup.Provider)placer.level().registryAccess());
            }
            te.sync();
        });
        super.setPlacedBy(worldIn, pos, state, placer, stack);
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof CourierPackageTile) {
            CourierPackageTile packageTile = (CourierPackageTile)blockentity;
            if (!pLevel.isClientSide && pPlayer.isCreative() && !packageTile.isEmpty()) {
                ItemStack itemstack = ((Item)ModItems.COURIER_PACKAGE.get()).getDefaultInstance();
                blockentity.saveToItem(itemstack, (HolderLookup.Provider)pLevel.registryAccess());
                if (packageTile.hasCustomName()) {
                    itemstack.set(DataComponents.CUSTOM_NAME, (Object)packageTile.getCustomName());
                }
                ItemEntity itementity = new ItemEntity(pLevel, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, itemstack);
                itementity.setDefaultPickUpDelay();
                pLevel.addFreshEntity((Entity)itementity);
            } else {
                packageTile.unpackLootTable(pPlayer);
            }
        }
        return super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
    }

    public List<ItemStack> getDrops(BlockState pState, LootParams.Builder pParams) {
        return super.getDrops(pState, pParams);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (!pState.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
            return this.shape;
        }
        Direction dir = (Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING);
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            return this.shape;
        }
        return this.shape_turned;
    }

    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        State state = State.OPENED;
        ItemStack stack = context.getItemInHand();
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains("Items") && !tag.getList("Items", 10).isEmpty()) {
            state = tag.contains("Sealed") && tag.getBoolean("Sealed") ? State.SEALED : State.CLOSED;
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER))).setValue(STATE, (Comparable)((Object)state));
    }

    public RenderShape getRenderShape(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return CourierPackage.canSupportCenter((LevelReader)worldIn, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, HorizontalDirectionalBlock.FACING, STATE});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    @Override
    public Class<CourierPackageTile> getTileEntityClass() {
        return CourierPackageTile.class;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new CourierPackageTile((BlockEntityType)ModTileEntities.COURIER_PACKAGE_TILE.get(), pPos, pState);
    }

    public static enum State implements StringRepresentable
    {
        OPENED("opened"),
        CLOSED("closed"),
        SEALED("sealed");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

