/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.List;
import java.util.stream.Stream;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.item.ModDataComponents;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.data_components.FluteData;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.tileentity.PestleAndMortarTile;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PestleAndMortar
extends Block
implements ITileEntity<PestleAndMortarTile>,
EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape SHAPE = Stream.of(Block.box((double)4.0, (double)1.0, (double)4.0, (double)5.0, (double)7.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)4.0, (double)11.0, (double)7.0, (double)5.0), Block.box((double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)7.0, (double)12.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), Block.box((double)11.0, (double)1.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public RenderShape getRenderShape(BlockState p_60550_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is((Item)ModItems.CROW_FLUTE.get()) && ((FluteData)stack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY)).commandMode() == 2) {
            stack.useOn(new UseOnContext(player, hand, hitResult));
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof PestleAndMortarTile) {
            ((PestleAndMortarTile)tileEntity).interactPestleAndMortar(player, hitResult);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public PestleAndMortar(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.withPropertiesOf((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.pestle_and_mortar_shift_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.pestle_and_mortar_shift_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.pestle_and_mortar_shift_3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.pestle_and_mortar_shift_4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.pestle_and_mortar_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileentity = level.getBlockEntity(pos);
            if (tileentity != null) {
                PestleAndMortarTile te = (PestleAndMortarTile)level.getBlockEntity(pos);
                if (!((ItemStack)te.getItems().get(0)).isEmpty()) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.25f), (double)((float)pos.getZ() + 0.5f), (ItemStack)te.getItems().get(0)));
                }
                if (!((ItemStack)te.getItems().get(1)).isEmpty()) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.25f), (double)((float)pos.getZ() + 0.5f), (ItemStack)te.getItems().get(1)));
                }
                if (!((ItemStack)te.getItems().get(2)).isEmpty()) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.25f), (double)((float)pos.getZ() + 0.5f), (ItemStack)te.getItems().get(2)));
                }
                if (!((ItemStack)te.getItems().get(3)).isEmpty()) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.25f), (double)((float)pos.getZ() + 0.5f), (ItemStack)te.getItems().get(3)));
                }
                if (!((ItemStack)te.getItems().get(4)).isEmpty()) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.25f), (double)((float)pos.getZ() + 0.5f), (ItemStack)te.getItems().get(4)));
                }
                if (!((ItemStack)te.getItems().get(5)).isEmpty()) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.25f), (double)((float)pos.getZ() + 0.5f), (ItemStack)te.getItems().get(5)));
                }
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Override
    public Class<PestleAndMortarTile> getTileEntityClass() {
        return PestleAndMortarTile.class;
    }

    @javax.annotation.Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PestleAndMortarTile((BlockEntityType)ModTileEntities.PESTLE_AND_MORTAR_TILE.get(), pos, state);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> entityType) {
        return entityType == ModTileEntities.PESTLE_AND_MORTAR_TILE.get() ? (world2, pos, state2, entity) -> ((PestleAndMortarTile)entity).tick() : null;
    }
}

