/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import com.mojang.datafixers.DataFixUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class PickableDoublePlant
extends DoublePlantBlock
implements BonemealableBlock {
    protected static final float AABB_OFFSET = 3.0f;
    protected static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    protected static final VoxelShape SHAPE_BOTTOM = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final int MAX_AGE = 3;
    public int type;
    public ResourceKey<Item> firstOutput;
    public int maxFirstOutput;
    public ResourceKey<Item> secondOutput;
    public int maxSecondOutput;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    public PickableDoublePlant(BlockBehaviour.Properties properties, ResourceKey<Item> firstOutput, int maxFirstOutput, ResourceKey<Item> secondOutput, int maxSecondOutput) {
        super(properties);
        this.firstOutput = firstOutput;
        this.maxFirstOutput = maxFirstOutput;
        this.secondOutput = secondOutput;
        this.maxSecondOutput = maxSecondOutput;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public PickableDoublePlant(BlockBehaviour.Properties properties, ResourceKey<Item> firstOutput, int maxFirstOutput) {
        super(properties);
        this.firstOutput = firstOutput;
        this.maxFirstOutput = maxFirstOutput;
        this.secondOutput = null;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState p_53517_, BlockGetter p_53518_, BlockPos p_53519_, CollisionContext p_53520_) {
        Vec3 vec3 = p_53517_.getOffset(p_53518_, p_53519_);
        if (p_53517_.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return SHAPE_BOTTOM.move(vec3.x, vec3.y, vec3.z);
        }
        return SHAPE.move(vec3.x, vec3.y, vec3.z);
    }

    public BlockBehaviour.OffsetType getOffsetType() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public boolean isRandomlyTicking(BlockState p_57284_) {
        return (Integer)p_57284_.getValue((Property)AGE) < 3;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int i = (Integer)state.getValue((Property)AGE);
        if (state.hasProperty(HALF) && state.getValue(HALF) == DoubleBlockHalf.LOWER && i < 3 && level.getRawBrightness(pos.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0) && state.hasProperty((Property)AGE) && level.getBlockState(pos.above()).hasProperty((Property)AGE)) {
            BlockState blockstate = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.setBlock(pos, blockstate, 2);
            if (level.getBlockState(pos.above()).getBlock() instanceof PickableDoublePlant) {
                level.setBlock(pos.above(), (BlockState)level.getBlockState(pos.above()).setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                this.destroy((LevelAccessor)level, pos, state);
            }
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockstate));
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        int i = (Integer)state.getValue((Property)AGE);
        boolean flag = i == 3;
        return !flag && stack.is(Items.BONE_MEAL) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean flag;
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl = flag = i == 3;
        if (i > 1) {
            ItemStack firstOutput = new ItemStack((ItemLike)DataFixUtils.orElse((Optional)level.registryAccess().registryOrThrow(Registries.ITEM).getOptional(this.firstOutput), (Object)((Object)this)), this.maxFirstOutput);
            ItemStack secondOutput = ItemStack.EMPTY;
            if (this.secondOutput != null) {
                secondOutput = new ItemStack((ItemLike)DataFixUtils.orElse((Optional)level.registryAccess().registryOrThrow(Registries.ITEM).getOptional(this.secondOutput), (Object)((Object)this)), this.maxSecondOutput);
            }
            int j = Math.max(1, level.random.nextInt(firstOutput.getCount()));
            int k = 0;
            if (this.secondOutput != null) {
                k = Math.max(1, level.random.nextInt(secondOutput.getCount()));
            }
            PickableDoublePlant.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)firstOutput.getItem(), Math.max(1, (int)Math.floor((float)j / 2.0f)) + (flag ? (int)Math.ceil((float)j / 2.0f) : 0)));
            if (level.random.nextInt(2) == 0 && this.secondOutput != null) {
                PickableDoublePlant.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)secondOutput.getItem(), Math.max(1, (int)Math.floor((float)k / 2.0f)) + (flag ? (int)Math.ceil((float)k / 2.0f) : 0)));
            }
            level.playSound(null, pos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
                level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
                BlockState blockState = level.getBlockState(pos.above());
                if (blockState.getBlock() == level.getBlockState(pos).getBlock()) {
                    level.setBlock(pos.above(), (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
                } else if (blockState.isAir()) {
                    level.setBlock(pos.above(), (BlockState)((BlockState)level.getBlockState(pos).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
                }
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
            } else {
                level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
                BlockState blockState = level.getBlockState(pos.below());
                if (blockState.getBlock() == level.getBlockState(pos).getBlock()) {
                    level.setBlock(pos.below(), (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
                } else if (blockState.isAir()) {
                    level.setBlock(pos.below(), (BlockState)((BlockState)level.getBlockState(pos).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
                }
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_57282_) {
        p_57282_.add(new Property[]{AGE}).add(new Property[]{HALF});
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level p_57265_, RandomSource p_57266_, BlockPos p_57267_, BlockState p_57268_) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos blockPos, BlockState blockState) {
        if (blockState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            int i = Math.min(3, (Integer)blockState.getValue((Property)AGE) + 1);
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
            level.setBlock(blockPos.above(), (BlockState)level.getBlockState(blockPos.above()).setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
        } else {
            int i = Math.min(3, (Integer)level.getBlockState(blockPos.below()).getValue((Property)AGE) + 1);
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
            level.setBlock(blockPos.below(), (BlockState)level.getBlockState(blockPos.below()).setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
        }
    }
}

