/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.List;
import java.util.Random;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.item.ModDataComponents;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.data_components.FluteData;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.tileentity.SageBurningPlateTile;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SageBurningPlate
extends Block
implements ITileEntity<SageBurningPlateTile>,
EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final IntegerProperty MODE = IntegerProperty.create((String)"mode", (int)0, (int)3);
    public static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)1.0, (double)11.0);
    public static final VoxelShape SHAPE_TURNED = Block.box((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)1.0, (double)14.0);

    public RenderShape getRenderShape(BlockState p_60550_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)MODE, (Comparable)Integer.valueOf(0));
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        if (p_220053_1_.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST || p_220053_1_.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
            return SHAPE_TURNED;
        }
        return SHAPE;
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (stack.is((Item)ModItems.CROW_FLUTE.get()) && ((FluteData)stack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY)).commandMode() == 2) {
            stack.useOn(new UseOnContext(player, hand, hitResult));
            return ItemInteractionResult.SUCCESS;
        }
        ItemStack itemstack = player.getItemInHand(hand);
        Random random = new Random();
        if (tileEntity instanceof SageBurningPlateTile) {
            SageBurningPlateTile sageBurningPlateTile = (SageBurningPlateTile)tileEntity;
            if (itemstack.getItem() == Items.FLINT_AND_STEEL) {
                if (((ItemStack)sageBurningPlateTile.getItems().get(0)).is((Item)ModItems.DRIED_SAGE_BUNDLE.get()) && !((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 11);
                    level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.4f + 1.0f);
                    itemstack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (itemstack.isEmpty() && !player.isShiftKeyDown()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MODE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)MODE) + 1 > 3 ? 0 : (Integer)state.getValue((Property)MODE) + 1)), 11);
                state = level.getBlockState(pos);
                String s = "display.hexerei.sage_plate_toggle_" + String.valueOf(state.getValue((Property)MODE));
                player.displayClientMessage((Component)Component.translatable((String)s), true);
            } else {
                ((SageBurningPlateTile)tileEntity).interactSageBurningPlate(player, hitResult);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public SageBurningPlate(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.withPropertiesOf((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING, WATERLOGGED, LIT, MODE});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            MutableComponent string = Component.translatable((String)String.valueOf(HexConfig.SAGE_BURNING_PLATE_RANGE.get())).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)));
            MutableComponent itemText = Component.translatable((String)((Item)ModItems.DRIED_SAGE_BUNDLE.get()).getDescriptionId()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x998800)));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.sage_burning_plate_shift_1", (Object[])new Object[]{itemText}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.sage_burning_plate_shift_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.sage_burning_plate_shift_3", (Object[])new Object[]{string}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.sage_burning_plate_shift_4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.sage_burning_plate_shift_5").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.sage_burning_plate_shift_6").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            SageBurningPlateTile te;
            BlockEntity tileentity = level.getBlockEntity(pos);
            if (tileentity != null && !((ItemStack)(te = (SageBurningPlateTile)level.getBlockEntity(pos)).getItems().get(0)).isEmpty()) {
                level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), (ItemStack)te.getItems().get(0)));
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Override
    public Class<SageBurningPlateTile> getTileEntityClass() {
        return SageBurningPlateTile.class;
    }

    @javax.annotation.Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SageBurningPlateTile((BlockEntityType)ModTileEntities.SAGE_BURNING_PLATE_TILE.get(), pos, state);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> entityType) {
        return entityType == ModTileEntities.SAGE_BURNING_PLATE_TILE.get() ? (world2, pos, state2, entity) -> ((SageBurningPlateTile)entity).tick() : null;
    }
}

