/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.color;

import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.Coffer;
import net.joefoxe.hexerei.block.custom.ConnectingCarpetDyed;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ModBlockColors {
    public static final BlockColor WATER_COLOR = ModBlockColors.setDynamicBlockColorProvider(1.0, 0.5);
    public static final BlockColor GRASS_COLOR = ModBlockColors.setDynamicBlockColorProviderGrass(1.0, 0.5);

    public static BlockColor setDynamicBlockColorProvider(double temp, double humidity) {
        return (unknown, lightReader, pos, unknown2) -> {
            assert (lightReader != null);
            return BiomeColors.getAverageWaterColor((BlockAndTintGetter)lightReader, (BlockPos)pos);
        };
    }

    public static BlockColor setDynamicBlockColorProviderGrass(double temp, double humidity) {
        return (unknown, lightReader, pos, unknown2) -> {
            assert (lightReader != null);
            return BiomeColors.getAverageGrassColor((BlockAndTintGetter)lightReader, (BlockPos)pos);
        };
    }

    @SubscribeEvent
    public static void onBlockColorsInit(RegisterColorHandlersEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        event.register((state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)reader, (BlockPos)pos) : GrassColor.get((double)0.5, (double)0.5), new Block[]{(Block)ModBlocks.LILY_PAD_BLOCK.get()});
        event.register((state, reader, pos, color) -> reader != null && pos != null ? Coffer.getColorValue(state, pos, (BlockGetter)reader) : 4464659, new Block[]{(Block)ModBlocks.COFFER.get(), (Block)ModBlocks.ENTANGLED_COFFER.get()});
        event.register((state, reader, pos, color) -> ConnectingCarpetDyed.getColorValue(state), new Block[]{(Block)ModBlocks.INFUSED_FABRIC_CARPET.get(), (Block)ModBlocks.WAXED_INFUSED_FABRIC_CARPET.get(), (Block)ModBlocks.INFUSED_FABRIC_BLOCK.get(), (Block)ModBlocks.WAXED_INFUSED_FABRIC_BLOCK.get(), (Block)ModBlocks.INFUSED_FABRIC_CARPET_STAIRS.get(), (Block)ModBlocks.WAXED_INFUSED_FABRIC_CARPET_STAIRS.get(), (Block)ModBlocks.INFUSED_FABRIC_CARPET_SLAB.get(), (Block)ModBlocks.WAXED_INFUSED_FABRIC_CARPET_SLAB.get()});
        event.register((state, reader, pos, color) -> reader != null && pos != null ? Coffer.getColorValue(state, pos, (BlockGetter)reader) : 4464659, new Block[]{(Block)ModBlocks.BOOK_OF_SHADOWS_BACK.get(), (Block)ModBlocks.BOOK_OF_SHADOWS_COVER.get()});
    }
}

