/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.ITargetsDroppedItems;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.owl.QuirkController;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.owl.quirks.FavoriteBlockQuirk;
import net.joefoxe.hexerei.client.renderer.entity.render.OwlVariant;
import net.joefoxe.hexerei.container.OwlContainer;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotData;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotSavedData;
import net.joefoxe.hexerei.data.owl.OwlLoadedChunksSavedData;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.CourierLetterItem;
import net.joefoxe.hexerei.item.custom.CourierPackageItem;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.sounds.ModSounds;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.AskForSyncPacket;
import net.joefoxe.hexerei.util.message.BrowAnimPacket;
import net.joefoxe.hexerei.util.message.BrowPositioningPacket;
import net.joefoxe.hexerei.util.message.ClientboundOpenOwlCourierSendScreenPacket;
import net.joefoxe.hexerei.util.message.EatParticlesPacket;
import net.joefoxe.hexerei.util.message.EmotionPacket;
import net.joefoxe.hexerei.util.message.EntitySyncAdditionalDataPacket;
import net.joefoxe.hexerei.util.message.EntitySyncPacket;
import net.joefoxe.hexerei.util.message.HeadShakePacket;
import net.joefoxe.hexerei.util.message.HeadTiltPacket;
import net.joefoxe.hexerei.util.message.OwlHootPacket;
import net.joefoxe.hexerei.util.message.OwlSyncInvPacket;
import net.joefoxe.hexerei.util.message.OwlTeleportParticlePacket;
import net.joefoxe.hexerei.util.message.PeckPacket;
import net.joefoxe.hexerei.util.message.StartRidingPacket;
import net.joefoxe.hexerei.util.message.TailFanPacket;
import net.joefoxe.hexerei.util.message.TailWagPacket;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class OwlEntity
extends TamableAnimal
implements ContainerListener,
FlyingAnimal,
ITargetsDroppedItems,
Container,
MenuProvider,
PowerableMob {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.of((ItemLike[])new ItemLike[]{Items.SALMON, Items.COD});
    public BrowPositioning browPositioning = BrowPositioning.NORMAL;
    public BrowAnimation browAnimation;
    public BrowHappyAnimation browHappyAnimation;
    public TailWagAnimation tailWagAnimation;
    public TailFanAnimation tailFanAnimation;
    public HootAnimation hootAnimation;
    public PeckAnimation peckAnimation;
    public HeadTiltAnimation headTiltAnimation;
    public HeadShakeAnimation headShakeAnimation;
    public AnimationController animationController;
    public MessagingController messagingController;
    public float bodyXRot;
    public float bodyXRotLast;
    public float bodyYOffset;
    public float bodyYOffsetLast;
    public float rightWingAngle;
    public float rightWingAngleLast;
    public float rightWingFoldAngle;
    public float rightWingMiddleAngle;
    public float rightWingMiddleAngleLast;
    public float rightWingMiddleFoldAngle;
    public float rightWingTipAngle;
    public float leftWingAngle;
    public float leftWingAngleLast;
    public float leftWingFoldAngle;
    public float leftWingMiddleAngle;
    public float leftWingMiddleAngleLast;
    public float leftWingMiddleFoldAngle;
    public float leftWingTipAngle;
    public boolean dance;
    public int animationCounter;
    public float itemHeldSwing = 0.0f;
    public float itemHeldSwingLast = 0.0f;
    private BlockPos jukebox;
    private int rideCooldownCounter;
    private UUID fishThrowerID;
    private int heldItemTime = 0;
    public OwlTask currentTask;
    public ItemEntity targetingItem;
    public boolean sync;
    public final ItemStackHandler itemHandler = this.createHandler();
    private static final EntityDataAccessor<Optional<BlockPos>> PERCH_POS = SynchedEntityData.defineId(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Integer> OWL_DYE_COLOR = SynchedEntityData.defineId(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_FLYING = SynchedEntityData.defineId(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int interactionRange;
    public boolean canAttack;
    private final Map<String, Vector3f> modelRotationValues = Maps.newHashMap();
    protected FlyingPathNavigation flyingNav;
    protected GroundPathNavigation groundNav;
    private int lastSwappedNavigator = -40;
    public Emotions emotions;
    public EmotionState emotionState;
    private int emotionTicks = 0;
    public QuirkController quirkController;
    public int lowHealthDistressIncreaseTickLast = 0;
    public boolean breedGiftGivenByPlayer = false;
    public int breedGiftGivenByPartnerTimer = 0;
    public UUID breedGiftGivenByPlayerUUID;
    public int waitToGiveTime = 0;

    public OwlEntity(EntityType<OwlEntity> type, Level worldIn) {
        super(type, worldIn);
        this.registerGoals();
        this.flyingNav = (FlyingPathNavigation)this.createFlyingNavigation(worldIn);
        this.groundNav = (GroundPathNavigation)this.createGroundNavigation(worldIn);
        this.moveControl = new OwlMoveController(this, 10);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.animationCounter = 0;
        this.currentTask = OwlTask.NONE;
        this.targetingItem = null;
        this.sync = false;
        this.animationController = new AnimationController(this);
        this.browAnimation = new BrowAnimation(this);
        this.animationController.addAnimation(this.browAnimation);
        this.browHappyAnimation = new BrowHappyAnimation(this);
        this.animationController.addAnimation(this.browHappyAnimation);
        this.tailWagAnimation = new TailWagAnimation(this);
        this.animationController.addAnimation(this.tailWagAnimation);
        this.tailFanAnimation = new TailFanAnimation(this);
        this.animationController.addAnimation(this.tailFanAnimation);
        this.hootAnimation = new HootAnimation(this);
        this.animationController.addAnimation(this.hootAnimation);
        this.peckAnimation = new PeckAnimation(this);
        this.animationController.addAnimation(this.peckAnimation);
        this.headTiltAnimation = new HeadTiltAnimation(this);
        this.animationController.addAnimation(this.headTiltAnimation);
        this.headShakeAnimation = new HeadShakeAnimation(this);
        this.animationController.addAnimation(this.headShakeAnimation);
        this.messagingController = new MessagingController(this);
        this.bodyXRot = 0.0f;
        this.bodyYOffset = 0.0f;
        this.rightWingAngle = -((float)Math.toRadians(85.0));
        this.leftWingAngle = (float)Math.toRadians(85.0);
        this.rightWingMiddleAngle = -((float)Math.toRadians(10.0));
        this.leftWingMiddleAngle = (float)Math.toRadians(10.0);
        this.rightWingMiddleFoldAngle = (float)Math.toRadians(30.0);
        this.leftWingMiddleFoldAngle = -((float)Math.toRadians(30.0));
        this.rightWingFoldAngle = (float)Math.toRadians(0.0);
        this.leftWingFoldAngle = -((float)Math.toRadians(0.0));
        this.rightWingTipAngle = (float)Math.toRadians(60.0);
        this.leftWingTipAngle = -((float)Math.toRadians(60.0));
        this.bodyYOffsetLast = this.bodyYOffset;
        this.rightWingAngleLast = this.rightWingAngle;
        this.leftWingAngleLast = this.leftWingAngle;
        this.rightWingMiddleAngleLast = this.rightWingMiddleAngle;
        this.leftWingMiddleAngleLast = this.leftWingMiddleAngle;
        this.interactionRange = 24;
        this.canAttack = true;
        this.emotions = new Emotions(0, 0, 0);
        this.determineEmotionState();
        this.quirkController = new QuirkController();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal(this, (PathfinderMob)this, 1.4){

            public boolean canUse() {
                OwlEntity owl;
                PathfinderMob pathfinderMob = this.mob;
                if (pathfinderMob instanceof OwlEntity && (owl = (OwlEntity)pathfinderMob).isInSittingPose()) {
                    return false;
                }
                return super.canUse();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new FlyBackToPerchGoal(this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal(this));
        this.goalSelector.addGoal(2, (Goal)new DeliverMessageGoal(this));
        this.goalSelector.addGoal(3, (Goal)new OwlFavoriteBlockGoal(this, this, 1.5));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal(this, 1.25, 5.0f, 1.0f, true));
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.5));
        this.goalSelector.addGoal(1, (Goal)new TemptGoal(this, 1.0, TEMPTATION_ITEMS, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new OwlLookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(2, new OwlGatherItems((PathfinderMob)this, false, false, 40, this.interactionRange));
    }

    protected float nextStep() {
        return this.moveDist + 0.25f;
    }

    protected void playStepSound(BlockPos pPos, BlockState pBlock) {
        this.playSound(SoundEvents.CHICKEN_STEP, 0.03f, 0.75f);
    }

    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.500001f);
    }

    protected float getJumpPower() {
        return super.getJumpPower() * 1.1f;
    }

    public int getMaxHeadYRot() {
        if ((this.onGround() || !this.isFlying()) && this.navigation.isDone()) {
            return 180;
        }
        return 90;
    }

    public void switchNavigator(boolean shouldFly, boolean force) {
        if (Math.abs(this.tickCount - this.lastSwappedNavigator) > 40 || force) {
            if (this.lastSwappedNavigator == -40) {
                this.entityData.set(DATA_FLYING, (Object)shouldFly);
            }
            this.lastSwappedNavigator = this.tickCount;
            this.navigation = shouldFly ? this.flyingNav : this.groundNav;
        }
    }

    public void switchNavigator(boolean shouldFly) {
        this.switchNavigator(shouldFly, false);
    }

    public boolean isFlyingNav() {
        return this.navigation == this.flyingNav;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PERCH_POS, Optional.empty());
        builder.define(OWL_DYE_COLOR, (Object)-1);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
        builder.define(DATA_FLYING, (Object)true);
    }

    public void syncInv() {
        if (!this.level().isClientSide) {
            HexereiPacketHandler.sendToNearbyClient(this.level(), (Entity)this, (CustomPacketPayload)new OwlSyncInvPacket((Entity)this, this.itemHandler.serializeNBT((HolderLookup.Provider)this.level().registryAccess())));
        }
    }

    public void sync() {
        this.setChanged();
        if (!this.level().isClientSide) {
            HexereiPacketHandler.sendToNearbyClient(this.level(), (Entity)this, (CustomPacketPayload)new EntitySyncPacket((Entity)this, this.saveWithoutId(new CompoundTag())));
            this.syncAdditionalData();
        }
    }

    public void syncAdditionalData() {
        this.setChanged();
        if (!this.level().isClientSide) {
            CompoundTag tag = new CompoundTag();
            this.addAdditionalSaveDataNoSuper(tag);
            HexereiPacketHandler.sendToNearbyClient(this.level(), (Entity)this, (CustomPacketPayload)new EntitySyncAdditionalDataPacket((Entity)this, tag));
        }
    }

    public boolean isMaxHealth() {
        return this.getHealth() >= this.getMaxHealth();
    }

    public void die(DamageSource pCause) {
        if (!this.checkTotemDeathProtection(pCause)) {
            this.messagingController.stopForceloadingChunks();
            super.die(pCause);
        }
    }

    public void remove(Entity.RemovalReason pReason) {
        if (pReason.shouldDestroy()) {
            this.messagingController.stopForceloadingChunks();
        }
        super.remove(pReason);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        float f = this.getHealth();
        if (pSource.is(DamageTypes.SWEET_BERRY_BUSH)) {
            return false;
        }
        if (!this.level().isClientSide) {
            this.emotions.setAnger(this.emotions.getAnger() + (int)Mth.clamp((float)(pAmount * 20.0f), (float)10.0f, (float)30.0f));
            this.emotionChanged();
        }
        return super.hurt(pSource, pAmount);
    }

    public boolean isInWall() {
        if (this.isPassenger()) {
            return false;
        }
        return super.isInWall();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                OwlEntity.this.syncAdditionalData();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                ArmorItem armorItem;
                Item item;
                return slot != 0 || (item = stack.getItem()) instanceof ArmorItem && (armorItem = (ArmorItem)item).getType() == ArmorItem.Type.HELMET;
            }

            public int getSlotLimit(int slot) {
                if (slot == 0 || slot == 1 || slot == 2) {
                    return 1;
                }
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    public void peck() {
        this.peckAnimation.start();
        this.hootAnimation.start();
    }

    public void rideTick() {
        Entity entity = this.getVehicle();
        if (this.isPassenger() && !entity.isAlive()) {
            this.stopRiding();
        } else if (this.isTame() && entity instanceof LivingEntity && this.isOwnedBy((LivingEntity)entity)) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.tick();
            Entity player = this.getVehicle();
            if (this.isPassenger()) {
                int i = player.getPassengers().indexOf(this);
                float radius = 0.38f;
                float angle = (float)Math.PI / 180 * (((Player)player).yBodyRot + (float)(i == 0 ? -90 : 90));
                this.yHeadRot = ((Player)player).yHeadRot;
                this.yRotO = ((Player)player).yHeadRot;
                this.setPos(player.getX() + (double)(radius * Mth.sin((float)((float)(Math.PI + (double)angle)))), player.getY() + (!player.isShiftKeyDown() ? 1.4 : 1.2), player.getZ() + (double)(radius * Mth.cos((float)angle)));
                if (!player.isAlive() || player.isShiftKeyDown() || ((Player)player).isFallFlying() || this.getTarget() != null && this.getTarget().isAlive()) {
                    this.removeVehicle();
                }
            }
        } else {
            super.rideTick();
        }
    }

    private void setTypeVariant(int pTypeVariant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)pTypeVariant);
    }

    private void setFlying(boolean flying) {
        this.entityData.set(DATA_FLYING, (Object)flying);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public OwlVariant getVariant() {
        return OwlVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void setRecordPlayingNearby(BlockPos p_21082_, boolean p_21083_) {
        this.jukebox = p_21082_;
        this.dance = p_21083_;
    }

    protected AABB getTargetableArea(double targetDistance) {
        Vec3 renderCenter = new Vec3(this.getX(), this.getY(), this.getZ());
        AABB aabb = new AABB(-targetDistance, -targetDistance, -targetDistance, targetDistance, targetDistance, targetDistance);
        return aabb.move(renderCenter);
    }

    public void setBrowPos(BrowPositioning browPositioning) {
        this.browPositioning = browPositioning;
        if (!this.level().isClientSide) {
            HexereiPacketHandler.sendToNearbyClient(this.level(), (Entity)this, (CustomPacketPayload)new BrowPositioningPacket((Entity)this, this.browPositioning));
        }
    }

    public void determineEmotionState() {
        EmotionState closestState = null;
        double closestDistance = Double.MAX_VALUE;
        for (EmotionState state : EmotionState.values()) {
            double distance = this.calculateStateDistance(this.emotions, state.getScales());
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closestState = state;
        }
        this.emotionState = closestState;
    }

    private double calculateStateDistance(Emotions scales1, Emotions scales2) {
        int anger = scales1.getAnger() - scales2.getAnger();
        int plead = scales1.getDistress() - scales2.getDistress();
        int happiness = scales1.getHappiness() - scales2.getHappiness();
        return Math.sqrt(anger * anger + plead * plead + happiness * happiness);
    }

    private void adjustEmotion() {
        int adjustment;
        if (this.random.nextInt(1) == 0) {
            adjustment = (int)Math.round((this.easeInOutCubic((float)this.emotions.getAnger() / 100.0f) * 0.5 + 0.25) * 20.0 + 1.0);
            this.emotions.setAnger(this.emotions.getAnger() - adjustment);
        }
        if (this.random.nextInt(1) == 0) {
            adjustment = (int)Math.round((this.easeInOutCubic((float)this.emotions.getDistress() / 100.0f) * 0.5 + 0.25) * 20.0 + 1.0);
            this.emotions.setDistress(this.emotions.getDistress() - adjustment);
        }
        if (this.random.nextInt(1) == 0) {
            adjustment = (int)Math.round((this.easeInOutCubic((float)this.emotions.getDistress() / 100.0f) * 0.5 + 0.25) * 20.0 + 1.0);
            this.emotions.setHappiness(this.emotions.getHappiness() - adjustment);
        }
        this.emotionChanged();
    }

    public double easeInOutCubic(float x) {
        return (double)x < 0.5 ? (double)(4.0f * x * x * x) : 1.0 - Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0;
    }

    public void tame(Player pPlayer) {
        this.emotions.setDistress(this.emotions.getDistress() - 70);
        this.emotions.setHappiness(this.emotions.getHappiness() + 60);
        super.tame(pPlayer);
    }

    public void emotionChanged() {
        if (!this.level().isClientSide) {
            int packedEmotion = this.emotions.getHappiness() << 16 | this.emotions.getDistress() << 8 | this.emotions.getAnger();
            HexereiPacketHandler.sendToNearbyClient(this.level(), (Entity)this, (CustomPacketPayload)new EmotionPacket((Entity)this, packedEmotion));
        }
    }

    private int adjustTowardsRestingPoint(int currentValue, int adjustmentFactor) {
        int restingPoint = 0;
        int difference = currentValue - restingPoint;
        int adjustment = Math.round((float)difference / (float)adjustmentFactor);
        int newValue = Math.max(0, Math.min(100, currentValue - (adjustment += this.random.nextInt(5) - 2)));
        return newValue;
    }

    public boolean checkTotemDeathProtection(DamageSource pDamageSource) {
        if (pDamageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        ItemStack itemstack = null;
        boolean triggered = false;
        for (InteractionHand interactionhand : InteractionHand.values()) {
            ItemStack itemstack1 = this.getItemInHand(interactionhand);
            if (!itemstack1.is((Item)ModItems.CROW_ANKH_AMULET.get())) continue;
            itemstack = itemstack1.copy();
            itemstack1.shrink(1);
            triggered = true;
            break;
        }
        if (triggered) {
            this.setHealth(1.0f);
            this.removeAllEffects();
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
            this.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
            this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
            this.level().broadcastEntityEvent((Entity)this, (byte)35);
            this.sync();
        }
        return triggered;
    }

    public void tick() {
        LivingEntity livingEntity;
        super.tick();
        if (!this.sync && this.level() instanceof ServerLevel) {
            this.sync();
            this.sync = true;
        }
        if (!this.sync && this.level() instanceof ClientLevel) {
            if (this.level().isClientSide) {
                HexereiPacketHandler.sendToServer(new AskForSyncPacket((Entity)this));
            }
            this.sync = true;
        }
        if (this.breedGiftGivenByPartnerTimer > 0 && !this.level().isClientSide) {
            --this.breedGiftGivenByPartnerTimer;
            if (this.breedGiftGivenByPartnerTimer == 16) {
                this.peck();
                HexereiPacketHandler.sendToNearbyClient(this.level(), (Entity)this, (CustomPacketPayload)new PeckPacket((Entity)this));
            }
            if (this.breedGiftGivenByPartnerTimer == 0 && this.level().getPlayerByUUID(this.breedGiftGivenByPlayerUUID) != null) {
                this.setInLove(this.level().getPlayerByUUID(this.breedGiftGivenByPlayerUUID));
                this.heal(4.0f);
                if (!this.level().isClientSide) {
                    HexereiPacketHandler.sendToNearbyClient(this.level(), (Entity)this, (CustomPacketPayload)new EatParticlesPacket((Entity)this, this.itemHandler.getStackInSlot(1)));
                    this.emotions.setDistress(this.emotions.getDistress() - 25);
                    this.emotions.setAnger(this.emotions.getAnger() - 15 - this.random.nextInt(5));
                    this.emotionChanged();
                }
                if (this.itemHandler.getStackInSlot(1).hasCraftingRemainingItem()) {
                    this.spawnAtLocation(this.itemHandler.getStackInSlot(1).getCraftingRemainingItem());
                }
                this.itemHandler.getStackInSlot(1).shrink(1);
                this.playSound(SoundEvents.PARROT_EAT, this.getSoundVolume(), this.getVoicePitch());
                this.syncInv();
            }
        }
        this.quirkController.tick(this);
        if (!this.level().isClientSide) {
            float threshold;
            float health = this.getHealth();
            if (health < (threshold = this.getMaxHealth() / 3.0f) && this.tickCount - this.lowHealthDistressIncreaseTickLast > 20 && this.random.nextInt(10) == 0) {
                this.lowHealthDistressIncreaseTickLast = this.tickCount;
                this.emotions.setDistress(this.emotions.getDistress() + 5 + this.random.nextInt(15));
                this.emotions.setHappiness(this.emotions.getHappiness() - (this.random.nextInt(5) + 1));
                this.emotionChanged();
            }
            if (this.tickCount % 100 == 0) {
                Player owner;
                if (this.isTame() && (livingEntity = this.getOwner()) instanceof Player && (owner = (Player)livingEntity).distanceTo((Entity)this) < 5.0f) {
                    this.emotions.setHappiness(this.emotions.getHappiness() + (this.random.nextInt(5) + 1));
                }
                if (this.emotions.isHappy() && this.getHealth() < this.getMaxHealth()) {
                    this.heal(1.0f);
                }
            }
        }
        float deltaDist = (float)Math.sqrt(this.getDeltaMovement().x * this.getDeltaMovement().x + this.getDeltaMovement().z * this.getDeltaMovement().z);
        float deltaYDist = (float)Math.sqrt(this.getDeltaMovement().y * this.getDeltaMovement().y);
        this.itemHeldSwingLast = this.itemHeldSwing;
        this.itemHeldSwing = this.moveTo(this.itemHeldSwing, Mth.clamp((float)((deltaDist * 455.0f - deltaYDist * 300.0f) / 4.0f), (float)0.0f, (float)40.0f), 3.0f + 10.0f * Mth.abs((float)(Mth.clamp((float)((deltaDist * 455.0f - deltaYDist * 300.0f) / 4.0f), (float)0.0f, (float)40.0f) - this.itemHeldSwing)) / 40.0f);
        ++this.animationCounter;
        ++this.rideCooldownCounter;
        if (!this.level().isClientSide) {
            if (this.onGround() && this.isFlying()) {
                this.entityData.set(DATA_FLYING, (Object)false);
            }
            if (this.isFlyingNav() && !this.isFlying()) {
                this.entityData.set(DATA_FLYING, (Object)true);
            }
            ++this.emotionTicks;
            if (this.emotionTicks >= 600) {
                this.emotionTicks = 0;
                this.adjustEmotion();
            }
        }
        if ((livingEntity = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)livingEntity;
            if (this.targetingItem == null && this.currentTask == OwlTask.PICKUP_ITEM) {
                this.currentTask = OwlTask.NONE;
            }
        }
        this.bodyYOffsetLast = this.bodyYOffset;
        this.rightWingAngleLast = this.rightWingAngle;
        this.leftWingAngleLast = this.leftWingAngle;
        this.rightWingMiddleAngleLast = this.rightWingMiddleAngle;
        this.leftWingMiddleAngleLast = this.leftWingMiddleAngle;
        this.bodyXRotLast = this.bodyXRot;
        if (this.isFlying() && !this.onGround()) {
            if (this.getDeltaMovement().y < -0.0075) {
                this.bodyXRot = (float)Mth.lerp((double)0.15, (double)this.bodyXRot, (double)1.0471975803375244);
                this.rightWingMiddleFoldAngle = (float)Mth.lerp((double)0.45, (double)this.rightWingMiddleFoldAngle, (double)(-((float)Math.toRadians(-15.0))));
                this.leftWingMiddleFoldAngle = (float)Mth.lerp((double)0.45, (double)this.leftWingMiddleFoldAngle, (double)((float)Math.toRadians(-15.0)));
                this.rightWingFoldAngle = (float)Mth.lerp((double)0.45, (double)this.rightWingFoldAngle, (double)((float)Math.toRadians(25.0)));
                this.leftWingFoldAngle = (float)Mth.lerp((double)0.45, (double)this.leftWingFoldAngle, (double)(-((float)Math.toRadians(25.0))));
                this.bodyYOffset = (float)Mth.lerp((double)0.45, (double)this.bodyYOffset, (double)Math.sin((ClientEvents.getClientTicksWithoutPartial() + 2.0f) / 8.0f));
                this.rightWingAngle = (float)Mth.lerp((double)0.75, (double)this.rightWingAngle, (double)(Math.sin(ClientEvents.getClientTicksWithoutPartial() / 8.0f) * (double)0.1f));
                this.leftWingAngle = (float)Mth.lerp((double)0.75, (double)this.leftWingAngle, (double)(-Math.sin(ClientEvents.getClientTicksWithoutPartial() / 8.0f) * (double)0.1f));
                this.rightWingMiddleAngle = (float)Mth.lerp((double)0.75, (double)this.rightWingMiddleAngle, (double)((double)(Mth.sin((float)((ClientEvents.getClientTicksWithoutPartial() - 8.0f) / 8.0f)) * 0.25f) - 0.125));
                this.leftWingMiddleAngle = (float)Mth.lerp((double)0.75, (double)this.leftWingMiddleAngle, (double)((double)(-Mth.sin((float)((ClientEvents.getClientTicksWithoutPartial() - 8.0f) / 8.0f)) * 0.25f) + 0.125));
            } else {
                this.bodyXRot = (float)Mth.lerp((double)0.15, (double)this.bodyXRot, (double)0.7853981852531433);
                this.rightWingMiddleFoldAngle = (float)Mth.lerp((double)0.45, (double)this.rightWingMiddleFoldAngle, (double)(-((float)Math.toRadians(5.0))));
                this.leftWingMiddleFoldAngle = (float)Mth.lerp((double)0.45, (double)this.leftWingMiddleFoldAngle, (double)((float)Math.toRadians(5.0)));
                this.rightWingFoldAngle = (float)Mth.lerp((double)0.45, (double)this.rightWingFoldAngle, (double)((float)Math.toRadians(0.0)));
                this.leftWingFoldAngle = (float)Mth.lerp((double)0.45, (double)this.leftWingFoldAngle, (double)(-((float)Math.toRadians(0.0))));
                this.bodyYOffset = (float)Mth.lerp((double)0.45, (double)this.bodyYOffset, (double)Math.sin((ClientEvents.getClientTicksWithoutPartial() + 1.0f) / 4.0f));
                this.rightWingAngle = (float)Mth.lerp((double)0.75, (double)this.rightWingAngle, (double)(Math.sin(ClientEvents.getClientTicksWithoutPartial() / 4.0f) * 1.0));
                this.leftWingAngle = (float)Mth.lerp((double)0.75, (double)this.leftWingAngle, (double)(-Math.sin(ClientEvents.getClientTicksWithoutPartial() / 4.0f) * 1.0));
                this.rightWingMiddleAngle = (float)Mth.lerp((double)0.75, (double)this.rightWingMiddleAngle, (double)((double)(Mth.sin((float)((ClientEvents.getClientTicksWithoutPartial() - 4.0f) / 4.0f)) * 0.5f) - 0.25));
                this.leftWingMiddleAngle = (float)Mth.lerp((double)0.75, (double)this.leftWingMiddleAngle, (double)((double)(-Mth.sin((float)((ClientEvents.getClientTicksWithoutPartial() - 4.0f) / 4.0f)) * 0.5f) + 0.25));
            }
            this.rightWingTipAngle = (float)Mth.lerp((double)0.45, (double)this.rightWingTipAngle, (double)((float)Math.toRadians(15.0)));
            this.leftWingTipAngle = (float)Mth.lerp((double)0.45, (double)this.leftWingTipAngle, (double)(-((float)Math.toRadians(15.0))));
        } else {
            this.bodyXRot = (float)Mth.lerp((double)0.25, (double)this.bodyXRot, (double)0.0);
            this.bodyYOffset = (float)Mth.lerp((double)0.25, (double)this.bodyYOffset, (double)0.0);
            this.rightWingAngle = (float)Mth.lerp((double)0.45, (double)this.rightWingAngle, (double)(-((float)Math.toRadians(85.0))));
            this.leftWingAngle = (float)Mth.lerp((double)0.45, (double)this.leftWingAngle, (double)((float)Math.toRadians(85.0)));
            this.rightWingMiddleAngle = (float)Mth.lerp((double)0.45, (double)this.rightWingMiddleAngle, (double)(-((float)Math.toRadians(10.0))));
            this.leftWingMiddleAngle = (float)Mth.lerp((double)0.45, (double)this.leftWingMiddleAngle, (double)((float)Math.toRadians(10.0)));
            this.rightWingMiddleFoldAngle = (float)Mth.lerp((double)0.45, (double)this.rightWingMiddleFoldAngle, (double)((float)Math.toRadians(30.0)));
            this.leftWingMiddleFoldAngle = (float)Mth.lerp((double)0.45, (double)this.leftWingMiddleFoldAngle, (double)(-((float)Math.toRadians(30.0))));
            this.rightWingFoldAngle = (float)Mth.lerp((double)0.45, (double)this.rightWingFoldAngle, (double)((float)Math.toRadians(0.0)));
            this.leftWingFoldAngle = (float)Mth.lerp((double)0.45, (double)this.leftWingFoldAngle, (double)(-((float)Math.toRadians(0.0))));
            this.rightWingTipAngle = (float)Mth.lerp((double)0.45, (double)this.rightWingTipAngle, (double)((float)Math.toRadians(60.0)));
            this.leftWingTipAngle = (float)Mth.lerp((double)0.45, (double)this.leftWingTipAngle, (double)(-((float)Math.toRadians(60.0))));
        }
        this.animationController.tick();
        this.messagingController.tick();
        if (!this.itemHandler.getStackInSlot(1).isEmpty()) {
            ++this.heldItemTime;
            if (this.heldItemTime > 60 && this.isOwlEdible(this.itemHandler.getStackInSlot(1)) && (!this.isTame() || this.getHealth() < this.getMaxHealth() || this.emotions.getDistress() > 50 || this.emotionState == EmotionState.DISTRESSED)) {
                this.heldItemTime = 0;
                this.heal(4.0f);
                if (!this.level().isClientSide) {
                    HexereiPacketHandler.sendToNearbyClient(this.level(), (Entity)this, (CustomPacketPayload)new EatParticlesPacket((Entity)this, this.itemHandler.getStackInSlot(1)));
                    this.emotions.setDistress(this.emotions.getDistress() - 25);
                    this.emotions.setAnger(this.emotions.getAnger() - 15 - this.random.nextInt(5));
                    this.emotionChanged();
                }
                this.playSound(SoundEvents.PARROT_EAT, this.getSoundVolume(), this.getVoicePitch());
                if (TEMPTATION_ITEMS.test(this.itemHandler.getStackInSlot(1)) && this.fishThrowerID != null && !this.isTame()) {
                    if (this.getRandom().nextFloat() < 0.5f && this.level().getPlayerByUUID(this.fishThrowerID) != null && !EventHooks.onAnimalTame((Animal)this, (Player)this.level().getPlayerByUUID(this.fishThrowerID))) {
                        this.setTame(true, true);
                        this.setOwnerUUID(this.fishThrowerID);
                        Player player = this.level().getPlayerByUUID(this.fishThrowerID);
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.TAME_ANIMAL.trigger((ServerPlayer)player, (Animal)this);
                        }
                        this.level().broadcastEntityEvent((Entity)this, (byte)7);
                    } else {
                        this.level().broadcastEntityEvent((Entity)this, (byte)6);
                    }
                }
                if (this.itemHandler.getStackInSlot(1).hasCraftingRemainingItem()) {
                    this.spawnAtLocation(this.itemHandler.getStackInSlot(1).getCraftingRemainingItem());
                }
                this.itemHandler.getStackInSlot(1).shrink(1);
                this.syncInv();
            }
        } else {
            this.heldItemTime = 0;
        }
        this.determineEmotionState();
    }

    public void eatParticles(ItemStack stack) {
        float scale = 3.0f;
        if (this.isBaby()) {
            scale = 4.0f;
        }
        Vec3 vec3 = this.calculateViewVector(0.0f, this.yHeadRot);
        for (int i = 0; i < 6; ++i) {
            this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), this.getRandomX(0.125) + vec3.x / (double)scale, this.random.nextDouble() / 4.0 - 0.125 + this.getEyeY(), this.getRandomZ(0.125) + vec3.z / (double)scale, (this.random.nextDouble() - 0.5) / 15.0, (this.random.nextDouble() + 0.5) * 0.15, (this.random.nextDouble() - 0.5) / 15.0);
        }
    }

    private float moveTo(float input, float moveTo, float speed) {
        float distance = moveTo - input;
        if (Math.abs(distance) <= speed) {
            return moveTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    public void setPerchPos(BlockPos pos) {
        this.entityData.set(PERCH_POS, Optional.ofNullable(pos));
    }

    public BlockPos getPerchPos() {
        return ((Optional)this.entityData.get(PERCH_POS)).orElse(null);
    }

    public DyeColor getDyeColor() {
        DyeColor color = HexereiUtil.getDyeColorNamed(this.getName().getString(), 0);
        return color == null ? DyeColor.byId((int)((Integer)this.entityData.get(OWL_DYE_COLOR))) : color;
    }

    public int getDyeColorId() {
        return (Integer)this.entityData.get(OWL_DYE_COLOR);
    }

    public void setDyeColor(int color) {
        this.entityData.set(OWL_DYE_COLOR, (Object)color);
    }

    public void setDyeColor(DyeColor color) {
        this.entityData.set(OWL_DYE_COLOR, (Object)color.getId());
    }

    protected PathNavigation createNavigation(Level worldIn) {
        return this.createFlyingNavigation(worldIn);
    }

    protected PathNavigation createFlyingNavigation(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.setCanOpenDoors(false);
        flyingpathnavigator.setCanFloat(true);
        flyingpathnavigator.setCanPassDoors(true);
        return flyingpathnavigator;
    }

    protected PathNavigation createGroundNavigation(Level worldIn) {
        GroundPathNavigation groundpathnavigator = new GroundPathNavigation((Mob)this, worldIn);
        groundpathnavigator.setCanOpenDoors(false);
        groundpathnavigator.setCanFloat(true);
        groundpathnavigator.setCanPassDoors(true);
        return groundpathnavigator;
    }

    public static AttributeSupplier createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.FLYING_SPEED, 0.6).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 3.0).build();
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return switch (slot.getType()) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.Type.HAND -> this.itemHandler.getStackInSlot(1);
            case EquipmentSlot.Type.HUMANOID_ARMOR -> this.itemHandler.getStackInSlot(0);
            case EquipmentSlot.Type.ANIMAL_ARMOR -> ItemStack.EMPTY;
        };
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readAdditionalSaveDataNoSuper(compound);
    }

    public void readAdditionalSaveDataNoSuper(CompoundTag compound) {
        this.setTypeVariant(compound.getInt("Variant"));
        if (compound.contains("IsFlyingNav")) {
            this.switchNavigator(compound.getBoolean("IsFlyingNav"), true);
        }
        if (compound.contains("IsFlying")) {
            this.setFlying(compound.getBoolean("IsFlying"));
        } else {
            this.entityData.set(DATA_FLYING, (Object)false);
        }
        if (compound.contains("InteractionRange")) {
            this.interactionRange = compound.getInt("InteractionRange");
        }
        if (compound.contains("CanAttack")) {
            this.canAttack = compound.getBoolean("CanAttack");
        }
        this.itemHandler.deserializeNBT((HolderLookup.Provider)this.registryAccess(), compound.getCompound("inv"));
        if (compound.contains("PerchX") && compound.contains("PerchY") && compound.contains("PerchZ")) {
            this.setPerchPos(new BlockPos(compound.getInt("PerchX"), compound.getInt("PerchY"), compound.getInt("PerchZ")));
        }
        if (compound.contains("DyeColor")) {
            this.setDyeColor(compound.getInt("DyeColor"));
        }
        if (compound.contains("EmotionScales")) {
            int packedEmotionScales = compound.getInt("EmotionScales");
            int happiness = packedEmotionScales >> 16 & 0xFF;
            int distress = packedEmotionScales >> 8 & 0xFF;
            int anger = packedEmotionScales & 0xFF;
            this.emotions = new Emotions(anger, distress, happiness);
        }
        this.quirkController.read(compound);
        this.messagingController.read(compound);
        if (compound.contains("task")) {
            this.currentTask = OwlTask.byId(compound.getInt("task"));
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addAdditionalSaveDataNoSuper(compound);
    }

    public void addAdditionalSaveDataNoSuper(CompoundTag compound) {
        compound.putInt("Variant", this.getTypeVariant());
        compound.putInt("InteractionRange", this.interactionRange);
        compound.putBoolean("CanAttack", this.canAttack);
        compound.putBoolean("IsFlying", this.isFlying());
        compound.putBoolean("IsFlyingNav", this.isFlyingNav());
        compound.put("inv", (Tag)this.itemHandler.serializeNBT((HolderLookup.Provider)this.registryAccess()));
        if (this.getPerchPos() != null) {
            compound.putInt("PerchX", this.getPerchPos().getX());
            compound.putInt("PerchY", this.getPerchPos().getY());
            compound.putInt("PerchZ", this.getPerchPos().getZ());
        }
        compound.putInt("DyeColor", this.getDyeColorId());
        int packedEmotionScales = this.emotions.getHappiness() << 16 | this.emotions.getDistress() << 8 | this.emotions.getAnger();
        compound.putInt("EmotionScales", packedEmotionScales);
        this.quirkController.write(compound);
        this.messagingController.write(compound);
        compound.putInt("task", this.currentTask.ordinal());
    }

    @javax.annotation.Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @javax.annotation.Nullable SpawnGroupData spawnGroupData) {
        OwlVariant variant;
        RandomSource randomsource = level.getRandom();
        if (spawnGroupData instanceof CrowGroupData) {
            variant = ((CrowGroupData)((Object)spawnGroupData)).variant;
        } else {
            boolean isVariant = randomsource.nextInt(5) == 0;
            variant = (OwlVariant)((Object)Util.getRandom((Object[])OwlVariant.values(), (RandomSource)randomsource));
            if (!isVariant) {
                variant = OwlVariant.GREAT_HORNED;
            }
            spawnGroupData = new CrowGroupData(variant);
        }
        this.setTypeVariant(variant.getId() & 0xFF);
        List col = BuiltInRegistries.BLOCK.stream().toList();
        for (int i = 0; i < 25; ++i) {
            Object object = col.toArray()[(int)((float)col.size() * new Random().nextFloat())];
            if (!(object instanceof Block)) continue;
            Block block = (Block)object;
            try {
                if (!Block.isFaceFull((VoxelShape)block.defaultBlockState().getShape((BlockGetter)level, this.blockPosition(), CollisionContext.empty()), (Direction)Direction.UP) || block.asItem() == Items.AIR) continue;
                this.quirkController.addQuirk(new FavoriteBlockQuirk(block, 20));
                break;
            }
            catch (Exception err) {
                LOGGER.error("Error trying to set block as favorite: {}", (Object)block, (Object)err);
            }
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void aiStep() {
        super.aiStep();
        Vec3 motion = this.getDeltaMovement();
        if (this.isFlying() && motion.y < 0.0) {
            this.setDeltaMovement(motion.multiply(1.0, 0.7, 1.0));
        }
    }

    public void travel(Vec3 vec3d) {
        if (this.getPerchPos() == null) {
            if ((this.isOrderedToSit() || this.isInSittingPose()) && this.currentTask.isNone()) {
                if (this.getNavigation().getPath() != null) {
                    this.getNavigation().stop();
                }
                vec3d = Vec3.ZERO;
            }
        } else {
            double topOffset = this.level().getBlockState(this.getPerchPos()).getOcclusionShape((BlockGetter)this.level(), this.getPerchPos()).max(Direction.Axis.Y);
            if (this.distanceTo(this.getPerchPos().getX(), this.getPerchPos().getZ()) < 1.0 && this.position().y() >= (double)this.getPerchPos().getY() + topOffset && this.position().y() < (double)this.getPerchPos().above().getY() + topOffset - 0.75 && (this.isOrderedToSit() || this.isInSittingPose()) && this.currentTask.isNone()) {
                if (this.getNavigation().getPath() != null) {
                    this.getNavigation().stop();
                }
                vec3d = Vec3.ZERO;
            }
        }
        super.travel(vec3d);
    }

    public double distanceTo(double p_20276_, double p_20278_) {
        double d0 = this.getX() - p_20276_ - 0.5;
        double d1 = this.getZ() - p_20278_ - 0.5;
        return Mth.sqrt((float)((float)(d0 * d0 + d1 * d1)));
    }

    protected int calculateFallDamage(float p_21237_, float p_21238_) {
        return 0;
    }

    protected void checkFallDamage(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    public boolean isFood(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    public Map<String, Vector3f> getModelRotationValues() {
        return this.modelRotationValues;
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        OwlEntity owl = (OwlEntity)((EntityType)ModEntityTypes.OWL.get()).create((Level)world);
        if (owl != null) {
            OwlVariant owlVariant = ((OwlEntity)entity).getVariant();
            if (this.random.nextBoolean()) {
                owlVariant = this.getVariant();
            }
            owl.setTypeVariant(owlVariant.getId() & 0xFF);
            owl.setPersistenceRequired();
        }
        return owl;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.itemHandler.getStackInSlot(1).isEmpty()) {
            if (!this.isTame() && this.isOwlTemptItem(itemstack)) {
                ItemStack particleCopy = itemstack.copy();
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                if (!this.level().isClientSide) {
                    this.emotions.setDistress(this.emotions.getDistress() - 25);
                    this.emotions.setAnger(this.emotions.getAnger() - 15 - this.random.nextInt(5));
                    this.emotionChanged();
                    this.heal(4.0f);
                    if (!this.level().isClientSide) {
                        HexereiPacketHandler.sendToNearbyClient(this.level(), (Entity)this, (CustomPacketPayload)new EatParticlesPacket((Entity)this, particleCopy));
                    }
                    if (this.random.nextInt(5) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)player)) {
                        this.tame(player);
                        this.level().broadcastEntityEvent((Entity)this, (byte)7);
                    } else {
                        this.level().broadcastEntityEvent((Entity)this, (byte)6);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (this.isTame() && this.isOwlTemptItem(itemstack) && (this.emotions.getDistress() > 15 || !this.isMaxHealth())) {
                ItemStack particleCopy = itemstack.copy();
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                if (!this.level().isClientSide) {
                    this.emotions.setDistress(this.emotions.getDistress() - 25);
                    this.emotions.setAnger(this.emotions.getAnger() - 15 - this.random.nextInt(5));
                    this.emotionChanged();
                    this.heal(4.0f);
                    if (!this.level().isClientSide) {
                        HexereiPacketHandler.sendToNearbyClient(this.level(), (Entity)this, (CustomPacketPayload)new EatParticlesPacket((Entity)this, particleCopy));
                    }
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (!player.isSecondaryUseActive() && this.isTame() && this.isOwnedBy((LivingEntity)player) && !this.isBaby() && itemstack.getItem() == Items.RABBIT && !this.isInLove()) {
                if (this.getAge() == 0) {
                    if (!player.getAbilities().instabuild) {
                        itemstack.shrink(1);
                    }
                    if (!this.level().isClientSide) {
                        this.setInLove(player);
                        this.spawnAtLocation(this.itemHandler.getStackInSlot(1).copy());
                        this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)Items.RABBIT));
                        this.breedGiftGivenByPlayer = true;
                        this.breedGiftGivenByPlayerUUID = player.getUUID();
                        this.currentTask = OwlTask.BREEDING;
                    }
                } else if (!this.headShakeAnimation.active) {
                    this.headShakeAnimation.start();
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
        }
        if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
            if (player.isSecondaryUseActive() && this.isOwnedBy((LivingEntity)player)) {
                if (!this.level().isClientSide()) {
                    MenuProvider containerProvider = this.createContainerProvider(this.level(), this.blockPosition());
                    player.openMenu(containerProvider, b -> b.writeInt(this.getId()));
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (itemstack.getItem() == ModItems.COURIER_LETTER.get()) {
                if (this.getOwner() == player) {
                    if (this.level().isClientSide) {
                        if (!CourierLetterItem.isSealed(itemstack)) {
                            player.sendSystemMessage((Component)Component.translatable((String)"hexerei.letter.empty"));
                        }
                    } else if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        if (CourierLetterItem.isSealed(itemstack)) {
                            HexereiPacketHandler.sendToPlayerClient(new ClientboundOpenOwlCourierSendScreenPacket(this.getId(), hand, player.getInventory().selected), serverPlayer);
                        }
                    }
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (itemstack.getItem() == ModItems.COURIER_PACKAGE.get()) {
                CourierPackageItem.PackageInvWrapper wrapper = new CourierPackageItem.PackageInvWrapper(itemstack);
                boolean empty = wrapper.isEmpty();
                if (this.getOwner() == player) {
                    if (this.level().isClientSide) {
                        if (empty || !wrapper.getSealed()) {
                            player.sendSystemMessage((Component)Component.translatable((String)"hexerei.package.empty"));
                        }
                    } else if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        if (!empty && wrapper.getSealed()) {
                            HexereiPacketHandler.sendToPlayerClient(new ClientboundOpenOwlCourierSendScreenPacket(this.getId(), hand, player.getInventory().selected), serverPlayer);
                        }
                    }
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (!this.level().isClientSide) {
                DyeColor dyecolor;
                if (itemstack.getItem() instanceof DyeItem && ((dyecolor = ((DyeItem)itemstack.getItem()).getDyeColor()) != this.getDyeColor() || this.getDyeColorId() == -1)) {
                    this.setDyeColor(dyecolor);
                    if (!player.getAbilities().instabuild) {
                        itemstack.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                this.setOrderedToSit(!this.isOrderedToSit());
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    protected void dropAllDeathLoot(ServerLevel p_level, DamageSource damageSource) {
        ItemStack hat = this.itemHandler.getStackInSlot(0);
        ItemStack itemstack = this.itemHandler.getStackInSlot(1);
        ItemStack messageStack = this.messagingController.getMessageStack();
        if (!itemstack.isEmpty()) {
            this.spawnAtLocation(itemstack);
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
        if (!hat.isEmpty()) {
            this.spawnAtLocation(hat.copy());
            this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
        }
        if (!messageStack.isEmpty()) {
            this.spawnAtLocation(messageStack.copy());
            this.messagingController.messageStack = ItemStack.EMPTY;
        }
        super.dropAllDeathLoot(p_level, damageSource);
    }

    private boolean isOwlEdible(ItemStack stack) {
        return stack.has(DataComponents.FOOD) || this.isOwlTemptItem(stack);
    }

    private boolean isOwlTemptItem(ItemStack stack) {
        return TEMPTATION_ITEMS.test(stack);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        if (this.isTame()) {
            if (this.getHealth() < this.getMaxHealth()) {
                return this.isOwlEdible(stack);
            }
            if (this.emotions.getDistress() > 50 || this.emotionState == EmotionState.DISTRESSED) {
                return this.isOwlTemptItem(stack);
            }
        }
        return !this.isTame() && this.isOwlEdible(stack) && !this.isMaxHealth() || this.isOwlTemptItem(stack);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        ItemStack duplicate = e.getItem().copy();
        duplicate.setCount(1);
        if (!this.itemHandler.getStackInSlot(1).isEmpty() && !this.level().isClientSide) {
            this.spawnAtLocation(this.itemHandler.getStackInSlot(1), 0.0f);
        }
        Entity itemThrower = e.getOwner();
        this.itemHandler.setStackInSlot(1, duplicate);
        this.fishThrowerID = TEMPTATION_ITEMS.test(e.getItem()) && !this.isTame() ? (itemThrower == null ? null : itemThrower.getUUID()) : null;
        if (this.currentTask == OwlTask.PICKUP_ITEM) {
            this.currentTask = OwlTask.NONE;
        }
    }

    @Override
    public void onFindTarget(ItemEntity e) {
        if (this.currentTask.isNone()) {
            this.currentTask = OwlTask.PICKUP_ITEM;
        }
        ITargetsDroppedItems.super.onFindTarget(e);
    }

    @Override
    public double getMaxDistToItem() {
        return 1.0;
    }

    public boolean isFlying() {
        return (Boolean)this.entityData.get(DATA_FLYING);
    }

    public boolean canSitOnShoulder() {
        return this.rideCooldownCounter > 100;
    }

    protected void doPush(Entity entityIn) {
        if (!(entityIn instanceof Player)) {
            super.doPush(entityIn);
        }
    }

    public boolean onGround() {
        return this.isPassenger() || super.onGround();
    }

    public int getContainerSize() {
        return 2;
    }

    public boolean canPlaceItem(int pIndex, ItemStack pStack) {
        return this.itemHandler.isItemValid(pIndex, pStack);
    }

    public boolean canTakeItem(Container pTarget, int pIndex, ItemStack pStack) {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public ItemStack getItem(int index) {
        return this.itemHandler.getStackInSlot(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack stack = this.itemHandler.getStackInSlot(index).copy();
        if (count >= stack.getCount()) {
            this.itemHandler.setStackInSlot(index, ItemStack.EMPTY);
        } else {
            this.itemHandler.getStackInSlot(index).setCount(stack.getCount() - count);
            stack.setCount(count);
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.itemHandler.getStackInSlot(index).copy();
        this.itemHandler.setStackInSlot(index, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        if (index >= 0 && index < 3) {
            this.itemHandler.setStackInSlot(index, stack);
        }
        this.syncAdditionalData();
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        if (this.isRemoved()) {
            return false;
        }
        return !(player.distanceToSqr((Entity)this) > 144.0);
    }

    public void clearContent() {
        for (int i = 0; i < 3; ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new OwlContainer(id, this, inv, player);
    }

    private MenuProvider createContainerProvider(Level worldIn, BlockPos pos) {
        return new MenuProvider(){

            @Nullable
            public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                return new OwlContainer(i, OwlEntity.this, playerInventory, playerEntity);
            }

            public Component getDisplayName() {
                return Component.translatable((String)"");
            }
        };
    }

    public boolean isPowered() {
        return false;
    }

    public void containerChanged(Container p_18983_) {
        ItemStack stack = p_18983_.getItem(0);
        stack.setEntityRepresentation((Entity)this);
    }

    public static void teleportParticles(Level level, Vec3 pos, OwlVariant owlVariant) {
        if (level.isClientSide()) {
            for (int i = 0; i < 10; ++i) {
                RandomSource random = level.getRandom();
                SimpleParticleType particleType = OwlEntity.getParticle(owlVariant);
                Vec3 offset = new Vec3(random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1));
                level.addParticle((ParticleOptions)particleType, true, pos.x() + 0.5 + offset.x, pos.y() + random.nextDouble() * (double)0.15f, pos.z() + 0.5 + offset.z, offset.x / 4.0, random.nextDouble() * -0.05 - 0.05, offset.z / 4.0);
            }
            RandomSource random = level.getRandom();
            SimpleParticleType particleType = (SimpleParticleType)ModParticleTypes.STAR_BRUSH.get();
            float radius = 3.0f;
            for (int i = 0; i < 10; ++i) {
                float rotation = random.nextFloat() * 18.0f + 36.0f * (float)i;
                float rad = radius * random.nextFloat() * 0.5f;
                Vec3 offset = new Vec3((double)rad * Math.cos(rotation), 0.0, (double)rad * Math.sin(rotation));
                level.addParticle((ParticleOptions)particleType, true, pos.x() + offset.x, pos.y() + random.nextDouble() * (double)0.15f, pos.z() + offset.z, offset.x / 20.0, random.nextDouble() * 0.025, offset.z / 20.0);
            }
        }
    }

    public static SimpleParticleType getParticle(OwlVariant owlVariant) {
        return switch (owlVariant) {
            default -> throw new MatchException(null, null);
            case OwlVariant.GREAT_HORNED -> (SimpleParticleType)ModParticleTypes.OWL_TELEPORT.get();
            case OwlVariant.BARN -> (SimpleParticleType)ModParticleTypes.OWL_TELEPORT_BARN.get();
            case OwlVariant.BARRED -> (SimpleParticleType)ModParticleTypes.OWL_TELEPORT_BARRED.get();
            case OwlVariant.SNOWY -> (SimpleParticleType)ModParticleTypes.OWL_TELEPORT_SNOWY.get();
        };
    }

    private void flyOrWalkTo(Vec3 pos) {
        Path path1 = this.flyingNav.createPath(BlockPos.containing((Position)pos), 0);
        Path path2 = this.groundNav.createPath(BlockPos.containing((Position)pos), 0);
        if (path1 != null) {
            if (path2 == null || !path2.canReach()) {
                this.switchNavigator(true);
            } else if (path2.getDistToTarget() > path1.getDistToTarget()) {
                this.switchNavigator(true);
            } else {
                this.switchNavigator(!this.random.nextBoolean());
            }
        }
    }

    private void walkToIfNotFlyTo(Vec3 pos) {
        Path path1 = this.flyingNav.createPath(BlockPos.containing((Position)pos), 0);
        Path path2 = this.groundNav.createPath(BlockPos.containing((Position)pos), 0);
        if (path1 != null) {
            if (path2 == null) {
                this.switchNavigator(true);
            } else if (Math.max(0.0f, path2.getDistToTarget() - 2.0f) > path1.getDistToTarget()) {
                this.switchNavigator(true);
            } else {
                this.switchNavigator(false);
            }
        }
    }

    private void teleportToOwner() {
        LivingEntity livingEntity = this.getOwner();
        if (livingEntity instanceof Player) {
            Player owner = (Player)livingEntity;
            BlockPos blockpos = owner.blockPosition();
            for (int i = 0; i < 30; ++i) {
                int j = this.randomIntInclusive(-5, 5);
                int k = this.randomIntInclusive(-1, 5);
                int l = this.randomIntInclusive(-5, 5);
                boolean flag = this.teleportTo(blockpos.getX() + j, blockpos.getY() + k, blockpos.getZ() + l);
                if (!flag) continue;
                return;
            }
        }
    }

    private boolean teleportToDest(ResourceKey<Level> dim, BlockPos blockpos) {
        for (int i = 0; i < 30; ++i) {
            int j = this.randomInt(6, 12);
            int k = this.randomInt(6, 12);
            int l = this.randomInt(6, 12);
            boolean flag = this.teleportTo(dim, blockpos.getX() + j, blockpos.getY() + k, blockpos.getZ() + l);
            if (!flag) continue;
            return true;
        }
        return false;
    }

    private int randomInt(int min, int max) {
        return (this.getRandom().nextInt(max - min + 1) + min) * (this.getRandom().nextBoolean() ? -1 : 1);
    }

    private boolean teleportTo(int x, int y, int z) {
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.switchNavigator(true, true);
        this.setPos(x, y, z);
        this.moveTo((double)x + 0.5, y, (double)z + 0.5, this.getYRot(), this.getXRot());
        return true;
    }

    private boolean teleportTo(ResourceKey<Level> dim, int x, int y, int z) {
        if (!this.canTeleportTo(dim, new BlockPos(x, y, z))) {
            return false;
        }
        this.switchNavigator(true, true);
        this.setPos(x, y, z);
        this.moveTo((double)x + 0.5, y, (double)z + 0.5, this.getYRot(), this.getXRot());
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        if (pos.getY() <= -64) {
            return false;
        }
        BlockPos offset = pos.subtract((Vec3i)this.blockPosition());
        FluidState state = this.level().getFluidState(pos);
        return this.level().noCollision((Entity)this, this.getBoundingBox().move(offset)) && state.isEmpty();
    }

    private boolean canTeleportTo(ResourceKey<Level> dim, BlockPos pos) {
        if (pos.getY() <= -64) {
            return false;
        }
        BlockPos offset = pos.subtract((Vec3i)this.blockPosition());
        if (this.getServer().getLevel(dim) == null) {
            return false;
        }
        FluidState state = this.getServer().getLevel(dim).getFluidState(pos);
        return this.getServer().getLevel(dim).noCollision((Entity)this, this.getBoundingBox().move(offset)) && state.isEmpty();
    }

    private int randomIntInclusive(int p_25301_, int p_25302_) {
        return this.getRandom().nextInt(p_25302_ - p_25301_ + 1) + p_25301_;
    }

    public static enum BrowPositioning {
        NORMAL(0.0f, 0.0f, 0.0f),
        PLEAD(0.75f, 0.05f, 40.0f),
        ANGRY(0.25f, 0.5f, -15.0f);

        final float xOffset;
        final float yOffset;
        final float zRot;

        private BrowPositioning(float xOffset, float yOffset, float zRot) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zRot = zRot;
        }

        public float getxOffset() {
            return this.xOffset;
        }

        public float getyOffset() {
            return this.yOffset;
        }

        public float getzRot() {
            return this.zRot;
        }
    }

    private static class OwlMoveController
    extends MoveControl {
        private final int maxTurn;

        public OwlMoveController(OwlEntity crow, int pMaxTurn) {
            super((Mob)crow);
            this.maxTurn = pMaxTurn;
        }

        public void tick() {
            if (this.mob.getNavigation() instanceof FlyingPathNavigation) {
                if (this.operation == MoveControl.Operation.MOVE_TO) {
                    this.operation = MoveControl.Operation.WAIT;
                    this.mob.setNoGravity(true);
                    double d0 = this.wantedX - this.mob.getX();
                    double d1 = this.wantedY - this.mob.getY();
                    double d2 = this.wantedZ - this.mob.getZ();
                    double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                    if (d3 < 2.500000277905201E-7) {
                        this.mob.setYya(0.0f);
                        this.mob.setZza(0.0f);
                        return;
                    }
                    float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.mob.setYRot(this.rotlerp(this.mob.getYRot(), f, 90.0f));
                    float f1 = this.mob.onGround() ? (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)) : (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.FLYING_SPEED));
                    this.mob.setSpeed(f1);
                    double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                    if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                        float f2 = (float)(-(Mth.atan2((double)d1, (double)d4) * 57.2957763671875));
                        this.mob.setXRot(this.rotlerp(this.mob.getXRot(), f2, this.maxTurn));
                        this.mob.setYya(d1 > 0.0 ? f1 : -f1);
                    }
                } else {
                    this.mob.setNoGravity(false);
                    this.mob.setYya(0.0f);
                    this.mob.setZza(0.0f);
                }
            } else if (this.operation == MoveControl.Operation.STRAFE) {
                float f8;
                float f = (float)this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED);
                float f1 = (float)this.speedModifier * f;
                float f2 = this.strafeForwards;
                float f3 = this.strafeRight;
                float f4 = Mth.sqrt((float)(f2 * f2 + f3 * f3));
                if (f4 < 1.0f) {
                    f4 = 1.0f;
                }
                f4 = f1 / f4;
                float f5 = Mth.sin((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
                float f6 = Mth.cos((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
                float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
                if (!this.isWalkable(f7, f8 = f3 * f6 + f2 * f5)) {
                    this.strafeForwards = 1.0f;
                    this.strafeRight = 0.0f;
                }
                this.mob.setSpeed(f1);
                this.mob.setZza(this.strafeForwards);
                this.mob.setXxa(this.strafeRight);
                this.operation = MoveControl.Operation.WAIT;
            } else if (this.operation == MoveControl.Operation.MOVE_TO) {
                this.operation = MoveControl.Operation.WAIT;
                double d0 = this.wantedX - this.mob.getX();
                double d1 = this.wantedZ - this.mob.getZ();
                double d2 = this.wantedY - this.mob.getY();
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.mob.setZza(0.0f);
                    return;
                }
                float f9 = (float)(Mth.atan2((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
                this.mob.setYRot(this.rotlerp(this.mob.getYRot(), f9, 90.0f));
                this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                BlockPos blockpos = this.mob.blockPosition();
                BlockState blockstate = this.mob.level().getBlockState(blockpos);
                VoxelShape voxelshape = blockstate.getCollisionShape((BlockGetter)this.mob.level(), blockpos);
                if (d2 > (double)this.mob.maxUpStep() && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.mob.getBbWidth()) || !voxelshape.isEmpty() && this.mob.getY() < voxelshape.max(Direction.Axis.Y) + (double)blockpos.getY() && !blockstate.is(BlockTags.DOORS) && !blockstate.is(BlockTags.FENCES)) {
                    this.mob.getJumpControl().jump();
                    this.operation = MoveControl.Operation.JUMPING;
                }
            } else if (this.operation == MoveControl.Operation.JUMPING) {
                this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                if (this.mob.onGround()) {
                    this.operation = MoveControl.Operation.WAIT;
                }
            } else {
                this.mob.setZza(0.0f);
            }
        }

        private boolean isWalkable(float pRelativeX, float pRelativeZ) {
            NodeEvaluator nodeevaluator;
            PathNavigation pathnavigation = this.mob.getNavigation();
            return pathnavigation == null || (nodeevaluator = pathnavigation.getNodeEvaluator()) == null || nodeevaluator.getPathType(new PathfindingContext((CollisionGetter)this.mob.level(), this.mob), Mth.floor((double)(this.mob.getX() + (double)pRelativeX)), this.mob.getBlockY(), Mth.floor((double)(this.mob.getZ() + (double)pRelativeZ))) == PathType.WALKABLE;
        }
    }

    public static enum OwlTask {
        NONE,
        DELIVER_MESSAGE,
        GO_TO_FAVORITE_BLOCK,
        PICKUP_ITEM,
        BREEDING;


        public boolean isNoneOr(OwlTask owlTask) {
            return this == owlTask || this == NONE;
        }

        public boolean is(OwlTask owlTask) {
            return this == owlTask;
        }

        public boolean isNone() {
            return this == NONE;
        }

        public static OwlTask byId(int id) {
            OwlTask[] type = OwlTask.values();
            return type[id < 0 || id >= type.length ? 0 : id];
        }
    }

    public class AnimationController {
        private List<Animation> animations = new ArrayList<Animation>();

        public AnimationController(OwlEntity this$0) {
        }

        public void addAnimation(Animation animation) {
            this.animations.add(animation);
        }

        public void tick() {
            for (Animation animation : this.animations) {
                animation.tick();
            }
        }
    }

    public class BrowAnimation
    extends AnimationBase {
        private BrowAnim browAnim;
        private float browRotTarget;
        private float browRot;
        private OwlEntity owl;

        public float getBrowRot() {
            return this.browRot;
        }

        public void setBrowAnim(BrowAnim browAnim) {
            this.browAnim = browAnim;
        }

        public BrowAnim getBrowAnim() {
            return this.browAnim;
        }

        public BrowAnimation(OwlEntity owl) {
            this.browAnim = BrowAnim.BOTH;
            this.browRot = 0.0f;
            this.browRotTarget = 0.0f;
            this.owl = owl;
        }

        @Override
        public void activeTick() {
            if (this.owl.level().isClientSide) {
                this.browRotTarget = Mth.sin((float)(this.owl.tickCount + this.owl.getId() * 342)) * 16.0f;
            }
        }

        @Override
        public void postTick() {
            this.browRot = OwlEntity.this.moveTo(this.browRot, this.browRotTarget, 30.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.level().isClientSide) {
                this.activeTimer = 5 + this.owl.getRandom().nextInt(10);
                HexereiPacketHandler.sendToNearbyClient(this.owl.level(), (Entity)this.owl, (CustomPacketPayload)new BrowAnimPacket((Entity)this.owl, BrowAnim.values()[this.owl.getRandom().nextInt(BrowAnim.values().length)], this.activeTimer));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.cooldownTimer = OwlEntity.this.random.nextInt(160) + 60;
            this.browRotTarget = 0.0f;
        }
    }

    public static interface Animation {
        public void tick();

        public void start();

        public void stop();

        public boolean isActive();
    }

    public class BrowHappyAnimation
    extends AnimationBase {
        private BrowAnim browAnim;
        private float browRotTarget;
        private float browRot;
        private float browRotLast;
        private OwlEntity owl;

        public float getBrowRot() {
            return this.browRot;
        }

        public float getBrowRotLast() {
            return this.browRotLast;
        }

        public void setBrowAnim(BrowAnim browAnim) {
            this.browAnim = browAnim;
        }

        public BrowAnim getBrowAnim() {
            return this.browAnim;
        }

        public BrowHappyAnimation(OwlEntity owl) {
            this.browAnim = BrowAnim.BOTH;
            this.browRot = 0.0f;
            this.browRotTarget = 0.0f;
            this.owl = owl;
        }

        @Override
        public void activeTick() {
            if (this.owl.level().isClientSide) {
                float val = this.owl.tickCount + this.owl.getId() * 342;
                this.browRotTarget = Mth.sin((float)val) * 26.0f;
            }
        }

        @Override
        public void postTick() {
            this.browRotLast = this.browRot;
            this.browRot = OwlEntity.this.moveTo(this.browRot, this.browRotTarget, 30.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.level().isClientSide) {
                this.activeTimer = 15 + this.owl.getRandom().nextInt(10);
                HexereiPacketHandler.sendToNearbyClient(this.owl.level(), (Entity)this.owl, (CustomPacketPayload)new BrowAnimPacket((Entity)this.owl, BrowAnim.values()[this.owl.getRandom().nextInt(BrowAnim.values().length)], this.activeTimer, true));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.cooldownTimer = OwlEntity.this.random.nextInt(160) + 60;
            this.browRotTarget = 0.0f;
        }
    }

    public class TailWagAnimation
    extends AnimationBase {
        private float wagRotTarget;
        private float wagRot;
        private OwlEntity owl;

        public float getWagRot() {
            return this.wagRot;
        }

        public TailWagAnimation(OwlEntity owl) {
            this.wagRotTarget = 0.0f;
            this.wagRot = 0.0f;
            this.owl = owl;
        }

        @Override
        public void activeTick() {
            if (this.owl.level().isClientSide) {
                this.wagRotTarget = Mth.sin((float)(this.owl.tickCount + this.owl.getId() * 342)) * 100.0f;
            }
        }

        @Override
        public void postTick() {
            this.wagRot = OwlEntity.this.moveTo(this.wagRot, this.wagRotTarget, 30.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.level().isClientSide) {
                this.activeTimer = 5 + this.owl.getRandom().nextInt(10);
                HexereiPacketHandler.sendToNearbyClient(this.owl.level(), (Entity)this.owl, (CustomPacketPayload)new TailWagPacket((Entity)this.owl, this.activeTimer));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.cooldownTimer = OwlEntity.this.random.nextInt(160) + 20;
            this.wagRotTarget = 0.0f;
        }
    }

    public class TailFanAnimation
    extends AnimationBase {
        private float fanRotTarget;
        private float fanRot;
        private OwlEntity owl;

        public float getFanRot() {
            return this.fanRot;
        }

        public TailFanAnimation(OwlEntity owl) {
            this.fanRotTarget = 0.0f;
            this.fanRot = 0.0f;
            this.owl = owl;
        }

        @Override
        public void activeTick() {
            if (this.owl.level().isClientSide) {
                this.fanRotTarget = Mth.sin((float)(this.owl.tickCount + this.owl.getId() * 342)) * 100.0f;
            }
        }

        @Override
        public void postTick() {
            this.fanRot = OwlEntity.this.moveTo(this.fanRot, this.fanRotTarget, 30.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.level().isClientSide) {
                this.activeTimer = 5 + this.owl.getRandom().nextInt(10);
                HexereiPacketHandler.sendToNearbyClient(this.owl.level(), (Entity)this.owl, (CustomPacketPayload)new TailFanPacket((Entity)this.owl, this.activeTimer));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.cooldownTimer = OwlEntity.this.random.nextInt(160) + 20;
            this.fanRotTarget = 0.0f;
        }
    }

    public class HootAnimation
    extends AnimationBase {
        private float hootRotTarget;
        private float hootRot;
        private OwlEntity owl;

        public float getHootRot() {
            return this.hootRot;
        }

        public HootAnimation(OwlEntity owl) {
            this.hootRotTarget = 0.0f;
            this.hootRot = 0.0f;
            this.owl = owl;
        }

        @Override
        public void activeTick() {
            if (this.owl.level().isClientSide) {
                this.hootRotTarget = 80.0f;
            }
        }

        @Override
        public void postTick() {
            this.hootRot = OwlEntity.this.moveTo(this.hootRot, this.hootRotTarget, 30.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.level().isClientSide) {
                this.activeTimer = 15;
                HexereiPacketHandler.sendToNearbyClient(this.owl.level(), (Entity)this.owl, (CustomPacketPayload)new OwlHootPacket((Entity)this.owl, this.activeTimer));
                this.owl.playSound((SoundEvent)ModSounds.OWL_HOOT.get(), this.owl.getSoundVolume(), this.owl.getVoicePitch());
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.cooldownTimer = OwlEntity.this.random.nextInt(560) + 160;
            this.hootRotTarget = 0.0f;
        }
    }

    public class PeckAnimation
    extends AnimationBase {
        private float peckRotTarget;
        private float peckRot;
        private OwlEntity owl;

        public float getPeckRot() {
            return this.peckRot;
        }

        public PeckAnimation(OwlEntity owl) {
            this.peckRotTarget = 0.0f;
            this.peckRot = 0.0f;
            this.owl = owl;
            this.useCooldown = false;
        }

        @Override
        public void activeTick() {
            this.peckRotTarget = 80.0f;
        }

        @Override
        public void postTick() {
            this.peckRot = OwlEntity.this.moveTo(this.peckRot, this.peckRotTarget, 15.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.level().isClientSide) {
                this.activeTimer = 10;
                HexereiPacketHandler.sendToNearbyClient(this.owl.level(), (Entity)this.owl, (CustomPacketPayload)new PeckPacket((Entity)this.owl));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.peckRotTarget = 0.0f;
        }
    }

    public class HeadTiltAnimation
    extends AnimationBase {
        public float zTiltTarget;
        private float zTilt;
        public float xTiltTarget;
        private float xTilt;
        private OwlEntity owl;

        public float getzTilt() {
            return this.zTilt;
        }

        public float getxTilt() {
            return this.xTilt;
        }

        public HeadTiltAnimation(OwlEntity owl) {
            this.zTiltTarget = 0.0f;
            this.xTiltTarget = 0.0f;
            this.zTilt = 0.0f;
            this.xTilt = 0.0f;
            this.owl = owl;
            this.cooldownTimer = OwlEntity.this.random.nextInt(100);
        }

        @Override
        public void activeTick() {
        }

        @Override
        public void postTick() {
            this.zTilt = OwlEntity.this.moveTo(this.zTilt, this.zTiltTarget, 15.0f);
            this.xTilt = OwlEntity.this.moveTo(this.xTilt, this.xTiltTarget, 15.0f);
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.level().isClientSide) {
                this.activeTimer = OwlEntity.this.random.nextInt(20) + 10;
                this.xTiltTarget = OwlEntity.this.random.nextInt(100) - 50;
                this.zTiltTarget = OwlEntity.this.random.nextInt(100) - 50;
                HexereiPacketHandler.sendToNearbyClient(this.owl.level(), (Entity)this.owl, (CustomPacketPayload)new HeadTiltPacket((Entity)this.owl, this.activeTimer, this.xTiltTarget, this.zTiltTarget));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.zTiltTarget = 0.0f;
            this.xTiltTarget = 0.0f;
            this.cooldownTimer = OwlEntity.this.random.nextInt(80) + 20;
        }
    }

    public class HeadShakeAnimation
    extends AnimationBase {
        public float zTiltTarget;
        private float zTilt;
        private float zTiltLast;
        private OwlEntity owl;

        public float getzTilt() {
            return this.zTilt;
        }

        public float getzTiltLast() {
            return this.zTiltLast;
        }

        public HeadShakeAnimation(OwlEntity owl) {
            this.zTiltTarget = 0.0f;
            this.zTiltLast = this.zTilt = 0.0f;
            this.owl = owl;
            this.useCooldown = false;
        }

        @Override
        public void start() {
            super.start();
            if (!this.owl.level().isClientSide) {
                this.activeTimer = 15;
                HexereiPacketHandler.sendToNearbyClient(this.owl.level(), (Entity)this.owl, (CustomPacketPayload)new HeadShakePacket((Entity)this.owl, this.activeTimer));
            }
        }

        @Override
        public void stop() {
            super.stop();
            this.zTiltTarget = 0.0f;
        }

        @Override
        public void preTick() {
            this.zTiltLast = this.zTilt;
        }

        @Override
        public void activeTick() {
            this.zTiltTarget = Mth.sin((float)(this.owl.tickCount + this.owl.getId() * 642)) * 100.0f;
        }

        @Override
        public void postTick() {
            this.zTilt = OwlEntity.this.moveTo(this.zTilt, this.zTiltTarget, 15.0f);
        }
    }

    public static class MessagingController {
        private OwlEntity owl;
        private GlobalPos startPos = null;
        private GlobalPos destinationPos = null;
        private Player destinationPlayer = null;
        private Map<ResourceKey<Level>, Set<ChunkPos>> lastCheckedChunks = new HashMap<ResourceKey<Level>, Set<ChunkPos>>();
        private Stage stage = Stage.DONE;
        private ItemStack messageStack = ItemStack.EMPTY;

        public MessagingController(OwlEntity owl) {
            this.owl = owl;
        }

        public boolean hasDelivery() {
            return !this.getMessageStack().isEmpty();
        }

        public boolean isDelivering() {
            return this.stage != Stage.DONE;
        }

        public ItemStack getMessageStack() {
            return this.messageStack;
        }

        public void setMessageStack(ItemStack messageStack) {
            this.messageStack = messageStack;
        }

        public void tick() {
            if (this.owl.currentTask == OwlTask.DELIVER_MESSAGE) {
                this.handleActiveState();
            } else {
                this.handleInactiveState();
            }
        }

        public Map<ResourceKey<Level>, Set<ChunkPos>> getLastCheckedChunks() {
            return this.lastCheckedChunks;
        }

        public void clearLastCheckedChunks() {
            this.lastCheckedChunks.clear();
        }

        private MessageText loadLines(MessageText pText) {
            for (int i = 0; i < 4; ++i) {
                Component component = pText.getMessage(i);
                pText = pText.setMessage(i, component);
            }
            return pText;
        }

        public boolean forceLoadChunks() {
            Level level;
            if (this.owl.isTame() && !this.owl.isDeadOrDying() && (level = this.owl.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.hasDestination()) {
                    ServerLevel level2;
                    ServerLevel level3;
                    int dz;
                    int dx;
                    GlobalPos dest = this.getDestination();
                    GlobalPos start = this.startPos;
                    ChunkPos startChunk = new ChunkPos(start.pos());
                    ChunkPos targetChunk = new ChunkPos(dest.pos());
                    HashSet<ChunkPos> newChunks = new HashSet<ChunkPos>();
                    for (dx = -1; dx <= 1; ++dx) {
                        for (dz = -1; dz <= 1; ++dz) {
                            newChunks.add(new ChunkPos(startChunk.x + dx, startChunk.z + dz));
                        }
                    }
                    if (!newChunks.equals(this.lastCheckedChunks.get(start.dimension())) && (level3 = serverLevel.getServer().getLevel(start.dimension())) != null) {
                        OwlLoadedChunksSavedData.get().addOwlLoading(level3, this.owl, newChunks);
                        if (this.lastCheckedChunks.containsKey(start.dimension())) {
                            this.lastCheckedChunks.get(start.dimension()).clear();
                        }
                        this.lastCheckedChunks.put((ResourceKey<Level>)start.dimension(), newChunks);
                    }
                    newChunks = new HashSet();
                    for (dx = -1; dx <= 1; ++dx) {
                        for (dz = -1; dz <= 1; ++dz) {
                            newChunks.add(new ChunkPos(targetChunk.x + dx, targetChunk.z + dz));
                        }
                    }
                    if (!newChunks.equals(this.lastCheckedChunks.get(dest.dimension())) && (level2 = serverLevel.getServer().getLevel(dest.dimension())) != null) {
                        OwlLoadedChunksSavedData.get().addOwlLoading(level2, this.owl, newChunks);
                        if (this.lastCheckedChunks.containsKey(dest.dimension())) {
                            this.lastCheckedChunks.get(dest.dimension()).clear();
                        }
                        this.lastCheckedChunks.put((ResourceKey<Level>)dest.dimension(), newChunks);
                    }
                    return true;
                }
            }
            return false;
        }

        public void stopForceloadingChunks() {
            Level level = this.owl.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                OwlLoadedChunksSavedData.get(serverLevel).clearOwl(serverLevel, this.owl);
                this.owl.messagingController.clearLastCheckedChunks();
            }
        }

        private void handleActiveState() {
            if (!(this.owl.level().isClientSide || this.hasDestination() || this.owl.currentTask != OwlTask.DELIVER_MESSAGE || this.stage != Stage.FIND_FLY_OFF_LOCATION && this.stage != Stage.FLY_OFF_AND_TELEPORT && this.stage != Stage.FLY_TO_DESTINATION)) {
                this.stage = Stage.FIND_FLY_BACK_LOCATION;
            }
        }

        private void handleInactiveState() {
            if (!this.owl.level().isClientSide) {
                if (this.hasDelivery() && !this.hasDestination()) {
                    this.owl.spawnAtLocation(this.getMessageStack().copy());
                    this.setMessageStack(ItemStack.EMPTY);
                } else if (this.hasDelivery()) {
                    this.owl.currentTask = OwlTask.DELIVER_MESSAGE;
                }
            }
        }

        public void write(CompoundTag nbt) {
            Optional tag;
            if (this.startPos != null) {
                tag = GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.startPos).result();
                tag.ifPresent(value -> nbt.put("startPos", value));
            }
            if (this.destinationPos != null) {
                tag = GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.destinationPos).result();
                tag.ifPresent(value -> nbt.put("destinationPos", value));
            }
            if (this.destinationPlayer != null) {
                nbt.putUUID("destinationEntity", this.destinationPlayer.getUUID());
            }
            if (this.stage != null) {
                nbt.putInt("stage", this.stage.ordinal());
            }
            if (!this.messageStack.isEmpty()) {
                nbt.put("messageStack", this.messageStack.save((HolderLookup.Provider)this.owl.registryAccess(), (Tag)new CompoundTag()));
            }
        }

        public void read(CompoundTag nbt) {
            Optional pos;
            if (nbt.contains("startPos")) {
                pos = GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("startPos")).result();
                pos.ifPresent(globalPos -> {
                    this.startPos = globalPos;
                });
            }
            if (nbt.contains("destinationPos")) {
                pos = GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("destinationPos")).result();
                pos.ifPresent(globalPos -> {
                    this.destinationPos = globalPos;
                });
            }
            if (nbt.contains("destinationEntity")) {
                this.destinationPlayer = this.owl.level().getPlayerByUUID(nbt.getUUID("destinationEntity"));
            }
            if (nbt.contains("stage")) {
                this.stage = Stage.byId(nbt.getInt("stage"));
            }
            this.messageStack = nbt.contains("messageStack") ? ItemStack.parseOptional((HolderLookup.Provider)this.owl.registryAccess(), (CompoundTag)nbt.getCompound("messageStack")) : ItemStack.EMPTY.copy();
        }

        public void setDestination(Player entity) {
            this.destinationPlayer = entity;
        }

        public void setDestination(GlobalPos pos) {
            this.destinationPos = pos;
        }

        public void setStartPos(GlobalPos startPos) {
            this.startPos = startPos;
        }

        public boolean hasDestination() {
            return this.destinationPos != null || this.destinationPlayer != null;
        }

        public GlobalPos getDestination() {
            return this.destinationPlayer != null ? GlobalPos.of((ResourceKey)this.destinationPlayer.level().dimension(), (BlockPos)this.destinationPlayer.blockPosition()) : this.destinationPos;
        }

        public void start(GlobalPos startPos) {
            this.setStartPos(startPos);
            this.stage = Stage.byId(0);
        }

        public static enum Stage {
            FIND_FLY_OFF_LOCATION,
            FLY_OFF_AND_TELEPORT,
            FLY_TO_DESTINATION,
            FIND_FLY_BACK_LOCATION,
            FLY_BACK_AND_TELEPORT,
            RETURN_TO_START,
            DONE;


            public static Stage byId(int id) {
                return Stage.values()[id < 0 || id >= Stage.values().length ? 0 : id];
            }
        }
    }

    public static class Emotions {
        private int anger;
        private int distress;
        private int happiness;

        public Emotions(int anger, int distress, int happiness) {
            this.anger = anger;
            this.distress = distress;
            this.happiness = happiness;
        }

        public void setAnger(int anger) {
            this.anger = Mth.clamp((int)anger, (int)0, (int)100);
        }

        public void setDistress(int distress) {
            this.distress = Mth.clamp((int)distress, (int)0, (int)100);
        }

        public void setHappiness(int happiness) {
            this.happiness = Mth.clamp((int)happiness, (int)0, (int)100);
        }

        public int getAnger() {
            return this.anger;
        }

        public int getDistress() {
            return this.distress;
        }

        public int getHappiness() {
            return this.happiness;
        }

        public boolean isHappy() {
            return this.getAnger() < 30 && this.getHappiness() > 50;
        }
    }

    public class FloatGoal
    extends Goal {
        private final Mob mob;

        public FloatGoal(Mob p_25230_) {
            this.mob = p_25230_;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP));
            p_25230_.getNavigation().setCanFloat(true);
        }

        public boolean canUse() {
            return this.mob.isInWater() && this.mob.getFluidHeight(FluidTags.WATER) > this.mob.getFluidJumpThreshold() || this.mob.isInLava();
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            if (this.mob.getRandom().nextFloat() < 0.8f) {
                this.mob.getJumpControl().jump();
                Vec3 randomPos = DefaultRandomPos.getPos((PathfinderMob)OwlEntity.this, (int)10, (int)7);
                if (randomPos == null) {
                    randomPos = LandRandomPos.getPos((PathfinderMob)OwlEntity.this, (int)10, (int)7);
                }
                BlockPos pos = randomPos != null ? new BlockPos((int)randomPos.x, (int)randomPos.y, (int)randomPos.z) : (OwlEntity.this.getPerchPos() != null ? OwlEntity.this.getPerchPos().above().above() : OwlEntity.this.blockPosition().above().above());
                if (!OwlEntity.this.isInSittingPose()) {
                    this.mob.push(0.0, 0.1, 0.0);
                }
                OwlEntity.this.flyOrWalkTo(pos.getCenter());
                OwlEntity.this.navigation.moveTo(OwlEntity.this.getNavigation().createPath(pos, 0), OwlEntity.this.isFlyingNav() ? 1.5 : 1.0);
            }
        }
    }

    public class FlyBackToPerchGoal
    extends Goal {
        private final TamableAnimal mob;

        public FlyBackToPerchGoal(TamableAnimal p_25898_) {
            this.mob = p_25898_;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canContinueToUse() {
            if (OwlEntity.this.getPerchPos() == null) {
                return false;
            }
            double topOffset = 0.0;
            if (OwlEntity.this.getPerchPos() != null) {
                topOffset = OwlEntity.this.level().getBlockState(OwlEntity.this.getPerchPos()).getOcclusionShape((BlockGetter)OwlEntity.this.level(), OwlEntity.this.getPerchPos()).max(Direction.Axis.Y);
            }
            if (this.distanceTo(OwlEntity.this.getPerchPos().getX(), OwlEntity.this.getPerchPos().getZ()) < 1.0 && this.mob.position().y() >= (double)OwlEntity.this.getPerchPos().getY() + topOffset && this.mob.position().y() < (double)OwlEntity.this.getPerchPos().above().getY() + topOffset) {
                return false;
            }
            if (OwlEntity.this.isInSittingPose()) {
                OwlEntity.this.setInSittingPose(false);
                OwlEntity.this.setOrderedToSit(false);
            }
            return true;
        }

        public double distanceTo(double p_20276_, double p_20278_) {
            double d0 = OwlEntity.this.getX() - p_20276_ - 0.5;
            double d1 = OwlEntity.this.getZ() - p_20278_ - 0.5;
            return Mth.sqrt((float)((float)(d0 * d0 + d1 * d1)));
        }

        public boolean canUse() {
            if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            if (OwlEntity.this.isInSittingPose()) {
                if (OwlEntity.this.getPerchPos() != null) {
                    if (OwlEntity.this.getPerchPos().distToCenterSqr(OwlEntity.this.position().x, OwlEntity.this.position().y, OwlEntity.this.position().z) < 1.0) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (!this.mob.isTame()) {
                return false;
            }
            if (this.mob.isInWaterOrBubble()) {
                return false;
            }
            LivingEntity livingentity = this.mob.getOwner();
            if (livingentity == null) {
                return true;
            }
            if (OwlEntity.this.getPerchPos() == null) {
                return false;
            }
            double topOffset = OwlEntity.this.level().getBlockState(OwlEntity.this.getPerchPos()).getOcclusionShape((BlockGetter)OwlEntity.this.level(), OwlEntity.this.getPerchPos()).max(Direction.Axis.Y);
            if (this.distanceTo(OwlEntity.this.getPerchPos().getX(), OwlEntity.this.getPerchPos().getZ()) < 1.0 && this.mob.position().y() >= (double)OwlEntity.this.getPerchPos().getY() + topOffset && this.mob.position().y() < (double)OwlEntity.this.getPerchPos().above().getY() + topOffset) {
                if (OwlEntity.this.isInSittingPose()) {
                    return false;
                }
            } else {
                if (OwlEntity.this.isInSittingPose()) {
                    OwlEntity.this.setInSittingPose(false);
                    OwlEntity.this.setOrderedToSit(false);
                }
                return true;
            }
            return !(this.distanceTo(OwlEntity.this.getPerchPos().getX(), OwlEntity.this.getPerchPos().getZ()) < 1.0 && this.mob.position().y() >= (double)OwlEntity.this.getPerchPos().getY() + topOffset && this.mob.position().y() < (double)OwlEntity.this.getPerchPos().above().getY() + topOffset);
        }

        public void tick() {
            double topOffset = 0.0;
            if (OwlEntity.this.getPerchPos() != null) {
                topOffset = OwlEntity.this.level().getBlockState(OwlEntity.this.getPerchPos()).getOcclusionShape((BlockGetter)OwlEntity.this.level(), OwlEntity.this.getPerchPos()).max(Direction.Axis.Y);
            }
            boolean isStuck = false;
            if (!(OwlEntity.this.getPerchPos() == null || this.distanceTo(OwlEntity.this.getPerchPos().getX(), OwlEntity.this.getPerchPos().getZ()) < 1.0 && this.mob.position().y() >= (double)OwlEntity.this.getPerchPos().getY() + topOffset && this.mob.position().y() < (double)OwlEntity.this.getPerchPos().above().getY() + topOffset)) {
                OwlEntity.this.flyOrWalkTo(OwlEntity.this.getPerchPos().above().getCenter());
                OwlEntity.this.navigation.moveTo(this.mob.getNavigation().createPath(OwlEntity.this.getPerchPos().above(), -1), OwlEntity.this.isFlyingNav() ? 1.5 : 1.0);
            }
            super.tick();
        }

        public void start() {
            if (OwlEntity.this.getPerchPos() != null) {
                OwlEntity.this.flyOrWalkTo(OwlEntity.this.getPerchPos().above().getCenter());
                OwlEntity.this.navigation.moveTo(this.mob.getNavigation().createPath(OwlEntity.this.getPerchPos().above(), 0), OwlEntity.this.isFlyingNav() ? 1.5 : 1.0);
            }
        }

        public void stop() {
            OwlEntity.this.currentTask = OwlTask.NONE;
            if (OwlEntity.this.getPerchPos() != null) {
                double topOffset = OwlEntity.this.level().getBlockState(OwlEntity.this.getPerchPos()).getOcclusionShape((BlockGetter)OwlEntity.this.level(), OwlEntity.this.getPerchPos()).max(Direction.Axis.Y);
                if (this.distanceTo(OwlEntity.this.getPerchPos().getX(), OwlEntity.this.getPerchPos().getZ()) < 1.0 && this.mob.position().y() >= (double)OwlEntity.this.getPerchPos().getY() + topOffset && this.mob.position().y() < (double)OwlEntity.this.getPerchPos().above().getY() + topOffset) {
                    OwlEntity.this.setInSittingPose(true);
                }
            }
        }
    }

    public class SitWhenOrderedToGoal
    extends Goal {
        private final TamableAnimal mob;

        public SitWhenOrderedToGoal(TamableAnimal p_25898_) {
            this.mob = p_25898_;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public double distanceTo(double p_20276_, double p_20278_) {
            double d0 = OwlEntity.this.getX() - p_20276_ - 0.5;
            double d1 = OwlEntity.this.getZ() - p_20278_ - 0.5;
            return Mth.sqrt((float)((float)(d0 * d0 + d1 * d1)));
        }

        public boolean canContinueToUse() {
            if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            if (OwlEntity.this.getPerchPos() != null) {
                double topOffset = OwlEntity.this.level().getBlockState(OwlEntity.this.getPerchPos()).getOcclusionShape((BlockGetter)OwlEntity.this.level(), OwlEntity.this.getPerchPos()).max(Direction.Axis.Y);
                if (!(this.distanceTo(OwlEntity.this.getPerchPos().getX(), OwlEntity.this.getPerchPos().getZ()) < 1.0 && this.mob.position().y() >= (double)OwlEntity.this.getPerchPos().getY() + topOffset && this.mob.position().y() < (double)OwlEntity.this.getPerchPos().above().getY() + topOffset)) {
                    OwlEntity.this.setOrderedToSit(false);
                    return false;
                }
            }
            return this.mob.isOrderedToSit();
        }

        public boolean canUse() {
            if (OwlEntity.this.currentTask == OwlTask.GO_TO_FAVORITE_BLOCK) {
                List<FavoriteBlockQuirk> quirks = FavoriteBlockQuirk.fromController(OwlEntity.this.quirkController);
                boolean flag = false;
                for (FavoriteBlockQuirk quirk : quirks) {
                    if (!OwlEntity.this.getBlockStateOn().is(quirk.getFavoriteBlock())) continue;
                    flag = true;
                }
                if (!flag) {
                    return false;
                }
            } else if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            if (!this.mob.isTame()) {
                return false;
            }
            if (this.mob.isInWaterOrBubble()) {
                return false;
            }
            if (!this.mob.onGround()) {
                return false;
            }
            LivingEntity livingentity = this.mob.getOwner();
            if (livingentity == null) {
                return true;
            }
            if (OwlEntity.this.getPerchPos() != null) {
                double topOffset = OwlEntity.this.level().getBlockState(OwlEntity.this.getPerchPos()).getOcclusionShape((BlockGetter)OwlEntity.this.level(), OwlEntity.this.getPerchPos()).max(Direction.Axis.Y);
                if (!(this.distanceTo(OwlEntity.this.getPerchPos().getX(), OwlEntity.this.getPerchPos().getZ()) < 1.0 && this.mob.position().y() >= (double)OwlEntity.this.getPerchPos().getY() + topOffset && this.mob.position().y() < (double)OwlEntity.this.getPerchPos().above().getY() + topOffset)) {
                    return false;
                }
            }
            return this.mob.distanceToSqr((Entity)livingentity) < 288.0 && livingentity.getLastHurtByMob() != null ? false : this.mob.isOrderedToSit();
        }

        public void tick() {
            super.tick();
        }

        public void start() {
            this.mob.getNavigation().stop();
            this.mob.setInSittingPose(true);
        }

        public void stop() {
            this.mob.setInSittingPose(false);
        }
    }

    public class DeliverMessageGoal
    extends Goal {
        private final OwlEntity owl;
        private Vec3 wantedPos = null;
        private static final int REFRESH_MAX = 5;
        private int refresh = 5;
        private int stuck = 0;
        private int stuckStageTotal = 0;
        private int checkOldPos = 0;
        private Vec3 oldPos = null;
        private Path stuckPath = null;
        private BlockPos stuckPathDest = null;

        public DeliverMessageGoal(OwlEntity owl) {
            this.owl = owl;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canContinueToUse() {
            if (!OwlEntity.this.currentTask.is(OwlTask.DELIVER_MESSAGE)) {
                return false;
            }
            return this.owl.messagingController.isDelivering();
        }

        public boolean canUse() {
            if (!OwlEntity.this.currentTask.is(OwlTask.DELIVER_MESSAGE)) {
                return false;
            }
            if (!this.owl.messagingController.isDelivering()) {
                return false;
            }
            return this.owl.isTame();
        }

        public void tick() {
            MessagingController controller = this.owl.messagingController;
            ++this.refresh;
            ++this.stuck;
            ++this.stuckStageTotal;
            ++this.checkOldPos;
            if (this.checkOldPos > 40) {
                if (this.oldPos != null && this.oldPos.distanceTo(this.owl.position()) < 1.0) {
                    this.stuck = 200;
                }
                this.oldPos = this.owl.position();
                this.checkOldPos = 0;
            }
            this.owl.setInSittingPose(false);
            if (this.stuckStageTotal >= 400) {
                switch (controller.stage.ordinal()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        if (controller.getDestination() == null) break;
                        this.wantedPos = controller.getDestination().pos().getCenter();
                        controller.stage = MessagingController.Stage.FLY_TO_DESTINATION;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        if (controller.startPos == null) break;
                        this.wantedPos = controller.startPos.pos().getCenter();
                        controller.stage = MessagingController.Stage.RETURN_TO_START;
                    }
                }
                Vec3 oldPos = this.owl.position();
                ResourceKey oldDim = this.owl.level().dimension();
                OwlEntity.this.teleportTo(this.wantedPos.x(), this.wantedPos.y(), this.wantedPos.z());
                HexereiPacketHandler.sendToNearbyClient(this.owl.level(), (Entity)this.owl, (CustomPacketPayload)new OwlTeleportParticlePacket((ResourceKey<Level>)this.owl.level().dimension(), this.owl.position(), this.owl.getVariant()));
                HexereiPacketHandler.sendToNearbyClient((Level)this.owl.level().getServer().getLevel(oldDim), (Entity)this.owl, (CustomPacketPayload)new OwlTeleportParticlePacket((ResourceKey<Level>)this.owl.level().dimension(), oldPos, this.owl.getVariant()));
                this.stuckStageTotal = 0;
                this.stuck = 0;
                this.stuckPath = null;
            } else if (this.stuck >= 160 || this.stuckPath != null) {
                if (this.stuckPath == null) {
                    Path path;
                    Vec3 vec3 = this.owl.getViewVector(0.0f);
                    Vec3 vec = DeliverMessageGoal.getPos((PathfinderMob)this.owl, 7, 2, 1, vec3.x, vec3.z, 1.5707963705062866);
                    OwlEntity.this.switchNavigator(true, true);
                    if (vec != null && (path = this.owl.getNavigation().createPath(BlockPos.containing((Position)vec), 0)) != null && path.canReach()) {
                        this.stuckPath = path;
                        this.stuckPathDest = BlockPos.containing((Position)vec);
                        this.owl.getNavigation().moveTo(this.stuckPath, 2.0);
                    }
                } else {
                    this.owl.getNavigation().moveTo(this.stuckPath, 2.0);
                    if (this.owl.distanceToSqr(this.stuckPathDest.getX(), this.stuckPathDest.getY(), this.stuckPathDest.getZ()) < 3.0) {
                        this.stuckPath = null;
                        this.stuckPathDest = null;
                        this.stuck = 0;
                    }
                }
            } else {
                block4 : switch (controller.stage.ordinal()) {
                    case 0: {
                        for (int i = 0; i < 10; ++i) {
                            Vec3 vec3 = this.owl.getViewVector(0.0f);
                            Vec3 vec = DeliverMessageGoal.getPos((PathfinderMob)this.owl, 14, 4, 6, vec3.x, vec3.z, 1.5707963705062866);
                            if (vec == null || !(vec.distanceTo(this.owl.position()) > 8.0)) continue;
                            OwlEntity.this.switchNavigator(true, true);
                            Path path = this.owl.getNavigation().createPath(BlockPos.containing((Position)vec), 0);
                            if (path == null || !path.canReach()) continue;
                            this.wantedPos = vec;
                            if (!controller.forceLoadChunks()) continue;
                            controller.stage = MessagingController.Stage.FLY_OFF_AND_TELEPORT;
                            this.refresh = 5;
                            this.stuck = 0;
                            this.stuckStageTotal = 0;
                            break block4;
                        }
                        break;
                    }
                    case 1: {
                        if (!controller.hasDestination()) break;
                        if (this.wantedPos == null) {
                            controller.stage = MessagingController.Stage.FIND_FLY_OFF_LOCATION;
                            break;
                        }
                        BlockPos pos = controller.getDestination().pos();
                        Path path = this.owl.getNavigation().createPath(pos, 0);
                        double dist = this.owl.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)pos));
                        if (path != null && path.getDistToTarget() < 2.0f && dist < 1.0) {
                            controller.stage = MessagingController.Stage.FLY_TO_DESTINATION;
                            break;
                        }
                        path = this.owl.getNavigation().createPath(BlockPos.containing((Position)this.wantedPos), 0);
                        if (this.refresh > 5) {
                            this.owl.getNavigation().moveTo(path, 2.0);
                            this.refresh = 0;
                        }
                        if (!controller.forceLoadChunks() || !(OwlEntity.this.distanceToSqr(this.wantedPos.x, this.wantedPos.y, this.wantedPos.z) < 4.0)) break;
                        ResourceKey oldDim = this.owl.level().dimension();
                        Vec3 oldPos = new Vec3(this.owl.position().toVector3f());
                        if (!OwlEntity.this.teleportToDest((ResourceKey<Level>)controller.getDestination().dimension(), pos)) break;
                        ServerLevel dimChange = this.owl.getServer().getLevel(controller.getDestination().dimension());
                        if (dimChange != null && !dimChange.equals(this.owl.level())) {
                            this.owl.changeDimension(new DimensionTransition(dimChange, pos.getCenter(), this.owl.getDeltaMovement(), this.owl.getYRot(), this.owl.getXRot(), DimensionTransition.DO_NOTHING));
                        }
                        Vec3 newPos = new Vec3(this.owl.position().toVector3f());
                        HexereiPacketHandler.sendToNearbyClient(this.owl.level(), (Entity)this.owl, (CustomPacketPayload)new OwlTeleportParticlePacket((ResourceKey<Level>)this.owl.level().dimension(), this.owl.position(), this.owl.getVariant()));
                        HexereiPacketHandler.sendToNearbyClient((Level)this.owl.level().getServer().getLevel(oldDim), (Entity)this.owl, (CustomPacketPayload)new OwlTeleportParticlePacket((ResourceKey<Level>)this.owl.level().dimension(), oldPos, this.owl.getVariant()));
                        this.owl.hootAnimation.start();
                        controller.stage = MessagingController.Stage.FLY_TO_DESTINATION;
                        this.refresh = 5;
                        this.stuck = 0;
                        this.stuckStageTotal = 0;
                        break;
                    }
                    case 2: {
                        if (!controller.hasDestination()) break;
                        BlockPos pos = controller.getDestination().pos();
                        if (this.refresh > 5) {
                            Path path = this.owl.getNavigation().createPath(pos, 0);
                            this.owl.getNavigation().moveTo(path, 2.0);
                            this.refresh = 0;
                        }
                        if (!controller.forceLoadChunks() || !(OwlEntity.this.distanceToSqr(pos.getX(), pos.getY(), pos.getZ()) < 3.0)) break;
                        controller.stage = MessagingController.Stage.FIND_FLY_BACK_LOCATION;
                        this.refresh = 5;
                        this.stuck = 0;
                        this.stuckStageTotal = 0;
                        Map<GlobalPos, OwlCourierDepotData> depots = OwlCourierDepotSavedData.get().getDepots();
                        if (controller.destinationPos != null) {
                            if (this.owl.messagingController.messageStack.isEmpty() || !depots.containsKey(controller.getDestination())) break;
                            for (int i = 0; i < depots.get((Object)controller.getDestination()).items.size(); ++i) {
                                if (!((ItemStack)depots.get((Object)controller.getDestination()).items.get(i)).isEmpty()) continue;
                                depots.get((Object)controller.getDestination()).items.set(i, (Object)this.owl.messagingController.messageStack.copy());
                                this.owl.messagingController.messageStack = ItemStack.EMPTY;
                                OwlCourierDepotSavedData.get().setDirty();
                                OwlCourierDepotSavedData.get().syncInvToClient(controller.getDestination());
                                this.owl.sync();
                                this.owl.peck();
                                break block4;
                            }
                            break;
                        }
                        if (controller.destinationPlayer == null || this.owl.level().getServer().getPlayerList().getPlayer(controller.destinationPlayer.getUUID()) == null || !controller.destinationPlayer.isAlive() || this.owl.messagingController.messageStack.isEmpty()) break;
                        controller.destinationPlayer.getInventory().placeItemBackInInventory(this.owl.messagingController.messageStack.copy());
                        this.owl.messagingController.messageStack = ItemStack.EMPTY;
                        this.owl.sync();
                        this.owl.peck();
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < 10; ++i) {
                            Vec3 vec3 = this.owl.getViewVector(0.0f);
                            Vec3 vec = DeliverMessageGoal.getPos((PathfinderMob)this.owl, 14, 4, 6, vec3.x, vec3.z, 1.5707963705062866);
                            if (vec == null || !(vec.distanceTo(this.owl.position()) > 8.0)) continue;
                            OwlEntity.this.switchNavigator(true, true);
                            Path path = this.owl.getNavigation().createPath(BlockPos.containing((Position)vec), 0);
                            if (path == null || !path.canReach()) continue;
                            this.wantedPos = vec;
                            controller.stage = MessagingController.Stage.FLY_BACK_AND_TELEPORT;
                            this.refresh = 5;
                            break block4;
                        }
                        break;
                    }
                    case 4: {
                        if (controller.startPos == null) break;
                        Path path = this.owl.getNavigation().createPath(controller.startPos.pos(), 0);
                        if (path != null && path.getDistToTarget() < 2.0f && this.owl.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)controller.startPos.pos())) < 4.0) {
                            controller.stage = MessagingController.Stage.RETURN_TO_START;
                            break;
                        }
                        if (this.wantedPos == null) {
                            controller.stage = MessagingController.Stage.FIND_FLY_BACK_LOCATION;
                            break;
                        }
                        Path path2 = this.owl.getNavigation().createPath(BlockPos.containing((Position)this.wantedPos), 0);
                        if (this.refresh > 5) {
                            this.owl.getNavigation().moveTo(path2, 3.0);
                            this.refresh = 0;
                        }
                        if (!(OwlEntity.this.distanceToSqr(this.wantedPos.x, this.wantedPos.y, this.wantedPos.z) < 2.0)) break;
                        BlockPos pos = controller.startPos.pos();
                        Vec3 oldPos = new Vec3(this.owl.position().toVector3f());
                        ServerLevel dimChange = this.owl.getServer().getLevel(controller.startPos.dimension());
                        ResourceKey dim1 = controller.startPos.dimension();
                        ResourceKey dim2 = OwlEntity.this.level().dimension();
                        if (!OwlEntity.this.teleportToDest((ResourceKey<Level>)controller.startPos.dimension(), pos)) break;
                        Vec3 newPos = new Vec3(this.owl.position().toVector3f());
                        if (dimChange != null && !dimChange.equals(this.owl.level())) {
                            this.owl.changeDimension(new DimensionTransition(dimChange, pos.getCenter(), this.owl.getDeltaMovement(), this.owl.getYRot(), this.owl.getXRot(), DimensionTransition.DO_NOTHING));
                        }
                        HexereiPacketHandler.sendToNearbyClient((Level)this.owl.level().getServer().getLevel(dim1), (Entity)this.owl, (CustomPacketPayload)new OwlTeleportParticlePacket((ResourceKey<Level>)this.owl.level().dimension(), newPos, this.owl.getVariant()));
                        HexereiPacketHandler.sendToNearbyClient((Level)this.owl.level().getServer().getLevel(dim2), (Entity)this.owl, (CustomPacketPayload)new OwlTeleportParticlePacket((ResourceKey<Level>)this.owl.level().dimension(), oldPos, this.owl.getVariant()));
                        controller.stage = MessagingController.Stage.RETURN_TO_START;
                        this.wantedPos = controller.startPos.pos().getCenter();
                        this.refresh = 5;
                        this.stuck = 0;
                        this.stuckStageTotal = 0;
                        this.owl.hootAnimation.start();
                        break;
                    }
                    case 5: {
                        if (controller.startPos == null) {
                            this.end();
                            break;
                        }
                        BlockPos pos = controller.startPos.pos();
                        Path path = this.owl.getNavigation().createPath(pos, 0);
                        if (this.refresh > 5 && path != null) {
                            this.owl.getNavigation().moveTo(path, 2.0);
                            this.refresh = 0;
                        }
                        if (!(OwlEntity.this.distanceToSqr(pos.getX(), pos.getY(), pos.getZ()) < 1.5)) break;
                        this.refresh = 5;
                        this.stuck = 0;
                        this.stuckStageTotal = 0;
                        controller.stage = MessagingController.Stage.DONE;
                        if (!controller.messageStack.isEmpty()) {
                            LivingEntity livingEntity;
                            ItemEntity item = this.owl.spawnAtLocation(controller.getMessageStack().copy(), 0.0f);
                            if (item != null) {
                                item.setUnlimitedLifetime();
                            }
                            if ((livingEntity = this.owl.getOwner()) instanceof ServerPlayer) {
                                ServerPlayer owner = (ServerPlayer)livingEntity;
                                owner.sendSystemMessage((Component)Component.translatable((String)"message.hexerei.owl_could_not_deliver", (Object[])new Object[]{this.owl.getName().getString(), controller.getMessageStack().getHoverName().getString()}));
                            }
                            controller.setMessageStack(ItemStack.EMPTY);
                            this.owl.sync();
                            this.owl.peck();
                        }
                        this.end();
                    }
                }
            }
            super.tick();
        }

        public void end() {
            MessagingController controller = this.owl.messagingController;
            Level level = this.owl.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (controller.stage == MessagingController.Stage.DONE) {
                    OwlLoadedChunksSavedData.get(serverLevel).clearOwl(serverLevel, this.owl);
                }
            }
            controller.startPos = null;
            controller.destinationPlayer = null;
            controller.destinationPos = null;
            controller.stage = MessagingController.Stage.FIND_FLY_OFF_LOCATION;
            this.owl.currentTask = OwlTask.NONE;
            controller.clearLastCheckedChunks();
            this.stop();
        }

        public void start() {
            this.owl.setInSittingPose(false);
        }

        public void stop() {
        }

        @javax.annotation.Nullable
        public static Vec3 getPos(PathfinderMob pMob, int pMaxDistance, int pYRange, int pY, double pX, double pZ, double pAmplifier) {
            boolean flag = GoalUtils.mobRestricted((PathfinderMob)pMob, (int)pMaxDistance);
            return RandomPos.generateRandomPos((PathfinderMob)pMob, () -> {
                BlockPos blockpos = DeliverMessageGoal.generateRandomPos(pMob, pMaxDistance, pYRange, pY, pX, pZ, pAmplifier, flag);
                return blockpos != null && pMob.level().getFluidState(blockpos).isEmpty() ? blockpos : null;
            });
        }

        @javax.annotation.Nullable
        public static BlockPos generateRandomPos(PathfinderMob pMob, int pMaxDistance, int pYRange, int pY, double pX, double pZ, double pAmplifier, boolean pShortCircuit) {
            BlockPos blockpos = RandomPos.generateRandomDirectionWithinRadians((RandomSource)pMob.getRandom(), (int)pMaxDistance, (int)pYRange, (int)pY, (double)pX, (double)pZ, (double)pAmplifier);
            if (blockpos == null) {
                return null;
            }
            BlockPos blockpos1 = RandomPos.generateRandomPosTowardDirection((PathfinderMob)pMob, (int)pMaxDistance, (RandomSource)pMob.getRandom(), (BlockPos)blockpos);
            if (!GoalUtils.isOutsideLimits((BlockPos)blockpos1, (PathfinderMob)pMob) && !GoalUtils.isRestricted((boolean)pShortCircuit, (PathfinderMob)pMob, (BlockPos)blockpos1)) {
                return GoalUtils.hasMalus((PathfinderMob)pMob, (BlockPos)(blockpos1 = RandomPos.moveUpOutOfSolid((BlockPos)blockpos1, (int)pMob.level().getMaxBuildHeight(), p_148376_ -> GoalUtils.isSolid((PathfinderMob)pMob, (BlockPos)p_148376_)))) ? null : blockpos1;
            }
            return null;
        }
    }

    public class OwlFavoriteBlockGoal
    extends MoveToBlockGoal {
        private final OwlEntity owl;
        private int ticks;
        private int sinceLastOnBlock;
        private int cooldownTicks = 0;
        private boolean useCooldown = false;

        public OwlFavoriteBlockGoal(OwlEntity this$0, OwlEntity pOwl, double pSpeedModifier) {
            super((PathfinderMob)pOwl, pSpeedModifier, 12, 3);
            this.owl = pOwl;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        }

        public double acceptedDistance() {
            return 0.25;
        }

        public boolean canUse() {
            if (this.useCooldown && this.cooldownTicks < 500) {
                ++this.cooldownTicks;
                if (this.cooldownTicks >= 500) {
                    this.cooldownTicks = 0;
                    this.useCooldown = false;
                }
                if (this.owl.currentTask == OwlTask.GO_TO_FAVORITE_BLOCK) {
                    this.owl.currentTask = OwlTask.NONE;
                }
                return false;
            }
            if (this.sinceLastOnBlock < 20) {
                ++this.sinceLastOnBlock;
                return false;
            }
            if (this.owl.isTame() && this.owl.currentTask.isNoneOr(OwlTask.GO_TO_FAVORITE_BLOCK) && FavoriteBlockQuirk.fromController(this.owl.quirkController).size() > 0) {
                if (this.owl.currentTask == OwlTask.GO_TO_FAVORITE_BLOCK) {
                    ++this.ticks;
                    if (this.ticks > 500 || this.owl.isOrderedToSit() || this.owl.isInSittingPose()) {
                        this.owl.currentTask = OwlTask.NONE;
                        this.owl.getNavigation().stop();
                        return false;
                    }
                    List<FavoriteBlockQuirk> quirks = FavoriteBlockQuirk.fromController(this.owl.quirkController);
                    for (FavoriteBlockQuirk quirk : quirks) {
                        if (!this.owl.getBlockStateOn().is(quirk.getFavoriteBlock())) continue;
                        ++this.ticks;
                        if (this.ticks > 100) {
                            this.owl.currentTask = OwlTask.NONE;
                            this.owl.getNavigation().stop();
                            this.useCooldown = true;
                        } else {
                            Player owner;
                            LivingEntity livingEntity = this.owl.getOwner();
                            if (livingEntity instanceof Player && this.owl.distanceToSqr((Entity)(owner = (Player)livingEntity)) >= 144.0) {
                                if (!this.owl.isOrderedToSit()) {
                                    this.owl.teleportToOwner();
                                }
                                this.owl.currentTask = OwlTask.NONE;
                                this.owl.getNavigation().stop();
                                this.useCooldown = true;
                            }
                        }
                        return false;
                    }
                }
                if (this.owl.isOrderedToSit() || this.owl.isInSittingPose()) {
                    return false;
                }
                return super.canUse();
            }
            return false;
        }

        public boolean canContinueToUse() {
            boolean canContinue = super.canContinueToUse();
            return !this.useCooldown && canContinue && !this.owl.isOrderedToSit();
        }

        public void start() {
            super.start();
        }

        public void stop() {
            super.stop();
        }

        public void tick() {
            Player owner;
            BlockPos blockpos = this.getMoveToTarget();
            float dist = (float)blockpos.distToCenterSqr((Position)this.mob.position().add(0.0, 0.5, 0.0));
            if (!((double)dist < this.acceptedDistance())) {
                ++this.tryTicks;
                if (this.shouldRecalculatePath()) {
                    this.owl.walkToIfNotFlyTo(new Vec3((double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5));
                    this.mob.getNavigation().moveTo((double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5, this.speedModifier);
                } else if (dist < 3.0f) {
                    this.mob.getNavigation().stop();
                    this.mob.getMoveControl().setWantedPosition((double)((float)blockpos.getX() + 0.5f), (double)blockpos.getY(), (double)((float)blockpos.getZ() + 0.5f), this.speedModifier * 1.25);
                }
            } else {
                if (this.ticks < 100) {
                    ++this.ticks;
                } else {
                    this.owl.currentTask = OwlTask.NONE;
                    this.ticks = 0;
                    this.useCooldown = true;
                    this.stop();
                }
                this.sinceLastOnBlock = 0;
                --this.tryTicks;
            }
            LivingEntity livingEntity = this.owl.getOwner();
            if (livingEntity instanceof Player && this.owl.distanceToSqr((Entity)(owner = (Player)livingEntity)) >= 144.0) {
                this.owl.teleportToOwner();
                this.owl.currentTask = OwlTask.NONE;
                this.owl.getNavigation().stop();
                this.useCooldown = true;
                this.stop();
            }
        }

        protected int nextStartTick(PathfinderMob pCreature) {
            return OwlFavoriteBlockGoal.reducedTickDelay((int)(200 + pCreature.getRandom().nextInt(200)));
        }

        public boolean posEqual(BlockPos pos1, BlockPos pos2) {
            if (pos1 == null || pos2 == null) {
                return false;
            }
            return pos1.getX() == pos2.getX() && pos1.getY() == pos2.getY() && pos1.getZ() == pos2.getZ();
        }

        protected boolean isValidTarget(LevelReader pLevel, BlockPos pPos) {
            if (pLevel.isEmptyBlock(pPos.above())) {
                BlockState blockstate = pLevel.getBlockState(pPos);
                List<FavoriteBlockQuirk> quirks = FavoriteBlockQuirk.fromController(this.owl.quirkController);
                for (FavoriteBlockQuirk quirk : quirks) {
                    boolean collisionBelow;
                    if (!blockstate.is(quirk.getFavoriteBlock())) continue;
                    boolean collision = !quirk.getFavoriteBlock().defaultBlockState().getCollisionShape((BlockGetter)pLevel, BlockPos.ZERO, CollisionContext.empty()).isEmpty();
                    boolean bl = collisionBelow = !pLevel.getBlockState(pPos.below()).getBlock().defaultBlockState().getCollisionShape((BlockGetter)pLevel, BlockPos.ZERO, CollisionContext.empty()).isEmpty();
                    if (collision || collisionBelow) {
                        if (this.ticks > 100) {
                            if (this.posEqual(this.owl.getOnPos(0.5001f), pPos)) {
                                if (this.owl.currentTask == OwlTask.GO_TO_FAVORITE_BLOCK) {
                                    this.owl.currentTask = OwlTask.NONE;
                                }
                                return false;
                            }
                            if (this.posEqual(this.owl.getOnPos(), pPos)) {
                                if (this.owl.currentTask == OwlTask.GO_TO_FAVORITE_BLOCK) {
                                    this.owl.currentTask = OwlTask.NONE;
                                }
                                return false;
                            }
                        }
                    } else {
                        return false;
                    }
                    this.owl.currentTask = OwlTask.GO_TO_FAVORITE_BLOCK;
                    return true;
                }
            }
            return false;
        }
    }

    public class FollowOwnerGoal
    extends Goal {
        private final OwlEntity owl;
        private LivingEntity owner;
        private final LevelReader level;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;
        private float oldWaterCost;
        private final boolean canFly;

        public FollowOwnerGoal(OwlEntity owl, double speedModifier, float startDistance, float stopDistance, boolean canFly) {
            this.owl = owl;
            this.level = owl.level();
            this.speedModifier = speedModifier;
            this.navigation = owl.getNavigation();
            this.startDistance = startDistance;
            this.stopDistance = stopDistance;
            this.canFly = canFly;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(owl.getNavigation() instanceof GroundPathNavigation) && !(owl.getNavigation() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean canUse() {
            if (!this.owl.currentTask.isNone()) {
                return false;
            }
            LivingEntity livingentity = this.owl.getOwner();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.isSpectator()) {
                return false;
            }
            if (this.owl.isOrderedToSit() || OwlEntity.this.isInSittingPose()) {
                return false;
            }
            if (this.owl.distanceToSqr((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean canContinueToUse() {
            if (!this.owl.currentTask.isNone()) {
                return false;
            }
            if (this.navigation.isDone()) {
                return false;
            }
            if (this.owl.isOrderedToSit() || OwlEntity.this.isInSittingPose()) {
                return false;
            }
            return !(this.owl.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
        }

        public void start() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.owl.getPathfindingMalus(PathType.WATER);
            this.owl.setPathfindingMalus(PathType.WATER, 0.0f);
        }

        public void stop() {
            OwlEntity.this.currentTask = OwlTask.NONE;
            this.owner = null;
            this.navigation.stop();
            this.owl.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
        }

        public void tick() {
            this.owl.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.owl.getMaxHeadXRot());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.adjustedTickDelay(4);
                if (!this.owl.isLeashed() && !this.owl.isPassenger()) {
                    if (this.owl.distanceToSqr((Entity)this.owner) >= 144.0) {
                        if (this.teleportToOwner()) {
                            OwlEntity.this.getNavigation().stop();
                            OwlEntity.this.flyOrWalkTo(this.owner.position());
                            OwlEntity.this.getNavigation().moveTo(this.owner.position().x, this.owner.position().y, this.owner.position().z, this.speedModifier);
                        }
                    } else {
                        OwlEntity.this.flyOrWalkTo(this.owner.position());
                        OwlEntity.this.getNavigation().moveTo(this.owner.position().x, this.owner.position().y, this.owner.position().z, this.speedModifier);
                    }
                }
            }
        }

        private boolean teleportToOwner() {
            BlockPos blockpos = this.owner.blockPosition();
            for (int i = 0; i < 10; ++i) {
                int j = this.randomIntInclusive(-3, 3);
                int k = this.randomIntInclusive(-1, 1);
                int l = this.randomIntInclusive(-3, 3);
                boolean flag = this.maybeTeleportTo(blockpos.getX() + j, blockpos.getY() + k, blockpos.getZ() + l);
                if (!flag) continue;
                return true;
            }
            return false;
        }

        private boolean maybeTeleportTo(int x, int y, int z) {
            if (Math.abs((double)x - this.owner.getX()) < 2.0 && Math.abs((double)z - this.owner.getZ()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new BlockPos(x, y, z))) {
                return false;
            }
            OwlEntity.this.flyOrWalkTo(new Vec3((double)x + 0.5, (double)y, (double)z + 0.5));
            this.owl.moveTo((double)x + 0.5, y, (double)z + 0.5, this.owl.getYRot(), this.owl.getXRot());
            this.navigation.stop();
            return true;
        }

        private boolean canTeleportTo(BlockPos pos) {
            if (pos.getY() <= -64) {
                return false;
            }
            BlockState blockstate = this.level.getBlockState(pos.below());
            if (!this.canFly && blockstate.getBlock() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockpos = pos.subtract((Vec3i)this.owl.blockPosition());
            return this.level.noCollision((Entity)this.owl, this.owl.getBoundingBox().move(blockpos));
        }

        private int randomIntInclusive(int p_25301_, int p_25302_) {
            return this.owl.getRandom().nextInt(p_25302_ - p_25301_ + 1) + p_25301_;
        }
    }

    public class BreedGoal
    extends Goal {
        private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.forNonCombat().range(16.0).ignoreLineOfSight();
        protected final Animal animal;
        private final Class<? extends Animal> partnerClass;
        protected final Level level;
        @javax.annotation.Nullable
        protected Animal partner;
        private int loveTime;
        private final double speedModifier;

        public BreedGoal(Animal p_25122_, double p_25123_) {
            this(p_25122_, p_25123_, p_25122_.getClass());
        }

        public BreedGoal(Animal p_25125_, double p_25126_, Class<? extends Animal> p_25127_) {
            this.animal = p_25125_;
            this.level = p_25125_.level();
            this.partnerClass = p_25127_;
            this.speedModifier = p_25126_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (OwlEntity.this.currentTask.is(OwlTask.BREEDING)) {
                this.partner = this.getFreePartner();
                return this.partner != null;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.partner != null && this.partner.isAlive() && this.partner.isInLove() && this.loveTime < 120;
        }

        public void start() {
            if (OwlEntity.this.isInSittingPose()) {
                OwlEntity.this.setInSittingPose(false);
                OwlEntity.this.setOrderedToSit(false);
            }
            super.start();
        }

        public void stop() {
        }

        public void tick() {
            if (this.partner != null) {
                this.animal.getLookControl().setLookAt((Entity)this.partner, 10.0f, (float)this.animal.getMaxHeadXRot());
                OwlEntity.this.walkToIfNotFlyTo(this.partner.position());
                this.animal.getNavigation().moveTo((Entity)this.partner, OwlEntity.this.isFlyingNav() ? 1.25 * this.speedModifier : 0.75 * this.speedModifier);
                ++this.loveTime;
                if (this.animal.distanceToSqr((Entity)this.partner) < 4.0 && OwlEntity.this.breedGiftGivenByPlayer) {
                    if (!((OwlEntity)this.partner).isOrderedToSit()) {
                        ((OwlEntity)this.partner).setOrderedToSit(true);
                    }
                    if (!this.partner.getLookControl().isLookingAtTarget()) {
                        this.partner.getLookControl().setLookAt((Entity)this.animal);
                    }
                    ++OwlEntity.this.waitToGiveTime;
                    if (OwlEntity.this.waitToGiveTime > 20 && OwlEntity.this.onGround() && OwlEntity.this.itemHandler.getStackInSlot(1).is(Items.RABBIT)) {
                        ((OwlEntity)this.partner).setOrderedToSit(false);
                        OwlEntity.this.waitToGiveTime = 0;
                        OwlEntity.this.breedGiftGivenByPlayer = false;
                        OwlEntity.this.peck();
                        HexereiPacketHandler.sendToNearbyClient(OwlEntity.this.level(), (Entity)OwlEntity.this, (CustomPacketPayload)new PeckPacket((Entity)OwlEntity.this));
                        ItemStack stack = ((OwlEntity)this.partner).itemHandler.getStackInSlot(1).copy();
                        ItemStack stack2 = OwlEntity.this.itemHandler.getStackInSlot(1).copy();
                        ((OwlEntity)this.partner).itemHandler.setStackInSlot(1, stack2);
                        OwlEntity.this.itemHandler.setStackInSlot(1, ItemStack.EMPTY);
                        ItemEntity itemEntity = new ItemEntity(this.partner.level(), this.partner.position().x, this.partner.position().y, this.partner.position().z, stack);
                        this.partner.level().addFreshEntity((Entity)itemEntity);
                        if (OwlEntity.this.breedGiftGivenByPlayerUUID != null && this.level.getPlayerByUUID(OwlEntity.this.breedGiftGivenByPlayerUUID) != null) {
                            ((OwlEntity)this.partner).breedGiftGivenByPlayerUUID = OwlEntity.this.breedGiftGivenByPlayerUUID;
                            ((OwlEntity)this.partner).breedGiftGivenByPartnerTimer = 20;
                        } else if (OwlEntity.this.getOwner() instanceof Player) {
                            this.partner.setInLove((Player)OwlEntity.this.getOwner());
                        }
                    }
                }
                if (this.loveTime >= this.adjustedTickDelay(60) && this.animal.distanceToSqr((Entity)this.partner) < 9.0) {
                    this.breed();
                    OwlEntity.this.currentTask = OwlTask.NONE;
                    this.partner = null;
                    this.loveTime = 0;
                }
            }
        }

        public boolean canMateOwlBringGift(Animal animal) {
            if (animal.isBaby()) {
                return false;
            }
            if (animal == OwlEntity.this) {
                return false;
            }
            if (animal.getClass() != OwlEntity.this.getClass()) {
                return false;
            }
            return OwlEntity.this.itemHandler.getStackInSlot(1).is(Items.RABBIT) && animal.getAge() == 0;
        }

        public boolean canMateOwlReceiveGift(Animal animal) {
            if (animal.isBaby()) {
                return false;
            }
            if (animal == OwlEntity.this) {
                return false;
            }
            if (animal.getClass() != OwlEntity.this.getClass()) {
                return false;
            }
            return OwlEntity.this.isInLove() && animal.isInLove();
        }

        @javax.annotation.Nullable
        private Animal getFreePartner() {
            List list = this.level.getNearbyEntities(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.getBoundingBox().inflate(16.0));
            double d0 = Double.MAX_VALUE;
            Animal animal = null;
            if (OwlEntity.this.breedGiftGivenByPlayer) {
                for (Animal animal1 : list) {
                    if (!this.canMateOwlBringGift(animal1) || !(this.animal.distanceToSqr((Entity)animal1) < d0)) continue;
                    animal = animal1;
                    d0 = this.animal.distanceToSqr((Entity)animal1);
                }
            } else {
                for (Animal animal1 : list) {
                    if (!this.canMateOwlReceiveGift(animal1) || !(this.animal.distanceToSqr((Entity)animal1) < d0)) continue;
                    animal = animal1;
                    d0 = this.animal.distanceToSqr((Entity)animal1);
                }
            }
            return animal;
        }

        protected void breed() {
            OwlEntity.this.itemHandler.setStackInSlot(1, ItemStack.EMPTY);
            this.spawnChildFromBreeding((ServerLevel)this.level, this.partner);
        }

        public void spawnChildFromBreeding(ServerLevel p_27564_, Animal p_27565_) {
            AgeableMob ageablemob = OwlEntity.this.getBreedOffspring(p_27564_, (AgeableMob)p_27565_);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)OwlEntity.this, (Mob)p_27565_, ageablemob);
            boolean cancelled = ((BabyEntitySpawnEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled();
            ageablemob = event.getChild();
            if (cancelled) {
                OwlEntity.this.setAge(6000);
                p_27565_.setAge(6000);
                OwlEntity.this.resetLove();
                p_27565_.resetLove();
                return;
            }
            if (ageablemob != null) {
                ServerPlayer serverplayer = OwlEntity.this.getLoveCause();
                if (serverplayer == null && p_27565_.getLoveCause() != null) {
                    serverplayer = p_27565_.getLoveCause();
                }
                if (serverplayer != null) {
                    serverplayer.awardStat(Stats.ANIMALS_BRED);
                    CriteriaTriggers.BRED_ANIMALS.trigger(serverplayer, (Animal)OwlEntity.this, p_27565_, ageablemob);
                }
                OwlEntity.this.setAge(6000);
                p_27565_.setAge(6000);
                OwlEntity.this.resetLove();
                p_27565_.resetLove();
                ageablemob.setBaby(true);
                ageablemob.moveTo(this.partner.getX(), this.partner.getY(), this.partner.getZ(), 0.0f, 0.0f);
                p_27564_.addFreshEntityWithPassengers((Entity)ageablemob);
                ((OwlEntity)ageablemob).setOwnerUUID(OwlEntity.this.getOwnerUUID());
                ((OwlEntity)ageablemob).setTame(true, false);
                ((OwlEntity)ageablemob).setOrderedToSit(true);
                p_27564_.broadcastEntityEvent((Entity)OwlEntity.this, (byte)18);
                if (p_27564_.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                    p_27564_.addFreshEntity((Entity)new ExperienceOrb((Level)p_27564_, OwlEntity.this.getX(), OwlEntity.this.getY(), OwlEntity.this.getZ(), OwlEntity.this.getRandom().nextInt(7) + 1));
                }
            }
        }
    }

    public class TemptGoal
    extends Goal {
        private static final TargetingConditions TEMP_TARGETING = TargetingConditions.forNonCombat().range(10.0).ignoreLineOfSight();
        private final TargetingConditions targetingConditions;
        protected final OwlEntity owl;
        private final double speedModifier;
        private double px;
        private double py;
        private double pz;
        private double pRotX;
        private double pRotY;
        @javax.annotation.Nullable
        protected Player player;
        private int calmDown;
        private boolean isRunning;
        private final Ingredient items;
        private final boolean canScare;

        public TemptGoal(OwlEntity p_25939_, double p_25940_, Ingredient p_25941_, boolean p_25942_) {
            this.owl = p_25939_;
            this.speedModifier = p_25940_;
            this.items = p_25941_;
            this.canScare = p_25942_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.targetingConditions = TEMP_TARGETING.copy().selector(this::shouldFollow);
        }

        public boolean canUse() {
            if (this.owl.isInSittingPose() || this.owl.isOrderedToSit()) {
                return false;
            }
            if (this.owl.currentTask.is(OwlTask.PICKUP_ITEM) || this.owl.currentTask.is(OwlTask.BREEDING)) {
                return false;
            }
            if (this.calmDown > 0) {
                --this.calmDown;
                return false;
            }
            this.player = this.owl.level().getNearestPlayer(this.targetingConditions, (LivingEntity)this.owl);
            return this.player != null;
        }

        private boolean shouldFollow(LivingEntity player) {
            if (this.player != null && OwlEntity.this.isTame() && OwlEntity.this.isOwnedBy(player) && !OwlEntity.this.isBaby() && OwlEntity.this.getAge() == 0) {
                return player.getMainHandItem().is(HexereiTags.Items.OWL_BREEDING_FOOD) || player.getOffhandItem().is(HexereiTags.Items.OWL_BREEDING_FOOD);
            }
            return player.getMainHandItem().is(HexereiTags.Items.OWL_TAMING_FOOD) || player.getOffhandItem().is(HexereiTags.Items.OWL_TAMING_FOOD);
        }

        public boolean canContinueToUse() {
            if (this.owl.isInSittingPose() || this.owl.isOrderedToSit()) {
                return false;
            }
            if (this.canScare()) {
                if (this.owl.distanceToSqr((Entity)this.player) < 36.0) {
                    if (this.player.distanceToSqr(this.px, this.py, this.pz) > 0.010000000000000002) {
                        return false;
                    }
                    if (Math.abs((double)this.player.getXRot() - this.pRotX) > 5.0 || Math.abs((double)this.player.getYRot() - this.pRotY) > 5.0) {
                        return false;
                    }
                } else {
                    this.px = this.player.getX();
                    this.py = this.player.getY();
                    this.pz = this.player.getZ();
                }
                this.pRotX = this.player.getXRot();
                this.pRotY = this.player.getYRot();
            }
            return this.canUse();
        }

        protected boolean canScare() {
            return this.canScare;
        }

        public void start() {
            this.px = this.player.getX();
            this.py = this.player.getY();
            this.pz = this.player.getZ();
            this.isRunning = true;
        }

        public void stop() {
            OwlEntity.this.currentTask = OwlTask.NONE;
            this.player = null;
            this.owl.getNavigation().stop();
            this.calmDown = TemptGoal.reducedTickDelay((int)100);
            this.isRunning = false;
            OwlEntity.this.setBrowPos(BrowPositioning.NORMAL);
        }

        public void tick() {
            this.owl.getLookControl().setLookAt((Entity)this.player, (float)(this.owl.getMaxHeadYRot() + 20), (float)this.owl.getMaxHeadXRot());
            if (OwlEntity.this.isInSittingPose()) {
                return;
            }
            if (!OwlEntity.this.isTame()) {
                if (this.owl.distanceToSqr((Entity)this.player) < 14.25 && OwlEntity.this.random.nextInt(20) == 0) {
                    OwlEntity.this.emotions.setDistress(OwlEntity.this.emotions.getDistress() + 5 + OwlEntity.this.random.nextInt(5));
                    OwlEntity.this.emotionChanged();
                    OwlEntity.this.determineEmotionState();
                }
            } else if (this.owl.distanceToSqr((Entity)this.player) < 10.25 && OwlEntity.this.random.nextInt(20) == 0) {
                OwlEntity.this.emotions.setDistress(OwlEntity.this.emotions.getDistress() + 5 + OwlEntity.this.random.nextInt(5));
                OwlEntity.this.emotionChanged();
                OwlEntity.this.determineEmotionState();
            }
            if (this.owl.distanceToSqr((Entity)this.player) < 6.25) {
                this.owl.getNavigation().stop();
            } else {
                if (OwlEntity.this.random.nextInt(TemptGoal.reducedTickDelay((int)2)) == 0) {
                    OwlEntity.this.walkToIfNotFlyTo(this.player.position());
                }
                this.owl.getNavigation().moveTo((Entity)this.player, 1.25 * this.speedModifier);
            }
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    public class FollowParentGoal
    extends Goal {
        public static final int HORIZONTAL_SCAN_RANGE = 8;
        public static final int VERTICAL_SCAN_RANGE = 4;
        public static final int DONT_FOLLOW_IF_CLOSER_THAN = 3;
        private final Animal animal;
        @javax.annotation.Nullable
        private Animal parent;
        private final double speedModifier;
        private int timeToRecalcPath;

        public FollowParentGoal(Animal p_25319_, double p_25320_) {
            this.animal = p_25319_;
            this.speedModifier = p_25320_;
        }

        public boolean canUse() {
            if (this.animal.getAge() >= 0) {
                return false;
            }
            if (OwlEntity.this.isOrderedToSit() || OwlEntity.this.isInSittingPose()) {
                return false;
            }
            List list = this.animal.level().getEntitiesOfClass(this.animal.getClass(), this.animal.getBoundingBox().inflate(8.0, 4.0, 8.0));
            Animal animal = null;
            double d0 = Double.MAX_VALUE;
            for (Animal animal1 : list) {
                double d1;
                if (animal1.getAge() < 0 || (d1 = this.animal.distanceToSqr((Entity)animal1)) > d0) continue;
                d0 = d1;
                animal = animal1;
            }
            if (animal == null) {
                return false;
            }
            if (d0 < 9.0) {
                return false;
            }
            this.parent = animal;
            return true;
        }

        public boolean canContinueToUse() {
            if (this.animal.getAge() >= 0) {
                return false;
            }
            if (!this.parent.isAlive()) {
                return false;
            }
            if (OwlEntity.this.isOrderedToSit() || OwlEntity.this.isInSittingPose()) {
                return false;
            }
            double d0 = this.animal.distanceToSqr((Entity)this.parent);
            return !(d0 < 9.0) && !(d0 > 256.0);
        }

        public void start() {
            this.timeToRecalcPath = 0;
        }

        public void stop() {
            this.parent = null;
        }

        public void tick() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.adjustedTickDelay(10);
                if (this.parent != null) {
                    OwlEntity.this.walkToIfNotFlyTo(this.parent.position());
                }
                this.animal.getNavigation().moveTo((Entity)this.parent, OwlEntity.this.isFlyingNav() ? 1.25 * this.speedModifier : 0.75 * this.speedModifier);
            }
        }
    }

    public class WaterAvoidingRandomFlyingGoal
    extends WaterAvoidingRandomStrollGoal {
        public WaterAvoidingRandomFlyingGoal(PathfinderMob p_25981_, double p_25982_) {
            super(p_25981_, p_25982_);
        }

        @Override
        public void start() {
            OwlEntity.this.switchNavigator(true);
            this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, OwlEntity.this.isFlyingNav() ? 1.25 * this.speedModifier : 0.75 * this.speedModifier);
        }

        @Override
        public boolean canUse() {
            if (OwlEntity.this.isTame()) {
                return false;
            }
            if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            if (OwlEntity.this.isInSittingPose()) {
                return false;
            }
            return super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            if (OwlEntity.this.isInSittingPose()) {
                return false;
            }
            return super.canContinueToUse();
        }

        @Override
        @javax.annotation.Nullable
        protected Vec3 getPosition() {
            Vec3 vec3 = this.mob.getViewVector(0.0f);
            int i = 8;
            Vec3 vec31 = HoverRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)7, (double)vec3.x, (double)vec3.z, (float)1.5707964f, (int)3, (int)1);
            return vec31 != null ? vec31 : AirAndWaterRandomPos.getPos((PathfinderMob)this.mob, (int)8, (int)4, (int)-2, (double)vec3.x, (double)vec3.z, (double)1.5707963705062866);
        }
    }

    public class WaterAvoidingRandomStrollGoal
    extends RandomStrollGoal {
        public static final float PROBABILITY = 0.001f;
        protected final float probability;

        public WaterAvoidingRandomStrollGoal(PathfinderMob p_25987_, double p_25988_) {
            this(p_25987_, p_25988_, 0.001f);
        }

        public WaterAvoidingRandomStrollGoal(PathfinderMob p_25990_, double p_25991_, float p_25992_) {
            super(p_25990_, p_25991_);
            this.probability = p_25992_;
        }

        public void start() {
            OwlEntity.this.walkToIfNotFlyTo(new Vec3(this.wantedX, this.wantedY, this.wantedZ));
            this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, OwlEntity.this.isFlyingNav() ? 1.25 * this.speedModifier : 0.75 * this.speedModifier);
        }

        public boolean canUse() {
            if (OwlEntity.this.isTame()) {
                return false;
            }
            if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            if (OwlEntity.this.isInSittingPose()) {
                return false;
            }
            return super.canUse();
        }

        public boolean canContinueToUse() {
            if (OwlEntity.this.isInSittingPose()) {
                return false;
            }
            return super.canContinueToUse();
        }

        @javax.annotation.Nullable
        protected Vec3 getPosition() {
            if (this.mob.isInWaterOrBubble()) {
                Vec3 vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)7);
                return vec3 == null ? super.getPosition() : vec3;
            }
            return this.mob.getRandom().nextFloat() >= this.probability ? LandRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7) : super.getPosition();
        }
    }

    public class OwlLookAtPlayerGoal
    extends LookAtPlayerGoal {
        public OwlLookAtPlayerGoal(Mob pMob, Class<? extends LivingEntity> pLookAtType, float pLookDistance) {
            super(pMob, pLookAtType, pLookDistance);
        }

        public boolean canUse() {
            if (OwlEntity.this.currentTask.is(OwlTask.BREEDING) || OwlEntity.this.breedGiftGivenByPartnerTimer > 0) {
                return false;
            }
            return super.canUse();
        }

        public boolean canContinueToUse() {
            if (OwlEntity.this.currentTask.is(OwlTask.BREEDING) || OwlEntity.this.breedGiftGivenByPartnerTimer > 0) {
                return false;
            }
            return super.canContinueToUse();
        }
    }

    public class OwlGatherItems<T extends ItemEntity>
    extends TargetGoal {
        protected final Sorter theNearestAttackableTargetSorter;
        protected final Predicate<? super ItemEntity> targetEntitySelector;
        protected int executionChance;
        protected boolean mustUpdate;
        protected ItemEntity targetEntity;
        protected ITargetsDroppedItems hunter;
        private int tickThreshold;
        private int walkCooldown;
        protected int tryTicks;

        public OwlGatherItems(PathfinderMob creature, boolean checkSight, boolean onlyNearby, int tickThreshold, int radius) {
            this(creature, 1, checkSight, onlyNearby, null, tickThreshold);
        }

        public OwlGatherItems(PathfinderMob creature, int chance, boolean checkSight, @javax.annotation.Nullable boolean onlyNearby, Predicate<? super T> targetSelector, int ticksExisted) {
            super((Mob)creature, checkSight, onlyNearby);
            this.walkCooldown = 0;
            this.tryTicks = 0;
            this.executionChance = chance;
            this.tickThreshold = ticksExisted;
            this.hunter = (ITargetsDroppedItems)creature;
            this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
            this.targetEntitySelector = item -> {
                ItemStack stack = item.getItem();
                return !stack.isEmpty() && this.hunter.canTargetItem(stack) && item.tickCount > this.tickThreshold;
            };
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            List list;
            if (!OwlEntity.this.currentTask.isNoneOr(OwlTask.PICKUP_ITEM)) {
                return false;
            }
            if (OwlEntity.this.isPassenger() || OwlEntity.this.isVehicle() && OwlEntity.this.getControllingPassenger() != null) {
                return false;
            }
            if (!OwlEntity.this.itemHandler.getStackInSlot(1).isEmpty()) {
                return false;
            }
            if (!this.mustUpdate) {
                long worldTime = OwlEntity.this.level().getGameTime() % 10L;
                if (this.mob.getNoActionTime() >= 100 && worldTime != 0L) {
                    return false;
                }
                if (this.mob.getRandom().nextInt(this.executionChance) != 0 && worldTime != 0L) {
                    return false;
                }
            }
            if ((list = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.getTargetableArea(OwlEntity.this.interactionRange + 1), this.targetEntitySelector)).isEmpty()) {
                return false;
            }
            if (OwlEntity.this.isInSittingPose()) {
                OwlEntity.this.setInSittingPose(false);
                OwlEntity.this.setOrderedToSit(false);
            }
            list.sort(this.theNearestAttackableTargetSorter);
            this.targetEntity = (ItemEntity)list.get(0);
            this.mustUpdate = false;
            if (this.targetEntity == null) {
                return false;
            }
            this.hunter.onFindTarget(this.targetEntity);
            return !((OwlEntity)this.mob).isInSittingPose() && (this.mob.getTarget() == null || !this.mob.getTarget().isAlive());
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 10 == 0;
        }

        protected double getFollowDistance() {
            return 16.0;
        }

        protected AABB getTargetableArea(double targetDistance) {
            Vec3 renderCenter = new Vec3(this.mob.getX() + 0.5, this.mob.getY() + 0.5, this.mob.getZ() + 0.5);
            AABB aabb = new AABB(-targetDistance, -targetDistance, -targetDistance, targetDistance, targetDistance, targetDistance);
            return aabb.move(renderCenter);
        }

        public void start() {
            this.moveTo();
            super.start();
        }

        protected void moveTo() {
            if (this.walkCooldown > 0) {
                --this.walkCooldown;
            } else {
                OwlEntity.this.walkToIfNotFlyTo(this.targetEntity.position().add(0.5, 0.25, 0.5));
                this.mob.getNavigation().moveTo(OwlEntity.this.getNavigation().createPath(this.targetEntity.getX() + 0.5, this.targetEntity.getY() + 0.25, this.targetEntity.getZ() + 0.5, 0), OwlEntity.this.isFlyingNav() ? 1.5 : 1.25);
                this.walkCooldown = 30 + this.mob.getRandom().nextInt(40);
            }
        }

        public void stop() {
            super.stop();
            this.mob.getNavigation().stop();
            this.targetEntity = null;
        }

        public void tick() {
            super.tick();
            if (this.targetEntity == null || this.targetEntity != null && !this.targetEntity.isAlive()) {
                this.stop();
                this.mob.getNavigation().stop();
            } else {
                this.moveTo();
            }
            if (this.targetEntity != null && this.mob.hasLineOfSight((Entity)this.targetEntity) && (double)this.mob.getBbWidth() > this.hunter.getMaxDistToItem() && this.mob.onGround()) {
                this.mob.getMoveControl().setWantedPosition(this.targetEntity.getX(), this.targetEntity.getY() + 0.5, this.targetEntity.getZ(), 1.5);
            }
            if (this.targetEntity != null && this.targetEntity.isAlive() && this.mob.distanceToSqr((Entity)this.targetEntity) < this.hunter.getMaxDistToItem() && OwlEntity.this.itemHandler.getStackInSlot(1).isEmpty()) {
                if (!((OwlEntity)this.hunter).peckAnimation.active) {
                    this.hunter.peck();
                    HexereiPacketHandler.sendToNearbyClient(this.mob.level(), (Entity)this.mob, (CustomPacketPayload)new PeckPacket((Entity)this.mob));
                }
                if (((OwlEntity)this.hunter).peckAnimation.peckRot > 40.0f) {
                    this.hunter.onGetItem(this.targetEntity);
                    this.targetEntity.getItem().shrink(1);
                    this.stop();
                }
            }
            OwlEntity crow = (OwlEntity)this.mob;
            if (this.targetEntity != null) {
                if ((double)this.mob.distanceTo((Entity)this.targetEntity) <= OwlEntity.this.getMaxDistToItem()) {
                    crow.getMoveControl().setWantedPosition(this.targetEntity.getX(), this.targetEntity.getY() + 0.5, this.targetEntity.getZ(), 1.5);
                }
                if (!crow.isInSittingPose()) {
                    OwlEntity.this.flyOrWalkTo(this.targetEntity.position().add(0.0, 0.5, 0.0));
                    this.mob.getNavigation().moveTo(OwlEntity.this.getNavigation().createPath(this.targetEntity.getX(), this.targetEntity.getY() + 0.5, this.targetEntity.getZ(), 0), OwlEntity.this.isFlyingNav() ? 1.5 : 1.0);
                }
                ++this.tryTicks;
                if (this.shouldRecalculatePath()) {
                    if (this.targetEntity.position().distanceTo(OwlEntity.this.position()) < 3.0 && OwlEntity.this.position().y < this.targetEntity.position().y()) {
                        OwlEntity.this.setNoGravity(false);
                        OwlEntity.this.push((this.targetEntity.position().x - OwlEntity.this.position().x) / 50.0, (this.targetEntity.position().y - OwlEntity.this.position().y) / 50.0 + (double)0.1f, (this.targetEntity.position().z - OwlEntity.this.position().z) / 50.0);
                    }
                    OwlEntity.this.flyOrWalkTo(this.targetEntity.position().add(0.0, 3.0, 0.0));
                    this.mob.getNavigation().moveTo(OwlEntity.this.getNavigation().createPath(this.targetEntity.getX(), this.targetEntity.getY() + 3.0, this.targetEntity.getZ(), 0), OwlEntity.this.isFlyingNav() ? 1.5 : 1.0);
                }
            }
        }

        public void makeUpdate() {
            this.mustUpdate = true;
        }

        public boolean canContinueToUse() {
            boolean path;
            if (OwlEntity.this.getHealth() >= OwlEntity.this.getMaxHealth() && OwlEntity.this.isTame()) {
                return false;
            }
            boolean bl = path = (double)this.mob.getBbWidth() > 2.0 || !this.mob.getNavigation().isDone();
            if (OwlEntity.this.isInSittingPose()) {
                OwlEntity.this.setInSittingPose(false);
                OwlEntity.this.setOrderedToSit(false);
            }
            return path && this.targetEntity != null && this.targetEntity.isAlive() && !((OwlEntity)this.mob).isInSittingPose() && (this.mob.getTarget() == null || !this.mob.getTarget().isAlive());
        }

        public static class Sorter
        implements Comparator<Entity> {
            private final Entity theEntity;

            public Sorter(Entity theEntityIn) {
                this.theEntity = theEntityIn;
            }

            @Override
            public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                double d0 = this.theEntity.distanceToSqr(p_compare_1_);
                double d1 = this.theEntity.distanceToSqr(p_compare_2_);
                return Double.compare(d0, d1);
            }
        }
    }

    public static enum EmotionState {
        CONTEMPT(0.0f, 0.0f, 0.0f, new Emotions(0, 0, 0)),
        HAPPY(0.0f, 0.0f, 0.0f, new Emotions(0, 0, 100)),
        DISTRESSED(0.75f, 0.05f, 40.0f, new Emotions(0, 100, 0)),
        ANGRY(0.25f, 0.5f, -15.0f, new Emotions(100, 0, 0));

        private final Emotions scales;
        final float browXOffset;
        final float browYOffset;
        final float browZRot;

        private EmotionState(float xOffset, float yOffset, float zRot, Emotions scales) {
            this.browXOffset = xOffset;
            this.browYOffset = yOffset;
            this.browZRot = zRot;
            this.scales = scales;
        }

        public Emotions getScales() {
            return this.scales;
        }

        public float getxOffset() {
            return this.browXOffset;
        }

        public float getyOffset() {
            return this.browYOffset;
        }

        public float getzRot() {
            return this.browZRot;
        }
    }

    public static class CrowGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final OwlVariant variant;

        public CrowGroupData(OwlVariant pVariant) {
            super(true);
            this.variant = pVariant;
        }
    }

    public static enum BrowAnim {
        LEFT,
        RIGHT,
        BOTH;

    }

    public class WanderAroundPlayerGoal
    extends RandomStrollGoal {
        public WanderAroundPlayerGoal(PathfinderMob pMob, double pSpeedModifier) {
            super(pMob, pSpeedModifier, 85);
        }

        public void start() {
            OwlEntity.this.flyOrWalkTo(new Vec3(this.wantedX, this.wantedY, this.wantedZ));
            this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, OwlEntity.this.isFlyingNav() ? 1.25 * this.speedModifier : 0.75 * this.speedModifier);
            this.mob.setNoActionTime(0);
        }

        public boolean canUse() {
            if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            return super.canUse();
        }

        public boolean canContinueToUse() {
            if (!OwlEntity.this.currentTask.isNone()) {
                return false;
            }
            return super.canContinueToUse();
        }

        protected Vec3 getPosition() {
            int pRadius = 5;
            int pVerticalDistance = 7;
            if (OwlEntity.this.getOwner() != null) {
                boolean flag = GoalUtils.mobRestricted((PathfinderMob)this.mob, (int)pRadius);
                double d0 = Double.NEGATIVE_INFINITY;
                BlockPos blockpos = null;
                for (int i = 0; i < 10; ++i) {
                    double d1;
                    BlockPos pos = RandomPos.generateRandomDirection((RandomSource)OwlEntity.this.getRandom(), (int)pRadius, (int)pVerticalDistance);
                    BlockPos blockpos1 = OwlEntity.this.getPerchPos() != null ? WanderAroundPlayerGoal.generateRandomPosTowardDirection((Position)Vec3.atLowerCornerOf((Vec3i)OwlEntity.this.getPerchPos()), this.mob, flag, pos) : (OwlEntity.this.getOwner() != null ? WanderAroundPlayerGoal.generateRandomPosTowardDirection((Position)OwlEntity.this.getOwner().position(), this.mob, flag, pos) : OwlEntity.this.blockPosition());
                    if (blockpos1 == null || !((d1 = (double)OwlEntity.this.getWalkTargetValue(blockpos1)) > d0)) continue;
                    d0 = d1;
                    blockpos = blockpos1;
                }
                return blockpos != null ? Vec3.atBottomCenterOf(blockpos) : null;
            }
            return DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
        }

        private static BlockPos generateRandomPosTowardDirection(Position pos, PathfinderMob pMob, boolean pShortCircuit, BlockPos pPos) {
            BlockPos blockpos = WanderAroundPlayerGoal.generateRandomPosTowardDirection(pos, pPos);
            boolean outsidelimits = !GoalUtils.isOutsideLimits((BlockPos)blockpos, (PathfinderMob)pMob);
            boolean restricted = !GoalUtils.isRestricted((boolean)pShortCircuit, (PathfinderMob)pMob, (BlockPos)blockpos);
            boolean notstable = !GoalUtils.isNotStable((PathNavigation)pMob.getNavigation(), (BlockPos)blockpos);
            boolean malus = !GoalUtils.hasMalus((PathfinderMob)pMob, (BlockPos)blockpos);
            return outsidelimits && restricted && malus ? blockpos : null;
        }

        public static BlockPos generateRandomPosTowardDirection(Position pos, BlockPos pPos) {
            int i = pPos.getX();
            int j = pPos.getZ();
            return BlockPos.containing((double)((double)i + pos.x()), (double)((double)pPos.getY() + pos.y()), (double)((double)j + pos.z()));
        }
    }

    public class LandOnOwnersShoulderGoal
    extends Goal {
        private final OwlEntity entity;
        private ServerPlayer owner;
        private boolean isSittingOnShoulder;

        public LandOnOwnersShoulderGoal(OwlEntity p_25483_) {
            this.entity = p_25483_;
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse();
        }

        public boolean canUse() {
            if (OwlEntity.this.isBaby()) {
                return false;
            }
            ServerPlayer serverplayer = (ServerPlayer)this.entity.getOwner();
            boolean flag = serverplayer != null && !serverplayer.isSpectator() && !serverplayer.getAbilities().flying && !serverplayer.isInWater() && !serverplayer.isInPowderSnow;
            return !this.entity.isOrderedToSit() && !this.entity.isInSittingPose() && flag && this.entity.canSitOnShoulder() && serverplayer.getPassengers().size() < 2;
        }

        public boolean isInterruptable() {
            return !this.isSittingOnShoulder;
        }

        public void start() {
            this.owner = (ServerPlayer)this.entity.getOwner();
            this.isSittingOnShoulder = false;
        }

        public void tick() {
            if (!this.isSittingOnShoulder && !this.entity.isInSittingPose() && !this.entity.isLeashed() && this.entity.getBoundingBox().intersects(this.owner.getBoundingBox())) {
                this.isSittingOnShoulder = this.entity.startRiding((Entity)this.owner, true);
                if (!OwlEntity.this.level().isClientSide) {
                    HexereiPacketHandler.sendToNearbyClient(this.entity.level(), (Entity)this.entity, (CustomPacketPayload)new StartRidingPacket((Entity)this.entity, (Player)this.owner));
                }
            }
            if (this.isSittingOnShoulder) {
                this.entity.rideCooldownCounter = 0;
            }
        }
    }

    public static class MessageText {
        public static final int LINES = 12;
        private static final Codec<Component[]> LINES_CODEC = ComponentSerialization.FLAT_CODEC.listOf().comapFlatMap(p_337999_ -> Util.fixedSize((List)p_337999_, (int)12).map(components -> components.toArray(new Component[0])), components -> Arrays.stream(components).toList());
        public static final Codec<MessageText> DIRECT_CODEC = RecordCodecBuilder.create(p_338000_ -> p_338000_.group((App)LINES_CODEC.fieldOf("messages").forGetter(text -> text.messages)).apply((Applicative)p_338000_, MessageText::load));
        private final Component[] messages;

        public MessageText() {
            this(MessageText.emptyMessages(12));
        }

        public MessageText(Component[] pMessages) {
            this.messages = pMessages;
        }

        private static Component[] emptyMessages(int size) {
            Object[] messages = new Component[size];
            Arrays.fill(messages, CommonComponents.EMPTY);
            return messages;
        }

        private static MessageText load(Component[] component) {
            return new MessageText(component);
        }

        public Component getMessage(int pIndex) {
            return this.getMessages()[pIndex];
        }

        public MessageText setMessage(int pIndex, Component pText) {
            Component[] acomponent = Arrays.copyOf(this.messages, this.messages.length);
            acomponent[pIndex] = pText;
            return new MessageText(acomponent);
        }

        public Component[] getMessages() {
            return this.messages;
        }
    }

    public class AnimationBase
    implements Animation {
        public boolean active;
        public int cooldownTimer;
        public int activeTimer;
        public boolean useCooldown = true;

        @Override
        public void tick() {
            this.preTick();
            if (this.active) {
                this.activeTick();
                --this.activeTimer;
                if (this.activeTimer <= 0) {
                    this.stop();
                }
            } else if (!OwlEntity.this.level().isClientSide && this.useCooldown) {
                --this.cooldownTimer;
                if (this.cooldownTimer <= 0) {
                    this.start();
                }
            }
            this.postTick();
        }

        public void preTick() {
        }

        public void activeTick() {
        }

        public void postTick() {
        }

        @Override
        public void start() {
            this.active = true;
        }

        @Override
        public void stop() {
            this.active = false;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }
    }
}

