/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.joefoxe.hexerei.client.renderer.entity.custom.ModChestBoatEntity;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class ModChestBoatRenderer
extends EntityRenderer<ModChestBoatEntity> {
    private final Map<ModChestBoatEntity.Type, Pair<ResourceLocation, ChestBoatModel>> boatResources;

    public ModChestBoatRenderer(EntityRendererProvider.Context p_234563_) {
        super(p_234563_);
        this.shadowRadius = 0.8f;
        this.boatResources = (Map)Stream.of(ModChestBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(p_173938_ -> p_173938_, p_234575_ -> Pair.of((Object)HexereiUtil.getResource(ModChestBoatRenderer.getTextureLocation(p_234575_)), (Object)this.createBoatModel(p_234563_, (ModChestBoatEntity.Type)((Object)p_234575_)))));
    }

    private ChestBoatModel createBoatModel(EntityRendererProvider.Context p_234569_, ModChestBoatEntity.Type p_234570_) {
        ModelLayerLocation modellayerlocation = new ModelLayerLocation(HexereiUtil.getResource("chest_boat/" + p_234570_.getName()), "main");
        return new ChestBoatModel(p_234569_.bakeLayer(modellayerlocation));
    }

    public void render(ModChestBoatEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        float f2;
        pMatrixStack.pushPose();
        pMatrixStack.translate(0.0, 0.375, 0.0);
        pMatrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - pEntityYaw));
        float f = (float)pEntity.getHurtTime() - pPartialTicks;
        float f1 = pEntity.getDamage() - pPartialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            pMatrixStack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)pEntity.getHurtDir()));
        }
        if (!Mth.equal((float)(f2 = pEntity.getBubbleAngle(pPartialTicks)), (float)0.0f)) {
            pMatrixStack.mulPose(new Quaternionf().setAngleAxis(pEntity.getBubbleAngle(pPartialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ChestBoatModel> pair = this.getModelWithLocation(pEntity);
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        ChestBoatModel boatmodel = (ChestBoatModel)pair.getSecond();
        pMatrixStack.scale(-1.0f, -1.0f, 1.0f);
        pMatrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        boatmodel.setupAnim((Boat)pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(boatmodel.renderType(resourcelocation));
        boatmodel.renderToBuffer(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 1.0f));
        if (!pEntity.isUnderWater()) {
            VertexConsumer vertexconsumer1 = pBuffer.getBuffer(RenderType.waterMask());
            boatmodel.waterPatch().render(pMatrixStack, vertexconsumer1, pPackedLight, OverlayTexture.NO_OVERLAY);
        }
        pMatrixStack.popPose();
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(ModChestBoatEntity entity) {
        return HexereiUtil.getResource(ModChestBoatRenderer.getTextureLocation(entity.getModBoatType()));
    }

    private static String getTextureLocation(ModChestBoatEntity.Type p_234566_) {
        return "textures/entity/chest_boat/" + p_234566_.getName() + ".png";
    }

    public Pair<ResourceLocation, ChestBoatModel> getModelWithLocation(ModChestBoatEntity boat) {
        return this.boatResources.get((Object)boat.getModBoatType());
    }
}

