/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.joefoxe.hexerei.data.coffer.CofferInventorySavedData;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class CofferListCommand {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final int ENTRIES_PER_PAGE = 10;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"hexerei").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"coffers").executes(ctx -> CofferListCommand.execute((CommandContext<CommandSourceStack>)ctx, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CofferListCommand.execute((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))));
    }

    private static int execute(CommandContext<CommandSourceStack> context, int page) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Entity entity = source.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            source.sendFailure((Component)Component.literal((String)"This command can only be used by players"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        CofferInventorySavedData data = CofferInventorySavedData.get(source.getServer().overworld());
        Map<UUID, ZonedDateTime> lastModifiedTimes = data.getLastModified();
        if (lastModifiedTimes.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"No coffer inventories found"), false);
            return 1;
        }
        List sortedEntries = lastModifiedTimes.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toList());
        int totalPages = (int)Math.ceil((double)sortedEntries.size() / 10.0);
        if (page > totalPages) {
            page = totalPages;
        }
        int startIndex = (page - 1) * 10;
        int endIndex = Math.min(startIndex + 10, sortedEntries.size());
        int finalPage = page;
        source.sendSuccess(() -> Component.literal((String)String.format("Coffer Inventories (Page %d/%d):", finalPage, totalPages)), false);
        for (int i = startIndex; i < endIndex; ++i) {
            Map.Entry entry = (Map.Entry)sortedEntries.get(i);
            UUID cofferId = (UUID)entry.getKey();
            String formattedTime = ((ZonedDateTime)entry.getValue()).format(FORMATTER);
            ItemStack replacement = ((Item)ModItems.COFFER.get()).getDefaultInstance();
            CompoundTag tag = ((CustomData)replacement.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            tag.putUUID("CofferId", cofferId);
            replacement.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            MutableComponent message = Component.literal((String)String.format("%d. ", i + 1)).append((Component)Component.literal((String)"[Coffer] ").withStyle(style -> style.withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/give @s hexerei:coffer[minecraft:custom_data={CofferId:" + CofferListCommand.uuidToNbtString(cofferId) + "}]")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to get coffer \nLast modified: " + formattedTime))))).append((Component)Component.literal((String)cofferId.toString()).withStyle(style -> style.withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/give @s hexerei:coffer[minecraft:custom_data={CofferId:" + CofferListCommand.uuidToNbtString(cofferId) + "}]")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(replacement))))));
            player.sendSystemMessage((Component)message);
        }
        if (totalPages > 1) {
            MutableComponent footer = Component.literal((String)"\nNavigation: ");
            if (page > 1) {
                footer = footer.append((Component)Component.literal((String)"[\u2190 Prev] ").withStyle(style -> style.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/hexerei coffers " + (finalPage - 1))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Go to page " + (finalPage - 1)))))));
            }
            footer = footer.append((Component)Component.literal((String)String.format(" %d/%d ", page, totalPages)).withStyle(ChatFormatting.WHITE));
            if (page < totalPages) {
                footer = footer.append((Component)Component.literal((String)"[Next \u2192]").withStyle(style -> style.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/hexerei coffers " + (finalPage + 1))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Go to page " + (finalPage + 1)))))));
            }
            player.sendSystemMessage((Component)footer);
        }
        return 1;
    }

    public static String uuidToNbtString(UUID uuid) {
        return String.format("[I;%d,%d,%d,%d]", (int)(uuid.getMostSignificantBits() >> 32), (int)uuid.getMostSignificantBits(), (int)(uuid.getLeastSignificantBits() >> 32), (int)uuid.getLeastSignificantBits());
    }
}

