/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.data.books.BookHoverOffset;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class BookEntity {
    public float x;
    public float y;
    public float rot;
    public float rotO;
    public float scale;
    public String entityType;
    public Entity entity;
    public CompoundTag entityTags;
    public ArrayList<CompoundTag> entityTagsList;
    public int entityTagsListOn;
    public int entityTagsLastChange;
    public int entityTagsListOnSet;
    public BookHoverOffset offset;
    public float toRotate;
    public float toRotateO;
    public boolean hovered;
    public boolean clicked;
    public float hoverTick;
    public float hoverTickO;
    public float hoverTickRender;
    public boolean markedForUpdate;
    public static final Codec<BookEntity> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("scale").orElse((Object)Float.valueOf(1.0f)).forGetter(e -> Float.valueOf(e.scale)), (App)Codec.FLOAT.fieldOf("x").orElse((Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.x)), (App)Codec.FLOAT.fieldOf("y").orElse((Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.y)), (App)Codec.STRING.fieldOf("id").orElse((Object)"player").forGetter(e -> e.entityType), (App)Codec.STRING.optionalFieldOf("tag", (Object)"{}").xmap(str -> {
        try {
            return TagParser.parseTag((String)str);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }, Tag::getAsString).forGetter(e -> e.entityTags), (App)Codec.STRING.listOf().optionalFieldOf("tag_array", new ArrayList()).xmap(strings -> strings.stream().map(s -> {
        try {
            return TagParser.parseTag((String)s);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }).toList(), compoundTags -> compoundTags.stream().map(Tag::getAsString).toList()).forGetter(e -> e.entityTagsList), (App)BookHoverOffset.CODEC.fieldOf("hover_offset").forGetter(e -> e.offset)).apply((Applicative)instance, (scale, x, y, entityType, entityTags, entityTagsList, offset) -> {
        Entity entity = null;
        Optional type = EntityType.byString((String)entityType);
        if (type.isPresent() && Hexerei.proxy.getLevel() != null && (entity = ((EntityType)type.get()).create(Hexerei.proxy.getLevel())) != null) {
            entity.load(entityTags);
        }
        return new BookEntity(scale.floatValue(), x.floatValue(), y.floatValue(), (String)entityType, entity, (CompoundTag)entityTags, new ArrayList<CompoundTag>((Collection<CompoundTag>)entityTagsList), (BookHoverOffset)offset);
    }));

    BookEntity(float scale, float x, float y, String entityType, Entity entity, CompoundTag entityTags, ArrayList<CompoundTag> entityTagsList, BookHoverOffset offset) {
        this.x = x;
        this.y = y;
        this.rot = 0.0f;
        this.rotO = 0.0f;
        this.scale = scale;
        this.entityType = entityType;
        this.entityTags = entityTags;
        this.entityTagsList = entityTagsList;
        this.entityTagsListOn = 0;
        this.entityTagsListOnSet = 0;
        this.entityTagsLastChange = 0;
        this.entity = entity;
        this.offset = offset;
        this.toRotate = 0.0f;
        this.toRotateO = 0.0f;
        this.hoverTick = 0.0f;
        this.hoverTickO = 0.0f;
        this.hoverTickRender = 0.0f;
        this.hovered = false;
        this.clicked = false;
        this.markedForUpdate = false;
    }

    private float normalizeAngle(float angle) {
        while (angle > 90.0f) {
            angle -= 360.0f;
        }
        while (angle < -270.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float getRot(float partial) {
        return HexereiUtil.lerpAngle(this.rotO, this.rot, partial);
    }

    public void tick() {
        this.rotO = this.rot;
        this.hoverTickO = this.hoverTick;
        if (this.toRotate != 0.0f) {
            this.rot = this.toRotate > 0.0f ? (this.rot += Math.max(Math.abs(this.toRotate) / 10.0f, 0.01f) / 3.0f) : (this.rot -= Math.max(Math.abs(this.toRotate) / 10.0f, 0.01f) / 3.0f);
            this.toRotate = HexereiUtil.moveTo(this.toRotate, 0.0f, Math.max(Math.abs(this.toRotate) / 10.0f, 0.01f));
        }
        this.rot = this.normalizeAngle(this.rot);
        this.hoverTick = this.hovered || this.clicked ? HexereiUtil.moveTo(this.hoverTick, 1.0f, 0.06f) : HexereiUtil.moveTo(this.hoverTick, 0.0f, 0.08f);
        this.hovered = false;
    }
}

