/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import java.util.ArrayList;
import net.joefoxe.hexerei.data.books.BookChapter;
import net.joefoxe.hexerei.data.books.BookPageEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class BookEntries {
    public ResourceLocation book;
    public ArrayList<BookChapter> chapterList;
    public int numberOfPages;

    public BookEntries(ResourceLocation book, ArrayList<BookChapter> chapterList, int numberOfPages) {
        this.chapterList = chapterList;
        this.numberOfPages = numberOfPages;
        this.book = book;
    }

    public static CompoundTag saveToTag(BookEntries bookEntries) {
        CompoundTag tag = new CompoundTag();
        tag.putString("bookId", bookEntries.book.toString());
        tag.putInt("numberOfChapters", bookEntries.chapterList.size());
        for (int i = 0; i < bookEntries.chapterList.size(); ++i) {
            BookChapter bookChapter = bookEntries.chapterList.get(i);
            CompoundTag compound = new CompoundTag();
            compound.putString("name", bookChapter.name);
            int num = bookChapter.pages.size();
            compound.putInt("num", num);
            for (int k = 0; k < num; ++k) {
                BookPageEntry bookPageEntry = (BookPageEntry)bookChapter.pages.toArray()[k];
                CompoundTag compoundBoxes = new CompoundTag();
                compoundBoxes.putString("location" + k, bookPageEntry.location);
                compoundBoxes.putInt("pageNum" + k, bookPageEntry.pageNum);
                compound.put("page" + k, (Tag)compoundBoxes);
            }
            tag.put("chapter" + i, (Tag)compound);
        }
        return tag;
    }

    public static BookEntries loadFromTag(CompoundTag tag) {
        String book = tag.getString("bookId");
        int size = tag.getInt("numberOfChapters");
        int numOfPages = 0;
        ArrayList<BookChapter> list = new ArrayList<BookChapter>();
        for (int i = 0; i < size; ++i) {
            CompoundTag paragraph = tag.getCompound("chapter" + i);
            String string = paragraph.getString("name");
            int num = paragraph.getInt("num");
            int numLast = numOfPages;
            numOfPages += num;
            ArrayList<BookPageEntry> pageEntryList = new ArrayList<BookPageEntry>();
            for (int k = 0; k < num; ++k) {
                CompoundTag pageEntries = paragraph.getCompound("page" + k);
                String location = pageEntries.getString("location" + k);
                int pageNum = pageEntries.getInt("pageNum" + k);
                BookPageEntry bookChapter = new BookPageEntry(location, pageNum, i, k);
                pageEntryList.add(bookChapter);
            }
            BookChapter bookChapter = new BookChapter(pageEntryList, string, numLast + 1, numOfPages, i);
            list.add(bookChapter);
        }
        return new BookEntries(ResourceLocation.parse((String)book), list, numOfPages);
    }
}

