/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.joefoxe.hexerei.data.books.BookTooltipExtra;
import net.joefoxe.hexerei.data.books.PageDrawing;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class BookItemsAndFluids {
    public float x;
    public float y;
    public boolean show_slot;
    public ItemStack item;
    public FluidStack fluid;
    public float fluid_width;
    public float fluid_height;
    public float fluid_offset_x;
    public float fluid_offset_y;
    public int capacity;
    public int amount;
    public String tag;
    public boolean refreshTag = false;
    public String type;
    public TagKey<Item> key;
    public List<Component> extra_tooltips = new ArrayList<Component>();
    List<BookTooltipExtra> extra_tooltips_raw;
    public BakedModel modelCache = null;
    public static final Codec<BookItemsAndFluids> ITEM_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(e -> e.type), (App)Codec.FLOAT.optionalFieldOf("x", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.x)), (App)Codec.FLOAT.optionalFieldOf("y", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.y)), (App)ItemStack.CODEC.optionalFieldOf("item", (Object)ItemStack.EMPTY).forGetter(e -> e.item), (App)Codec.BOOL.optionalFieldOf("show_slot", (Object)true).forGetter(e -> e.show_slot), (App)BookTooltipExtra.CODEC.listOf().optionalFieldOf("extra_tooltips", new ArrayList()).forGetter(e -> e.extra_tooltips_raw)).apply((Applicative)instance, BookItemsAndFluids::new));
    public static final Codec<BookItemsAndFluids> FLUID_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(e -> e.type), (App)Codec.FLOAT.optionalFieldOf("x", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.x)), (App)Codec.FLOAT.optionalFieldOf("y", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.y)), (App)FluidStack.CODEC.optionalFieldOf("fluid", (Object)FluidStack.EMPTY).forGetter(e -> e.fluid), (App)Codec.INT.optionalFieldOf("capacity", (Object)1000).forGetter(e -> e.capacity), (App)Codec.FLOAT.optionalFieldOf("fluid_height", (Object)Float.valueOf(16.0f)).forGetter(e -> Float.valueOf(e.fluid_height)), (App)Codec.FLOAT.optionalFieldOf("fluid_width", (Object)Float.valueOf(16.0f)).forGetter(e -> Float.valueOf(e.fluid_width)), (App)Codec.FLOAT.optionalFieldOf("fluid_offset_x", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.fluid_offset_x)), (App)Codec.FLOAT.optionalFieldOf("fluid_offset_y", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.fluid_offset_y)), (App)Codec.BOOL.optionalFieldOf("show_slot", (Object)true).forGetter(e -> e.show_slot), (App)BookTooltipExtra.CODEC.listOf().optionalFieldOf("extra_tooltips", new ArrayList()).forGetter(e -> e.extra_tooltips_raw)).apply((Applicative)instance, BookItemsAndFluids::new));
    public static final Codec<BookItemsAndFluids> TAG_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(e -> e.type), (App)Codec.FLOAT.optionalFieldOf("x", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.x)), (App)Codec.FLOAT.optionalFieldOf("y", (Object)Float.valueOf(0.0f)).forGetter(e -> Float.valueOf(e.y)), (App)Codec.STRING.optionalFieldOf("tag", (Object)"null").forGetter(e -> e.tag), (App)Codec.BOOL.optionalFieldOf("show_slot", (Object)true).forGetter(e -> e.show_slot), (App)BookTooltipExtra.CODEC.listOf().optionalFieldOf("extra_tooltips", new ArrayList()).forGetter(e -> e.extra_tooltips_raw)).apply((Applicative)instance, BookItemsAndFluids::new));
    public static final Codec<BookItemsAndFluids> CODEC = Codec.of(BookItemsAndFluids::encode, BookItemsAndFluids::decode);

    public BookItemsAndFluids(String type, Float x, Float y, FluidStack fluid, Integer capacity, Float fluid_height, Float fluid_width, Float fluid_offset_x, Float fluid_offset_y, Boolean showSlot, List<BookTooltipExtra> extra_tooltips_raw) {
        this.type = type;
        this.x = x.floatValue();
        this.y = y.floatValue();
        this.fluid = fluid;
        this.item = null;
        this.tag = "null";
        this.key = null;
        this.capacity = capacity;
        this.amount = fluid.getAmount();
        this.show_slot = showSlot;
        this.fluid_height = fluid_height.floatValue();
        this.fluid_width = fluid_width.floatValue();
        this.fluid_offset_x = fluid_offset_x.floatValue();
        this.fluid_offset_y = fluid_offset_y.floatValue();
        this.extra_tooltips_raw = extra_tooltips_raw;
        for (BookTooltipExtra tooltipExtra : extra_tooltips_raw) {
            if (!tooltipExtra.color_hex.isEmpty()) {
                tooltipExtra.color = (int)Long.parseLong(tooltipExtra.color_hex, 16);
            }
            if (tooltipExtra.type.equals("append")) {
                this.extra_tooltips.getLast().getSiblings().add(Component.translatable((String)tooltipExtra.text).withStyle(Style.EMPTY.withColor(tooltipExtra.color)));
                continue;
            }
            this.extra_tooltips.add((Component)Component.translatable((String)tooltipExtra.text).withStyle(Style.EMPTY.withColor(tooltipExtra.color)));
        }
    }

    public BookItemsAndFluids(String type, float x, float y, ItemStack item, boolean show_slot, List<BookTooltipExtra> extra_tooltips) {
        this.x = x;
        this.y = y;
        this.type = type;
        this.item = item;
        this.show_slot = show_slot;
        this.extra_tooltips_raw = extra_tooltips;
        for (BookTooltipExtra tooltipExtra : this.extra_tooltips_raw) {
            if (!tooltipExtra.color_hex.isEmpty()) {
                tooltipExtra.color = (int)Long.parseLong(tooltipExtra.color_hex, 16);
            }
            if (tooltipExtra.type.equals("append")) {
                this.extra_tooltips.getLast().getSiblings().add(Component.translatable((String)tooltipExtra.text).withStyle(Style.EMPTY.withColor(tooltipExtra.color)));
                continue;
            }
            this.extra_tooltips.add((Component)Component.translatable((String)tooltipExtra.text).withStyle(Style.EMPTY.withColor(tooltipExtra.color)));
        }
    }

    public BookItemsAndFluids(String type, float x, float y, String tag, boolean show_slot, List<BookTooltipExtra> extra_tooltips) {
        this.x = x;
        this.y = y;
        this.type = type;
        this.tag = tag;
        this.key = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tag));
        this.item = PageDrawing.getTagStack(this.key);
        this.show_slot = show_slot;
        this.extra_tooltips_raw = extra_tooltips;
        this.extra_tooltips.add((Component)Component.translatable((String)"book.hexerei.tooltip.accepts_any", (Object[])new Object[]{Component.translatable((String)tag)}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x808080))));
        for (BookTooltipExtra tooltipExtra : extra_tooltips) {
            if (!tooltipExtra.color_hex.isEmpty()) {
                tooltipExtra.color = (int)Long.parseLong(tooltipExtra.color_hex, 16);
            }
            if (tooltipExtra.type.equals("append")) {
                this.extra_tooltips.getLast().getSiblings().add(Component.translatable((String)tooltipExtra.text).withStyle(Style.EMPTY.withColor(tooltipExtra.color)));
                continue;
            }
            this.extra_tooltips.add((Component)Component.translatable((String)tooltipExtra.text).withStyle(Style.EMPTY.withColor(tooltipExtra.color)));
        }
    }

    public static <T> DataResult<T> encode(BookItemsAndFluids item, DynamicOps<T> ops, T prefix) {
        return switch (item.type) {
            case "item" -> ITEM_CODEC.encode((Object)item, ops, prefix);
            case "fluid" -> FLUID_CODEC.encode((Object)item, ops, prefix);
            case "tag" -> TAG_CODEC.encode((Object)item, ops, prefix);
            default -> DataResult.error(() -> "Unknown type: " + item.type);
        };
    }

    public static <T> DataResult<Pair<BookItemsAndFluids, T>> decode(DynamicOps<T> ops, T input) {
        String type;
        Optional typeOpt = ops.get(input, "type").result();
        if (typeOpt.isEmpty()) {
            return DataResult.error(() -> "Missing type field");
        }
        Dynamic typeDynamic = new Dynamic(ops, typeOpt.get());
        return switch (type = typeDynamic.asString("")) {
            case "item" -> ITEM_CODEC.decode(ops, input);
            case "fluid" -> FLUID_CODEC.decode(ops, input);
            case "tag" -> TAG_CODEC.decode(ops, input);
            default -> DataResult.error(() -> "Unknown type: " + type);
        };
    }
}

