/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import java.util.List;
import java.util.UUID;
import net.joefoxe.hexerei.item.ModDataComponents;
import net.joefoxe.hexerei.item.data_components.BookColorData;
import net.joefoxe.hexerei.item.data_components.BookData;
import net.joefoxe.hexerei.screen.BookOfShadowsScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.fml.util.thread.EffectiveSide;

public class HexereiBookItem
extends Item {
    public HexereiBookItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (EffectiveSide.get().isClient()) {
            ClientHelper.setScreen(player, usedHand);
        }
        return super.use(level, player, usedHand);
    }

    public void onCraftedPostProcess(ItemStack stack, Level level) {
        super.onCraftedPostProcess(stack, level);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        BookData bookData = (BookData)stack.get(ModDataComponents.BOOK);
        if (bookData != null && bookData.getUUID() == BookData.EMPTY_UUID) {
            bookData = bookData.setUUID(UUID.randomUUID());
            stack.set(ModDataComponents.BOOK, (Object)bookData);
        }
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public static ItemStack withColors(ItemStack stack, int color1, int color2) {
        stack.set(ModDataComponents.BOOK_COLORS, (Object)new BookColorData(color1, color2));
        return stack;
    }

    public static int getColor1(ItemStack stack) {
        BookColorData bookColorData = (BookColorData)stack.getOrDefault(ModDataComponents.BOOK_COLORS, (Object)BookColorData.EMPTY);
        return bookColorData.color1();
    }

    public static int getColor2(ItemStack stack) {
        BookColorData bookColorData = (BookColorData)stack.getOrDefault(ModDataComponents.BOOK_COLORS, (Object)BookColorData.EMPTY);
        return bookColorData.color2();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.book_of_shadows_shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    static class ClientHelper {
        ClientHelper() {
        }

        public static void setScreen(Player player, InteractionHand usedHand) {
            Minecraft.getInstance().setScreen((Screen)new BookOfShadowsScreen(player, usedHand));
        }
    }
}

