/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.runtime.IRecipesGui;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.config.ModKeyBindings;
import net.joefoxe.hexerei.data.books.BookChapter;
import net.joefoxe.hexerei.data.books.BookEntity;
import net.joefoxe.hexerei.data.books.BookEntries;
import net.joefoxe.hexerei.data.books.BookItemsAndFluids;
import net.joefoxe.hexerei.data.books.BookManager;
import net.joefoxe.hexerei.data.books.BookPage;
import net.joefoxe.hexerei.data.books.BookPageEntry;
import net.joefoxe.hexerei.data.books.BookPaintElement;
import net.joefoxe.hexerei.data.books.BookReloadListener;
import net.joefoxe.hexerei.data.books.PageDrawing;
import net.joefoxe.hexerei.data.books.PaintSystem;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.integration.jei.HexereiJei;
import net.joefoxe.hexerei.integration.jei.HexereiJeiCompat;
import net.joefoxe.hexerei.item.data_components.BookData;
import net.joefoxe.hexerei.tileentity.BookOfShadowsAltarTile;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.AskForEntriesAndPagesPacket;
import net.joefoxe.hexerei.util.message.AskForPaintDataToServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class PageDrawingEvents {
    @SubscribeEvent
    public static void clientTickEvent(ClientTickEvent.Pre event) {
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        if (BookReloadListener.askForUpdate && Minecraft.getInstance().level != null) {
            BookReloadListener.askForUpdate = false;
            HexereiPacketHandler.sendToServer(new AskForEntriesAndPagesPacket());
            HexereiPacketHandler.sendToServer(new AskForPaintDataToServer());
        }
        boolean pressed = false;
        for (ResourceLocation book : BookManager.getBookLocations()) {
            BookEntries bookEntries = BookManager.getBookEntries(book);
            if (bookEntries == null) continue;
            for (BookChapter bookChapter : bookEntries.chapterList) {
                for (BookPageEntry bookPageEntry : bookChapter.pages) {
                    BookPage page = BookManager.getBookPages(book, ResourceLocation.parse((String)bookPageEntry.location));
                    if (page == null) continue;
                    for (BookPaintElement paintElement : page.paintElements) {
                        if (paintElement.client == null) continue;
                        for (PaintSystem paintSystem : paintElement.client.paintSystems.values()) {
                            if (!paintSystem.shouldTick) continue;
                            paintSystem.tick();
                        }
                    }
                    for (BookEntity bookEntity : page.entityList) {
                        if (!bookEntity.markedForUpdate) continue;
                        bookEntity.markedForUpdate = false;
                        Entity paintSystem = bookEntity.entity;
                        if (paintSystem instanceof LivingEntity) {
                            LivingEntity livingEntity = (LivingEntity)paintSystem;
                            if (!bookEntity.entityTagsList.isEmpty() && ClientEvents.getClientTicksWithoutPartial() > (float)(bookEntity.entityTagsLastChange + 40)) {
                                bookEntity.entityTagsLastChange = (int)ClientEvents.getClientTicksWithoutPartial();
                                ++bookEntity.entityTagsListOn;
                                if (bookEntity.entityTagsListOn >= bookEntity.entityTagsList.size()) {
                                    bookEntity.entityTagsListOn = 0;
                                }
                                int on = bookEntity.entityTagsListOn;
                                if (bookEntity.entityTagsListOnSet != bookEntity.entityTagsListOn && !bookEntity.entityTagsList.get(on).isEmpty()) {
                                    livingEntity.load(bookEntity.entityTagsList.get(on));
                                    bookEntity.entityTagsListOnSet = bookEntity.entityTagsListOn;
                                }
                            }
                        } else if (bookEntity.entity != null) {
                            if (!bookEntity.entityTagsList.isEmpty() && ClientEvents.getClientTicksWithoutPartial() > (float)(bookEntity.entityTagsLastChange + 40)) {
                                int on;
                                bookEntity.entityTagsLastChange = (int)ClientEvents.getClientTicksWithoutPartial();
                                ++bookEntity.entityTagsListOn;
                                if (bookEntity.entityTagsListOn >= bookEntity.entityTagsList.size()) {
                                    bookEntity.entityTagsListOn = 0;
                                }
                                if (bookEntity.entityTagsListOnSet != (on = bookEntity.entityTagsListOn) && !bookEntity.entityTagsList.get(on).isEmpty()) {
                                    bookEntity.entity.load(bookEntity.entityTagsList.get(on));
                                    bookEntity.entityTagsListOnSet = bookEntity.entityTagsListOn;
                                }
                            }
                        } else {
                            Optional optionalEntityType = EntityType.byString((String)bookEntity.entityType);
                            if (optionalEntityType.isPresent()) {
                                Entity entity = ((EntityType)optionalEntityType.get()).create(Hexerei.proxy.getLevel());
                                if (entity instanceof LivingEntity) {
                                    LivingEntity livingEntity = (LivingEntity)entity;
                                    bookEntity.entity = entity;
                                    if (!bookEntity.entityTags.isEmpty()) {
                                        livingEntity.load(bookEntity.entityTags);
                                    }
                                } else {
                                    bookEntity.entity = entity;
                                    if (!bookEntity.entityTags.isEmpty() && entity != null) {
                                        entity.load(bookEntity.entityTags);
                                    }
                                }
                            }
                        }
                        MouseHandler handler = Minecraft.getInstance().mouseHandler;
                        if (bookEntity.entity != null) {
                            bookEntity.toRotateO = bookEntity.toRotate;
                            if (bookEntity.clicked) {
                                bookEntity.toRotate -= (float)handler.getXVelocity() * 5.0f;
                                pressed = true;
                            }
                            bookEntity.entity.tick();
                        }
                        bookEntity.tick();
                    }
                }
            }
        }
        PageDrawing.isClicked = pressed;
        Hexerei.entityClicked = pressed;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @OnlyIn(value=Dist.CLIENT)
    public static void onKeyEvent(InputEvent.Key event) {
        if (!HexereiJeiCompat.LOADED) {
            return;
        }
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        Player playerIn = Hexerei.proxy.getPlayer();
        if (playerIn == null || event.getAction() == 0) {
            // empty if block
        }
        if (playerIn != null && event.getAction() == 1) {
            if (event.getKey() != ModKeyBindings.bookJEIShowUses.getKey().getValue() && event.getKey() != ModKeyBindings.bookJEIShowRecipe.getKey().getValue()) {
                return;
            }
            if (Minecraft.getInstance().screen instanceof IRecipesGui) {
                return;
            }
            double reach = playerIn.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue();
            List<BlockPos> altars = PageDrawing.getAltars(playerIn);
            block0: for (BlockPos pos : altars) {
                BookData bookData;
                BlockEntity blockEntity = playerIn.level().getBlockEntity(pos);
                if (!(blockEntity instanceof BookOfShadowsAltarTile)) continue;
                BookOfShadowsAltarTile altarTile = (BookOfShadowsAltarTile)blockEntity;
                if (altarTile.turnPage != 0) continue;
                Vec2 leftCursor = PageDrawing.getIntersectPoint(Minecraft.getInstance().player.getLookAngle(), Minecraft.getInstance().player.getEyePosition(), altarTile, PageDrawing.PageOn.LEFT_PAGE);
                Vec2 rightCursor = PageDrawing.getIntersectPoint(Minecraft.getInstance().player.getLookAngle(), Minecraft.getInstance().player.getEyePosition(), altarTile, PageDrawing.PageOn.RIGHT_PAGE);
                if (leftCursor == null) {
                    leftCursor = new Vec2(50.0f, 50.0f);
                }
                if (rightCursor == null) {
                    rightCursor = new Vec2(50.0f, 50.0f);
                }
                if ((bookData = altarTile.currentBook) == null || !bookData.isOpened()) continue;
                String location1 = "";
                String location2 = "";
                BookEntries bookEntries = BookManager.getBookEntries(bookData.getBook());
                if (bookEntries == null) continue;
                int chapter = bookData.getChapter();
                int page = bookData.getPage();
                if (page % 2 == 1) {
                    --page;
                }
                if (bookEntries.chapterList.get((int)chapter).pages.size() > page && page >= 0) {
                    location1 = bookEntries.chapterList.get((int)chapter).pages.get((int)page).location;
                }
                if (bookEntries.chapterList.get((int)chapter).pages.size() > page + 1 && page >= 0) {
                    location2 = bookEntries.chapterList.get((int)chapter).pages.get((int)(page + 1)).location;
                }
                BookPage page1 = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)location1));
                BookPage page2 = BookManager.getBookPages(bookData.getBook(), ResourceLocation.parse((String)location2));
                if (page1 != null) {
                    for (BookItemsAndFluids bookItemStackInSlot : page1.itemList) {
                        if (bookItemStackInSlot.item != null && bookItemStackInSlot.item.isEmpty() || !PageDrawing.canInteract(leftCursor.x, leftCursor.y, bookItemStackInSlot.x, bookItemStackInSlot.y, 0.86f, 0.86f, altarTile, PageDrawing.DrawingType.BOOK)) continue;
                        if (event.getKey() == ModKeyBindings.bookJEIShowUses.getKey().getValue()) {
                            if (bookItemStackInSlot.item != null) {
                                HexereiJei.showUses(bookItemStackInSlot.item);
                            } else {
                                HexereiJei.showUses(bookItemStackInSlot.fluid);
                            }
                        }
                        if (event.getKey() != ModKeyBindings.bookJEIShowRecipe.getKey().getValue()) break;
                        if (bookItemStackInSlot.item != null) {
                            HexereiJei.showRecipe(bookItemStackInSlot.item);
                            break;
                        }
                        HexereiJei.showRecipe(bookItemStackInSlot.fluid);
                        break;
                    }
                }
                if (page2 == null) continue;
                for (BookItemsAndFluids bookItemStackInSlot : page2.itemList) {
                    if (bookItemStackInSlot.item == null || bookItemStackInSlot.item.isEmpty() || !PageDrawing.canInteract(rightCursor.x, rightCursor.y, bookItemStackInSlot.x, bookItemStackInSlot.y, 0.86f, 0.86f, altarTile, PageDrawing.DrawingType.BOOK)) continue;
                    if (event.getKey() == ModKeyBindings.bookJEIShowUses.getKey().getValue()) {
                        if (bookItemStackInSlot.item != null) {
                            HexereiJei.showUses(bookItemStackInSlot.item);
                        } else {
                            HexereiJei.showUses(bookItemStackInSlot.fluid);
                        }
                    }
                    if (event.getKey() != ModKeyBindings.bookJEIShowRecipe.getKey().getValue()) continue block0;
                    if (bookItemStackInSlot.item != null) {
                        HexereiJei.showRecipe(bookItemStackInSlot.item);
                        continue block0;
                    }
                    HexereiJei.showRecipe(bookItemStackInSlot.fluid);
                    continue block0;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClickEvent(InputEvent.MouseButton.Pre event) {
        Player playerIn = Hexerei.proxy.getPlayer();
        if (event.getButton() == 1 && playerIn != null && Minecraft.getInstance().screen == null) {
            if (event.getAction() == 1) {
                PageDrawing.clearFocusedWritableTextBox();
            }
            List<BlockPos> altars = PageDrawing.getAltars(playerIn);
            for (BlockPos pos : altars) {
                BlockEntity blockEntity = playerIn.level().getBlockEntity(pos);
                if (!(blockEntity instanceof BookOfShadowsAltarTile)) continue;
                BookOfShadowsAltarTile altarTile = (BookOfShadowsAltarTile)blockEntity;
                Vec2 leftCursor = PageDrawing.getIntersectPoint(playerIn.getLookAngle(), playerIn.getEyePosition(), altarTile, PageDrawing.PageOn.LEFT_PAGE);
                Vec2 rightCursor = PageDrawing.getIntersectPoint(playerIn.getLookAngle(), playerIn.getEyePosition(), altarTile, PageDrawing.PageOn.RIGHT_PAGE);
                if (leftCursor == null) {
                    leftCursor = new Vec2(50.0f, 50.0f);
                }
                if (rightCursor == null) {
                    rightCursor = new Vec2(50.0f, 50.0f);
                }
                if (event.getAction() == 1 && altarTile.drawing.interactClick(altarTile, playerIn, leftCursor.x, leftCursor.y, rightCursor.x, rightCursor.y, PageDrawing.DrawingType.BOOK)) {
                    event.setCanceled(true);
                    playerIn.swing(InteractionHand.MAIN_HAND);
                    break;
                }
                if (event.getAction() != 0 || !altarTile.drawing.releaseClick(altarTile, playerIn, leftCursor.x, leftCursor.y, rightCursor.x, rightCursor.y, PageDrawing.DrawingType.BOOK)) continue;
                event.setCanceled(true);
                playerIn.swing(InteractionHand.MAIN_HAND);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPostClickEvent(InputEvent.MouseButton.Post event) {
        Player playerIn = Hexerei.proxy.getPlayer();
        if (playerIn != null && event.getAction() == 0) {
            for (ResourceLocation book : BookManager.getBookLocations()) {
                BookEntries bookEntries = BookManager.getBookEntries(book);
                if (bookEntries == null) continue;
                for (BookChapter bookChapter : bookEntries.chapterList) {
                    for (BookPageEntry bookPageEntry : bookChapter.pages) {
                        BookPage page = BookManager.getBookPages(book, ResourceLocation.parse((String)bookPageEntry.location));
                        if (page == null) continue;
                        for (BookEntity bookEntity : page.entityList) {
                            bookEntity.clicked = false;
                        }
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean clickedBack(BookOfShadowsAltarTile altarTile) {
        BookData bookData = altarTile.currentBook;
        int currentPage = bookData.getPage();
        int currentChapter = bookData.getChapter();
        return currentChapter > 0 || currentPage > 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean clickedNext(BookOfShadowsAltarTile altarTile) {
        BookData bookData = altarTile.currentBook;
        BookEntries bookEntries = BookManager.getBookEntries(bookData.getBook());
        int currentPage = bookData.getPage();
        int currentChapter = bookData.getChapter();
        return bookEntries != null && (currentChapter < bookEntries.chapterList.size() - 1 || currentPage < bookEntries.chapterList.get((int)currentChapter).pages.size() - 2);
    }
}

