/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.joefoxe.hexerei.data.books.PageDrawing;
import net.joefoxe.hexerei.data.books.PaintData;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.PaintDataToServer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class PaintSystem {
    public static BufferedImage clipboardImage;
    public static Rectangle clipboardBounds;
    public static BufferedImage clipboardMask;
    private final List<Layer> layers = new ArrayList<Layer>();
    private Layer activeLayer;
    public final ResourceLocation parentLocation;
    private UUID uuid;
    public int width;
    public int height;
    private static Colors colors;
    private float colorsVisibility;
    private float colorsVisibilityOld;
    private Brush brush;
    private Selection selection;
    public List<Button> buttons = new ArrayList<Button>();
    private ValueSliders valueSliders;
    public BufferedImage compositeImage;
    public BufferedImage strokeMask;
    public Brush.Type strokeType;
    private BufferedImage movingSelection;
    private Pos2i movingSelectionOffset = new Pos2i(0, 0);
    private Pos2i movingSelectionClickedPos = new Pos2i(0, 0);
    private boolean skipNextRelease;
    private boolean dirty;
    private boolean updateToServer = false;
    private static Tool currentTool;
    private final List<Tool> tools = Arrays.asList(Tool.values());
    public float cursorX = -10.0f;
    public float cursorY = -10.0f;
    public float cursorXOld = -10.0f;
    public float cursorYOld = -10.0f;
    public boolean shouldTick = false;
    public boolean toolsVisible = false;
    public float toolVisibility = 0.0f;
    public float toolVisibilityOld = 0.0f;
    public boolean locked = false;
    public UUID lockedByUUID = new UUID(0L, 0L);
    public Component lockedByName = Component.empty();
    private DrawAction currentDrawAction = null;
    private Rectangle initialSelectionBounds = null;
    private BufferedImage initialSelectionMask = null;
    public ActionManager actionManager = new ActionManager();

    public PaintSystem(int width, int height, ResourceLocation parentLocation, UUID uuid) {
        this.parentLocation = parentLocation;
        this.uuid = uuid;
        this.width = width;
        this.height = height;
        this.brush = new Brush(this);
        this.selection = new Selection(this);
        this.addLayer(width, height);
        this.valueSliders = new ValueSliders(this);
        this.valueSliders.updateColorSliders(colors.getColor());
        this.valueSliders.updateHardnessSlider(Brush.hardness);
        this.valueSliders.updateBrushSizeSlider(Brush.size);
        this.valueSliders.updateToleranceSlider(Brush.tolerance);
        this.movingSelection = null;
        this.buttons.add(new Button(this, -0.5f, 0.0f, 5.5f, 0.0f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/selection_box.png", "hexerei:textures/book/paint_tools/selection_box_hover.png", "hexerei:textures/book/paint_tools/selection_box.png", paintSystem -> paintSystem.setCurrentTool(Tool.SELECTION), (Component)Component.translatable((String)"Select").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> ps.getCurrentTool() == Tool.SELECTION, ps -> false, ps -> this.toolsVisible));
        this.buttons.add(new Button(this, -0.5f, 0.8f, 5.5f, 0.8f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/magic_wand.png", "hexerei:textures/book/paint_tools/magic_wand_hover.png", "hexerei:textures/book/paint_tools/magic_wand.png", paintSystem -> paintSystem.setCurrentTool(Tool.MAGIC_WAND), (Component)Component.translatable((String)"Magic Wand").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> ps.getCurrentTool() == Tool.MAGIC_WAND, ps -> false, ps -> this.toolsVisible));
        this.buttons.add(new Button(this, -0.5f, 1.6f, 5.5f, 1.6f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/move.png", "hexerei:textures/book/paint_tools/move_hover.png", "hexerei:textures/book/paint_tools/move.png", paintSystem -> paintSystem.setCurrentTool(Tool.MOVE), (Component)Component.translatable((String)"Move").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> ps.getCurrentTool() == Tool.MOVE, ps -> false, ps -> this.toolsVisible));
        this.buttons.add(new Button(this, -0.5f, 2.4f, 5.5f, 2.4f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/brush.png", "hexerei:textures/book/paint_tools/brush_hover.png", "hexerei:textures/book/paint_tools/brush.png", paintSystem -> paintSystem.setCurrentTool(Tool.BRUSH), (Component)Component.translatable((String)"Brush").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> ps.getCurrentTool() == Tool.BRUSH, ps -> false, ps -> this.toolsVisible));
        this.buttons.add(new Button(this, -0.5f, 3.2f, 5.5f, 3.2f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/eraser.png", "hexerei:textures/book/paint_tools/eraser_hover.png", "hexerei:textures/book/paint_tools/eraser.png", paintSystem -> paintSystem.setCurrentTool(Tool.ERASER), (Component)Component.translatable((String)"Eraser").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> ps.getCurrentTool() == Tool.ERASER, ps -> false, ps -> this.toolsVisible));
        this.buttons.add(new Button(this, -0.5f, 4.0f, 5.5f, 4.0f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/fill.png", "hexerei:textures/book/paint_tools/fill_hover.png", "hexerei:textures/book/paint_tools/fill.png", paintSystem -> paintSystem.setCurrentTool(Tool.FILL), (Component)Component.translatable((String)"Fill").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> ps.getCurrentTool() == Tool.FILL, ps -> false, ps -> this.toolsVisible));
        this.buttons.add(new Button(this, -0.5f, 4.8f, 5.5f, 4.8f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/color_picker.png", "hexerei:textures/book/paint_tools/color_picker_hover.png", "hexerei:textures/book/paint_tools/color_picker.png", paintSystem -> paintSystem.setCurrentTool(Tool.EYEDROPPER), (Component)Component.translatable((String)"Color Picker").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> ps.getCurrentTool() == Tool.EYEDROPPER, ps -> false, ps -> this.toolsVisible));
        this.buttons.add(new ToggleButton(this, -0.5f, 6.2f, 5.5f, 6.2f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/visible.png", "hexerei:textures/book/paint_tools/visible_hover.png", "hexerei:textures/book/paint_tools/visible.png", "hexerei:textures/book/paint_tools/visible_toggled.png", "hexerei:textures/book/paint_tools/visible_toggled_hover.png", "hexerei:textures/book/paint_tools/visible_toggled.png", paintSystem -> {
            this.toolsVisible = !this.toolsVisible;
        }, paintSystem -> {
            this.toolsVisible = !this.toolsVisible;
        }, (Component)Component.translatable((String)"Tool Visibility").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> false, ps -> this.locked, ps -> !this.locked, ps -> !this.toolsVisible));
        AtomicReference<Float> lockY = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Float> lockYO = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Float> lockYTarget = new AtomicReference<Float>(Float.valueOf(0.0f));
        this.buttons.add(new ToggleButton((ps, partial) -> Float.valueOf(-0.5f), (ps, partial) -> Float.valueOf(5.4f + HexereiUtil.easeInOutCubic(Mth.lerp((float)partial.floatValue(), (float)((Float)lockYO.get()).floatValue(), (float)((Float)lockY.get()).floatValue())) * 0.8f), (ps, partial) -> Float.valueOf(5.5f), (ps, partial) -> Float.valueOf(5.4f + HexereiUtil.easeInOutCubic(Mth.lerp((float)partial.floatValue(), (float)((Float)lockYO.get()).floatValue(), (float)((Float)lockY.get()).floatValue())) * 0.8f), 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/locked.png", "hexerei:textures/book/paint_tools/locked_hover.png", "hexerei:textures/book/paint_tools/locked.png", "hexerei:textures/book/paint_tools/locked_toggled.png", "hexerei:textures/book/paint_tools/locked_toggled_hover.png", "hexerei:textures/book/paint_tools/locked_toggled.png", paintSystem -> {
            if (Minecraft.getInstance().player != null) {
                this.locked = true;
                this.lockedByName = Minecraft.getInstance().player.getName();
                this.lockedByUUID = Minecraft.getInstance().player.getUUID();
                HexereiPacketHandler.sendToServer(new PaintDataToServer(paintSystem.toPaintData()));
            }
        }, paintSystem -> {
            if (Minecraft.getInstance().player != null && this.lockedByUUID != null && this.lockedByUUID.equals(Minecraft.getInstance().player.getUUID())) {
                this.locked = false;
                this.lockedByName = Component.empty();
                this.lockedByUUID = new UUID(0L, 0L);
                HexereiPacketHandler.sendToServer(new PaintDataToServer(paintSystem.toPaintData()));
            }
        }, (Component)Component.translatable((String)"Lock").withStyle(ChatFormatting.GRAY), ps -> {
            lockYO.set((Float)lockY.get());
            lockYTarget.set(Float.valueOf(ps.locked ? 1.0f : 0.0f));
            lockY.set(Float.valueOf(HexereiUtil.moveTo(((Float)lockY.get()).floatValue(), ((Float)lockYTarget.get()).floatValue(), Math.abs(((Float)lockYTarget.get()).floatValue() - ((Float)lockY.get()).floatValue()) / 5.0f + 0.01f)));
        }, ps -> false, ps -> false, ps -> !this.toolsVisible, ps -> this.locked){

            @Override
            public List<Component> getTooltipList() {
                ArrayList<Component> components = new ArrayList<Component>();
                if (PaintSystem.this.locked) {
                    components.add((Component)Component.translatable((String)"Unlock").withStyle(ChatFormatting.GRAY));
                    components.add((Component)Component.translatable((String)"Locked by: ").withStyle(ChatFormatting.DARK_GRAY).append(PaintSystem.this.lockedByName));
                } else {
                    components.add((Component)Component.translatable((String)"Lock").withStyle(ChatFormatting.GRAY));
                }
                return components;
            }
        });
        this.buttons.add(new Button(this, 0.6f, -1.0f, 0.6f, -1.0f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/undo.png", "hexerei:textures/book/paint_tools/undo_hover.png", "hexerei:textures/book/paint_tools/undo_disabled.png", paintSystem -> paintSystem.actionManager.undo(), (Component)Component.translatable((String)"Undo").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> false, ps -> ps.actionManager.undoStack.isEmpty(), ps -> this.toolsVisible));
        this.buttons.add(new Button(this, 1.5f, -1.0f, 1.5f, -1.0f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/redo.png", "hexerei:textures/book/paint_tools/redo_hover.png", "hexerei:textures/book/paint_tools/redo_disabled.png", paintSystem -> paintSystem.actionManager.redo(), (Component)Component.translatable((String)"Redo").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> false, ps -> ps.actionManager.redoStack.isEmpty(), ps -> this.toolsVisible));
        this.buttons.add(new Button(this, 2.4f, -1.0f, 2.4f, -1.0f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/cut.png", "hexerei:textures/book/paint_tools/cut_hover.png", "hexerei:textures/book/paint_tools/cut_disabled.png", PaintSystem::cutSelectionToClipboard, (Component)Component.translatable((String)"Cut").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> false, ps -> ps.selection.isEmpty(), ps -> this.toolsVisible));
        this.buttons.add(new Button(this, 3.3f, -1.0f, 3.3f, -1.0f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/copy.png", "hexerei:textures/book/paint_tools/copy_hover.png", "hexerei:textures/book/paint_tools/copy_disabled.png", PaintSystem::copySelectionToClipboard, (Component)Component.translatable((String)"Copy").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> false, ps -> ps.selection.isEmpty(), ps -> this.toolsVisible));
        this.buttons.add(new Button(this, 4.2f, -1.0f, 4.2f, -1.0f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/paste.png", "hexerei:textures/book/paint_tools/paste_hover.png", "hexerei:textures/book/paint_tools/paste_disabled.png", PaintSystem::pasteClipboard, (Component)Component.translatable((String)"Paste").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> false, ps -> clipboardImage == null, ps -> this.toolsVisible));
        this.buttons.add(new Button(this, 0.6f, 7.1f, 1.4f, 7.1f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/magic_wand_replace.png", "hexerei:textures/book/paint_tools/magic_wand_replace_hover.png", "hexerei:textures/book/paint_tools/magic_wand_replace.png", ps -> ps.selection.setType(Selection.Type.REPLACE), (Component)Component.translatable((String)"Replace").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> ps.selection.getType() == Selection.Type.REPLACE, ps -> ps.getCurrentTool() != Tool.MAGIC_WAND, ps -> ps.getCurrentTool() == Tool.MAGIC_WAND && this.toolsVisible));
        this.buttons.add(new Button(this, 1.5f, 7.1f, 2.3f, 7.1f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/magic_wand_add.png", "hexerei:textures/book/paint_tools/magic_wand_add_hover.png", "hexerei:textures/book/paint_tools/magic_wand_add.png", ps -> ps.selection.setType(Selection.Type.ADD), (Component)Component.translatable((String)"Add").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> ps.selection.getType() == Selection.Type.ADD, ps -> ps.getCurrentTool() != Tool.MAGIC_WAND, ps -> ps.getCurrentTool() == Tool.MAGIC_WAND && this.toolsVisible));
        this.buttons.add(new Button(this, 2.4f, 7.1f, 3.2f, 7.1f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/magic_wand_remove.png", "hexerei:textures/book/paint_tools/magic_wand_remove_hover.png", "hexerei:textures/book/paint_tools/magic_wand_remove.png", ps -> ps.selection.setType(Selection.Type.REMOVE), (Component)Component.translatable((String)"Remove").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> ps.selection.getType() == Selection.Type.REMOVE, ps -> ps.getCurrentTool() != Tool.MAGIC_WAND, ps -> ps.getCurrentTool() == Tool.MAGIC_WAND && this.toolsVisible));
        this.buttons.add(new ToggleButton(this, 3.55f, 6.95f, 4.35f, 6.95f, 18.0f, 18.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 0.9f), "hexerei:textures/book/paint_tools/global_toggled.png", "hexerei:textures/book/paint_tools/global_toggled_hover.png", "hexerei:textures/book/paint_tools/global_toggled.png", "hexerei:textures/book/paint_tools/global_detoggled.png", "hexerei:textures/book/paint_tools/global_detoggled_hover.png", "hexerei:textures/book/paint_tools/global_detoggled.png", ps -> ps.selection.setGlobal(!ps.selection.getGlobal()), ps -> ps.selection.setGlobal(!ps.selection.getGlobal()), (Component)Component.translatable((String)"Toggle Global").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> false, ps -> ps.getCurrentTool() != Tool.MAGIC_WAND, ps -> ps.getCurrentTool() == Tool.MAGIC_WAND && this.toolsVisible, ps -> !ps.selection.getGlobal()));
        this.buttons.add(new Button(this, 0.6f, 7.1f, 1.4f, 7.1f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/selection_box.png", "hexerei:textures/book/paint_tools/selection_box_hover.png", "hexerei:textures/book/paint_tools/selection_box.png", ps -> ps.selection.setType(Selection.Type.REPLACE), (Component)Component.translatable((String)"Replace").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> ps.selection.getType() == Selection.Type.REPLACE, ps -> false, ps -> ps.getCurrentTool() == Tool.SELECTION && this.toolsVisible));
        this.buttons.add(new Button(this, 1.5f, 7.1f, 2.3f, 7.1f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/selection_box_add.png", "hexerei:textures/book/paint_tools/selection_box_add_hover.png", "hexerei:textures/book/paint_tools/selection_box_add.png", ps -> ps.selection.setType(Selection.Type.ADD), (Component)Component.translatable((String)"Add").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> ps.selection.getType() == Selection.Type.ADD, ps -> ps.getCurrentTool() != Tool.SELECTION, ps -> ps.getCurrentTool() == Tool.SELECTION && this.toolsVisible));
        this.buttons.add(new Button(this, 2.4f, 7.1f, 3.2f, 7.1f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/selection_box_remove.png", "hexerei:textures/book/paint_tools/selection_box_remove_hover.png", "hexerei:textures/book/paint_tools/selection_box_remove.png", ps -> ps.selection.setType(Selection.Type.REMOVE), (Component)Component.translatable((String)"Remove").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> ps.selection.getType() == Selection.Type.REMOVE, ps -> ps.getCurrentTool() != Tool.SELECTION, ps -> ps.getCurrentTool() == Tool.SELECTION && this.toolsVisible));
        this.buttons.add(new Button(this, 3.3f, 7.1f, 4.1f, 7.1f, 32.0f, 32.0f, value -> Float.valueOf(value.floatValue() / 2.0f * 1.01f), "hexerei:textures/book/paint_tools/selection_box_deselect.png", "hexerei:textures/book/paint_tools/selection_box_deselect_hover.png", "hexerei:textures/book/paint_tools/selection_box_deselect_disabled.png", ps -> ps.selection.deselect(), (Component)Component.translatable((String)"Clear").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> false, ps -> this.selection.isEmpty(), ps -> ps.getCurrentTool() == Tool.SELECTION && this.toolsVisible));
        this.buttons.add(new ToggleButton(this, 3.55f, 6.95f, 4.35f, 6.95f, 18.0f, 18.0f, value -> Float.valueOf(value.floatValue() / 2.0f), "hexerei:textures/book/paint_tools/global_toggled.png", "hexerei:textures/book/paint_tools/global_toggled_hover.png", "hexerei:textures/book/paint_tools/global_toggled.png", "hexerei:textures/book/paint_tools/global_detoggled.png", "hexerei:textures/book/paint_tools/global_detoggled_hover.png", "hexerei:textures/book/paint_tools/global_detoggled.png", ps -> ps.brush.setGlobal(!ps.brush.getGlobal()), ps -> ps.brush.setGlobal(!ps.brush.getGlobal()), (Component)Component.translatable((String)"Toggle Global").withStyle(ChatFormatting.GRAY), ps -> {}, ps -> false, ps -> ps.getCurrentTool() != Tool.FILL, ps -> ps.getCurrentTool() == Tool.FILL && this.toolsVisible, ps -> !ps.brush.getGlobal()));
    }

    public PaintData toPaintData() {
        ArrayList<PaintData.LayerData> layerDataList = new ArrayList<PaintData.LayerData>();
        for (Layer layer : this.layers) {
            int[] pixels = new int[layer.pixels.getWidth() * layer.pixels.getHeight()];
            layer.pixels.getRGB(0, 0, layer.pixels.getWidth(), layer.pixels.getHeight(), pixels, 0, layer.pixels.getWidth());
            layerDataList.add(new PaintData.LayerData(layer.pixels.getWidth(), layer.pixels.getHeight(), Arrays.stream(pixels).boxed().toList(), layer.opacity, layer.blendMode.name(), layer.name));
        }
        return new PaintData(this.width, this.height, layerDataList, this.parentLocation, this.uuid, this.locked, this.lockedByUUID, this.lockedByName);
    }

    public void fromPaintData(PaintData data) {
        AbstractTexture tex;
        this.layers.clear();
        this.setActiveLayer(null);
        this.locked = data.locked;
        this.lockedByUUID = data.lockedByUUID;
        this.lockedByName = data.lockedByName;
        for (PaintData.LayerData layerData : data.getLayers()) {
            BufferedImage image = new BufferedImage(layerData.width(), layerData.height(), 2);
            image.setRGB(0, 0, layerData.width(), layerData.height(), layerData.pixels().stream().mapToInt(Integer::intValue).toArray(), 0, layerData.width());
            Layer layer = new Layer();
            layer.pixels = image;
            layer.opacity = layerData.opacity();
            layer.blendMode = BlendMode.valueOf(layerData.blendMode());
            layer.name = layerData.name();
            this.addLayer(layer);
        }
        this.dirty = true;
        this.rebuildComposite();
        if (this.compositeImage != null && (tex = Minecraft.getInstance().getTextureManager().getTexture(this.getImageLocation())) instanceof DynamicTexture) {
            DynamicTexture dynamicTexture = (DynamicTexture)tex;
            dynamicTexture.setPixels(PaintSystem.convertToNativeImage(this.compositeImage));
            dynamicTexture.upload();
        }
    }

    public static BufferedImage deepCopy(BufferedImage bi) {
        if (bi == null) {
            return null;
        }
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public float getColorsVisibility(float partial) {
        return Math.max(0.0f, HexereiUtil.easeInOutCubic(Mth.lerp((float)partial, (float)this.colorsVisibilityOld, (float)this.colorsVisibility)));
    }

    public ValueSliders getValueSliders() {
        return this.valueSliders;
    }

    public Tool getCurrentTool() {
        return currentTool;
    }

    public void setCurrentTool(Tool tool) {
        currentTool = tool;
    }

    public void setCurrentToolById(int id) {
        if (id >= 0 && id < this.tools.size()) {
            currentTool = this.tools.get(id);
        }
    }

    public void nextTool() {
        int currentIndex = this.tools.indexOf((Object)currentTool);
        int nextIndex = (currentIndex + 1) % this.tools.size();
        currentTool = this.tools.get(nextIndex);
    }

    public void previousTool() {
        int currentIndex = this.tools.indexOf((Object)currentTool);
        int prevIndex = (currentIndex - 1 + this.tools.size()) % this.tools.size();
        currentTool = this.tools.get(prevIndex);
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public int getColor() {
        return colors.getColor();
    }

    public void setColor(int col) {
        colors.setColor(col);
    }

    public void click(float xPixel, float yPixel) {
        switch (currentTool.ordinal()) {
            case 6: {
                if (xPixel < 0.0f || xPixel >= (float)this.width || yPixel < 0.0f || yPixel >= (float)this.height || this.activeLayer == null) break;
                this.initialSelectionBounds = new Rectangle(this.selection.bounds);
                this.initialSelectionMask = this.selection.mask != null ? PaintSystem.deepCopy(this.selection.mask) : null;
                BufferedImage newMask = this.selection.generateMagicWandMask(this.activeLayer, (int)xPixel, (int)yPixel, Brush.tolerance, this.selection.getGlobal());
                this.selection.bounds.x = 0;
                this.selection.bounds.y = 0;
                this.selection.setSelectionMask(newMask);
                if (this.selection.getType() == Selection.Type.ADD) {
                    if (this.initialSelectionMask != null) {
                        combinedBounds = this.initialSelectionBounds;
                        if (!this.selection.bounds.isEmpty()) {
                            combinedBounds = (Rectangle)this.selection.bounds.createUnion(this.initialSelectionBounds);
                        }
                        BufferedImage combinedMask = new BufferedImage(combinedBounds.width, combinedBounds.height, 2);
                        Graphics2D g = combinedMask.createGraphics();
                        if (this.selection.mask != null) {
                            g.drawImage(this.selection.mask, this.selection.bounds.x - combinedBounds.x, this.selection.bounds.y - combinedBounds.y, this.selection.mask.getWidth(), this.selection.mask.getHeight(), null);
                        }
                        if (this.initialSelectionMask != null) {
                            g.drawImage(this.initialSelectionMask, this.initialSelectionBounds.x - combinedBounds.x, this.initialSelectionBounds.y - combinedBounds.y, this.initialSelectionMask.getWidth(), this.initialSelectionMask.getHeight(), null);
                        }
                        g.dispose();
                        this.selection.bounds = combinedBounds;
                        this.selection.setSelectionMask(combinedMask);
                        this.selection.cropMaskToSelection();
                    }
                } else if (this.selection.getType() == Selection.Type.REMOVE) {
                    if (this.initialSelectionMask == null) {
                        this.selection.clear();
                        return;
                    }
                    combinedBounds = this.selection.isEmpty() ? this.initialSelectionBounds : (Rectangle)this.selection.bounds.createUnion(this.initialSelectionBounds);
                    BufferedImage combinedMask = new BufferedImage(combinedBounds.width, combinedBounds.height, 2);
                    Graphics2D g = combinedMask.createGraphics();
                    if (this.initialSelectionMask != null) {
                        g.drawImage(this.initialSelectionMask, this.initialSelectionBounds.x - combinedBounds.x, this.initialSelectionBounds.y - combinedBounds.y, this.initialSelectionMask.getWidth(), this.initialSelectionMask.getHeight(), null);
                    }
                    for (int y1 = 0; y1 < this.selection.bounds.height; ++y1) {
                        for (int x1 = 0; x1 < this.selection.bounds.width; ++x1) {
                            int maskAlpha;
                            int globalX = this.selection.bounds.x + x1;
                            int globalY = this.selection.bounds.y + y1;
                            if (globalX < 0 || globalX >= this.width || globalY < 0 || globalY >= this.height || x1 < 0 || x1 >= this.selection.mask.getWidth() || y1 < 0 || y1 >= this.selection.mask.getHeight() || globalX - combinedBounds.x < 0 || globalX - combinedBounds.x >= combinedBounds.width || globalY - combinedBounds.y < 0 || globalY - combinedBounds.y >= combinedBounds.height || (maskAlpha = this.selection.mask.getRGB(x1, y1) >> 24 & 0xFF) <= 0) continue;
                            combinedMask.setRGB(globalX - combinedBounds.x, globalY - combinedBounds.y, 0);
                        }
                    }
                    g.dispose();
                    this.selection.bounds = combinedBounds;
                    this.selection.setSelectionMask(combinedMask);
                    this.selection.cropMaskToSelection();
                }
                SelectionAction action = new SelectionAction(this.initialSelectionBounds, this.initialSelectionMask, this.selection.bounds, this.selection.mask);
                this.actionManager.beginAction(action);
                this.actionManager.commitAction();
                break;
            }
            case 0: 
            case 1: {
                this.brush.cursorX = xPixel;
                this.brush.cursorY = yPixel;
                this.brush.cursorXOld = xPixel;
                this.brush.cursorYOld = yPixel;
                this.brush.type = this.getCurrentTool() == Tool.ERASER ? Brush.Type.ERASE : Brush.Type.DRAW;
                this.brush.drawing = true;
                if (this.activeLayer != null) {
                    this.currentDrawAction = new DrawAction(this.activeLayer, PaintSystem.deepCopy(this.activeLayer.pixels));
                    this.actionManager.beginAction(this.currentDrawAction);
                }
                this.draw(xPixel, yPixel, xPixel, yPixel);
                break;
            }
            case 2: {
                if (this.selection.adjustingSelection) break;
                this.initialSelectionBounds = new Rectangle(this.selection.bounds);
                this.initialSelectionMask = this.selection.mask != null ? PaintSystem.deepCopy(this.selection.mask) : null;
                this.startSelection((int)xPixel, (int)yPixel);
                break;
            }
            case 3: {
                if (this.selection.isEmpty() || !this.selection.bounds.contains(xPixel, yPixel)) break;
                if (this.movingSelection == null) {
                    this.startMoveSelection((int)xPixel, (int)yPixel);
                    break;
                }
                this.endMoveSelection();
                break;
            }
            case 4: {
                if (xPixel < 0.0f || xPixel >= (float)this.width || yPixel < 0.0f || yPixel >= (float)this.height || this.activeLayer == null) break;
                DrawAction fillAction = new DrawAction(this.activeLayer, PaintSystem.deepCopy(this.activeLayer.pixels));
                this.actionManager.beginAction(fillAction);
                this.floodFill(this.activeLayer, (int)xPixel, (int)yPixel, this.getColor(), Brush.tolerance);
                fillAction.captureAfter();
                this.actionManager.commitAction();
                break;
            }
            case 5: {
                if (xPixel < 0.0f || xPixel >= (float)this.width || yPixel < 0.0f || yPixel >= (float)this.height) break;
                this.setColor(this.pickColor(this.activeLayer, (int)xPixel, (int)yPixel));
                this.valueSliders.updateColorSliders(this.getColor());
            }
        }
    }

    public void hover(float xPixel, float yPixel) {
        this.cursorX = xPixel;
        this.cursorY = yPixel;
        switch (currentTool.ordinal()) {
            case 0: 
            case 1: {
                if (!this.brush.drawing) break;
                this.brush.cursorX = xPixel;
                this.brush.cursorY = yPixel;
                break;
            }
            case 2: {
                if (!this.selection.adjustingSelection) break;
                this.selection.cursorX = (int)xPixel;
                this.selection.cursorY = (int)yPixel;
                break;
            }
            case 3: {
                if (this.movingSelection == null) break;
                this.updateMoveSelection((int)xPixel, (int)yPixel);
            }
        }
    }

    public void released(int xPixel, int yPixel) {
        switch (currentTool.ordinal()) {
            case 0: 
            case 1: {
                this.brush.drawing = false;
                this.endDrawing();
                break;
            }
            case 2: {
                if (!this.selection.adjustingSelection) break;
                if ((this.initialSelectionBounds == null || this.initialSelectionBounds.isEmpty()) && (this.selection.bounds == null || this.selection.bounds.isEmpty())) {
                    this.selection.adjustingSelection = false;
                    break;
                }
                this.endSelection(xPixel, yPixel);
                break;
            }
            case 3: {
                if (this.skipNextRelease) {
                    this.skipNextRelease = false;
                    break;
                }
                if (this.movingSelection == null) break;
                this.endMoveSelection();
            }
        }
    }

    public ResourceLocation getImageLocation() {
        return ResourceLocation.parse((String)(this.parentLocation.toString() + "/" + this.uuid.toString()));
    }

    public void tick() {
        AbstractTexture abstractTexture;
        this.toolVisibilityOld = this.toolVisibility;
        this.toolVisibility = this.toolsVisible ? HexereiUtil.moveTo(this.toolVisibility, 1.0f, 0.01f + Math.clamp(Math.abs(this.toolVisibility - 1.0f), 0.0f, 1.0f) * 0.15f) : HexereiUtil.moveTo(this.toolVisibility, -1.0f, 0.01f + Math.clamp(Math.abs(this.toolVisibility - 1.0f), 0.0f, 1.0f) * 0.25f);
        this.shouldTick = false;
        if (this.cursorXOld != this.cursorX || this.cursorYOld != this.cursorY) {
            this.cursorXOld = this.cursorX;
            this.cursorYOld = this.cursorY;
            if (this.getCurrentTool().shouldShowBrushSliders() || this.selection.adjustingSelection) {
                this.dirty = true;
            }
        }
        this.getColors().tick();
        this.getValueSliders().updateColorSliders(this.getColor());
        this.getValueSliders().updateBrushSizeSlider(Brush.size);
        this.getValueSliders().updateToleranceSlider(Brush.tolerance);
        this.getValueSliders().updateHardnessSlider(Brush.hardness);
        this.colorsVisibilityOld = this.colorsVisibility;
        this.colorsVisibility = this.getCurrentTool().shouldShowColorSliders() && this.toolsVisible ? HexereiUtil.moveTo(this.colorsVisibility, 1.0f, 0.01f + Math.clamp(Math.abs(this.colorsVisibility - 1.0f), 0.0f, 1.0f) * 0.15f) : HexereiUtil.moveTo(this.colorsVisibility, -1.0f, 0.01f + Math.clamp(Math.abs(this.colorsVisibility - 1.0f), 0.0f, 1.0f) * 0.25f);
        for (Button button : this.buttons) {
            button.tick(this);
        }
        for (ValueSlider valueSlider : this.valueSliders.sliders) {
            valueSlider.tick(this);
        }
        boolean anyDirty = false;
        if (this.dirty) {
            anyDirty = true;
            this.dirty = false;
        }
        if (this.brush.drawing) {
            if (this.brush.cursorXOld != this.cursorX || this.brush.cursorYOld != this.cursorY) {
                this.draw(this.brush.cursorXOld, this.brush.cursorYOld, this.cursorX, this.cursorY);
                this.brush.cursorXOld = this.brush.cursorX;
                this.brush.cursorYOld = this.brush.cursorY;
            }
        } else {
            this.endDrawing();
        }
        if (this.selection.adjustingSelection) {
            this.updateSelection(this.selection.cursorX, this.selection.cursorY);
            anyDirty = true;
        }
        for (Layer layer : this.layers) {
            if (!layer.dirty) continue;
            anyDirty = true;
            break;
        }
        if (this.selection.bounds.width * this.selection.bounds.height > 0) {
            anyDirty = true;
        }
        if (!anyDirty) {
            return;
        }
        this.rebuildComposite();
        if (this.compositeImage != null && (abstractTexture = Minecraft.getInstance().getTextureManager().getTexture(this.getImageLocation())) instanceof DynamicTexture) {
            DynamicTexture dynamicTexture = (DynamicTexture)abstractTexture;
            dynamicTexture.setPixels(PaintSystem.convertToNativeImage(this.compositeImage));
            dynamicTexture.upload();
        }
        if (this.updateToServer) {
            this.updateToServer = false;
            PaintData paintData = this.toPaintData();
            HexereiPacketHandler.sendToServer(new PaintDataToServer(paintData));
        }
    }

    public int pickColor(Layer layer, int x, int y) {
        if (layer == null || layer.pixels == null) {
            return 0;
        }
        int width = layer.pixels.getWidth();
        int height = layer.pixels.getHeight();
        if (x >= 0 && x < width && y >= 0 && y < height) {
            return layer.pixels.getRGB(x, y);
        }
        return 0;
    }

    public void floodFill(Layer layer, int x, int y, int newColor, float tolerance) {
        this.startStroke(this.activeLayer.pixels.getWidth(), this.activeLayer.pixels.getHeight(), Brush.Type.DRAW);
        if (layer == null || layer.pixels == null) {
            return;
        }
        int width = layer.pixels.getWidth();
        int height = layer.pixels.getHeight();
        if (x < 0 || x >= width || y < 0 || y >= height) {
            return;
        }
        int targetColor = layer.pixels.getRGB(x, y);
        float[] targetHSV = this.rgbToHsv(targetColor);
        if (!this.brush.getGlobal()) {
            Stack<Point> stack = new Stack<Point>();
            stack.push(new Point(x, y));
            boolean[][] visited = new boolean[width][height];
            while (!stack.isEmpty()) {
                Point p = (Point)stack.pop();
                int px = p.x;
                int py = p.y;
                if (!this.selection.isEmpty() && (!this.selection.bounds.contains(px, py) || (this.selection.mask.getRGB(px - this.selection.bounds.x, py - this.selection.bounds.y) >> 24 & 0xFF) == 0) || px < 0 || px >= width || py < 0 || py >= height || visited[px][py]) continue;
                visited[px][py] = true;
                int currentColor = layer.pixels.getRGB(px, py);
                float[] currentHSV = this.rgbToHsv(currentColor);
                int alpha = currentColor >> 24 & 0xFF;
                int targetAlpha = targetColor >> 24 & 0xFF;
                float difference = this.calculateColorDifference(targetHSV, currentHSV);
                if ((alpha != 0 || targetAlpha != 0) && !(difference <= tolerance)) continue;
                this.strokeMask.setRGB(px, py, newColor);
                if (px > 0) {
                    stack.push(new Point(px - 1, py));
                }
                if (px < width - 1) {
                    stack.push(new Point(px + 1, py));
                }
                if (py > 0) {
                    stack.push(new Point(px, py - 1));
                }
                if (py >= height - 1) continue;
                stack.push(new Point(px, py + 1));
            }
        } else {
            for (int px = 0; px < layer.pixels.getWidth(); ++px) {
                for (int py = 0; py < layer.pixels.getHeight(); ++py) {
                    if (!this.selection.isEmpty() && (!this.selection.bounds.contains(px, py) || (this.selection.mask.getRGB(px - this.selection.bounds.x, py - this.selection.bounds.y) >> 24 & 0xFF) == 0)) continue;
                    int currentColor = layer.pixels.getRGB(px, py);
                    float[] currentHSV = this.rgbToHsv(currentColor);
                    int alpha = currentColor >> 24 & 0xFF;
                    int targetAlpha = targetColor >> 24 & 0xFF;
                    float difference = this.calculateColorDifference(targetHSV, currentHSV);
                    if ((alpha != 0 || targetAlpha != 0) && !(difference <= tolerance)) continue;
                    this.strokeMask.setRGB(px, py, newColor);
                }
            }
        }
        this.endStroke();
        layer.dirty = true;
    }

    private float[] rgbToHsv(int rgb) {
        float s;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int a = rgb >> 24 & 0xFF;
        float rNorm = (float)r / 255.0f;
        float gNorm = (float)g / 255.0f;
        float bNorm = (float)b / 255.0f;
        float aNorm = (float)a / 255.0f;
        float max = Math.max(rNorm, Math.max(gNorm, bNorm));
        float min = Math.min(rNorm, Math.min(gNorm, bNorm));
        float delta = max - min;
        float h = 0.0f;
        float v = max;
        if (delta != 0.0f) {
            s = delta / max;
            h = rNorm == max ? (gNorm - bNorm) / delta : (gNorm == max ? 2.0f + (bNorm - rNorm) / delta : 4.0f + (rNorm - gNorm) / delta);
            if ((h *= 60.0f) < 0.0f) {
                h += 360.0f;
            }
        } else {
            s = 0.0f;
            h = -1.0f;
        }
        return new float[]{h, s, v, aNorm};
    }

    private float calculateColorDifference(float[] hsv1, float[] hsv2) {
        float dh = Math.abs(hsv1[0] - hsv2[0]);
        if (dh > 180.0f) {
            dh = 360.0f - dh;
        }
        dh /= 360.0f;
        float alphaAvg = (hsv1[3] + hsv2[3]) / 2.0f;
        dh *= alphaAvg;
        float ds = Math.abs(hsv1[1] - hsv2[1]);
        float dv = Math.abs(hsv1[2] - hsv2[2]);
        float da = Math.abs(hsv1[3] - hsv2[3]);
        float weightH = 0.55f * alphaAvg;
        float weightS = 0.25f * alphaAvg;
        float weightV = 0.25f * alphaAvg;
        float weightA = 0.3f;
        float diff = (float)Math.sqrt(weightH * dh * dh + weightS * ds * ds + weightV * dv * dv + weightA * da * da);
        return diff;
    }

    private void startMoveSelection(int x, int y) {
        SelectionAndDrawAction selAction = new SelectionAndDrawAction(this.activeLayer, this.selection);
        this.actionManager.beginAction(selAction);
        this.movingSelection = this.copySelection();
        this.movingSelectionClickedPos = new Pos2i(x - this.selection.bounds.x, y - this.selection.bounds.y);
        this.movingSelectionOffset = new Pos2i(x - this.movingSelectionClickedPos.x, y - this.movingSelectionClickedPos.y);
        this.selection.deleteFromLayer(this.activeLayer);
        this.activeLayer.dirty = true;
    }

    private void updateMoveSelection(int x, int y) {
        this.movingSelectionOffset = new Pos2i(x - this.movingSelectionClickedPos.x, y - this.movingSelectionClickedPos.y);
        this.selection.bounds.x = this.movingSelectionOffset.x;
        this.selection.bounds.y = this.movingSelectionOffset.y;
    }

    private void endMoveSelection() {
        if (this.movingSelection == null) {
            return;
        }
        Graphics2D g2d = this.activeLayer.pixels.createGraphics();
        this.deleteSelection();
        g2d.drawImage((Image)this.movingSelection, this.movingSelectionOffset.x, this.movingSelectionOffset.y, null);
        g2d.dispose();
        this.movingSelection = null;
        this.activeLayer.dirty = true;
        int oldX = this.movingSelectionOffset.x;
        int oldY = this.movingSelectionOffset.y;
        int layerWidth = this.activeLayer.pixels.getWidth();
        int layerHeight = this.activeLayer.pixels.getHeight();
        int newX = Math.max(oldX, 0);
        int newY = Math.max(oldY, 0);
        int newWidth = Math.max(0, Math.min(this.selection.bounds.width, layerWidth - newX));
        int newHeight = Math.max(0, Math.min(this.selection.bounds.height, layerHeight - newY));
        if (newWidth == 0 || newHeight == 0) {
            this.selection.clear();
        } else {
            this.selection.bounds = new Rectangle(newX, newY, newWidth, newHeight);
            if (this.selection.mask != null) {
                int offsetX = newX - oldX;
                int offsetY = newY - oldY;
                BufferedImage newMask = new BufferedImage(newWidth, newHeight, 2);
                Graphics2D g = newMask.createGraphics();
                g.drawImage(this.selection.mask, 0, 0, newWidth, newHeight, offsetX, offsetY, offsetX + newWidth, offsetY + newHeight, null);
                g.dispose();
                this.selection.mask = newMask;
                this.selection.cropMaskToSelection();
                this.selection.edgePoints = this.selection.orderEdgePoints(this.selection.findEdgePoints(this.selection.mask).stream().toList());
            }
        }
        Action action = this.actionManager.currentAction;
        if (action instanceof SelectionAndDrawAction) {
            SelectionAndDrawAction selectionAndDrawAction = (SelectionAndDrawAction)action;
            selectionAndDrawAction.captureAfter(this.selection);
            this.actionManager.commitAction();
        }
        this.updateToServer = true;
    }

    public void startSelection(int x, int y) {
        this.selection.cursorX = x;
        this.selection.cursorY = y;
        this.selection.cursorXOld = x;
        this.selection.cursorYOld = y;
        this.selection.adjustingSelection = true;
        this.selection.initializeBounds(x, y);
        this.selection.clearMask();
        this.selection.anchor = new Pos2i(Math.clamp((long)x, 0, this.activeLayer.pixels.getWidth()), Math.clamp((long)y, 0, this.activeLayer.pixels.getHeight()));
        this.selection.updateEdgePoints();
        this.dirty = true;
    }

    public void updateSelection(int x, int y) {
        Rectangle newBounds;
        this.selection.bounds = newBounds = this.selection.getUpdateRectangleBounds(this.selection.anchor, new Pos2i(Math.clamp((long)x, 0, this.activeLayer.pixels.getWidth() - 1), Math.clamp((long)y, 0, this.activeLayer.pixels.getHeight() - 1)));
        if (this.selection.bounds.getWidth() > 1.0 || this.selection.bounds.getHeight() > 1.0) {
            this.selection.createRectangleMask();
        } else {
            this.selection.setSelectionMask(null);
        }
    }

    public void endSelection(int x, int y) {
        if (this.selection.adjustingSelection) {
            this.selection.adjustingSelection = false;
            this.updateSelection(x, y);
            if (this.activeLayer != null && this.activeLayer.pixels != null) {
                if (this.selection.bounds.getWidth() > 1.0 || this.selection.bounds.getHeight() > 1.0) {
                    this.selection.createRectangleMask();
                } else {
                    this.selection.setSelectionMask(null);
                }
            }
            this.dirty = true;
        }
        if (this.selection.getType() == Selection.Type.ADD) {
            if (this.initialSelectionMask != null) {
                combinedBounds = this.selection.isEmpty() ? this.initialSelectionBounds : (Rectangle)this.selection.bounds.createUnion(this.initialSelectionBounds);
                BufferedImage combinedMask = new BufferedImage(combinedBounds.width, combinedBounds.height, 2);
                Graphics2D g = combinedMask.createGraphics();
                if (this.selection.mask != null) {
                    g.drawImage(this.selection.mask, this.selection.bounds.x - combinedBounds.x, this.selection.bounds.y - combinedBounds.y, this.selection.mask.getWidth(), this.selection.mask.getHeight(), null);
                }
                if (this.initialSelectionMask != null) {
                    g.drawImage(this.initialSelectionMask, this.initialSelectionBounds.x - combinedBounds.x, this.initialSelectionBounds.y - combinedBounds.y, this.initialSelectionMask.getWidth(), this.initialSelectionMask.getHeight(), null);
                }
                g.dispose();
                this.selection.bounds = combinedBounds;
                this.selection.setSelectionMask(combinedMask);
                this.selection.cropMaskToSelection();
            }
        } else if (this.selection.getType() == Selection.Type.REMOVE) {
            if (this.initialSelectionMask == null) {
                this.selection.clear();
                return;
            }
            combinedBounds = this.selection.isEmpty() ? this.initialSelectionBounds : (Rectangle)this.selection.bounds.createUnion(this.initialSelectionBounds);
            BufferedImage combinedMask = new BufferedImage(combinedBounds.width, combinedBounds.height, 2);
            Graphics2D g = combinedMask.createGraphics();
            if (this.initialSelectionMask != null) {
                g.drawImage(this.initialSelectionMask, this.initialSelectionBounds.x - combinedBounds.x, this.initialSelectionBounds.y - combinedBounds.y, this.initialSelectionMask.getWidth(), this.initialSelectionMask.getHeight(), null);
            }
            for (int y1 = 0; y1 < this.selection.bounds.height; ++y1) {
                for (int x1 = 0; x1 < this.selection.bounds.width; ++x1) {
                    int maskAlpha;
                    int globalX = this.selection.bounds.x + x1;
                    int globalY = this.selection.bounds.y + y1;
                    if (globalX < 0 || globalX >= this.width || globalY < 0 || globalY >= this.height || x1 < 0 || x1 >= this.selection.mask.getWidth() || y1 < 0 || y1 >= this.selection.mask.getHeight() || globalX - combinedBounds.x < 0 || globalX - combinedBounds.x >= combinedBounds.width || globalY - combinedBounds.y < 0 || globalY - combinedBounds.y >= combinedBounds.height || (maskAlpha = this.selection.mask.getRGB(x1, y1) >> 24 & 0xFF) <= 0) continue;
                    combinedMask.setRGB(globalX - combinedBounds.x, globalY - combinedBounds.y, 0);
                }
            }
            g.dispose();
            this.selection.bounds = combinedBounds;
            this.selection.setSelectionMask(combinedMask);
        }
        if (this.initialSelectionMask == null && this.selection.mask == null) {
            return;
        }
        SelectionAction selAction = new SelectionAction(this.initialSelectionBounds, this.initialSelectionMask, this.selection.bounds, this.selection.mask);
        this.actionManager.beginAction(selAction);
        this.actionManager.commitAction();
    }

    public BufferedImage copySelection() {
        if (this.activeLayer == null || this.selection.isEmpty()) {
            return null;
        }
        return this.selection.extractSelectedArea(this.activeLayer);
    }

    public boolean canCopy() {
        return this.selection.bounds != null && this.selection.mask != null;
    }

    public void copySelectionToClipboard() {
        if (!this.canCopy()) {
            return;
        }
        clipboardImage = this.copySelection();
        clipboardBounds = new Rectangle(this.selection.bounds);
        clipboardMask = PaintSystem.deepCopy(this.selection.mask);
    }

    public void cutSelectionToClipboard() {
        if (!this.canCopy()) {
            return;
        }
        SelectionAndDrawAction action = new SelectionAndDrawAction(this.activeLayer, this.selection);
        this.actionManager.beginAction(action);
        this.copySelectionToClipboard();
        this.deleteSelection();
        this.selection.clear();
        this.activeLayer.dirty = true;
        action.captureAfter(this.selection);
        this.actionManager.commitAction();
        this.updateToServer = true;
    }

    public void pasteClipboard() {
        if (clipboardImage == null || clipboardBounds == null || clipboardMask == null) {
            return;
        }
        if (this.movingSelection != null) {
            this.endMoveSelection();
        }
        SelectionAndDrawAction action = new SelectionAndDrawAction(this.activeLayer, this.selection);
        this.actionManager.beginAction(action);
        this.movingSelection = PaintSystem.deepCopy(clipboardImage);
        this.selection.mask = PaintSystem.deepCopy(clipboardMask);
        this.selection.bounds = clipboardBounds == null ? null : new Rectangle(clipboardBounds);
        this.selection.updateEdgePoints();
        this.movingSelectionClickedPos = new Pos2i(this.movingSelection.getWidth() / 2, this.movingSelection.getHeight() / 2);
        this.movingSelectionOffset = new Pos2i((int)this.cursorX - this.movingSelectionClickedPos.x, (int)this.cursorY - this.movingSelectionClickedPos.y);
        this.setCurrentTool(Tool.MOVE);
        this.updateMoveSelection((int)this.cursorX, (int)this.cursorY);
        this.skipNextRelease = true;
    }

    public void deleteSelection() {
        this.selection.deleteFromLayer(this.activeLayer);
    }

    public void startStroke(int width, int height, Brush.Type strokeType) {
        this.strokeType = strokeType;
        this.strokeMask = new BufferedImage(width, height, 2);
    }

    public void endStroke() {
        if (this.strokeMask == null || this.activeLayer == null) {
            return;
        }
        boolean changed = false;
        for (int y = 0; y < this.strokeMask.getHeight(); ++y) {
            block5: for (int x = 0; x < this.strokeMask.getWidth(); ++x) {
                switch (this.strokeType.ordinal()) {
                    case 1: {
                        int maskPixel = this.strokeMask.getRGB(x, y);
                        int maskA = maskPixel >> 24 & 0xFF;
                        int pixel = this.activeLayer.pixels.getRGB(x, y);
                        int destA = pixel >> 24 & 0xFF;
                        if (destA == 0 || maskA == 0) continue block5;
                        int newA = Math.max(0, destA - maskA);
                        int newPixel = newA << 24 | pixel & 0xFFFFFF;
                        this.activeLayer.pixels.setRGB(x, y, newPixel);
                        changed = true;
                        continue block5;
                    }
                    case 0: {
                        int maskPixel = this.strokeMask.getRGB(x, y);
                        int maskA = maskPixel >> 24 & 0xFF;
                        if (maskA <= 0) continue block5;
                        int layerPixel = this.activeLayer.pixels.getRGB(x, y);
                        if (this.activeLayer.blendMode != null) {
                            maskPixel = this.activeLayer.blendMode.apply(layerPixel, maskA, maskPixel >> 16 & 0xFF, maskPixel >> 8 & 0xFF, maskPixel & 0xFF);
                        }
                        this.activeLayer.pixels.setRGB(x, y, maskPixel);
                        changed = true;
                    }
                }
            }
        }
        this.strokeMask = null;
        this.activeLayer.dirty = true;
        if (changed) {
            this.updateToServer = true;
        }
        if (this.currentDrawAction != null) {
            this.currentDrawAction.captureAfter();
            if (changed) {
                this.actionManager.commitAction();
            }
            this.currentDrawAction = null;
        }
    }

    public static NativeImage convertToNativeImage(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        NativeImage nativeImage = new NativeImage(NativeImage.Format.RGBA, width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = bufferedImage.getRGB(x, y);
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb & 0xFF;
                int abgrColor = a << 24 | b << 16 | g << 8 | r;
                nativeImage.setPixelRGBA(x, y, abgrColor);
            }
        }
        return nativeImage;
    }

    public void addAndUpdateTexture() {
        this.rebuildComposite();
        DynamicTexture dynamicTexture = new DynamicTexture(PaintSystem.convertToNativeImage(this.compositeImage));
        Minecraft.getInstance().getTextureManager().register(this.getImageLocation(), (AbstractTexture)dynamicTexture);
    }

    public void rebuildComposite() {
        int y;
        if (this.layers.isEmpty()) {
            return;
        }
        int width = this.width;
        int height = this.height;
        this.compositeImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = this.compositeImage.createGraphics();
        for (Layer layer : this.layers) {
            int x;
            BufferedImage temp = new BufferedImage(width, height, 2);
            for (x = 0; x < width; ++x) {
                for (y = 0; y < height; ++y) {
                    int pixel = layer.pixels.getRGB(x, y);
                    int a = pixel >> 24 & 0xFF;
                    if (layer.opacity != 1.0f) {
                        a = (int)((float)a * layer.opacity);
                    }
                    if (layer == this.activeLayer && this.strokeMask != null && this.strokeType == Brush.Type.ERASE) {
                        int maskPixel = this.strokeMask.getRGB(x, y);
                        int maskA = maskPixel >> 24 & 0xFF;
                        int destA = pixel >> 24 & 0xFF;
                        if (a != 0 && maskA != 0) {
                            int newPixel;
                            int newA = Math.max(0, destA - maskA);
                            pixel = newPixel = newA << 24 | pixel & 0xFFFFFF;
                            a = newA;
                        }
                    }
                    int existing = this.compositeImage.getRGB(x, y);
                    if (layer.blendMode != null) {
                        pixel = layer.blendMode.apply(existing, a, pixel >> 16 & 0xFF, pixel >> 8 & 0xFF, pixel & 0xFF);
                    }
                    temp.setRGB(x, y, pixel);
                }
            }
            if (layer == this.activeLayer && this.movingSelection != null) {
                for (int y2 = 0; y2 < this.selection.bounds.height; ++y2) {
                    for (int x2 = 0; x2 < this.selection.bounds.width; ++x2) {
                        int maskAlpha;
                        int globalX = this.selection.bounds.x + x2;
                        int globalY = this.selection.bounds.y + y2;
                        if (globalX < 0 || globalX >= temp.getWidth() || globalY < 0 || globalY >= temp.getHeight() || x2 >= this.selection.mask.getWidth() || y2 >= this.selection.mask.getHeight() || (maskAlpha = this.selection.mask.getRGB(x2, y2) >> 24 & 0xFF) <= 0) continue;
                        temp.setRGB(globalX, globalY, 0);
                    }
                }
                Graphics2D g = temp.createGraphics();
                g.drawImage((Image)this.movingSelection, this.movingSelectionOffset.x, this.movingSelectionOffset.y, null);
            }
            g2d.drawImage((Image)temp, 0, 0, null);
            if (layer == this.activeLayer && this.strokeMask != null && this.brush.type == Brush.Type.DRAW) {
                for (x = 0; x < width; ++x) {
                    for (y = 0; y < height; ++y) {
                        int maskPixel = this.strokeMask.getRGB(x, y);
                        int maskA = maskPixel >> 24 & 0xFF;
                        if (maskA <= 0) continue;
                        int existingPixel = this.compositeImage.getRGB(x, y);
                        if (layer.blendMode != null) {
                            maskPixel = layer.blendMode.apply(existingPixel, maskA, maskPixel >> 16 & 0xFF, maskPixel >> 8 & 0xFF, maskPixel & 0xFF);
                        }
                        this.compositeImage.setRGB(x, y, maskPixel);
                    }
                }
            }
            layer.dirty = false;
        }
        if (this.selection != null && this.toolsVisible) {
            this.selection.render(g2d);
        }
        if (currentTool.shouldShowBrushSliders() && this.toolsVisible) {
            int diameter = Brush.size + 1;
            int drawX = (int)(this.cursorX - (float)diameter / 2.0f + 0.5f);
            int drawY = (int)(this.cursorY - (float)diameter / 2.0f + 0.5f);
            BufferedImage brushImage = this.brush.generateBrushMask(true);
            brushImage = this.adjustImage(brushImage, 0.35f, Color.GRAY);
            if (this.selection.mask != null) {
                for (y = 0; y < brushImage.getWidth(); ++y) {
                    for (int x = 0; x < brushImage.getHeight(); ++x) {
                        int globalX = drawX + x;
                        int globalY = drawY + y;
                        if (globalX - this.selection.bounds.x >= 0 && globalX - this.selection.bounds.x < this.selection.mask.getWidth() && globalY - this.selection.bounds.y >= 0 && globalY - this.selection.bounds.y < this.selection.mask.getHeight() && globalX >= this.selection.bounds.x && globalX < this.selection.mask.getWidth() + this.selection.bounds.x && globalY >= this.selection.bounds.y && globalY < this.selection.mask.getHeight() + this.selection.bounds.y) {
                            int maskAlpha = this.selection.mask.getRGB(globalX - this.selection.bounds.x, globalY - this.selection.bounds.y) >> 24 & 0xFF;
                            if (maskAlpha != 0) continue;
                            brushImage.setRGB(x, y, 0);
                            continue;
                        }
                        brushImage.setRGB(x, y, 0);
                    }
                }
            }
            g2d.drawImage((Image)brushImage, drawX, drawY, null);
        }
        g2d.dispose();
    }

    public BufferedImage adjustImage(BufferedImage image, float alphaFactor, Color newColor) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = image.getRGB(x, y);
                int origAlpha = pixel >> 24 & 0xFF;
                int newAlpha = (int)((float)origAlpha * alphaFactor);
                int r = newColor.getRed();
                int g = newColor.getGreen();
                int b = newColor.getBlue();
                int outPixel = newAlpha << 24 | r << 16 | g << 8 | b;
                result.setRGB(x, y, outPixel);
            }
        }
        return result;
    }

    public void addLayer(int width, int height) {
        Layer layer = new Layer();
        layer.pixels = new BufferedImage(width, height, 2);
        this.layers.add(layer);
        if (this.activeLayer == null) {
            this.activeLayer = layer;
        }
    }

    public void addLayer(Layer layer) {
        this.layers.add(layer);
        if (this.activeLayer == null) {
            this.activeLayer = layer;
        }
    }

    public void setActiveLayer(int index) {
        if (index >= 0 && index < this.layers.size()) {
            this.activeLayer = this.layers.get(index);
        }
    }

    public void endDrawing() {
        if (this.strokeMask != null) {
            this.endStroke();
        }
    }

    public void draw(float lastX, float lastY, float x, float y) {
        if (this.activeLayer == null || this.brush == null) {
            return;
        }
        if (this.strokeMask == null) {
            this.startStroke(this.activeLayer.pixels.getWidth(), this.activeLayer.pixels.getHeight(), this.brush.type);
        }
        this.drawLine(lastX, lastY, x, y);
        this.activeLayer.dirty = true;
    }

    private void drawLine(float x0, float y0, float x1, float y1) {
        float currentX = x0;
        float currentY = y0;
        int targetX = (int)Math.ceil(x1);
        int targetY = (int)Math.ceil(y1);
        int lastX = (int)Math.ceil(currentX);
        int lastY = (int)Math.ceil(currentY);
        this.brush.apply(currentX, currentY);
        this.brush.apply(x1, y1);
        double dx = (double)targetX - Math.ceil(currentX);
        double dy = (double)targetY - Math.ceil(currentY);
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (distance == 0.0) {
            return;
        }
        float stepX = (float)dx / (float)distance;
        float stepY = (float)dy / (float)distance;
        int i = 0;
        while (!(Math.ceil(currentX) == (double)targetX && Math.ceil(currentY) == (double)targetY || (double)((float)(++i) + 0.5f) > distance)) {
            int newX = (int)(currentX += stepX);
            int newY = (int)(currentY += stepY);
            if (newX == lastX && newY == lastY) continue;
            this.brush.apply(newX, newY);
            lastX = newX;
            lastY = newY;
        }
    }

    public void setToolsVisible(boolean toolsVisible) {
        if (this.toolsVisible != toolsVisible) {
            this.toolsVisible = toolsVisible;
            this.dirty = true;
        }
    }

    public BufferedImage getMovingSelection() {
        return this.movingSelection;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public Layer getActiveLayer() {
        return this.activeLayer;
    }

    public void setActiveLayer(Layer activeLayer) {
        this.activeLayer = activeLayer;
    }

    public Brush getBrush() {
        return this.brush;
    }

    public Colors getColors() {
        return colors;
    }

    static {
        colors = new Colors(List.of());
        currentTool = Tool.BRUSH;
    }

    public static class Pos2i {
        public final int x;
        public final int y;

        Pos2i(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    public static enum Tool {
        BRUSH("Brush"),
        ERASER("Eraser"),
        SELECTION("Selection"),
        MOVE("Move"),
        FILL("Fill"),
        EYEDROPPER("Eyedropper"),
        MAGIC_WAND("Magic Wand");

        private final String name;

        private Tool(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean shouldShowColorSliders() {
            return this == BRUSH || this == ERASER || this == EYEDROPPER || this == FILL;
        }

        public boolean shouldShowBrushSliders() {
            return this == BRUSH || this == ERASER;
        }

        public boolean shouldShowToleranceSliders() {
            return this == FILL || this == MAGIC_WAND;
        }

        public boolean shouldSelectionShowMask() {
            return this != BRUSH && this != ERASER && this != EYEDROPPER && this != FILL;
        }
    }

    public class DrawAction
    implements Action {
        private Layer layer;
        private int index;
        private BufferedImage beforeImage;
        private BufferedImage afterImage;

        public DrawAction(Layer layer, BufferedImage beforeImage) {
            this.layer = layer;
            this.index = PaintSystem.this.getLayers().indexOf(layer);
            this.beforeImage = PaintSystem.deepCopy(beforeImage);
        }

        public void captureAfter() {
            this.afterImage = PaintSystem.deepCopy(this.layer.pixels.getSubimage(0, 0, this.layer.pixels.getWidth(), this.layer.pixels.getHeight()));
        }

        @Override
        public void undo() {
            Layer layer = PaintSystem.this.getLayers().get(this.index);
            layer.pixels = PaintSystem.deepCopy(this.beforeImage);
            layer.dirty = true;
            PaintSystem.this.updateToServer = true;
        }

        @Override
        public void redo() {
            Layer layer = PaintSystem.this.getLayers().get(this.index);
            layer.pixels = PaintSystem.deepCopy(this.afterImage);
            layer.dirty = true;
            PaintSystem.this.updateToServer = true;
        }
    }

    public class ActionManager {
        private final Stack<Action> undoStack = new Stack();
        private final Stack<Action> redoStack = new Stack();
        private static final int MAX_SIZE = 30;
        private Action currentAction = null;

        public void beginAction(Action action) {
            this.currentAction = action;
        }

        public void commitAction() {
            if (this.currentAction != null) {
                this.undoStack.push(this.currentAction);
                if (this.undoStack.size() > 30) {
                    this.undoStack.removeFirst();
                }
                this.redoStack.clear();
                this.currentAction = null;
            }
        }

        public void undo() {
            if (!this.undoStack.isEmpty()) {
                Action action = this.undoStack.pop();
                action.undo();
                this.redoStack.push(action);
            }
            PaintSystem.this.activeLayer.dirty = true;
        }

        public void redo() {
            if (!this.redoStack.isEmpty()) {
                Action action = this.redoStack.pop();
                action.redo();
                this.undoStack.push(action);
            }
            PaintSystem.this.activeLayer.dirty = true;
        }
    }

    public static class Brush {
        public PaintSystem parent;
        public Type type = Type.DRAW;
        public static int size = 5;
        public static float hardness = 1.0f;
        public static float tolerance = 0.0f;
        public float cursorX = 0.0f;
        public float cursorY = 0.0f;
        public float cursorXOld = 0.0f;
        public float cursorYOld = 0.0f;
        public boolean drawing = false;
        public static boolean global = false;

        public Brush(PaintSystem parent) {
            this.parent = parent;
        }

        public void apply(float x, float y) {
            this.applyBrushMask(this.parent.strokeMask, x, y);
        }

        private BufferedImage generateBrushMask() {
            return this.generateBrushMask(false);
        }

        private BufferedImage generateBrushMask(boolean ignoreColorAlpha) {
            float centerX;
            int diameter = size + 1;
            BufferedImage brushImage = new BufferedImage(diameter, diameter, 2);
            int color = this.parent.getColor();
            float radius = (float)diameter / 2.0f;
            float centerY = centerX = (float)(diameter - 1) / 2.0f;
            float innerRadius = hardness * radius;
            for (int x = 0; x < diameter; ++x) {
                for (int y = 0; y < diameter; ++y) {
                    float dx = (float)x - centerX;
                    float dy = (float)y - centerY;
                    float distance = (float)Math.sqrt(dx * dx + dy * dy);
                    int alpha = (int)((float)this.calculateAlpha(distance, radius, innerRadius) / 255.0f * (float)(ignoreColorAlpha ? 255 : color >> 24 & 0xFF));
                    brushImage.setRGB(x, y, alpha << 24 | color & 0xFFFFFF);
                }
            }
            return brushImage;
        }

        private int calculateAlpha(float distance, float radius, float innerRadius) {
            if (distance <= innerRadius) {
                return 255;
            }
            if (distance <= radius) {
                float t = (distance - innerRadius) / (radius - innerRadius);
                return (int)(255.0f * (1.0f - t));
            }
            return 0;
        }

        private void applyBrushMask(BufferedImage strokeMask, float x, float y) {
            int diameter = size + 1;
            BufferedImage brushImage = this.generateBrushMask();
            int drawX = (int)(x - (float)diameter / 2.0f + 0.5f);
            int drawY = (int)(y - (float)diameter / 2.0f + 0.5f);
            for (int bx = 0; bx < brushImage.getWidth(); ++bx) {
                for (int by = 0; by < brushImage.getHeight(); ++by) {
                    int strokePixel;
                    int strokeAlpha;
                    int brushPixel;
                    int brushAlpha;
                    int sx = drawX + bx;
                    int sy = drawY + by;
                    if (sx < 0 || sx >= strokeMask.getWidth() || sy < 0 || sy >= strokeMask.getHeight()) continue;
                    if (this.parent.selection.mask != null) {
                        int posX = sx - this.parent.selection.bounds.x;
                        int posY = sy - this.parent.selection.bounds.y;
                        if (posX >= this.parent.selection.mask.getWidth() || posY >= this.parent.selection.mask.getHeight() || posX < 0 || posY < 0 || (this.parent.selection.mask.getRGB(posX, posY) >> 24 & 0xFF) == 0) continue;
                    }
                    if ((brushAlpha = (brushPixel = brushImage.getRGB(bx, by)) >>> 24) <= (strokeAlpha = (strokePixel = strokeMask.getRGB(sx, sy)) >>> 24)) continue;
                    strokeMask.setRGB(sx, sy, brushPixel);
                }
            }
        }

        public void setGlobal(boolean global) {
            Brush.global = global;
        }

        public boolean getGlobal() {
            return global;
        }

        public static enum Type {
            DRAW,
            ERASE;

        }
    }

    class Selection {
        private Rectangle bounds;
        private BufferedImage mask;
        public Pos2i anchor;
        public boolean adjustingSelection;
        private PaintSystem parent;
        List<Point> edgePoints = new ArrayList<Point>();
        public int cursorX = 0;
        public int cursorY = 0;
        public int cursorXOld = 0;
        public int cursorYOld = 0;
        public static Type type = Type.REPLACE;
        public static boolean global = false;

        public Selection(PaintSystem parent) {
            this.parent = parent;
            this.bounds = new Rectangle(0, 0, 0, 0);
            this.mask = null;
            this.anchor = new Pos2i(0, 0);
            this.adjustingSelection = false;
        }

        public void setType(Type type) {
            Selection.type = type;
        }

        public Type getType() {
            return type;
        }

        public void setGlobal(boolean global) {
            Selection.global = global;
        }

        public boolean getGlobal() {
            return global;
        }

        public BufferedImage getMask() {
            return this.mask;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public boolean isEmpty() {
            if (this.adjustingSelection) {
                switch (PaintSystem.this.selection.getType().ordinal()) {
                    case 0: {
                        return this.mask == null || this.bounds.width == 1 && this.bounds.height == 1;
                    }
                    case 1: 
                    case 2: {
                        return (this.mask == null || this.bounds.width == 1 && this.bounds.height == 1) && (PaintSystem.this.initialSelectionMask == null || PaintSystem.this.initialSelectionBounds.width == 1 && PaintSystem.this.initialSelectionBounds.height == 1);
                    }
                }
            }
            return this.mask == null || this.bounds.width == 1 && this.bounds.height == 1;
        }

        public void setBoundsByOffset(int x, int y) {
            this.bounds.setBounds(x, y, this.bounds.width, this.bounds.height);
        }

        public void updateBoundsAfterMove(Pos2i offset) {
            this.bounds.setLocation(offset.x, offset.y);
        }

        public void initializeBounds(int x, int y) {
            this.bounds = new Rectangle(x, y, 0, 0);
        }

        public Rectangle getUpdateRectangleBounds(Pos2i start, Pos2i end) {
            int x1 = Math.min(start.x, end.x);
            int y1 = Math.min(start.y, end.y);
            int width = Math.abs(end.x - start.x) + 1;
            int height = Math.abs(end.y - start.y) + 1;
            return new Rectangle(x1, y1, width, height);
        }

        public void clearMask() {
            this.mask = null;
            this.edgePoints.clear();
        }

        public void createRectangleMask() {
            BufferedImage mask = new BufferedImage(this.bounds.width, this.bounds.height, 2);
            Graphics2D g2d = mask.createGraphics();
            g2d.setColor(new Color(0, 0, 0, 255));
            g2d.fillRect(0, 0, this.bounds.width, this.bounds.height);
            g2d.dispose();
            this.setSelectionMask(mask);
        }

        public void clear() {
            this.clearMask();
            this.bounds.setBounds(0, 0, 0, 0);
        }

        public void deselect() {
            PaintSystem.this.initialSelectionBounds = new Rectangle(PaintSystem.this.selection.bounds);
            PaintSystem.this.initialSelectionMask = PaintSystem.this.selection.mask != null ? PaintSystem.deepCopy(PaintSystem.this.selection.mask) : null;
            this.clearMask();
            this.bounds.setBounds(0, 0, 0, 0);
            SelectionAction action = new SelectionAction(PaintSystem.this.initialSelectionBounds, PaintSystem.this.initialSelectionMask, PaintSystem.this.selection.bounds, PaintSystem.this.selection.mask);
            PaintSystem.this.actionManager.beginAction(action);
            PaintSystem.this.actionManager.commitAction();
            PaintSystem.this.dirty = true;
        }

        public void updateEdgePoints() {
            Rectangle bounds = this.bounds;
            BufferedImage mask = this.mask;
            if (PaintSystem.this.selection.getType() == Type.ADD && PaintSystem.this.selection.adjustingSelection) {
                if (PaintSystem.this.initialSelectionMask == null && mask == null) {
                    return;
                }
                Rectangle combinedBounds = PaintSystem.this.selection.isEmpty() ? PaintSystem.this.initialSelectionBounds : (Rectangle)PaintSystem.this.selection.bounds.createUnion(PaintSystem.this.initialSelectionBounds);
                BufferedImage combinedMask = new BufferedImage(combinedBounds.width, combinedBounds.height, 2);
                Graphics2D g = combinedMask.createGraphics();
                if (mask != null) {
                    g.drawImage(PaintSystem.this.selection.mask, PaintSystem.this.selection.bounds.x - combinedBounds.x, PaintSystem.this.selection.bounds.y - combinedBounds.y, PaintSystem.this.selection.mask.getWidth(), PaintSystem.this.selection.mask.getHeight(), null);
                }
                if (PaintSystem.this.initialSelectionMask != null) {
                    g.drawImage(PaintSystem.this.initialSelectionMask, PaintSystem.this.initialSelectionBounds.x - combinedBounds.x, PaintSystem.this.initialSelectionBounds.y - combinedBounds.y, PaintSystem.this.initialSelectionMask.getWidth(), PaintSystem.this.initialSelectionMask.getHeight(), null);
                }
                g.dispose();
                bounds = combinedBounds;
                mask = combinedMask;
            } else if (PaintSystem.this.selection.getType() == Type.REMOVE && PaintSystem.this.selection.adjustingSelection) {
                if (PaintSystem.this.initialSelectionMask == null && mask == null) {
                    return;
                }
                Rectangle combinedBounds = PaintSystem.this.selection.isEmpty() ? PaintSystem.this.initialSelectionBounds : (Rectangle)PaintSystem.this.selection.bounds.createUnion(PaintSystem.this.initialSelectionBounds);
                BufferedImage combinedMask = new BufferedImage(combinedBounds.width, combinedBounds.height, 2);
                Graphics2D g = combinedMask.createGraphics();
                if (PaintSystem.this.initialSelectionMask != null) {
                    g.drawImage(PaintSystem.this.initialSelectionMask, PaintSystem.this.initialSelectionBounds.x - combinedBounds.x, PaintSystem.this.initialSelectionBounds.y - combinedBounds.y, PaintSystem.this.initialSelectionMask.getWidth(), PaintSystem.this.initialSelectionMask.getHeight(), null);
                }
                for (int y = 0; y < bounds.height; ++y) {
                    for (int x = 0; x < bounds.width; ++x) {
                        int maskAlpha;
                        int globalX = bounds.x + x;
                        int globalY = bounds.y + y;
                        if (globalX < 0 || globalX >= PaintSystem.this.width || globalY < 0 || globalY >= PaintSystem.this.height || x < 0 || x >= mask.getWidth() || y < 0 || y >= mask.getHeight() || (maskAlpha = mask.getRGB(x, y) >> 24 & 0xFF) <= 0) continue;
                        combinedMask.setRGB(globalX - combinedBounds.x, globalY - combinedBounds.y, 0);
                    }
                }
                g.dispose();
                bounds = combinedBounds;
                mask = combinedMask;
            }
            if (mask == null) {
                return;
            }
            this.edgePoints = this.orderEdgePoints(this.findEdgePoints(mask).stream().toList());
        }

        public void setSelectionMask(BufferedImage mask) {
            this.mask = mask;
            if (mask != null) {
                this.cropMaskToSelection();
            } else {
                this.clear();
                this.updateEdgePoints();
            }
        }

        public BufferedImage generateMagicWandMask(Layer layer, int x, int y, float tolerance, boolean global) {
            if (layer == null || layer.pixels == null) {
                return null;
            }
            int width = layer.pixels.getWidth();
            int height = layer.pixels.getHeight();
            if (x < 0 || x >= width || y < 0 || y >= height) {
                return null;
            }
            BufferedImage mask = new BufferedImage(width, height, 2);
            int targetColor = layer.pixels.getRGB(x, y);
            float[] targetHSV = PaintSystem.this.rgbToHsv(targetColor);
            if (global) {
                for (int py = 0; py < height; ++py) {
                    for (int px = 0; px < width; ++px) {
                        int currentColor = layer.pixels.getRGB(px, py);
                        int alpha = currentColor >> 24 & 0xFF;
                        int targetAlpha = targetColor >> 24 & 0xFF;
                        float difference = PaintSystem.this.calculateColorDifference(targetHSV, PaintSystem.this.rgbToHsv(currentColor));
                        if ((alpha != 0 || targetAlpha != 0) && !(difference <= tolerance)) continue;
                        mask.setRGB(px, py, -16777216);
                    }
                }
            } else {
                Stack<Point> stack = new Stack<Point>();
                boolean[][] visited = new boolean[width][height];
                stack.push(new Point(x, y));
                while (!stack.isEmpty()) {
                    Point p = (Point)stack.pop();
                    int px = p.x;
                    int py = p.y;
                    if (px < 0 || px >= width || py < 0 || py >= height || visited[px][py]) continue;
                    visited[px][py] = true;
                    int currentColor = layer.pixels.getRGB(px, py);
                    int alpha = currentColor >> 24 & 0xFF;
                    int targetAlpha = targetColor >> 24 & 0xFF;
                    float difference = PaintSystem.this.calculateColorDifference(targetHSV, PaintSystem.this.rgbToHsv(currentColor));
                    if ((alpha != 0 || targetAlpha != 0) && !(difference <= tolerance)) continue;
                    mask.setRGB(px, py, -16777216);
                    if (px > 0) {
                        stack.push(new Point(px - 1, py));
                    }
                    if (px < width - 1) {
                        stack.push(new Point(px + 1, py));
                    }
                    if (py > 0) {
                        stack.push(new Point(px, py - 1));
                    }
                    if (py >= height - 1) continue;
                    stack.push(new Point(px, py + 1));
                }
            }
            return mask;
        }

        public BufferedImage extractSelectedArea(Layer layer) {
            if (this.isEmpty() || layer == null || layer.pixels == null || this.mask == null) {
                return null;
            }
            BufferedImage selectedArea = new BufferedImage(this.bounds.width, this.bounds.height, 2);
            for (int y = 0; y < this.bounds.height; ++y) {
                for (int x = 0; x < this.bounds.width; ++x) {
                    int maskX = x;
                    int maskY = y;
                    int maskAlpha = this.mask.getRGB(maskX, maskY) >> 24 & 0xFF;
                    if (maskAlpha <= 0) continue;
                    int globalX = this.bounds.x + x;
                    int globalY = this.bounds.y + y;
                    if (globalX < 0 || globalX >= layer.pixels.getWidth() || globalY < 0 || globalY >= layer.pixels.getHeight()) continue;
                    int pixel = layer.pixels.getRGB(globalX, globalY);
                    selectedArea.setRGB(x, y, pixel);
                }
            }
            return selectedArea;
        }

        public void pasteToLayer(Layer layer, BufferedImage image) {
            if (layer == null || image == null) {
                return;
            }
            Graphics2D g2d = layer.pixels.createGraphics();
            g2d.drawImage((Image)image, this.bounds.x, this.bounds.y, null);
            g2d.dispose();
        }

        public void deleteFromLayer(Layer layer) {
            if (this.isEmpty() || layer == null || layer.pixels == null) {
                return;
            }
            for (int y = 0; y < this.bounds.height; ++y) {
                for (int x = 0; x < this.bounds.width; ++x) {
                    int maskAlpha;
                    int globalX = this.bounds.x + x;
                    int globalY = this.bounds.y + y;
                    if (globalX < 0 || globalX >= layer.pixels.getWidth() || globalY < 0 || globalY >= layer.pixels.getHeight() || x < 0 || x >= this.mask.getWidth() || y < 0 || y >= this.mask.getHeight() || (maskAlpha = this.mask.getRGB(x, y) >> 24 & 0xFF) <= 0) continue;
                    layer.pixels.setRGB(globalX, globalY, 0);
                }
            }
        }

        private void cropMaskToSelection() {
            if (this.mask == null) {
                this.clear();
                PaintSystem.this.dirty = true;
                return;
            }
            int minX = this.mask.getWidth();
            int minY = this.mask.getHeight();
            int maxX = 0;
            int maxY = 0;
            boolean empty = true;
            for (int y = 0; y < this.mask.getHeight(); ++y) {
                for (int x = 0; x < this.mask.getWidth(); ++x) {
                    int alpha;
                    if (this.bounds.x + x > PaintSystem.this.width || this.bounds.y + y > PaintSystem.this.height || (alpha = this.mask.getRGB(x, y) >> 24 & 0xFF) <= 0) continue;
                    empty = false;
                    if (x < minX) {
                        minX = x;
                    }
                    if (y < minY) {
                        minY = y;
                    }
                    if (x > maxX) {
                        maxX = x;
                    }
                    if (y <= maxY) continue;
                    maxY = y;
                }
            }
            if (minX <= maxX && minY <= maxY && !empty) {
                int width = maxX - minX + 1;
                int height = maxY - minY + 1;
                BufferedImage croppedMask = new BufferedImage(width, height, 2);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int pixel = this.mask.getRGB(minX + x, minY + y);
                        croppedMask.setRGB(x, y, pixel);
                    }
                }
                this.mask = croppedMask;
                this.bounds = new Rectangle(this.bounds.x + minX, this.bounds.y + minY, width, height);
            } else {
                this.clear();
                PaintSystem.this.dirty = true;
            }
            this.updateEdgePoints();
        }

        public void render(Graphics2D g2d) {
            Rectangle bounds = this.bounds;
            BufferedImage mask = this.mask;
            if (PaintSystem.this.selection.getType() == Type.REPLACE || !PaintSystem.this.selection.adjustingSelection) {
                if (mask == null) {
                    return;
                }
            } else if (PaintSystem.this.selection.getType() == Type.ADD) {
                if (PaintSystem.this.initialSelectionMask == null && mask == null) {
                    return;
                }
                combinedBounds = PaintSystem.this.selection.isEmpty() ? PaintSystem.this.initialSelectionBounds : (Rectangle)PaintSystem.this.selection.bounds.createUnion(PaintSystem.this.initialSelectionBounds);
                combinedMask = new BufferedImage(combinedBounds.width, combinedBounds.height, 2);
                g = combinedMask.createGraphics();
                if (mask != null) {
                    g.drawImage(PaintSystem.this.selection.mask, PaintSystem.this.selection.bounds.x - combinedBounds.x, PaintSystem.this.selection.bounds.y - combinedBounds.y, PaintSystem.this.selection.mask.getWidth(), PaintSystem.this.selection.mask.getHeight(), null);
                }
                if (PaintSystem.this.initialSelectionMask != null) {
                    g.drawImage(PaintSystem.this.initialSelectionMask, PaintSystem.this.initialSelectionBounds.x - combinedBounds.x, PaintSystem.this.initialSelectionBounds.y - combinedBounds.y, PaintSystem.this.initialSelectionMask.getWidth(), PaintSystem.this.initialSelectionMask.getHeight(), null);
                }
                g.dispose();
                bounds = combinedBounds;
                mask = combinedMask;
            } else if (PaintSystem.this.selection.getType() == Type.REMOVE) {
                if (PaintSystem.this.initialSelectionMask == null && mask == null) {
                    return;
                }
                combinedBounds = PaintSystem.this.selection.isEmpty() ? PaintSystem.this.initialSelectionBounds : (Rectangle)PaintSystem.this.selection.bounds.createUnion(PaintSystem.this.initialSelectionBounds);
                combinedMask = new BufferedImage(combinedBounds.width, combinedBounds.height, 2);
                g = combinedMask.createGraphics();
                if (PaintSystem.this.initialSelectionMask != null) {
                    g.drawImage(PaintSystem.this.initialSelectionMask, PaintSystem.this.initialSelectionBounds.x - combinedBounds.x, PaintSystem.this.initialSelectionBounds.y - combinedBounds.y, PaintSystem.this.initialSelectionMask.getWidth(), PaintSystem.this.initialSelectionMask.getHeight(), null);
                }
                for (int y = 0; y < bounds.height; ++y) {
                    for (int x = 0; x < bounds.width; ++x) {
                        int maskAlpha;
                        int globalX = bounds.x + x;
                        int globalY = bounds.y + y;
                        if (globalX < 0 || globalX >= PaintSystem.this.width || globalY < 0 || globalY >= PaintSystem.this.height || x < 0 || x >= mask.getWidth() || y < 0 || y >= mask.getHeight() || (maskAlpha = mask.getRGB(x, y) >> 24 & 0xFF) <= 0) continue;
                        Color tealTint = new Color(418317056, true);
                        g2d.setColor(tealTint);
                        g2d.fillRect(globalX, globalY, 1, 1);
                    }
                }
                g.dispose();
                bounds = combinedBounds;
                mask = combinedMask;
            }
            BufferedImage img = PaintSystem.deepCopy(mask);
            if (PaintSystem.this.getCurrentTool().shouldSelectionShowMask() && PaintSystem.this.movingSelection == null) {
                Color tealTint = new Color(811204590, true);
                for (int y = 0; y < img.getHeight(); ++y) {
                    for (int x = 0; x < img.getWidth(); ++x) {
                        int alpha = img.getRGB(x, y) >> 24 & 0xFF;
                        if (alpha <= 0) continue;
                        img.setRGB(x, y, tealTint.getRGB());
                    }
                }
                g2d.drawImage((Image)img, bounds.x, bounds.y, null);
            }
            this.renderDashedOutline(g2d, bounds);
        }

        private void renderDashedOutline(Graphics2D g2d, Rectangle bounds) {
            int dotLengthMAX = 5;
            int skipLengthMAX = 1;
            float clientTicks = ClientEvents.getClientTicks();
            for (int i = 0; i < this.edgePoints.size(); ++i) {
                if (((float)i + clientTicks * 0.5f) % (float)(dotLengthMAX + skipLengthMAX) > (float)(dotLengthMAX - 1)) continue;
                Point p = this.edgePoints.get(i);
                float hue = ((float)i / (float)this.edgePoints.size() + clientTicks * 0.01f) % 1.0f;
                int col = (PaintSystem.this.movingSelection != null || PaintSystem.this.getCurrentTool().shouldShowColorSliders() ? 48 : 128) << 24 | Color.getHSBColor(hue, 1.0f, 1.0f).getRGB() & 0xFFFFFF;
                Color color = new Color(col, true);
                g2d.setColor(color);
                int renderX = bounds.x + p.x;
                int renderY = bounds.y + p.y;
                g2d.fillRect(renderX, renderY, 1, 1);
            }
        }

        private List<Point> orderEdgePoints(List<Point> edgePoints) {
            List<Point> unvisited;
            if (edgePoints.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Point> orderedPoints = new ArrayList<Point>();
            HashSet<Point> visited = new HashSet<Point>();
            Point currentPoint = edgePoints.getFirst();
            orderedPoints.add(currentPoint);
            visited.add(currentPoint);
            while (orderedPoints.size() < edgePoints.size() && !(unvisited = edgePoints.stream().filter(p -> !visited.contains(p)).toList()).isEmpty()) {
                String prevDirection;
                double minDist = Double.MAX_VALUE;
                for (Point p2 : unvisited) {
                    double d = currentPoint.distance(p2);
                    if (!(d < minDist)) continue;
                    minDist = d;
                }
                Point finalCurrentPoint1 = currentPoint;
                double finalMinDist = minDist;
                List<Point> minDistPoints = unvisited.stream().filter(p -> finalCurrentPoint1.distance((Point2D)p) == finalMinDist).toList();
                if (orderedPoints.size() >= 2) {
                    Point prevPrev = (Point)orderedPoints.get(orderedPoints.size() - 2);
                    Point prev = (Point)orderedPoints.getLast();
                    int dx = prev.x - prevPrev.x;
                    int dy = prev.y - prevPrev.y;
                    prevDirection = this.computeDirection(dx, dy);
                } else {
                    prevDirection = null;
                }
                List<Point> sameDirCandidates = new ArrayList<Point>();
                if (prevDirection != null) {
                    Point finalCurrentPoint = currentPoint;
                    sameDirCandidates = minDistPoints.stream().filter(p -> {
                        int pDx = p.x - finalCurrentPoint.x;
                        int pDy = p.y - finalCurrentPoint.y;
                        String dir = this.computeDirection(pDx, pDy);
                        return dir != null && dir.equals(prevDirection);
                    }).toList();
                }
                ArrayList<Point> candidatesToConsider = new ArrayList<Point>(sameDirCandidates.isEmpty() ? minDistPoints : sameDirCandidates);
                candidatesToConsider.sort(this.getDirectionComparator(currentPoint));
                if (candidatesToConsider.isEmpty()) break;
                Point nearestPoint = (Point)candidatesToConsider.getFirst();
                orderedPoints.add(nearestPoint);
                visited.add(nearestPoint);
                currentPoint = nearestPoint;
            }
            return orderedPoints;
        }

        private String computeDirection(int dx, int dy) {
            if (dx > 0 && dy == 0) {
                return "E";
            }
            if (dx < 0 && dy == 0) {
                return "W";
            }
            if (dy > 0 && dx == 0) {
                return "S";
            }
            if (dy < 0 && dx == 0) {
                return "N";
            }
            return null;
        }

        private Comparator<Point> getDirectionComparator(Point currentPoint) {
            return (a, b) -> {
                int bDir;
                int aDir = this.getDirectionPriority(currentPoint, (Point)a);
                if (aDir != (bDir = this.getDirectionPriority(currentPoint, (Point)b))) {
                    return Integer.compare(aDir, bDir);
                }
                if (aDir == 1 || aDir == 2) {
                    int cmpX = Integer.compare(a.x, b.x);
                    if (cmpX != 0) {
                        return cmpX;
                    }
                    if (aDir == 1) {
                        return Integer.compare(a.y, b.y);
                    }
                    return Integer.compare(b.y, a.y);
                }
                int cmpY = Integer.compare(a.y, b.y);
                if (cmpY != 0) {
                    return cmpY;
                }
                if (aDir == 3) {
                    return Integer.compare(a.x, b.x);
                }
                return Integer.compare(b.x, a.x);
            };
        }

        private int getDirectionPriority(Point current, Point p) {
            int dx = p.x - current.x;
            int dy = p.y - current.y;
            if (dy < 0) {
                return 1;
            }
            if (dy > 0) {
                return 2;
            }
            if (dx > 0) {
                return 3;
            }
            if (dx < 0) {
                return 4;
            }
            return 5;
        }

        private Set<Point> findEdgePoints(BufferedImage mask) {
            if (mask == null) {
                return Set.of();
            }
            HashSet<Point> edgePoints = new HashSet<Point>();
            int width = mask.getWidth();
            int height = mask.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int alpha = mask.getRGB(x, y) >> 24 & 0xFF;
                    if (alpha <= 0 || !this.isEdgePixel(mask, x, y, width, height)) continue;
                    edgePoints.add(new Point(x, y));
                }
            }
            return edgePoints;
        }

        private boolean isEdgePixel(BufferedImage mask, int x, int y, int width, int height) {
            int[][] directions;
            if ((mask.getRGB(x, y) >> 24 & 0xFF) == 0) {
                return false;
            }
            if (x == 0 || y == 0 || x == width - 1 || y == height - 1) {
                return true;
            }
            for (int[] d : directions = new int[][]{{-1, 0}, {1, 0}, {0, -1}, {0, 1}}) {
                int neighborAlpha;
                int nx = x + d[0];
                int ny = y + d[1];
                if (nx < 0 || ny < 0 || nx >= width || ny >= height || (neighborAlpha = mask.getRGB(nx, ny) >> 24 & 0xFF) != 0) continue;
                return true;
            }
            return false;
        }

        public static enum Type {
            REPLACE,
            ADD,
            REMOVE;

        }
    }

    public class ValueSliders {
        private final ValueSlider hueSlider;
        private final ValueSlider saturationSlider;
        private final ValueSlider brightnessSlider;
        private final ValueSlider alphaSlider;
        private final ValueSlider hardnessSlider;
        private final ValueSlider brushSizeSlider;
        private final ValueSlider toleranceSlider;
        private final List<ValueSlider> sliders = new ArrayList<ValueSlider>();
        private final PaintSystem parent;

        public ValueSliders(PaintSystem parent) {
            this.parent = parent;
            float x = 1.75f;
            float y = 7.75f;
            float height = 0.33f;
            float rightOffset = 0.8f;
            this.hueSlider = new ValueSlider(PaintSystem.this, x, y, x + rightOffset, y, 8.0f, 2.5f, ps -> -1, ps -> -1, ps -> Color.HSBtoRGB(this.getHueSlider().getValue(), 1.0f, 1.0f), ps -> ps.getCurrentTool().shouldShowColorSliders() && PaintSystem.this.toolsVisible, ps -> Component.translatable((String)"Hue - %s", (Object[])new Object[]{(int)(this.getHueSlider().getValue() * 360.0f)}).withStyle(ChatFormatting.GRAY), true, true);
            this.saturationSlider = new ValueSlider(PaintSystem.this, x, y + height, x + rightOffset, y + height, 8.0f, 2.5f, ps -> Color.HSBtoRGB(ps.getValueSliders().getHueSlider().getValue(), 0.0f, ps.getValueSliders().getBrightnessSlider().getValue()), ps -> Color.HSBtoRGB(ps.getValueSliders().getHueSlider().getValue(), 1.0f, ps.getValueSliders().getBrightnessSlider().getValue()), ps -> 0xFF000000 | ps.getColor() & 0xFFFFFF, ps -> ps.getCurrentTool().shouldShowColorSliders() && PaintSystem.this.toolsVisible, ps -> Component.translatable((String)"Saturation - %s%%", (Object[])new Object[]{(int)(this.getSaturationSlider().getValue() * 100.0f)}).withStyle(ChatFormatting.GRAY), true);
            this.brightnessSlider = new ValueSlider(PaintSystem.this, x, y + height * 2.0f, x + rightOffset, y + height * 2.0f, 8.0f, 2.5f, ps -> Color.HSBtoRGB(ps.getValueSliders().getHueSlider().getValue(), ps.getValueSliders().getSaturationSlider().getValue(), 0.0f), ps -> Color.HSBtoRGB(ps.getValueSliders().getHueSlider().getValue(), ps.getValueSliders().getSaturationSlider().getValue(), 1.0f), ps -> 0xFF000000 | ps.getColor() & 0xFFFFFF, ps -> ps.getCurrentTool().shouldShowColorSliders() && PaintSystem.this.toolsVisible, ps -> Component.translatable((String)"Brightness - %s%%", (Object[])new Object[]{(int)(this.getBrightnessSlider().getValue() * 100.0f)}).withStyle(ChatFormatting.GRAY), true);
            this.alphaSlider = new ValueSlider(PaintSystem.this, x + 1.2f, y + height, x + 1.2f + rightOffset, y + height, 2.5f, 6.5f, ps -> ps.getColor() & 0xFFFFFF, ps -> 0xFF000000 | ps.getColor() & 0xFFFFFF, ps -> ps.getColor(), ps -> ps.getCurrentTool().shouldShowColorSliders() && PaintSystem.this.toolsVisible, ps -> Component.translatable((String)"Alpha - %s%%", (Object[])new Object[]{(int)(this.getAlphaSlider().getValue() * 100.0f)}).withStyle(ChatFormatting.GRAY), false);
            this.hardnessSlider = new ValueSlider(PaintSystem.this, x + 1.75f, y + height * 1.5f, x + 1.75f + rightOffset, y + height * 1.5f, 8.0f, 2.5f, ps -> -14855091, ps -> -11806520, ps -> -13066092, ps -> ps.getCurrentTool().shouldShowBrushSliders() && PaintSystem.this.toolsVisible, ps -> Component.translatable((String)"Hardness - %s%%", (Object[])new Object[]{(int)(this.getHardnessSlider().getValue() * 100.0f)}).withStyle(ChatFormatting.GRAY), true);
            this.brushSizeSlider = new ValueSlider(PaintSystem.this, x + 1.75f, y + height * 0.5f, x + 1.75f + rightOffset, y + height * 0.5f, 8.0f, 2.5f, ps -> -14855091, ps -> -11806520, ps -> -13066092, ps -> ps.getCurrentTool().shouldShowBrushSliders() && PaintSystem.this.toolsVisible, ps -> Component.translatable((String)"Brush Size - %s", (Object[])new Object[]{(int)(this.getBrushSizeSlider().getValue() * (float)ps.getActiveLayer().pixels.getWidth() / 4.0f + 1.0f)}).withStyle(ChatFormatting.GRAY), true);
            this.toleranceSlider = new ValueSlider(PaintSystem.this, x + 1.75f, y + height * 1.9f, x + 1.75f + rightOffset, y + height * 1.9f, 8.0f, 2.5f, ps -> -14855091, ps -> -11806520, ps -> -13066092, ps -> ps.getCurrentTool().shouldShowToleranceSliders() && PaintSystem.this.toolsVisible, ps -> Component.translatable((String)"Tolerance - %s%%", (Object[])new Object[]{(int)(this.getToleranceSlider().getValue() * 100.0f)}).withStyle(ChatFormatting.GRAY), true);
            this.hueSlider.setSliderListener(value -> this.updateColor());
            this.saturationSlider.setSliderListener(value -> this.updateColor());
            this.brightnessSlider.setSliderListener(value -> this.updateColor());
            this.alphaSlider.setSliderListener(value -> this.updateColor());
            this.hardnessSlider.setSliderListener(value -> this.updateHardness());
            this.brushSizeSlider.setSliderListener(value -> this.updateBrushSize());
            this.toleranceSlider.setSliderListener(value -> this.updateTolerance());
            this.sliders.add(this.hueSlider);
            this.sliders.add(this.saturationSlider);
            this.sliders.add(this.brightnessSlider);
            this.sliders.add(this.alphaSlider);
            this.sliders.add(this.hardnessSlider);
            this.sliders.add(this.brushSizeSlider);
            this.sliders.add(this.toleranceSlider);
        }

        public List<ValueSlider> getSliders() {
            return this.sliders;
        }

        private void updateColor() {
            float h = this.hueSlider.getValue();
            float s = this.saturationSlider.getValue();
            float v = this.brightnessSlider.getValue();
            float a = this.alphaSlider.getValue();
            this.parent.setColor((int)(a * 255.0f) << 24 | Color.HSBtoRGB(h, s, v) & 0xFFFFFF);
            this.updateColorSliders(this.parent.getColor());
        }

        private void updateHardness() {
            this.parent.getBrush();
            Brush.hardness = this.hardnessSlider.getValue();
        }

        private void updateHardnessSlider(float hardness) {
            this.hardnessSlider.setValue(hardness);
        }

        private void updateBrushSize() {
            this.parent.getBrush();
            Brush.size = (int)(this.brushSizeSlider.getValue() * (float)this.parent.width / 4.0f);
        }

        private void updateBrushSizeSlider(int size) {
            this.brushSizeSlider.setValue((float)size / ((float)this.parent.width / 4.0f));
        }

        private void updateTolerance() {
            this.parent.getBrush();
            Brush.tolerance = this.toleranceSlider.getValue();
        }

        private void updateToleranceSlider(float tolerance) {
            this.toleranceSlider.setValue(tolerance);
        }

        public void updateColorSliders(int col) {
            if (this.hueSlider.dragging || this.saturationSlider.dragging || this.brightnessSlider.dragging || this.alphaSlider.dragging) {
                return;
            }
            float[] colors = HexereiUtil.rgbaIntToFloatArray(col);
            float[] hsv = new float[3];
            Color.RGBtoHSB((int)(colors[0] * 255.0f), (int)(colors[1] * 255.0f), (int)(colors[2] * 255.0f), hsv);
            if (hsv[1] != 0.0f) {
                this.hueSlider.setValue(hsv[0]);
            }
            if (hsv[2] != 0.0f) {
                this.saturationSlider.setValue(hsv[1]);
            }
            this.brightnessSlider.setValue(hsv[2]);
            this.alphaSlider.setValue(colors[3]);
        }

        public ValueSlider getHueSlider() {
            return this.hueSlider;
        }

        public ValueSlider getSaturationSlider() {
            return this.saturationSlider;
        }

        public ValueSlider getBrightnessSlider() {
            return this.brightnessSlider;
        }

        public ValueSlider getAlphaSlider() {
            return this.alphaSlider;
        }

        public ValueSlider getHardnessSlider() {
            return this.hardnessSlider;
        }

        public ValueSlider getBrushSizeSlider() {
            return this.brushSizeSlider;
        }

        public ValueSlider getToleranceSlider() {
            return this.toleranceSlider;
        }

        public void release() {
            this.hueSlider.dragging = false;
            this.saturationSlider.dragging = false;
            this.brightnessSlider.dragging = false;
            this.alphaSlider.dragging = false;
            this.hardnessSlider.dragging = false;
            this.brushSizeSlider.dragging = false;
            this.toleranceSlider.dragging = false;
        }

        public boolean click(float cursorX, float cursorY, PageDrawing.PageOn pageOn) {
            if (this.parent.getCurrentTool().shouldShowColorSliders()) {
                if (this.hueSlider.click(cursorX, cursorY, pageOn)) {
                    return true;
                }
                if (this.saturationSlider.click(cursorX, cursorY, pageOn)) {
                    return true;
                }
                if (this.brightnessSlider.click(cursorX, cursorY, pageOn)) {
                    return true;
                }
                if (this.alphaSlider.click(cursorX, cursorY, pageOn)) {
                    return true;
                }
            }
            if (this.parent.getCurrentTool().shouldShowBrushSliders()) {
                if (this.hardnessSlider.click(cursorX, cursorY, pageOn)) {
                    return true;
                }
                if (this.brushSizeSlider.click(cursorX, cursorY, pageOn)) {
                    return true;
                }
            }
            return this.parent.getCurrentTool().shouldShowToleranceSliders() && this.toleranceSlider.click(cursorX, cursorY, pageOn);
        }
    }

    public static class Colors {
        public List<ColorSelection> colors = new ArrayList<ColorSelection>();
        private final ColorSelectionPosData colorSelectionPosData1 = new ColorSelectionPosData(new Vec3((double)0.9f, (double)7.97f, 0.0), 4.0f, 4.0f);
        private final ColorSelectionPosData colorSelectionPosData2;
        private final ColorSelectionPosData colorSelectionPosData3;
        float offset;

        public Colors(List<ColorSelection> colors) {
            this.colorSelectionPosData2 = new ColorSelectionPosData(this.colorSelectionPosData1.pos.add(0.25, 0.15, (double)-8.0E-5f), this.colorSelectionPosData1.width - 0.75f, this.colorSelectionPosData1.height - 0.75f);
            this.colorSelectionPosData3 = new ColorSelectionPosData(this.colorSelectionPosData2.pos.add(0.25, 0.15, (double)-8.0E-5f), this.colorSelectionPosData2.width - 0.75f, this.colorSelectionPosData2.height - 0.75f);
            this.offset = 0.8f;
            this.colors.add(new ColorSelection(-16777216, this.colorSelectionPosData1.copy()));
            this.colors.add(new ColorSelection(-1, this.colorSelectionPosData2.copy()));
            this.colors.add(new ColorSelection(-8355712, this.colorSelectionPosData3.copy()));
            this.colors.addAll(colors);
        }

        public void tick() {
            for (ColorSelection colorSelection : this.colors) {
                colorSelection.tick();
            }
        }

        public int getColor() {
            return this.colors.getFirst().getColor();
        }

        public void setColor(int col) {
            this.colors.getFirst().setColor(col);
        }

        public void cycleColor(PaintSystem paintSystem) {
            ColorSelection first = this.colors.removeFirst();
            this.colors.addLast(first);
            paintSystem.getValueSliders().updateColorSliders(this.getColor());
            this.updateColorSelectionTargetPos();
        }

        public void cycleColorBack(PaintSystem paintSystem) {
            ColorSelection last = this.colors.removeLast();
            this.colors.addFirst(last);
            paintSystem.getValueSliders().updateColorSliders(this.getColor());
            this.updateColorSelectionTargetPos();
        }

        public void updateColorSelectionTargetPos() {
            this.colors.get((int)0).target = this.colorSelectionPosData1;
            this.colors.get((int)1).target = this.colorSelectionPosData2;
            this.colors.get((int)2).target = this.colorSelectionPosData3;
        }

        public static class ColorSelectionPosData {
            public float width;
            public float height;
            public Vec3 pos;

            public ColorSelectionPosData(Vec3 pos, float width, float height) {
                this.pos = pos;
                this.width = width;
                this.height = height;
            }

            public ColorSelectionPosData copy() {
                return new ColorSelectionPosData(this.pos, this.width, this.height);
            }
        }

        public static class ColorSelection {
            public ColorSelectionPosData target;
            public ColorSelectionPosData colorPosData;
            public ColorSelectionPosData colorPosDataOld;
            public int color;

            public ColorSelection(int color, ColorSelectionPosData colorPosData) {
                this.color = color;
                this.colorPosData = colorPosData;
                this.colorPosDataOld = colorPosData;
                this.target = colorPosData;
            }

            public void tick() {
                this.colorPosDataOld = this.colorPosData.copy();
                float x = HexereiUtil.moveTo((float)this.colorPosData.pos.x, (float)this.target.pos.x, 0.001f + 0.175f * Mth.abs((float)((float)(this.target.pos.x - this.colorPosData.pos.x))));
                float y = HexereiUtil.moveTo((float)this.colorPosData.pos.y, (float)this.target.pos.y, 0.001f + 0.175f * Mth.abs((float)((float)(this.target.pos.y - this.colorPosData.pos.y))));
                float z = HexereiUtil.moveTo((float)this.colorPosData.pos.z, (float)this.target.pos.z, 0.001f);
                float w = HexereiUtil.moveTo(this.colorPosData.width, this.target.width, 0.25f);
                float h = HexereiUtil.moveTo(this.colorPosData.height, this.target.height, 0.25f);
                this.colorPosData = new ColorSelectionPosData(new Vec3((double)x, (double)y, (double)z), w, h);
            }

            public int getColor() {
                return this.color;
            }

            public void setColor(int color) {
                this.color = color;
            }
        }
    }

    public class Button {
        public BiFunction<PaintSystem, Float, Float> lx;
        public BiFunction<PaintSystem, Float, Float> ly;
        public BiFunction<PaintSystem, Float, Float> rx;
        public BiFunction<PaintSystem, Float, Float> ry;
        public float width;
        public float height;
        public Function<Float, Float> scale;
        public String texture;
        public String hoverTexture;
        public String disabledTexture;
        public Consumer<PaintSystem> onClick;
        public Component tooltip;
        public Consumer<PaintSystem> onTick;
        public Function<PaintSystem, Boolean> selected;
        public Function<PaintSystem, Boolean> disabled;
        public Function<PaintSystem, Boolean> visible;
        public float visibility = 0.0f;
        public float visibilityOld = 0.0f;
        public boolean clicked = false;
        public float clickedScale = 1.0f;

        Button(PaintSystem this$0, float lx, float ly, float rx, float ry, float width, float height, Function<Float, Float> scale, String texture, String hoverTexture, String disabledTexture, Consumer<PaintSystem> onClick, Component tooltip, Consumer<PaintSystem> onTick, Function<PaintSystem, Boolean> selected, Function<PaintSystem, Boolean> disabled, Function<PaintSystem, Boolean> visible) {
            this.lx = (ps, partial) -> Float.valueOf(lx);
            this.ly = (ps, partial) -> Float.valueOf(ly);
            this.rx = (ps, partial) -> Float.valueOf(rx);
            this.ry = (ps, partial) -> Float.valueOf(ry);
            this.width = width;
            this.height = height;
            this.scale = scale;
            this.texture = texture;
            this.hoverTexture = hoverTexture;
            this.disabledTexture = disabledTexture;
            this.onClick = onClick;
            this.tooltip = tooltip;
            this.selected = selected;
            this.disabled = disabled;
            this.visible = visible;
            this.onTick = onTick;
        }

        Button(PaintSystem this$0, BiFunction<PaintSystem, Float, Float> lx, BiFunction<PaintSystem, Float, Float> ly, BiFunction<PaintSystem, Float, Float> rx, BiFunction<PaintSystem, Float, Float> ry, float width, float height, Function<Float, Float> scale, String texture, String hoverTexture, String disabledTexture, Consumer<PaintSystem> onClick, Component tooltip, Consumer<PaintSystem> onTick, Function<PaintSystem, Boolean> selected, Function<PaintSystem, Boolean> disabled, Function<PaintSystem, Boolean> visible) {
            this.lx = lx;
            this.ly = ly;
            this.rx = rx;
            this.ry = ry;
            this.width = width;
            this.height = height;
            this.scale = scale;
            this.texture = texture;
            this.hoverTexture = hoverTexture;
            this.disabledTexture = disabledTexture;
            this.onClick = onClick;
            this.tooltip = tooltip;
            this.selected = selected;
            this.disabled = disabled;
            this.visible = visible;
            this.onTick = onTick;
        }

        public float getX(PaintSystem paintSystem, PageDrawing.PageOn pageOn, float partial) {
            return (pageOn.isOnLeftSide() ? this.lx.apply(paintSystem, Float.valueOf(partial)) : this.rx.apply(paintSystem, Float.valueOf(partial))).floatValue();
        }

        public float getY(PaintSystem paintSystem, PageDrawing.PageOn pageOn, float partial) {
            return (pageOn.isOnLeftSide() ? this.ly.apply(paintSystem, Float.valueOf(partial)) : this.ry.apply(paintSystem, Float.valueOf(partial))).floatValue();
        }

        public Component getTooltip() {
            return this.tooltip;
        }

        public List<Component> getTooltipList() {
            return List.of(this.getTooltip());
        }

        public String getDisabledTexture(PaintSystem paintSystem) {
            return this.disabledTexture;
        }

        public String getTexture(PaintSystem paintSystem) {
            return this.texture;
        }

        public String getHoverTexture(PaintSystem paintSystem) {
            return this.hoverTexture;
        }

        public boolean shouldRender(PaintSystem paintSystem) {
            return this.visibility > 0.0f;
        }

        public float getVisibility(float partial) {
            return Math.max(0.0f, HexereiUtil.easeInOutCubic(Mth.lerp((float)partial, (float)this.visibilityOld, (float)this.visibility)));
        }

        public boolean isVisible(PaintSystem paintSystem) {
            return this.visible.apply(paintSystem);
        }

        public boolean getDisabled(PaintSystem paintSystem) {
            return this.disabled.apply(paintSystem);
        }

        public void onClick(PaintSystem paintSystem) {
            this.getOnClick(paintSystem).accept(paintSystem);
        }

        public Consumer<PaintSystem> getOnClick(PaintSystem paintSystem) {
            return this.onClick;
        }

        public float getScale(float val) {
            return this.scale.apply(Float.valueOf(val)).floatValue() * this.clickedScale;
        }

        public void tick(PaintSystem ps) {
            this.onTick.accept(ps);
            this.visibilityOld = this.visibility;
            this.visibility = this.isVisible(ps) ? HexereiUtil.moveTo(this.visibility, 1.0f, 0.01f + Math.clamp(Math.abs(this.visibility - 1.0f), 0.0f, 1.0f) * 0.15f) : HexereiUtil.moveTo(this.visibility, -1.0f, 0.01f + Math.clamp(Math.abs(this.visibility - 1.0f), 0.0f, 1.0f) * 0.25f);
            if (this.clicked) {
                this.clickedScale = HexereiUtil.moveTo(this.clickedScale, 0.75f, 0.01f + Math.abs(this.clickedScale - 0.75f) * 0.5f);
                if (this.clickedScale == 0.75f) {
                    this.clicked = false;
                }
            } else {
                this.clickedScale = HexereiUtil.moveTo(this.clickedScale, 1.0f, 0.01f + Math.abs(this.clickedScale - 0.75f) * 2.0f);
            }
        }
    }

    public class ToggleButton
    extends Button {
        public Function<PaintSystem, Boolean> toggled;
        public Consumer<PaintSystem> toggledOnClick;
        public String toggledTexture;
        public String toggledHoverTexture;
        public String toggledDisabledTexture;

        ToggleButton(PaintSystem this$0, float lx, float ly, float rx, float ry, float width, float height, Function<Float, Float> scale, String texture, String hoverTexture, String disabledTexture, String toggledTexture, String toggledHoverTexture, String toggledDisabledTexture, Consumer<PaintSystem> onClick, Consumer<PaintSystem> toggledOnClick, Component tooltip, Consumer<PaintSystem> onTick, Function<PaintSystem, Boolean> selected, Function<PaintSystem, Boolean> disabled, Function<PaintSystem, Boolean> visible, Function<PaintSystem, Boolean> toggled) {
            super(this$0, lx, ly, rx, ry, width, height, scale, texture, hoverTexture, disabledTexture, onClick, tooltip, onTick, selected, disabled, visible);
            this.toggledTexture = toggledTexture;
            this.toggledHoverTexture = toggledHoverTexture;
            this.toggledDisabledTexture = toggledDisabledTexture;
            this.toggledOnClick = toggledOnClick;
            this.toggled = toggled;
        }

        ToggleButton(PaintSystem this$0, BiFunction<PaintSystem, Float, Float> lx, BiFunction<PaintSystem, Float, Float> ly, BiFunction<PaintSystem, Float, Float> rx, BiFunction<PaintSystem, Float, Float> ry, float width, float height, Function<Float, Float> scale, String texture, String hoverTexture, String disabledTexture, String toggledTexture, String toggledHoverTexture, String toggledDisabledTexture, Consumer<PaintSystem> onClick, Consumer<PaintSystem> toggledOnClick, Component tooltip, Consumer<PaintSystem> onTick, Function<PaintSystem, Boolean> selected, Function<PaintSystem, Boolean> disabled, Function<PaintSystem, Boolean> visible, Function<PaintSystem, Boolean> toggled) {
            super(this$0, lx, ly, rx, ry, width, height, scale, texture, hoverTexture, disabledTexture, onClick, tooltip, onTick, selected, disabled, visible);
            this.toggledTexture = toggledTexture;
            this.toggledHoverTexture = toggledHoverTexture;
            this.toggledDisabledTexture = toggledDisabledTexture;
            this.toggledOnClick = toggledOnClick;
            this.toggled = toggled;
        }

        public boolean getToggled(PaintSystem paintSystem) {
            return this.toggled.apply(paintSystem);
        }

        @Override
        public String getTexture(PaintSystem paintSystem) {
            return this.getToggled(paintSystem) ? this.toggledTexture : super.getTexture(paintSystem);
        }

        @Override
        public String getDisabledTexture(PaintSystem paintSystem) {
            return this.getToggled(paintSystem) ? this.toggledDisabledTexture : super.getDisabledTexture(paintSystem);
        }

        @Override
        public String getHoverTexture(PaintSystem paintSystem) {
            return this.getToggled(paintSystem) ? this.toggledHoverTexture : super.getHoverTexture(paintSystem);
        }

        @Override
        public Consumer<PaintSystem> getOnClick(PaintSystem paintSystem) {
            return this.getToggled(paintSystem) ? this.toggledOnClick : super.getOnClick(paintSystem);
        }
    }

    public static class Layer {
        public BufferedImage pixels;
        public float opacity = 1.0f;
        public BlendMode blendMode = BlendMode.NORMAL;
        public boolean dirty = true;
        public String name = "";
    }

    public static enum BlendMode {
        NORMAL{

            @Override
            public int apply(int srcColor, int a, int r, int g, int b) {
                int destA = srcColor >> 24 & 0xFF;
                int destR = srcColor >> 16 & 0xFF;
                int destG = srcColor >> 8 & 0xFF;
                int destB = srcColor & 0xFF;
                if (a == 255 || destA == 0) {
                    return a << 24 | r << 16 | g << 8 | b;
                }
                if (a == 0) {
                    return srcColor;
                }
                float alpha = (float)a / 255.0f;
                float invAlpha = 1.0f - alpha;
                int blendedA = (int)((float)a + (float)destA * invAlpha);
                int blendedR = (int)((float)r * alpha + (float)destR * invAlpha);
                int blendedG = (int)((float)g * alpha + (float)destG * invAlpha);
                int blendedB = (int)((float)b * alpha + (float)destB * invAlpha);
                return blendedA << 24 | blendedR << 16 | blendedG << 8 | blendedB;
            }
        }
        ,
        OVERLAY{

            @Override
            public int apply(int srcColor, int a, int r, int g, int b) {
                int sr = srcColor >> 16 & 0xFF;
                int sg = srcColor >> 8 & 0xFF;
                int sb = srcColor & 0xFF;
                int or = sr * r / 255;
                int og = sg * g / 255;
                int ob = sb * b / 255;
                return a << 24 | or << 16 | og << 8 | ob;
            }
        };


        public abstract int apply(int var1, int var2, int var3, int var4, int var5);
    }

    public class SelectionAction
    implements Action {
        private Rectangle oldBounds;
        private BufferedImage oldMask;
        private Rectangle newBounds;
        private BufferedImage newMask;

        public SelectionAction(Rectangle oldBounds, BufferedImage oldMask, Rectangle newBounds, BufferedImage newMask) {
            this.oldBounds = oldBounds == null ? null : new Rectangle(oldBounds);
            this.oldMask = oldMask != null ? PaintSystem.deepCopy(oldMask) : null;
            this.newBounds = newBounds == null ? null : new Rectangle(newBounds);
            this.newMask = newMask != null ? PaintSystem.deepCopy(newMask) : null;
        }

        @Override
        public void undo() {
            PaintSystem.this.selection.bounds.setLocation(0, 0);
            PaintSystem.this.selection.setSelectionMask(this.oldMask != null ? PaintSystem.deepCopy(this.oldMask) : null);
            PaintSystem.this.selection.bounds = this.oldBounds == null ? new Rectangle(0, 0, 0, 0) : new Rectangle(this.oldBounds);
        }

        @Override
        public void redo() {
            PaintSystem.this.selection.bounds.setLocation(0, 0);
            PaintSystem.this.selection.setSelectionMask(this.newMask != null ? PaintSystem.deepCopy(this.newMask) : null);
            PaintSystem.this.selection.bounds = this.newBounds == null ? new Rectangle(0, 0, 0, 0) : new Rectangle(this.newBounds);
        }
    }

    public static interface Action {
        public void undo();

        public void redo();
    }

    public class ValueSlider {
        public float lx;
        public float ly;
        public float rx;
        public float ry;
        public float width;
        public float height;
        private boolean horizontal;
        private float value = 0.5f;
        private boolean dragging = false;
        private boolean hovering = false;
        private float hoveringScale = 1.0f;
        private float hoveringScaleOld = 1.0f;
        private Function<PaintSystem, Integer> color1;
        private Function<PaintSystem, Integer> color2;
        private Function<PaintSystem, Integer> sliderColor;
        private Function<PaintSystem, Boolean> visible;
        public float visibility = 0.0f;
        public float visibilityOld = 0.0f;
        private Function<PaintSystem, Component> tooltip;
        private boolean isSpecialHueSlider = false;
        private SliderListener listener;

        ValueSlider(PaintSystem this$0, float lx, float ly, float rx, float ry, float width, float height, Function<PaintSystem, Integer> color1, Function<PaintSystem, Integer> color2, Function<PaintSystem, Integer> sliderColor, Function<PaintSystem, Boolean> visible, Function<PaintSystem, Component> tooltip, boolean horizontal) {
            this.visible = visible;
            this.color1 = color1;
            this.color2 = color2;
            this.tooltip = tooltip;
            this.sliderColor = sliderColor;
            this.lx = lx;
            this.ly = ly;
            this.rx = rx;
            this.ry = ry;
            this.width = width;
            this.height = height;
            this.horizontal = horizontal;
        }

        ValueSlider(PaintSystem this$0, float lx, float ly, float rx, float ry, float width, float height, Function<PaintSystem, Integer> color1, Function<PaintSystem, Integer> color2, Function<PaintSystem, Integer> sliderColor, Function<PaintSystem, Boolean> visible, Function<PaintSystem, Component> tooltip, boolean horizontal, boolean isSpecialHueSlider) {
            this(this$0, lx, ly, rx, ry, width, height, color1, color2, sliderColor, visible, tooltip, horizontal);
            this.isSpecialHueSlider = isSpecialHueSlider;
        }

        public float getX(PageDrawing.PageOn pageOn) {
            return pageOn.isOnLeftSide() ? this.lx : this.rx;
        }

        public float getY(PageDrawing.PageOn pageOn) {
            return pageOn.isOnLeftSide() ? this.ly : this.ry;
        }

        public float getVisibility(float partial) {
            return Math.max(0.0f, HexereiUtil.easeInOutCubic(Mth.lerp((float)partial, (float)this.visibilityOld, (float)this.visibility)));
        }

        public void tick(PaintSystem ps) {
            this.visibilityOld = this.visibility;
            this.visibility = this.isVisible(ps) ? HexereiUtil.moveTo(this.visibility, 1.0f, 0.01f + Math.clamp(Math.abs(this.visibility - 1.0f), 0.0f, 1.0f) * 0.15f) : HexereiUtil.moveTo(this.visibility, -1.0f, 0.01f + Math.clamp(Math.abs(this.visibility - 1.0f), 0.0f, 1.0f) * 0.25f);
            this.hoveringScaleOld = this.hoveringScale;
            this.hoveringScale = this.hovering ? HexereiUtil.moveTo(this.hoveringScale, 1.0f, 0.01f + Math.abs(this.hoveringScale - 1.0f) * 0.1f) : HexereiUtil.moveTo(this.hoveringScale, 0.0f, 0.01f + Math.abs(this.hoveringScale - 0.0f) * 0.025f);
            this.hovering = false;
        }

        public boolean isSpecialHueSlider() {
            return this.isSpecialHueSlider;
        }

        public Component getTooltip(PaintSystem ps) {
            return this.tooltip.apply(ps);
        }

        public boolean shouldRender(PaintSystem ps) {
            return this.visibility > 0.0f;
        }

        public boolean isVisible(PaintSystem ps) {
            return this.visible.apply(ps);
        }

        public int getColor1(PaintSystem ps) {
            return this.color1.apply(ps);
        }

        public int getColor2(PaintSystem ps) {
            return this.color2.apply(ps);
        }

        public int getSliderColor(PaintSystem ps) {
            return this.sliderColor.apply(ps);
        }

        public void setHovering() {
            this.hovering = true;
        }

        public float getHoveringScale(float partial) {
            float val = HexereiUtil.easeInOutCubic(Mth.lerp((float)partial, (float)this.hoveringScaleOld, (float)this.hoveringScale));
            return val * 1.25f + 1.0f;
        }

        public boolean isHorizontal() {
            return this.horizontal;
        }

        public boolean isDragging() {
            return this.dragging;
        }

        private boolean click(float cursorX, float cursorY, PageDrawing.PageOn pageOn) {
            boolean clicked;
            float scale = 1.0f;
            float w1 = this.width / 326.0f * 2.55f * scale / 0.062f;
            float h1 = this.height / 326.0f * 2.55f * scale / 0.062f;
            float x1 = this.getX(pageOn) + 0.025f - (pageOn.isOnLeftSide() ? 0.0f : 0.09f);
            float y1 = this.getY(pageOn) - 0.5f - h1 / 2.0f;
            float u = (cursorX - x1) / w1;
            float v = (cursorY - y1) / h1;
            this.dragging = clicked = u >= 0.0f && u <= 1.0f && v >= 0.0f && v <= 1.0f;
            return clicked;
        }

        public void updateValue(float cursorX, float cursorY, PageDrawing.PageOn pageOn) {
            float scale = 1.0f;
            float w1 = this.width / 326.0f * 2.55f * scale / 0.062f;
            float h1 = this.height / 326.0f * 2.55f * scale / 0.062f;
            float x1 = this.getX(pageOn) + 0.025f - (pageOn.isOnLeftSide() ? 0.0f : 0.09f);
            float y1 = this.getY(pageOn) - 0.5f;
            float u = (cursorX - x1) / w1;
            float v = (cursorY - y1 + h1 / 2.0f) / h1;
            this.value = this.horizontal ? Math.max(0.0f, Math.min(1.0f, u)) : Math.max(0.0f, Math.min(1.0f, 1.0f - v));
            if (this.listener != null) {
                this.listener.onValueChanged(this.value);
            }
        }

        public void setSliderListener(SliderListener listener) {
            this.listener = listener;
        }

        public float getValue() {
            return this.value;
        }

        public void setValue(float value) {
            this.value = value;
        }

        public static interface SliderListener {
            public void onValueChanged(float var1);
        }
    }

    public class SelectionAndDrawAction
    implements Action {
        private Layer layer;
        private int index;
        private BufferedImage beforeImage;
        private BufferedImage afterImage;
        private Rectangle oldBounds;
        private BufferedImage oldMask;
        private Rectangle newBounds;
        private BufferedImage newMask;

        public SelectionAndDrawAction(Layer layer, Selection selection) {
            this.layer = layer;
            this.index = PaintSystem.this.getLayers().indexOf(layer);
            this.beforeImage = PaintSystem.deepCopy(layer.pixels);
            this.oldBounds = selection.bounds == null ? null : new Rectangle(selection.bounds);
            this.oldMask = selection.mask != null ? PaintSystem.deepCopy(selection.mask) : null;
        }

        public void captureAfter(Selection selection) {
            this.afterImage = PaintSystem.deepCopy(this.layer.pixels);
            this.newBounds = selection.bounds == null ? null : new Rectangle(selection.bounds);
            this.newMask = selection.mask != null ? PaintSystem.deepCopy(selection.mask) : null;
        }

        @Override
        public void undo() {
            Layer layer = PaintSystem.this.getLayers().get(this.index);
            Graphics2D g = layer.pixels.createGraphics();
            g.setBackground(new Color(Color.BLACK.getRGB() & 0xFFFFFF, true));
            g.clearRect(0, 0, layer.pixels.getWidth(), layer.pixels.getHeight());
            g.drawImage((Image)this.beforeImage, 0, 0, null);
            g.dispose();
            layer.dirty = true;
            PaintSystem.this.selection.bounds.setLocation(0, 0);
            PaintSystem.this.selection.setSelectionMask(this.oldMask != null ? PaintSystem.deepCopy(this.oldMask) : null);
            PaintSystem.this.selection.bounds = this.oldBounds == null ? new Rectangle(0, 0, 0, 0) : new Rectangle(this.oldBounds);
            PaintSystem.this.updateToServer = true;
        }

        @Override
        public void redo() {
            Layer layer = PaintSystem.this.getLayers().get(this.index);
            Graphics2D g = layer.pixels.createGraphics();
            g.setBackground(new Color(Color.BLACK.getRGB() & 0xFFFFFF, true));
            g.clearRect(0, 0, layer.pixels.getWidth(), layer.pixels.getHeight());
            g.drawImage((Image)this.afterImage, 0, 0, null);
            g.dispose();
            layer.dirty = true;
            PaintSystem.this.selection.bounds.setLocation(0, 0);
            PaintSystem.this.selection.setSelectionMask(this.newMask != null ? PaintSystem.deepCopy(this.newMask) : null);
            PaintSystem.this.selection.bounds = this.newBounds == null ? new Rectangle(0, 0, 0, 0) : new Rectangle(this.newBounds);
            PaintSystem.this.updateToServer = true;
        }
    }
}

