/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.candle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.data.candle.AbstractCandleEffect;
import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;

public class BonemealingCandleEffect
extends AbstractCandleEffect {
    private static final int MAX_TIME = 160;

    @Override
    public void tick(Level level, CandleTile blockEntity, CandleData candleData) {
        if (candleData.lit) {
            if ((float)candleData.cooldown >= 160.0f * candleData.getEffectCooldownMultiplier()) {
                for (int i = 0; i < 3; ++i) {
                    BlockPos crop = this.findCrop(level, blockEntity.getBlockPos());
                    if (crop == null) continue;
                    Block block = level.getBlockState(crop).getBlock();
                    if (level.isClientSide() || !(block instanceof CropBlock)) continue;
                    CropBlock cropBlock = (CropBlock)block;
                    ServerLevel serverLevel = (ServerLevel)level;
                    cropBlock.performBonemeal(serverLevel, level.random, crop, level.getBlockState(crop));
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)crop.getX() + 0.5, (double)crop.getY() + 0.5, (double)crop.getZ() + 0.5, 10, 0.5, 0.5, 0.5, 0.2);
                }
                candleData.cooldown = 0;
            }
            try {
                if (candleData.effectParticle != null && level.isClientSide() && candleData.effectParticle != null && !candleData.effectParticle.isEmpty()) {
                    this.particle = ParticleArgument.readParticle((StringReader)new StringReader(candleData.effectParticle.get(new Random().nextInt(candleData.effectParticle.size()))), (HolderLookup.Provider)Hexerei.DynamicRegistries.get());
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            candleData.cooldown = (candleData.cooldown + 1) % Integer.MAX_VALUE;
        }
    }

    @Nullable
    public BlockPos findCrop(Level level, BlockPos jarPos) {
        ArrayList<BlockPos> crops = new ArrayList<BlockPos>();
        for (BlockPos pos : area) {
            CropBlock cropBlock;
            Block block;
            BlockPos relativePos = jarPos.offset((Vec3i)pos);
            BlockState state = level.getBlockState(relativePos);
            if (state.isAir() || !((block = state.getBlock()) instanceof CropBlock) || !(cropBlock = (CropBlock)block).isValidBonemealTarget((LevelReader)level, pos, state)) continue;
            crops.add(relativePos);
        }
        if (crops.isEmpty()) {
            return null;
        }
        return (BlockPos)crops.get(level.random.nextInt(crops.size()));
    }

    @Override
    public <T> AbstractCandleEffect getCopy() {
        return new BonemealingCandleEffect();
    }

    @Override
    public String getLocationName() {
        return HexereiUtil.getResource("growth_effect").toString();
    }

    @Override
    public ParticleOptions getParticleType() {
        return ParticleTypes.HAPPY_VILLAGER;
    }
}

