/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.owl;

import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotData;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.ClientboundOwlCourierDepotDataInventoryPacket;
import net.joefoxe.hexerei.util.message.ClientboundOwlCourierDepotDataPacket;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class OwlCourierDepotSavedData
extends SavedData {
    protected static final String DATA_NAME = "hexerei_owl_courier_depot";
    Map<GlobalPos, OwlCourierDepotData> depots = new HashMap<GlobalPos, OwlCourierDepotData>();

    public OwlCourierDepotSavedData addOwlCourierDepot(String name, GlobalPos pos) {
        for (Map.Entry<GlobalPos, OwlCourierDepotData> entry : this.depots.entrySet()) {
            if (entry.getValue().name.equals(name)) {
                return this;
            }
            if (!entry.getKey().equals((Object)pos)) continue;
            return this;
        }
        this.depots.put(pos, new OwlCourierDepotData(name));
        this.syncToClient();
        this.setDirty();
        return this;
    }

    public Map<GlobalPos, OwlCourierDepotData> getDepots() {
        return this.depots;
    }

    public void syncToClient() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            HexereiPacketHandler.sendToAllPlayers(new ClientboundOwlCourierDepotDataPacket(this.save(new CompoundTag(), (HolderLookup.Provider)server.registryAccess())), server);
        }
    }

    public void syncToClient(Player player) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            HexereiPacketHandler.sendToPlayerClient(new ClientboundOwlCourierDepotDataPacket(this.save(new CompoundTag(), (HolderLookup.Provider)server.registryAccess())), serverPlayer);
        }
    }

    public void syncInvToClient(GlobalPos pos) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            HexereiPacketHandler.sendToAllPlayers(new ClientboundOwlCourierDepotDataInventoryPacket(this.invNbt(pos, new CompoundTag())), server);
        }
    }

    public void clearOwlCourierDepot(GlobalPos pos) {
        for (Map.Entry<GlobalPos, OwlCourierDepotData> entry : this.depots.entrySet()) {
            GlobalPos depotPos = entry.getKey();
            if (!pos.equals((Object)depotPos)) continue;
            this.depots.remove(entry.getKey());
            this.setDirty();
            this.syncToClient();
            break;
        }
    }

    public void tick(ServerLevel serverLevel) {
    }

    private static OwlCourierDepotSavedData create(CompoundTag tag, HolderLookup.Provider registries) {
        OwlCourierDepotSavedData data = new OwlCourierDepotSavedData();
        data.load(tag, registries);
        return data;
    }

    public void load(CompoundTag pCompoundTag, HolderLookup.Provider registries) {
        if (pCompoundTag.contains("depots")) {
            ListTag depotList = pCompoundTag.getList("depots", 10);
            for (int i = 0; i < depotList.size(); ++i) {
                CompoundTag depotTag = depotList.getCompound(i);
                String depotName = depotTag.getString("DepotName");
                Optional pos = GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)depotTag.get("Pos")).result();
                OwlCourierDepotData depotData = new OwlCourierDepotData(depotName);
                ContainerHelper.loadAllItems((CompoundTag)depotTag, depotData.items, (HolderLookup.Provider)registries);
                pos.ifPresent(globalPos -> this.depots.put((GlobalPos)globalPos, depotData));
            }
        }
    }

    public CompoundTag save(CompoundTag pCompoundTag, HolderLookup.Provider registries) {
        ListTag depotList = new ListTag();
        for (Map.Entry<GlobalPos, OwlCourierDepotData> entry : this.depots.entrySet()) {
            CompoundTag depotTag = new CompoundTag();
            depotTag.putString("DepotName", entry.getValue().name);
            Optional tag = GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)entry.getKey()).result();
            tag.ifPresent(value -> depotTag.put("Pos", value));
            ContainerHelper.saveAllItems((CompoundTag)depotTag, entry.getValue().items, (HolderLookup.Provider)registries);
            depotList.add((Object)depotTag);
        }
        pCompoundTag.put("depots", (Tag)depotList);
        return pCompoundTag;
    }

    public CompoundTag invNbt(GlobalPos pos, CompoundTag pCompoundTag) {
        Optional tag = GlobalPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)pos).result();
        tag.ifPresent(value -> pCompoundTag.put("Pos", value));
        ContainerHelper.saveAllItems((CompoundTag)pCompoundTag, this.depots.get((Object)pos).items, (HolderLookup.Provider)Hexerei.DynamicRegistries.get());
        return pCompoundTag;
    }

    public static SavedData.Factory<OwlCourierDepotSavedData> factory() {
        return new SavedData.Factory(OwlCourierDepotSavedData::new, OwlCourierDepotSavedData::create, null);
    }

    public static OwlCourierDepotSavedData get(ServerLevel world) {
        return (OwlCourierDepotSavedData)world.getServer().overworld().getDataStorage().computeIfAbsent(OwlCourierDepotSavedData.factory(), DATA_NAME);
    }

    public static OwlCourierDepotSavedData get() {
        return (OwlCourierDepotSavedData)ServerLifecycleHooks.getCurrentServer().overworld().getDataStorage().computeIfAbsent(OwlCourierDepotSavedData.factory(), DATA_NAME);
    }
}

