/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.joefoxe.hexerei.data.books.HexereiBookItem;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;

public class BookOfShadowsRecipe
extends ShapedRecipe {
    public BookOfShadowsRecipe(ShapedRecipe shapedRecipe) {
        super(shapedRecipe.getGroup(), shapedRecipe.category(), shapedRecipe.pattern, shapedRecipe.result, shapedRecipe.showNotification());
    }

    public BookOfShadowsRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        super(group, category, pattern, result, showNotification);
    }

    public boolean isSpecial() {
        return false;
    }

    @Nonnull
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        DyeColor color1 = null;
        DyeColor color2 = null;
        ItemStack book = null;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            Item item = stack.getItem();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                if (color1 == null) {
                    color1 = dye.getDyeColor();
                    continue;
                }
                color2 = dye.getDyeColor();
                continue;
            }
            if (!(item instanceof HexereiBookItem)) continue;
            book = stack;
        }
        ItemStack stack = new ItemStack((ItemLike)ModItems.BOOK_OF_SHADOWS.get());
        return HexereiBookItem.withColors(book == null ? stack : book, color1 == null ? 0 : color1.getTextureDiffuseColor(), color2 == null ? 0 : color2.getTextureDiffuseColor());
    }

    public ItemStack getOutput() {
        return this.getResultItem(null);
    }

    public NonNullList<Ingredient> getInputs() {
        return this.getIngredients();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.BOOK_OF_SHADOWS_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<BookOfShadowsRecipe> {
        public static final MapCodec<BookOfShadowsRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340778_ -> p_340778_.group((App)ShapedRecipe.Serializer.CODEC.forGetter(bookOfShadowsRecipe -> bookOfShadowsRecipe)).apply((Applicative)p_340778_, BookOfShadowsRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BookOfShadowsRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BookOfShadowsRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BookOfShadowsRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static BookOfShadowsRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new BookOfShadowsRecipe((ShapedRecipe)ShapedRecipe.Serializer.STREAM_CODEC.decode((Object)buffer));
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, BookOfShadowsRecipe recipe) {
            ShapedRecipe.Serializer.STREAM_CODEC.encode((Object)buffer, (Object)recipe);
        }
    }
}

