/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import java.util.ArrayList;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class FillWaxingKitRecipe
extends CustomRecipe {
    int waxUsed = 0;

    public FillWaxingKitRecipe(CraftingBookCategory cBc) {
        super(cBc);
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(CraftingInput pInv, Level pLevel) {
        int kit = 0;
        int wax = 0;
        ItemStack kit_item = ItemStack.EMPTY;
        for (int j = 0; j < pInv.size(); ++j) {
            ItemStack container_item = pInv.getItem(j);
            if (container_item.isEmpty()) continue;
            if (container_item.is((Item)ModItems.WAX_BLEND.get())) {
                ++wax;
                continue;
            }
            if (!container_item.is((Item)ModItems.WAXING_KIT.get())) {
                return false;
            }
            kit_item = container_item;
            ++kit;
        }
        CompoundTag tag = ((CustomData)kit_item.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        return wax >= 1 && kit == 1 && (!tag.contains("waxCount") || tag.getInt("waxCount") < 256);
    }

    public ItemStack assemble(CraftingInput pInv, HolderLookup.Provider registryAccess) {
        int kit_i = 0;
        int wax_i = 0;
        ItemStack kit = ItemStack.EMPTY;
        ArrayList<ItemStack> wax = new ArrayList<ItemStack>();
        for (int j = 0; j < pInv.size(); ++j) {
            ItemStack itemstack1 = pInv.getItem(j);
            if (itemstack1.isEmpty()) continue;
            if (itemstack1.is((Item)ModItems.WAX_BLEND.get())) {
                wax.add(itemstack1);
                wax_i += itemstack1.getCount();
                continue;
            }
            kit = itemstack1;
            ++kit_i;
        }
        if (wax_i >= 1 && kit_i == 1) {
            int count;
            ItemStack itemstack2 = kit.copy();
            int baseCount = 0;
            CompoundTag tag = ((CustomData)itemstack2.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (tag.contains("waxCount")) {
                baseCount = tag.getInt("waxCount");
            }
            if ((count = baseCount + wax_i) <= 256) {
                this.waxUsed = wax_i;
                tag.putInt("waxCount", count);
            } else {
                this.waxUsed = 256 - baseCount;
                tag.putInt("waxCount", 256);
            }
            itemstack2.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            return itemstack2;
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput pInv) {
        int kit_i = 0;
        int wax_i = 0;
        ItemStack kit = ItemStack.EMPTY;
        ArrayList<ItemStack> wax = new ArrayList<ItemStack>();
        for (int j = 0; j < pInv.size(); ++j) {
            ItemStack itemstack1 = pInv.getItem(j);
            if (itemstack1.isEmpty()) continue;
            if (itemstack1.is((Item)ModItems.WAX_BLEND.get())) {
                wax.add(itemstack1);
                wax_i += itemstack1.getCount();
                continue;
            }
            kit = itemstack1;
            ++kit_i;
        }
        if (wax_i >= 1 && kit_i == 1) {
            int count;
            ItemStack itemstack2 = kit.copy();
            int baseCount = 0;
            CompoundTag tag = ((CustomData)itemstack2.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (tag.contains("waxCount")) {
                baseCount = tag.getInt("waxCount");
            }
            this.waxUsed = (count = baseCount + wax_i) <= 256 ? wax_i : 256 - baseCount;
        }
        NonNullList nonnulllist = NonNullList.withSize((int)pInv.size(), (Object)ItemStack.EMPTY);
        int waxUsedTemp = this.waxUsed;
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = pInv.getItem(i);
            if (itemstack.hasCraftingRemainingItem()) {
                nonnulllist.set(i, (Object)itemstack.getCraftingRemainingItem());
                continue;
            }
            if (itemstack.getItem() != ModItems.WAX_BLEND.get()) continue;
            int toSubtract = 0;
            for (int j = 0; j < itemstack.getCount(); ++j) {
                if (waxUsedTemp <= 0) continue;
                ++toSubtract;
                --waxUsedTemp;
            }
            int count = itemstack.getCount() - toSubtract;
            itemstack.shrink(toSubtract);
            if (count == 0) continue;
            nonnulllist.set(i, (Object)itemstack.copyWithCount(1));
        }
        return nonnulllist;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.FILL_WAXING_KIT_SERIALIZER.get();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth >= 3 && pHeight >= 3;
    }
}

