/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class FluidMixingRecipe
implements Recipe<RecipeInput> {
    private final NonNullList<Ingredient> recipeItems;
    private final FluidStack fluid;
    private final FluidStack fluidOutput;
    private final HeatCondition heatCondition;

    public boolean isSpecial() {
        return true;
    }

    public FluidMixingRecipe(NonNullList<Ingredient> recipeItems, FluidStack fluid, FluidStack fluidOutput) {
        this(recipeItems, fluid, fluidOutput, HeatCondition.NONE);
    }

    public FluidMixingRecipe(NonNullList<Ingredient> recipeItems, FluidStack fluid, FluidStack fluidOutput, HeatCondition heatCondition) {
        this.recipeItems = recipeItems;
        this.fluid = fluid;
        this.fluidOutput = fluidOutput;
        this.heatCondition = heatCondition;
    }

    public boolean matches(RecipeInput input, Level worldIn) {
        List itemMatchesSlot = Stream.generate(() -> false).limit(8L).collect(Collectors.toList());
        boolean flag = false;
        for (Ingredient recipeItem : this.recipeItems) {
            for (int i = 0; i < 8; ++i) {
                if (!recipeItem.test(input.getItem(i)) || ((Boolean)itemMatchesSlot.get(i)).booleanValue()) continue;
                itemMatchesSlot.set(i, true);
                flag = true;
                break;
            }
            if (!flag) break;
            flag = false;
        }
        for (int i = 0; i < 8; ++i) {
            if (((Boolean)itemMatchesSlot.get(i)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public HeatCondition getHeatCondition() {
        return this.heatCondition;
    }

    public FluidStack getLiquid() {
        return this.fluid;
    }

    public FluidStack getLiquidOutput() {
        return this.fluidOutput;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.MIXING_CAULDRON.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.FLUID_MIXING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static enum HeatCondition implements StringRepresentable
    {
        NONE,
        HEATED,
        SUPERHEATED;

        public static final StringRepresentable.EnumCodec<HeatCondition> CODEC;

        public String toString() {
            return this.getSerializedName();
        }

        public static HeatCondition getHeated(String str) {
            return switch (str) {
                case "heated" -> HEATED;
                case "superheated" -> SUPERHEATED;
                default -> NONE;
            };
        }

        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> "heated";
                case 2 -> "superheated";
                case 0 -> "none";
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(HeatCondition::values);
        }
    }

    public static class Type
    implements RecipeType<FluidMixingRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<FluidMixingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<FluidMixingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NonNullList.codecOf((Codec)Ingredient.CODEC).fieldOf("ingredients").forGetter(recipe -> recipe.recipeItems), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(recipe -> recipe.fluid), (App)FluidStack.CODEC.fieldOf("output").forGetter(recipe -> recipe.fluidOutput), (App)HeatCondition.CODEC.fieldOf("heatRequirement").forGetter(recipe -> recipe.heatCondition)).apply((Applicative)instance, FluidMixingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidMixingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<FluidMixingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FluidMixingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static FluidMixingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            NonNullList inputs = NonNullList.withSize((int)buffer.readInt(), (Object)Ingredient.EMPTY);
            inputs.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            FluidStack inputFluid = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
            FluidStack outputFluid = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
            HeatCondition heatCondition = (HeatCondition)((Object)NeoForgeStreamCodecs.enumCodec(HeatCondition.class).decode((Object)buffer));
            return new FluidMixingRecipe((NonNullList<Ingredient>)inputs, inputFluid, outputFluid, heatCondition);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, FluidMixingRecipe recipe) {
            buffer.writeInt(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluid);
            FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluidOutput);
            NeoForgeStreamCodecs.enumCodec(HeatCondition.class).encode((Object)buffer, (Object)recipe.heatCondition);
        }
    }
}

