/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.item.custom.KeychainItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class KeychainUndoRecipe
extends CustomRecipe {
    public KeychainUndoRecipe(CraftingBookCategory cBc) {
        super(cBc);
    }

    public boolean isSpecial() {
        return true;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput p_44004_) {
        NonNullList nonnulllist = NonNullList.withSize((int)p_44004_.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            Item item;
            ItemStack item2 = p_44004_.getItem(i);
            if (item2.hasCraftingRemainingItem()) {
                nonnulllist.set(i, (Object)item2.getCraftingRemainingItem());
            }
            if (!((item = item2.getItem()) instanceof KeychainItem)) continue;
            KeychainItem keychainItem = (KeychainItem)item;
            nonnulllist.set(i, (Object)new ItemStack((ItemLike)keychainItem));
        }
        return nonnulllist;
    }

    public boolean matches(CraftingInput inventory, Level world) {
        int keychain = 0;
        int other = 0;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof KeychainItem) {
                CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                if (tag.contains("Items")) {
                    ++keychain;
                }
            } else {
                ++other;
            }
            if (other <= 1 && keychain <= true) continue;
            return false;
        }
        return keychain == 1 && other == 0;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider registryAccess) {
        ItemStack keychain = ItemStack.EMPTY;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !(stack.getItem() instanceof KeychainItem)) continue;
            keychain = stack.copy();
            keychain.setCount(1);
        }
        if (keychain.getItem() instanceof KeychainItem) {
            CompoundTag tag = ((CustomData)keychain.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            ListTag list = tag.getList("Items", 10);
            keychain = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)list.getCompound(0));
        }
        return keychain;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 1;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.KEYCHAIN_UNDO_SERIALIZER.get();
    }
}

