/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.recipes.FluidMixingRecipe;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.data.recipes.MoonPhases;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class MixingCauldronRecipe
implements Recipe<MixingCauldronRecipeInput> {
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;
    private final FluidStack fluid;
    private final FluidStack fluidOutput;
    protected static final List<Boolean> itemMatchesSlot = new ArrayList<Boolean>();
    private final FluidMixingRecipe.HeatCondition heatCondition;
    private final MoonPhases.MoonCondition moonCondition;

    public boolean isSpecial() {
        return true;
    }

    public MixingCauldronRecipe(ItemStack output, NonNullList<Ingredient> recipeItems, FluidStack fluid, FluidStack fluidOutput, FluidMixingRecipe.HeatCondition heatCondition, MoonPhases.MoonCondition moonCondition) {
        this.output = output;
        this.recipeItems = recipeItems;
        this.fluid = fluid;
        this.fluidOutput = fluidOutput;
        this.heatCondition = heatCondition;
        this.moonCondition = moonCondition;
    }

    public static MixingCauldronRecipeInput createInput(List<ItemStack> items) {
        return new MixingCauldronRecipeInput(items);
    }

    public List<FluidIngredient> getFluidIngredients() {
        return new ArrayList<FluidIngredient>(List.of(FluidIngredient.of((FluidStack[])new FluidStack[]{this.fluid})));
    }

    public FluidIngredient getFluidIngredient() {
        return FluidIngredient.of((FluidStack[])new FluidStack[]{this.fluid});
    }

    public boolean matches(MixingCauldronRecipeInput inv, Level worldIn) {
        List itemMatchesSlot = Stream.generate(() -> false).limit(inv.size()).collect(Collectors.toList());
        boolean flag = false;
        for (Ingredient recipeItem : this.recipeItems) {
            for (int i = 0; i < inv.size(); ++i) {
                if (!recipeItem.test(inv.getItem(i)) || ((Boolean)itemMatchesSlot.get(i)).booleanValue()) continue;
                itemMatchesSlot.set(i, true);
                flag = true;
                break;
            }
            if (!flag) break;
            flag = false;
        }
        for (int i = 0; i < inv.size(); ++i) {
            if (((Boolean)itemMatchesSlot.get(i)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public ItemStack assemble(MixingCauldronRecipeInput inv, HolderLookup.Provider registryAccess) {
        ItemStack outputCopy = this.output.copy();
        if (outputCopy.is(ModItems.ENTANGLED_COFFER)) {
            ItemStack coffer = null;
            for (int i = 0; i < inv.size(); ++i) {
                if (!inv.getItem(i).is(ModItems.COFFER)) continue;
                coffer = inv.getItem(i);
                break;
            }
            if (coffer != null) {
                CompoundTag tag = ((CustomData)coffer.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                CompoundTag tag2 = ((CustomData)outputCopy.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                if (!tag.contains("CofferId")) {
                    tag.putUUID("CofferId", UUID.randomUUID());
                }
                outputCopy.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag.merge(tag2)));
                if (coffer.has(DataComponents.DYED_COLOR) && ((DyedItemColor)coffer.getOrDefault(DataComponents.DYED_COLOR, (Object)new DyedItemColor(4337438, true))).rgb() != 4337438) {
                    outputCopy.set(DataComponents.DYED_COLOR, (Object)((DyedItemColor)coffer.get(DataComponents.DYED_COLOR)));
                }
            }
        }
        return outputCopy;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.getOutput();
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public FluidMixingRecipe.HeatCondition getHeatCondition() {
        return this.heatCondition;
    }

    public MoonPhases.MoonCondition getMoonCondition() {
        return this.moonCondition;
    }

    public FluidStack getLiquid() {
        return this.fluid.copy();
    }

    public FluidStack getLiquidOutput() {
        return this.fluidOutput.isEmpty() ? this.fluid.copy() : this.fluidOutput.copy();
    }

    public int getFluidLevelsConsumed() {
        return this.getLiquidOutput().getAmount();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.MIXING_CAULDRON.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.MIXING_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class MixingCauldronRecipeInput
    implements RecipeInput {
        private final List<ItemStack> items;
        private final StackedContents stackedContents = new StackedContents();

        public MixingCauldronRecipeInput(List<ItemStack> item) {
            this.items = item;
            for (ItemStack itemstack : item) {
                if (itemstack.isEmpty()) continue;
                this.stackedContents.accountStack(itemstack, 1);
            }
        }

        public ItemStack getItem(int i) {
            return this.items.get(i);
        }

        public int size() {
            return this.items.size();
        }
    }

    public static class Type
    implements RecipeType<MixingCauldronRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<MixingCauldronRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<MixingCauldronRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)NonNullList.codecOf((Codec)Ingredient.CODEC).fieldOf("ingredients").forGetter(recipe -> recipe.recipeItems), (App)FluidStack.CODEC.fieldOf("fluid").forGetter(recipe -> recipe.fluid), (App)FluidStack.CODEC.optionalFieldOf("fluidOutput", (Object)FluidStack.EMPTY).forGetter(recipe -> recipe.fluidOutput), (App)FluidMixingRecipe.HeatCondition.CODEC.optionalFieldOf("heatRequirement", (Object)FluidMixingRecipe.HeatCondition.NONE).forGetter(recipe -> recipe.heatCondition), (App)MoonPhases.MoonCondition.CODEC.optionalFieldOf("moonRequirement", (Object)MoonPhases.MoonCondition.NONE).forGetter(recipe -> recipe.moonCondition)).apply((Applicative)instance, MixingCauldronRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, MixingCauldronRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<MixingCauldronRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MixingCauldronRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static MixingCauldronRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            NonNullList inputs = NonNullList.withSize((int)buffer.readInt(), (Object)Ingredient.EMPTY);
            inputs.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            FluidStack inputFluid = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
            FluidStack outputFluid = FluidStack.EMPTY;
            if (buffer.readBoolean()) {
                outputFluid = (FluidStack)FluidStack.STREAM_CODEC.decode((Object)buffer);
            }
            FluidMixingRecipe.HeatCondition heatCondition = (FluidMixingRecipe.HeatCondition)((Object)NeoForgeStreamCodecs.enumCodec(FluidMixingRecipe.HeatCondition.class).decode((Object)buffer));
            MoonPhases.MoonCondition moonCondition = (MoonPhases.MoonCondition)((Object)NeoForgeStreamCodecs.enumCodec(MoonPhases.MoonCondition.class).decode((Object)buffer));
            return new MixingCauldronRecipe(output, (NonNullList<Ingredient>)inputs, inputFluid, outputFluid, heatCondition, moonCondition);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, MixingCauldronRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            buffer.writeInt(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluid);
            buffer.writeBoolean(!recipe.fluidOutput.isEmpty());
            if (!recipe.fluidOutput.isEmpty()) {
                FluidStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.fluidOutput);
            }
            NeoForgeStreamCodecs.enumCodec(FluidMixingRecipe.HeatCondition.class).encode((Object)buffer, (Object)recipe.heatCondition);
            NeoForgeStreamCodecs.enumCodec(MoonPhases.MoonCondition.class).encode((Object)buffer, (Object)recipe.moonCondition);
        }
    }
}

