/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import mezz.jei.api.gui.drawable.IDrawable;
import net.joefoxe.hexerei.data.books.HexereiBookItem;
import net.joefoxe.hexerei.data.recipes.CrowFluteRecipe;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;

public class ExtraBookOfShadowsIcon
implements IDrawable {
    private Supplier<ItemStack> extraSupplier;
    private ItemStack extraStack;
    private boolean findNewRecipe;
    private Recipe<?> recipeShown;
    private List<CraftingRecipe> flute_recipe;
    private int color1 = 12686147;
    private int color2 = 11030626;
    private Random rand = new Random();

    public ExtraBookOfShadowsIcon(Supplier<ItemStack> secondary) {
        this.extraSupplier = secondary;
        this.findNewRecipe = true;
        if (Minecraft.getInstance().level != null) {
            List<CraftingRecipe> recipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING).stream().map(RecipeHolder::value).toList();
            this.flute_recipe = recipes.stream().filter(craftingRecipe -> craftingRecipe instanceof CrowFluteRecipe).toList();
        }
    }

    public int getWidth() {
        return 18;
    }

    public int getHeight() {
        return 18;
    }

    public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
        float timer;
        if (this.extraStack == null) {
            this.extraStack = this.extraSupplier.get();
        }
        if ((double)(timer = ClientEvents.getClientTicks() % 100.0f / 100.0f) <= 0.1 && this.findNewRecipe || this.recipeShown == null) {
            this.findNewRecipe = false;
            this.recipeShown = (Recipe)this.flute_recipe.get(new Random().nextInt(this.flute_recipe.size()));
            this.color1 = DyeColor.byId((int)this.rand.nextInt(DyeColor.values().length - 1)).getTextureDiffuseColor();
            this.color2 = DyeColor.byId((int)this.rand.nextInt(DyeColor.values().length - 1)).getTextureDiffuseColor();
        }
        if ((double)timer > 0.1) {
            this.findNewRecipe = true;
        }
        RenderSystem.enableDepthTest();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)xOffset, (float)yOffset, 0.0f);
        guiGraphics.pose().mulPose(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(9.0f, -9.0f, 9.0f);
        guiGraphics.pose().scale(20.0f, 20.0f, 20.0f);
        Vec3 rotationOffset = new Vec3(0.0, 0.0, 0.0);
        float zRot = 0.0f;
        float xRot = 20.0f;
        float yRot = 30.0f;
        guiGraphics.pose().translate(rotationOffset.x, rotationOffset.y, rotationOffset.z);
        guiGraphics.pose().translate(-rotationOffset.x, -rotationOffset.y, -rotationOffset.z);
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemStack stack = new ItemStack((ItemLike)ModItems.BOOK_OF_SHADOWS.get());
        ItemStack output_stack = HexereiBookItem.withColors(stack, this.color1, this.color2);
        this.renderItem(output_stack, (Level)Minecraft.getInstance().level, guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
        guiGraphics.pose().popPose();
        guiGraphics.pose().popPose();
        buffer.endBatch();
        RenderSystem.enableDepthTest();
        Lighting.setupFor3DItems();
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GUI, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    private void renderItemFixed(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.getModelRenderer().renderModel(poseStack.last(), p_110915_.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    poseStack.translate(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

