/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.data.recipes.FluidMixingRecipe;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.integration.jei.ExtraCauldronIcon;
import net.joefoxe.hexerei.tileentity.renderer.MixingCauldronRenderer;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class FluidMixingRecipeCategory
implements IRecipeCategory<FluidMixingRecipe> {
    public static final ResourceLocation UID = HexereiUtil.getResource("fluid_mixing");
    public static final ResourceLocation POTION_UID = HexereiUtil.getResource("potion_mixing");
    public static final ResourceLocation TEXTURE = HexereiUtil.getResource("textures/gui/fluid_mixing_gui_jei.png");
    public static final ResourceLocation TEXTURE_BLANK = HexereiUtil.getResource("textures/block/blank.png");
    private IDrawable background;
    private final IDrawable icon;
    private final IDrawable liquid;
    private final IDrawable cauldron;
    private final IDrawable output1;
    private final IDrawable output2;
    private Block heatSource;
    private boolean findNewHeatSource;
    private String type;

    public void getTooltip(ITooltipBuilder tooltip, FluidMixingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (recipe.getHeatCondition() != FluidMixingRecipe.HeatCondition.NONE && this.isHovering(mouseX, mouseY, 79.0, 59.0, 24.0, 18.0)) {
            tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.heat_source"));
            if (Screen.hasShiftDown()) {
                tooltip.add((FormattedText)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.recipe_heated_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.recipe_heated_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.recipe_heated_3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.recipe_heated_4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"Heat source shown: - %s", (Object[])new Object[]{Component.translatable((String)this.heatSource.getDescriptionId()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xCC5522)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                tooltip.add((FormattedText)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.hexerei.recipe_heated").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
        }
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public FluidMixingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 186, 109);
        this.icon = new ExtraCauldronIcon(() -> new ItemStack((ItemLike)Items.WATER_BUCKET));
        this.liquid = helper.createDrawable(TEXTURE, 208, 12, 16, 32);
        this.cauldron = helper.createDrawable(TEXTURE, 238, 50, 12, 10);
        this.output1 = helper.createDrawable(TEXTURE, 209, 64, 47, 82);
        this.output2 = helper.createDrawable(TEXTURE, 209, 146, 47, 82);
        this.heatSource = FluidMixingRecipeCategory.getTagStack(HexereiTags.Blocks.HEAT_SOURCES);
        this.type = "Fluid";
    }

    public FluidMixingRecipeCategory(IGuiHelper helper, String type) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 186, 109);
        this.type = type;
        this.icon = Objects.equals(this.type, "Potion") ? new ExtraCauldronIcon(() -> new ItemStack((ItemLike)Items.POTION), type) : new ExtraCauldronIcon(() -> new ItemStack((ItemLike)Items.WATER_BUCKET));
        this.liquid = helper.createDrawable(TEXTURE, 208, 12, 16, 32);
        this.cauldron = helper.createDrawable(TEXTURE, 238, 50, 12, 10);
        this.output1 = helper.createDrawable(TEXTURE, 209, 64, 47, 82);
        this.output2 = helper.createDrawable(TEXTURE, 209, 146, 47, 82);
        this.heatSource = FluidMixingRecipeCategory.getTagStack(HexereiTags.Blocks.HEAT_SOURCES);
    }

    public static Block getTagStack(TagKey<Block> key) {
        if (BuiltInRegistries.BLOCK.getTag(key).isPresent()) {
            Optional optional = ((HolderSet.Named)BuiltInRegistries.BLOCK.getTag(key).get()).getRandomElement(RandomSource.create());
            return (Block)optional.orElse(Holder.direct((Object)Blocks.AIR)).value();
        }
        return Blocks.AIR;
    }

    public RecipeType<FluidMixingRecipe> getRecipeType() {
        return new RecipeType(HexereiUtil.getResource(this.type.toLowerCase(Locale.ROOT) + "_mixing"), FluidMixingRecipe.class);
    }

    public Component getTitle() {
        return Component.translatable((String)("gui.jei.category." + (this.type + "_mixing").toLowerCase(Locale.ROOT)));
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidMixingRecipe recipe, IFocusGroup focuses) {
        builder.moveRecipeTransferButton(160, 90);
        builder.setShapeless();
        FluidStack input = recipe.getLiquid();
        FluidStack output = recipe.getLiquidOutput();
        input.setAmount(2000);
        output.setAmount(2000);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 152, 51).setFluidRenderer(2000L, true, 12, 10).setBackground(this.cauldron, 0, 0).setOverlay(this.cauldron, 0, 0).addFluidStack(recipe.getLiquidOutput().getFluid(), 2000L, recipe.getLiquidOutput().getComponentsPatch()).addRichTooltipCallback((recipeSlotView, tooltip) -> {
            ArrayList tooltips = new ArrayList();
            ((PotionContents)recipe.getLiquidOutput().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).addPotionTooltip(tooltips::add, 1.0f, 20.0f);
            tooltip.addAll(tooltips);
        });
        builder.addSlot(RecipeIngredientRole.INPUT, 20, 57).setFluidRenderer(2000L, false, 16, 32).setBackground(this.liquid, 0, 0).setOverlay(this.liquid, 0, 0).addFluidStack(recipe.getLiquid().getFluid(), 2000L, recipe.getLiquid().getComponentsPatch()).addRichTooltipCallback((recipeSlotView, tooltip) -> {
            ArrayList tooltips = new ArrayList();
            ((PotionContents)recipe.getLiquid().getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).addPotionTooltip(tooltips::add, 1.0f, 20.0f);
            tooltip.addAll(tooltips);
        });
        int size = recipe.getIngredients().size();
        if (size > 0) {
            builder.addSlot(RecipeIngredientRole.INPUT, 83, 18).addIngredients((Ingredient)recipe.getIngredients().get(0));
        }
        if (size > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 105, 27).addIngredients((Ingredient)recipe.getIngredients().get(1));
        }
        if (size > 2) {
            builder.addSlot(RecipeIngredientRole.INPUT, 114, 49).addIngredients((Ingredient)recipe.getIngredients().get(2));
        }
        if (size > 3) {
            builder.addSlot(RecipeIngredientRole.INPUT, 105, 71).addIngredients((Ingredient)recipe.getIngredients().get(3));
        }
        if (size > 4) {
            builder.addSlot(RecipeIngredientRole.INPUT, 83, 80).addIngredients((Ingredient)recipe.getIngredients().get(4));
        }
        if (size > 5) {
            builder.addSlot(RecipeIngredientRole.INPUT, 61, 71).addIngredients((Ingredient)recipe.getIngredients().get(5));
        }
        if (size > 6) {
            builder.addSlot(RecipeIngredientRole.INPUT, 52, 49).addIngredients((Ingredient)recipe.getIngredients().get(6));
        }
        if (size > 7) {
            builder.addSlot(RecipeIngredientRole.INPUT, 61, 27).addIngredients((Ingredient)recipe.getIngredients().get(7));
        }
    }

    public void draw(FluidMixingRecipe recipe, IRecipeSlotsView view, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        if (recipe.getHeatCondition() == FluidMixingRecipe.HeatCondition.HEATED || recipe.getHeatCondition() == FluidMixingRecipe.HeatCondition.SUPERHEATED) {
            boolean showOutput;
            FluidStack input = recipe.getLiquid();
            FluidStack output = recipe.getLiquidOutput();
            input.setAmount(2000);
            output.setAmount(2000);
            float newHeatSource = ClientEvents.getClientTicks() % 200.0f / 200.0f;
            float craftPercent = ClientEvents.getClientTicks() % 100.0f / 100.0f;
            boolean bl = showOutput = ClientEvents.getClientTicks() % 200.0f > 100.0f;
            if (newHeatSource <= 0.05f && this.findNewHeatSource || this.heatSource == null) {
                this.findNewHeatSource = false;
                if (Minecraft.getInstance().level != null) {
                    this.heatSource = FluidMixingRecipeCategory.getTagStack(HexereiTags.Blocks.HEAT_SOURCES);
                }
            }
            if (newHeatSource > 0.05f) {
                this.findNewHeatSource = true;
            }
            boolean compare = FluidStack.isSameFluidSameComponents((FluidStack)recipe.getLiquid(), (FluidStack)recipe.getLiquidOutput());
            Minecraft minecraft = Minecraft.getInstance();
            Component outputName = recipe.getLiquidOutput().getHoverName();
            int width = minecraft.font.width((FormattedText)outputName);
            Objects.requireNonNull(minecraft.font);
            float lineHeight = 9.0f / 2.0f;
            if (width > 131) {
                float percent = (float)width / 131.0f;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(1.0f / percent, 1.0f / percent, 1.0f / percent);
                minecraft.font.drawInBatch(outputName, 7.0f * percent, (5.0f + lineHeight) * percent - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                guiGraphics.pose().popPose();
            } else {
                minecraft.font.drawInBatch(outputName, 7.0f, 5.0f + lineHeight - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            BlockState blockState = (BlockState)((MixingCauldron)ModBlocks.MIXING_CAULDRON.get()).defaultBlockState().setValue((Property)MixingCauldron.GUI_RENDER, (Comparable)Boolean.valueOf(true));
            ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(75.0f, 67.0f, 100.0f);
            guiGraphics.pose().translate(8.0f, -8.0f, 0.0f);
            guiGraphics.pose().scale(16.0f, 16.0f, 16.0f);
            guiGraphics.pose().mulPose(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
            Vec3 rotationOffset = new Vec3(0.5, 0.0, 0.5);
            float zRot = 0.0f;
            float xRot = 20.0f;
            float yRot = 30.0f;
            guiGraphics.pose().translate(rotationOffset.x, rotationOffset.y, rotationOffset.z);
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(zRot));
            guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(xRot));
            guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(yRot));
            guiGraphics.pose().translate(-rotationOffset.x, -rotationOffset.y, -rotationOffset.z);
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            Lighting.setupFor3DItems();
            guiGraphics.pose().last().normal().rotate((Quaternionfc)Axis.YP.rotationDegrees(-45.0f));
            this.renderBlock(guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, blockState, -1);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, -1.0f, 0.0f);
            BlockState state = this.heatSource.defaultBlockState();
            Block block = state.getBlock();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                state = (BlockState)liquidBlock.fluid.defaultFluidState().createLegacyBlock().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(7));
                MixingCauldronRenderer.renderFluidBlockGUI(guiGraphics.pose(), (MultiBufferSource)buffer, new FluidStack((Fluid)liquidBlock.fluid, 2000), 1.0f, OverlayTexture.NO_OVERLAY);
            }
            this.renderBlock(guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, state, -1);
            guiGraphics.pose().popPose();
            float fillPercentage = 1.0f;
            if (!showOutput) {
                if (input.getFluid().is(Tags.Fluids.GASEOUS)) {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, input, fillPercentage, 1.0f, OverlayTexture.NO_OVERLAY);
                } else {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, input, 1.0f, fillPercentage, OverlayTexture.NO_OVERLAY);
                }
                float height = 0.25f + 0.6875f * fillPercentage;
                for (int i = 0; i < recipe.getIngredients().size(); ++i) {
                    ItemStack[] items = ((Ingredient)recipe.getIngredients().get(i)).getItems();
                    if (items.length <= 0 || items[(int)ClientEvents.getClientTicksWithoutPartial() / 40 % items.length].isEmpty()) continue;
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate(0.5, (double)(height + 0.00390625f), 0.5);
                    double itemRotationOffset = 0.8 * (double)i + (double)(craftPercent * (20.0f * craftPercent));
                    guiGraphics.pose().translate(0.0 + Math.sin(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f), Math.sin(Math.PI * (double)ClientEvents.getClientTicks() / 30.0 + (double)(i * 20)) / 10.0 * 0.2, 0.0 + Math.cos(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f));
                    guiGraphics.pose().mulPose(Axis.YP.rotationDegrees((float)((double)((float)(45 * i) - 1.0f) + 2.0 * Math.sin((ClientEvents.getClientTicks() + (float)(i * 20)) / 40.0f))));
                    guiGraphics.pose().mulPose(Axis.XP.rotationDegrees((float)(82.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + (float)(i * 22)) / 40.0f))));
                    guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees((float)(-2.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + (float)(i * 24)) / 40.0f))));
                    guiGraphics.pose().scale(1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f);
                    guiGraphics.pose().scale(0.4f, 0.4f, 0.4f);
                    this.renderItem(items[(int)ClientEvents.getClientTicksWithoutPartial() / 40 % items.length], (Level)minecraft.level, guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
                    guiGraphics.pose().popPose();
                }
            } else if (input.getFluid().is(Tags.Fluids.GASEOUS)) {
                MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, output, fillPercentage, 1.0f, OverlayTexture.NO_OVERLAY);
            } else {
                MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, output, 1.0f, fillPercentage, OverlayTexture.NO_OVERLAY);
            }
            guiGraphics.pose().popPose();
            Lighting.setupFor3DItems();
            buffer.endBatch();
            RenderSystem.enableDepthTest();
            if (!output.isEmpty() && (!recipe.getLiquid().getFluid().isSame(recipe.getLiquidOutput().getFluid()) || recipe.getLiquid().getFluid().isSame(recipe.getLiquidOutput().getFluid()) && !compare)) {
                this.output2.draw(guiGraphics, 138, 16);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(0.6f, 0.6f, 0.6f);
                minecraft.font.drawInBatch((Component)Component.translatable((String)"gui.jei.category.mixing_cauldron.convert_fluid"), 231.574f, 63.308f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                guiGraphics.pose().popPose();
            } else {
                this.output1.draw(guiGraphics, 138, 16);
            }
        } else {
            boolean flatLighting;
            boolean showOutput;
            FluidStack input = recipe.getLiquid();
            FluidStack output = recipe.getLiquidOutput();
            input.setAmount(2000);
            output.setAmount(2000);
            float newHeatSource = ClientEvents.getClientTicks() % 200.0f / 200.0f;
            float craftPercent = ClientEvents.getClientTicks() % 100.0f / 100.0f;
            boolean bl = showOutput = ClientEvents.getClientTicks() % 200.0f > 100.0f;
            if (newHeatSource <= 0.05f && this.findNewHeatSource || this.heatSource == null) {
                this.findNewHeatSource = false;
                if (Minecraft.getInstance().level != null) {
                    this.heatSource = FluidMixingRecipeCategory.getTagStack(HexereiTags.Blocks.HEAT_SOURCES);
                }
            }
            if (newHeatSource > 0.05f) {
                this.findNewHeatSource = true;
            }
            boolean compare = FluidStack.isSameFluidSameComponents((FluidStack)recipe.getLiquid(), (FluidStack)recipe.getLiquidOutput());
            Minecraft minecraft = Minecraft.getInstance();
            Component outputName = recipe.getLiquidOutput().getHoverName();
            int width = minecraft.font.width((FormattedText)outputName);
            Objects.requireNonNull(minecraft.font);
            float lineHeight = 9.0f / 2.0f;
            if (width > 131) {
                float percent = (float)width / 131.0f;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(1.0f / percent, 1.0f / percent, 1.0f / percent);
                minecraft.font.drawInBatch(outputName, 7.0f * percent, (5.0f + lineHeight) * percent - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                guiGraphics.pose().popPose();
            } else {
                minecraft.font.drawInBatch(outputName, 7.0f, 5.0f + lineHeight - 4.5f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            BlockState blockState = (BlockState)((MixingCauldron)ModBlocks.MIXING_CAULDRON.get()).defaultBlockState().setValue((Property)MixingCauldron.GUI_RENDER, (Comparable)Boolean.valueOf(true));
            ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
            BlockRenderDispatcher rendererer = Minecraft.getInstance().getBlockRenderer();
            rendererer.getBlockModel(blockState);
            BakedModel bakedModel = rendererer.getBlockModel(blockState);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(70.0f, 73.0f, 100.0f);
            guiGraphics.pose().translate(8.0f, -8.0f, 0.0f);
            guiGraphics.pose().scale(20.0f, 20.0f, 20.0f);
            guiGraphics.pose().mulPose(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
            Vec3 rotationOffset = new Vec3(0.0, 0.0, 0.0);
            float zRot = 0.0f;
            float xRot = 20.0f;
            float yRot = 30.0f;
            guiGraphics.pose().translate(rotationOffset.x, rotationOffset.y, rotationOffset.z);
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(zRot));
            guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(xRot));
            guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(yRot));
            guiGraphics.pose().translate(-rotationOffset.x, -rotationOffset.y, -rotationOffset.z);
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            boolean bl2 = flatLighting = !bakedModel.usesBlockLight();
            if (flatLighting) {
                Lighting.setupForFlatItems();
            }
            this.renderBlock(guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0, blockState, -12566464);
            float fillPercentage = 1.0f;
            if (!showOutput) {
                if (input.getFluid().is(Tags.Fluids.GASEOUS)) {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, input, fillPercentage, 1.0f, OverlayTexture.NO_OVERLAY);
                } else {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, input, 1.0f, fillPercentage, OverlayTexture.NO_OVERLAY);
                }
                float height = 0.25f + 0.6875f * fillPercentage;
                for (int i = 0; i < recipe.getIngredients().size(); ++i) {
                    ItemStack[] items = ((Ingredient)recipe.getIngredients().get(i)).getItems();
                    if (items.length <= 0 || items[(int)ClientEvents.getClientTicksWithoutPartial() / 40 % items.length].isEmpty()) continue;
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate(0.5, (double)(height + 0.00390625f), 0.5);
                    double itemRotationOffset = 0.8 * (double)i + (double)(craftPercent * (20.0f * craftPercent));
                    guiGraphics.pose().translate(0.0 + Math.sin(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f), Math.sin(Math.PI * (double)ClientEvents.getClientTicks() / 30.0 + (double)(i * 20)) / 10.0 * 0.2, 0.0 + Math.cos(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f));
                    guiGraphics.pose().mulPose(Axis.YP.rotationDegrees((float)((double)((float)(45 * i) - 1.0f) + 2.0 * Math.sin((ClientEvents.getClientTicks() + (float)(i * 20)) / 40.0f))));
                    guiGraphics.pose().mulPose(Axis.XP.rotationDegrees((float)(82.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + (float)(i * 22)) / 40.0f))));
                    guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees((float)(-2.5 + 5.0 * Math.cos((ClientEvents.getClientTicks() + (float)(i * 24)) / 40.0f))));
                    guiGraphics.pose().scale(1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f);
                    guiGraphics.pose().scale(0.4f, 0.4f, 0.4f);
                    this.renderItem(items[(int)ClientEvents.getClientTicksWithoutPartial() / 40 % items.length], (Level)minecraft.level, guiGraphics.pose(), (MultiBufferSource)buffer, 0xF000F0);
                    guiGraphics.pose().popPose();
                }
            } else if (input.getFluid().is(Tags.Fluids.GASEOUS)) {
                MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, output, fillPercentage, 1.0f, OverlayTexture.NO_OVERLAY);
            } else {
                MixingCauldronRenderer.renderFluidGUI(guiGraphics.pose(), (MultiBufferSource)buffer, output, 1.0f, fillPercentage, OverlayTexture.NO_OVERLAY);
            }
            buffer.endBatch();
            RenderSystem.enableDepthTest();
            if (flatLighting) {
                Lighting.setupFor3DItems();
            }
            guiGraphics.pose().popPose();
            if (!output.isEmpty() && (!recipe.getLiquid().getFluid().isSame(recipe.getLiquidOutput().getFluid()) || recipe.getLiquid().getFluid().isSame(recipe.getLiquidOutput().getFluid()) && !compare)) {
                this.output2.draw(guiGraphics, 138, 16);
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(0.6f, 0.6f, 0.6f);
                minecraft.font.drawInBatch((Component)Component.translatable((String)"gui.jei.category.mixing_cauldron.convert_fluid"), 231.574f, 63.308f, -12566464, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                guiGraphics.pose().popPose();
            } else {
                this.output1.draw(guiGraphics, 138, 16);
            }
        }
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.getModelRenderer().renderModel(poseStack.last(), p_110915_.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    poseStack.translate(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

