/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.joefoxe.hexerei.container.MixingCauldronContainer;
import net.joefoxe.hexerei.data.recipes.MixingCauldronRecipe;
import net.joefoxe.hexerei.integration.jei.MixingCauldronRecipeCategory;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.RecipeToServer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class MixingCauldronTransferInfo
implements IRecipeTransferHandler<MixingCauldronContainer, MixingCauldronRecipe> {
    private final IRecipeTransferHandlerHelper transferHandlerHelper;

    public MixingCauldronTransferInfo(IRecipeTransferHandlerHelper transferHandlerHelper) {
        this.transferHandlerHelper = transferHandlerHelper;
    }

    public Class<MixingCauldronContainer> getContainerClass() {
        return MixingCauldronContainer.class;
    }

    public Optional<MenuType<MixingCauldronContainer>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<MixingCauldronRecipe> getRecipeType() {
        return new RecipeType(MixingCauldronRecipeCategory.UID, MixingCauldronRecipe.class);
    }

    @Nullable
    public IRecipeTransferError transferRecipe(final MixingCauldronContainer container, MixingCauldronRecipe recipe, IRecipeSlotsView recipeSlots, Player pPlayer, boolean pMaxTransfer, boolean pDoTransfer) {
        List stacks = recipeSlots.getSlotViews();
        NonNullList convertedInput = NonNullList.withSize((int)(stacks.size() - 1), (Object)ItemStack.EMPTY);
        MixingCauldronTile inventory = (MixingCauldronTile)container.tileEntity;
        final ArrayList<Boolean> itemMatchesSlot = new ArrayList<Boolean>();
        for (int i = 0; i < 8; ++i) {
            itemMatchesSlot.add(i, false);
        }
        boolean flag = false;
        for (int j = 0; j < 8; ++j) {
            int i;
            Ingredient ingredient = (Ingredient)recipe.getIngredients().get(j);
            for (i = 0; i < 8; ++i) {
                if (!ingredient.test((ItemStack)inventory.items.get(i)) || ((Boolean)itemMatchesSlot.get(j)).booleanValue()) continue;
                itemMatchesSlot.set(j, true);
            }
            for (i = 0; i < 36; ++i) {
                if (!ingredient.test((ItemStack)pPlayer.getInventory().items.get(i)) || ((Boolean)itemMatchesSlot.get(j)).booleanValue()) continue;
                itemMatchesSlot.set(j, true);
            }
        }
        boolean allItemsMissing = true;
        for (int i = 0; i < 8; ++i) {
            if (!((Boolean)itemMatchesSlot.get(i)).booleanValue()) continue;
            allItemsMissing = false;
            break;
        }
        int check = 0;
        if (!allItemsMissing) {
            check = MixingCauldronTransferInfo.checkRecipe(stacks, inventory, pPlayer);
        }
        if (!pDoTransfer && check == 0) {
            return new IRecipeTransferError(){

                public IRecipeTransferError.Type getType() {
                    return IRecipeTransferError.Type.USER_FACING;
                }

                public void showError(GuiGraphics guiGraphics, int mouseX, int mouseY, IRecipeSlotsView recipeSlotsView, int recipeX, int recipeY) {
                    for (int i = 0; i < itemMatchesSlot.size(); ++i) {
                        if (((Boolean)itemMatchesSlot.get(i)).booleanValue()) continue;
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        Slot slot = (Slot)container.slots.get(i + 37);
                        guiGraphics.pose().pushPose();
                        guiGraphics.pose().translate(0.0f, 0.0f, 1000.0f);
                        guiGraphics.fill(recipeX + slot.x - 22, recipeY + slot.y + 1, recipeX + slot.x + 16 - 22, recipeY + slot.y + 1 + 16, 0x66FF0000);
                        guiGraphics.pose().popPose();
                    }
                    super.showError(guiGraphics, mouseX, mouseY, recipeSlotsView, recipeX, recipeY);
                }
            };
        }
        if (!pDoTransfer && check == 1) {
            return new IRecipeTransferError(){

                public IRecipeTransferError.Type getType() {
                    return IRecipeTransferError.Type.COSMETIC;
                }

                public void showError(GuiGraphics guiGraphics, int mouseX, int mouseY, IRecipeSlotsView recipeSlotsView, int recipeX, int recipeY) {
                    for (int i = 0; i < itemMatchesSlot.size(); ++i) {
                        boolean bool = (Boolean)itemMatchesSlot.get(i);
                        if (bool) continue;
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        Slot slot = (Slot)container.slots.get(i + 37);
                        guiGraphics.pose().pushPose();
                        guiGraphics.pose().translate(0.0f, 0.0f, 1000.0f);
                        guiGraphics.fill(recipeX + slot.x - 22, recipeY + slot.y + 1, recipeX + slot.x + 16 - 22, recipeY + slot.y + 1 + 16, 0x66FF0000);
                        guiGraphics.pose().popPose();
                    }
                    super.showError(guiGraphics, mouseX, mouseY, recipeSlotsView, recipeX, recipeY);
                }
            };
        }
        if (pDoTransfer && !MixingCauldronTransferInfo.transferRecipe(stacks, inventory, pPlayer)) {
            return () -> IRecipeTransferError.Type.USER_FACING;
        }
        return null;
    }

    public static int checkRecipe(List<IRecipeSlotView> guiIngredients, MixingCauldronTile blockEntity, Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 10; ++i) {
            items.add(ItemStack.EMPTY);
        }
        int j = 0;
        for (IRecipeSlotView slotView : guiIngredients) {
            Optional<ItemStack> stack = slotView.getAllIngredients().filter(t -> t.getType() == VanillaTypes.ITEM_STACK).map(t -> (ItemStack)t.getIngredient()).findFirst();
            if (stack.isPresent() && j != 9) {
                items.set(j - 1, stack.get());
            }
            ++j;
        }
        NonNullList<ItemStack> inv = blockEntity.items;
        ArrayList<Boolean> itemMatchesSlot = new ArrayList<Boolean>();
        for (int i = 0; i < 7; ++i) {
            itemMatchesSlot.add(i, false);
        }
        boolean matchesAtleastOne = false;
        for (ItemStack stack : player.getInventory().items) {
            for (int i = 0; i < 7; ++i) {
                if (((Boolean)itemMatchesSlot.get(i)).booleanValue() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)((ItemStack)items.get(i)))) continue;
                itemMatchesSlot.set(i, true);
                matchesAtleastOne = true;
            }
        }
        boolean matchesItems = true;
        Iterator iterator = itemMatchesSlot.iterator();
        while (iterator.hasNext()) {
            boolean bool = (Boolean)iterator.next();
            if (bool) continue;
            matchesItems = false;
            break;
        }
        return matchesItems ? 2 : (matchesAtleastOne ? 1 : 0);
    }

    public static boolean transferRecipe(List<IRecipeSlotView> IRecipeSlotViews, MixingCauldronTile blockEntity, Player player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 10; ++i) {
            items.add(ItemStack.EMPTY);
        }
        int j = 0;
        for (IRecipeSlotView slotView : IRecipeSlotViews) {
            Optional<ItemStack> stack = slotView.getAllIngredients().filter(t -> t.getType() == VanillaTypes.ITEM_STACK).map(t -> (ItemStack)t.getIngredient()).findFirst();
            if (stack.isPresent() && j != 9) {
                items.set(j - 1, stack.get());
            }
            ++j;
        }
        boolean matchesItems = false;
        NonNullList<ItemStack> inv = blockEntity.items;
        block2: for (ItemStack stack : player.getInventory().items) {
            if (matchesItems) break;
            for (ItemStack stack2 : items) {
                if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)stack2)) continue;
                matchesItems = true;
                continue block2;
            }
        }
        if (matchesItems) {
            HexereiPacketHandler.sendToServer(new RecipeToServer(items, blockEntity.getBlockPos(), player.getUUID()));
        }
        return matchesItems;
    }
}

