/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.ArrayList;
import java.util.List;
import net.joefoxe.hexerei.client.renderer.entity.BroomType;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.client.renderer.entity.model.BroomMediumSatchelModel;
import net.joefoxe.hexerei.item.custom.BroomItem;
import net.joefoxe.hexerei.item.custom.BroomTickableAttachmentItem;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BroomBrushItem
extends BroomTickableAttachmentItem {
    public Model model = null;
    public ResourceLocation texture;
    public ResourceLocation dye_texture;
    public List<Tuple<ParticleOptions, Integer>> list = null;

    public BroomBrushItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void tick(BroomEntity broom, ItemStack stack) {
        super.tick(broom, stack);
    }

    @Override
    public void renderParticles(BroomEntity broom, Level level, BroomEntity.Status status, RandomSource random) {
        BroomType broomType;
        Object object;
        if (this.list != null && (object = (broomType = broom.getBroomType()).item()) instanceof BroomItem) {
            BroomItem broomItem = (BroomItem)((Object)object);
            for (Tuple tuple : this.list) {
                ParticleOptions option = (ParticleOptions)tuple.getA();
                int delay = (Integer)tuple.getB();
                if (random.nextInt(delay) != 0) continue;
                float rotOffset = random.nextFloat() * 10.0f - 5.0f;
                level.addParticle(option, broom.xOld + broomItem.getBrushOffset().x() - Math.sin((double)((broom.getYRot() - 90.0f + rotOffset) / 180.0f) * Math.PI) * 1.25 + (double)(0.25f * random.nextFloat()) - 0.125, broom.yOld + broomItem.getBrushOffset().y() + (double)broom.floatingOffsetOld - broom.deltaMovementOld.y() + (double)(0.25f * random.nextFloat()), broom.zOld + broomItem.getBrushOffset().z() + Math.cos((double)((broom.getYRot() - 90.0f + rotOffset) / 180.0f) * Math.PI) * 1.25 + (double)(0.25f * random.nextFloat()) - 0.125, (random.nextDouble() - 0.5) * 0.015, (random.nextDouble() - 0.5) * 0.015, (random.nextDouble() - 0.5) * 0.015);
            }
        }
    }

    public boolean shouldGlow(@Nullable Level level, ItemStack brushStack) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void bakeModels() {
        EntityModelSet context = Minecraft.getInstance().getEntityModels();
        this.model = new BroomMediumSatchelModel(context.bakeLayer(BroomMediumSatchelModel.LAYER_LOCATION));
        this.texture = HexereiUtil.getResource("textures/entity/broom_satchel.png");
        this.dye_texture = HexereiUtil.getResource("textures/entity/broom_satchel_dye.png");
        this.list = new ArrayList<Tuple<ParticleOptions, Integer>>();
        this.list.add((Tuple<ParticleOptions, Integer>)new Tuple((Object)((ParticleOptions)ModParticleTypes.BROOM.get()), (Object)50));
        this.list.add((Tuple<ParticleOptions, Integer>)new Tuple((Object)((ParticleOptions)ModParticleTypes.BROOM_2.get()), (Object)20));
        this.list.add((Tuple<ParticleOptions, Integer>)new Tuple((Object)((ParticleOptions)ModParticleTypes.BROOM_3.get()), (Object)80));
        this.list.add((Tuple<ParticleOptions, Integer>)new Tuple((Object)((ParticleOptions)ModParticleTypes.BROOM_4.get()), (Object)500));
        this.list.add((Tuple<ParticleOptions, Integer>)new Tuple((Object)((ParticleOptions)ModParticleTypes.BROOM_5.get()), (Object)500));
        this.list.add((Tuple<ParticleOptions, Integer>)new Tuple((Object)((ParticleOptions)ModParticleTypes.BROOM_6.get()), (Object)500));
    }

    public float getSpeedModifier() {
        return 0.0f;
    }

    public float getSpeedModifier(BroomEntity broom) {
        return this.getSpeedModifier();
    }
}

