/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.joefoxe.hexerei.client.renderer.IFirstPersonItemAnimation;
import net.joefoxe.hexerei.client.renderer.IThirdPersonItemAnimation;
import net.joefoxe.hexerei.client.renderer.IThirdPersonItemRenderer;
import net.joefoxe.hexerei.client.renderer.TwoHandedItemAnimation;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.container.CrowFluteContainer;
import net.joefoxe.hexerei.item.ModDataComponents;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.data_components.FluteData;
import net.joefoxe.hexerei.sounds.ModSounds;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.CrowFluteClearCrowListToServer;
import net.joefoxe.hexerei.util.message.CrowFluteClearCrowPerchToServer;
import net.joefoxe.hexerei.util.message.CrowFluteCommandModeSyncToServer;
import net.joefoxe.hexerei.util.message.CrowFluteCommandSyncToServer;
import net.joefoxe.hexerei.util.message.CrowFluteHelpCommandSyncToServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import org.jetbrains.annotations.Nullable;

public class CrowFluteItem
extends Item
implements IThirdPersonItemAnimation,
IThirdPersonItemRenderer,
IFirstPersonItemAnimation {
    protected final Predicate<CrowEntity> targetEntitySelector = input -> true;
    private static final Predicate<Entity> field_219989_a = EntitySelector.NO_SPECTATORS.and(Entity::canBeCollidedWith);
    public int commandSelected = 0;
    public int helpCommandSelected = 0;

    public CrowFluteItem(Item.Properties properties) {
        super(properties);
    }

    protected AABB getTargetableArea(double targetDistance, Entity entity) {
        Vec3 renderCenter = new Vec3(entity.getX(), entity.getY(), entity.getZ());
        AABB aabb = new AABB(-targetDistance, -targetDistance, -targetDistance, targetDistance, targetDistance, targetDistance);
        return aabb.move(renderCenter);
    }

    public void inventoryTick(ItemStack itemstack, Level level, Entity entity, int slotId, boolean isSelected) {
        FluteData data = (FluteData)itemstack.get(ModDataComponents.FLUTE);
        if (data == null) {
            data = FluteData.empty();
            itemstack.set(ModDataComponents.FLUTE, (Object)data);
        }
        if (!level.isClientSide) {
            List<FluteData.CrowIds> list = data.crowList();
            ArrayList<FluteData.CrowIds> newList = new ArrayList<FluteData.CrowIds>();
            boolean flag = false;
            for (FluteData.CrowIds crowIds : list) {
                Entity crow = ((ServerLevel)level).getEntity(crowIds.uuid());
                if (!(crow instanceof CrowEntity) || crow.getId() == crowIds.id()) continue;
                newList.add(new FluteData.CrowIds(crowIds.uuid(), crow.getId()));
                flag = true;
            }
            if (flag) {
                FluteData newData = new FluteData(data.commandSelected(), data.helpCommandSelected(), data.commandMode(), newList, data.dyeColor1(), data.dyeColor2());
                itemstack.set(ModDataComponents.FLUTE, (Object)newData);
            }
        }
        super.inventoryTick(itemstack, level, entity, slotId, isSelected);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        ItemStack itemstack = ctx.getItemInHand();
        FluteData fluteData = (FluteData)itemstack.get(ModDataComponents.FLUTE);
        if (player != null && !player.isShiftKeyDown() && fluteData != null && fluteData.commandMode() == 2) {
            ArrayList<CrowEntity> crows = new ArrayList<CrowEntity>();
            List<FluteData.CrowIds> ids = fluteData.crowList();
            if (ids.isEmpty()) {
                return InteractionResult.FAIL;
            }
            if (!player.level().isClientSide) {
                List<FluteData.CrowIds> newIds = ids.stream().filter(crowIds -> ((ServerLevel)player.level()).getEntity(crowIds.uuid()) instanceof CrowEntity).toList();
                fluteData = new FluteData(fluteData.commandSelected(), fluteData.helpCommandSelected(), fluteData.commandMode(), newIds, fluteData.dyeColor1(), fluteData.dyeColor2());
                for (FluteData.CrowIds crowIds2 : newIds) {
                    Entity entity = ((ServerLevel)player.level()).getEntity(crowIds2.uuid());
                    if (!(entity instanceof CrowEntity)) continue;
                    CrowEntity crow = (CrowEntity)entity;
                    crows.add(crow);
                    crow.setPerchPos(ctx.getClickedPos());
                }
                if (!crows.isEmpty()) {
                    player.level().playSound(null, player.getX() + player.getLookAngle().x(), player.getY() + (double)player.getEyeHeight(), player.getZ() + player.getLookAngle().z(), (SoundEvent)ModSounds.CROW_FLUTE.get(), SoundSource.PLAYERS, 1.0f, 0.8f + 0.4f * new Random().nextFloat());
                    player.getCooldowns().addCooldown((Item)this, 20);
                }
                itemstack.set(ModDataComponents.FLUTE, (Object)fluteData);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }

    public static ItemStack withColors(int color1, int color2) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.CROW_FLUTE.get());
        stack.set(ModDataComponents.FLUTE, (Object)new FluteData(0, 0, 0, new ArrayList<FluteData.CrowIds>(), color1, color2));
        return stack;
    }

    public static DyeColor getColor1(ItemStack stack) {
        DyeColor col = HexereiUtil.getDyeColorNamed(stack.getHoverName().getString(), 0);
        FluteData fluteData = (FluteData)stack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY);
        return col == null ? DyeColor.byId((int)fluteData.dyeColor1()) : col;
    }

    public static DyeColor getColor2(ItemStack stack) {
        DyeColor col = HexereiUtil.getDyeColorNamed(stack.getHoverName().getString(), 0);
        FluteData fluteData = (FluteData)stack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY);
        return col == null ? DyeColor.byId((int)fluteData.dyeColor2()) : col;
    }

    public boolean isFoil(ItemStack stack) {
        int commandMode = ((FluteData)stack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY)).commandMode();
        return commandMode == 2 || commandMode == 1;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.NONE;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand handIn) {
        BlockHitResult raytraceresult;
        ItemStack itemstack = player.getItemInHand(handIn);
        player.startUsingItem(handIn);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            FluteData fluteData = (FluteData)itemstack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY);
            if (player.isShiftKeyDown()) {
                List<FluteData.CrowIds> newIds = fluteData.crowList().stream().filter(crowIds -> ((ServerLevel)player.level()).getEntity(crowIds.uuid()) instanceof CrowEntity).toList();
                fluteData = new FluteData(fluteData.commandSelected(), fluteData.helpCommandSelected(), fluteData.commandMode(), newIds, fluteData.dyeColor1(), fluteData.dyeColor2());
                itemstack.set(ModDataComponents.FLUTE, (Object)fluteData);
                MenuProvider containerProvider = this.createContainerProvider(itemstack, handIn);
                serverPlayer.openMenu(containerProvider, b -> b.writeInt(handIn == InteractionHand.MAIN_HAND ? 0 : 1));
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (fluteData.commandMode() == 0) {
                List<FluteData.CrowIds> newIds = fluteData.crowList().stream().filter(crowIds -> ((ServerLevel)player.level()).getEntity(crowIds.uuid()) instanceof CrowEntity).toList();
                fluteData = new FluteData(fluteData.commandSelected(), fluteData.helpCommandSelected(), fluteData.commandMode(), newIds, fluteData.dyeColor1(), fluteData.dyeColor2());
                List<CrowEntity> crows = new ArrayList<CrowEntity>();
                for (FluteData.CrowIds crowIds2 : fluteData.crowList()) {
                    crows.add((CrowEntity)((ServerLevel)player.level()).getEntity(crowIds2.uuid()));
                }
                if (crows.isEmpty()) {
                    crows = level.getEntitiesOfClass(CrowEntity.class, this.getTargetableArea(64.0, (Entity)player), this.targetEntitySelector);
                    crows.removeIf(crow -> !crow.isOwnedBy((LivingEntity)player));
                }
                if (!crows.isEmpty()) {
                    int selected = fluteData.commandSelected();
                    if (selected == 0) {
                        player.displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_flute_set_message", (Object[])new Object[]{crows.size(), crows.size() > 1 ? "s" : "", Component.translatable((String)"entity.hexerei.crow_command_gui_0")}), true);
                        for (CrowEntity crow2 : crows) {
                            if (!crow2.isOwnedBy((LivingEntity)player)) continue;
                            crow2.setCommandFollow();
                        }
                    } else if (selected == 1) {
                        player.displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_flute_set_message", (Object[])new Object[]{crows.size(), crows.size() > 1 ? "s" : "", Component.translatable((String)"entity.hexerei.crow_command_gui_1")}), true);
                        for (CrowEntity crow3 : crows) {
                            if (!crow3.isOwnedBy((LivingEntity)player)) continue;
                            crow3.setCommandSit();
                        }
                    } else if (selected == 2) {
                        player.displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_flute_set_message", (Object[])new Object[]{crows.size(), crows.size() > 1 ? "s" : "", Component.translatable((String)"entity.hexerei.crow_command_gui_2")}), true);
                        for (CrowEntity crow4 : crows) {
                            if (!crow4.isOwnedBy((LivingEntity)player)) continue;
                            crow4.setCommandWander();
                        }
                    } else if (selected == 3) {
                        player.displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_flute_set_message", (Object[])new Object[]{crows.size(), crows.size() > 1 ? "s" : "", Component.translatable((String)"entity.hexerei.crow_command_gui_3")}).append(" (").append((Component)Component.translatable((String)("entity.hexerei.crow_help_command_gui_" + ((FluteData)itemstack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY)).helpCommandSelected()))).append(")"), true);
                        for (CrowEntity crow5 : crows) {
                            if (!crow5.isOwnedBy((LivingEntity)player)) continue;
                            crow5.setHelpCommand(((FluteData)itemstack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY)).helpCommandSelected());
                            crow5.setCommandHelp();
                        }
                    }
                }
                level.playSound(null, player.getX() + player.getLookAngle().x(), player.getY() + (double)player.getEyeHeight(), player.getZ() + player.getLookAngle().z(), (SoundEvent)ModSounds.CROW_FLUTE.get(), SoundSource.PLAYERS, 1.0f, 0.8f + 0.4f * new Random().nextFloat());
                player.getCooldowns().addCooldown((Item)this, 20);
                return InteractionResultHolder.success((Object)itemstack);
            }
            if (((FluteData)itemstack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY)).commandMode() == 1) {
                BlockHitResult raytraceresult2 = CrowFluteItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                if (raytraceresult2.getType() == HitResult.Type.ENTITY) {
                    boolean bl;
                    Vec3 vector3d = player.getLookAngle();
                    List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(vector3d.scale(5.0)).inflate(1.0), field_219989_a);
                    boolean bl2 = false;
                    for (Entity entity : list) {
                        if (!(entity instanceof CrowEntity) || !((CrowEntity)entity).isOwnedBy((LivingEntity)player)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) return InteractionResultHolder.fail((Object)itemstack);
                    player.getCooldowns().addCooldown((Item)this, 5);
                    return InteractionResultHolder.fail((Object)itemstack);
                } else {
                    player.getCooldowns().addCooldown((Item)this, 5);
                }
                return InteractionResultHolder.fail((Object)itemstack);
            } else {
                if (((FluteData)itemstack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY)).commandMode() != 2) return InteractionResultHolder.fail((Object)itemstack);
                BlockHitResult raytraceresult3 = CrowFluteItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                if (raytraceresult3.getType() == HitResult.Type.BLOCK) {
                    if (!((FluteData)itemstack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY)).crowList().isEmpty()) return InteractionResultHolder.success((Object)itemstack);
                    player.displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_flute_perch_message_fail_no_crows"), true);
                    player.getCooldowns().addCooldown((Item)this, 5);
                    return InteractionResultHolder.fail((Object)itemstack);
                } else {
                    player.getCooldowns().addCooldown((Item)this, 5);
                }
            }
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (player.isShiftKeyDown()) return InteractionResultHolder.success((Object)itemstack);
        if (((FluteData)itemstack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY)).commandMode() == 1) {
            raytraceresult = CrowFluteItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
            if (raytraceresult.getType() != HitResult.Type.ENTITY) {
                player.displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_flute_select_message_fail"), true);
                player.playSound((SoundEvent)ModSounds.CROW_FLUTE_DESELECT.get(), 1.0f, 0.1f);
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (raytraceresult.getType() == HitResult.Type.ENTITY) {
                Vec3 vector3d = player.getLookAngle();
                List list = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(vector3d.scale(5.0)).inflate(1.0), field_219989_a);
                boolean flag = false;
                for (Entity entity : list) {
                    if (!(entity instanceof CrowEntity) || !((CrowEntity)entity).isOwnedBy((LivingEntity)player)) continue;
                    flag = true;
                    break;
                }
                if (flag) return InteractionResultHolder.success((Object)itemstack);
                player.displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_flute_select_message_fail"), true);
                player.playSound((SoundEvent)ModSounds.CROW_FLUTE_DESELECT.get(), 1.0f, 0.1f);
                return InteractionResultHolder.fail((Object)itemstack);
            }
        }
        if (((FluteData)itemstack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY)).commandMode() != 2) return InteractionResultHolder.success((Object)itemstack);
        raytraceresult = CrowFluteItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (raytraceresult.getType() != HitResult.Type.BLOCK) {
            player.displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_flute_perch_message_fail_no_block"), true);
            player.playSound((SoundEvent)ModSounds.CROW_FLUTE_DESELECT.get(), 1.0f, 0.1f);
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (!((FluteData)itemstack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY)).crowList().isEmpty()) return InteractionResultHolder.fail((Object)itemstack);
        player.displayClientMessage((Component)Component.translatable((String)"entity.hexerei.crow_flute_perch_message_fail_no_crows"), true);
        player.playSound((SoundEvent)ModSounds.CROW_FLUTE_DESELECT.get(), 1.0f, 0.1f);
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.crow_flute_shift_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.crow_flute_shift_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.crow_flute_shift_3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.crow_flute_shift_4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.crow_flute_shift_5").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            FluteData fluteData = (FluteData)stack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.EMPTY);
            String command = "";
            if (fluteData.commandMode() == 0) {
                if (fluteData.commandSelected() == 0) {
                    command = "entity.hexerei.crow_command_gui_0";
                }
                if (fluteData.commandSelected() == 1) {
                    command = "entity.hexerei.crow_command_gui_1";
                }
                if (fluteData.commandSelected() == 2) {
                    command = "entity.hexerei.crow_command_gui_2";
                }
                if (fluteData.commandSelected() == 3) {
                    if (fluteData.helpCommandSelected() == 0) {
                        command = "entity.hexerei.crow_help_command_gui_0";
                    }
                    if (fluteData.helpCommandSelected() == 1) {
                        command = "entity.hexerei.crow_help_command_gui_1";
                    }
                    if (fluteData.helpCommandSelected() == 2) {
                        command = "entity.hexerei.crow_help_command_gui_2";
                    }
                }
            } else if (fluteData.commandMode() == 1) {
                command = "entity.hexerei.crow_flute_perch";
            } else if (fluteData.commandMode() == 2) {
                command = "entity.hexerei.crow_flute_select";
            }
            tooltipComponents.add((Component)Component.translatable((String)"-%s-", (Object[])new Object[]{Component.translatable((String)command).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static void setCommand(int command, ItemStack stack, Player player, InteractionHand hand) {
        if (player.level().isClientSide) {
            HexereiPacketHandler.sendToServer(new CrowFluteCommandSyncToServer(stack, command, player.getUUID(), hand == InteractionHand.MAIN_HAND ? 0 : 1));
        }
    }

    public static void setHelpCommand(int helpCommand, ItemStack stack, Player player, InteractionHand hand) {
        if (player.level().isClientSide) {
            HexereiPacketHandler.sendToServer(new CrowFluteHelpCommandSyncToServer(stack, helpCommand, player.getUUID(), hand == InteractionHand.MAIN_HAND ? 0 : 1));
        }
    }

    public static void setCommandMode(int mode, ItemStack stack, Player player, InteractionHand hand) {
        if (player.level().isClientSide) {
            HexereiPacketHandler.sendToServer(new CrowFluteCommandModeSyncToServer(stack, mode, player.getUUID(), hand == InteractionHand.MAIN_HAND ? 0 : 1));
        }
    }

    public static void clearCrowList(ItemStack stack, Player player, InteractionHand hand) {
        if (player.level().isClientSide) {
            HexereiPacketHandler.sendToServer(new CrowFluteClearCrowListToServer(stack, player.getUUID(), hand == InteractionHand.MAIN_HAND ? 0 : 1));
        }
    }

    public static void clearCrowPerch(ItemStack stack, Player player, InteractionHand hand) {
        if (player.level().isClientSide) {
            HexereiPacketHandler.sendToServer(new CrowFluteClearCrowPerchToServer(stack, player.getUUID(), hand == InteractionHand.MAIN_HAND ? 0 : 1));
        }
    }

    private MenuProvider createContainerProvider(final ItemStack itemStack, final InteractionHand hand) {
        return new MenuProvider(){

            @Nullable
            public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                return new CrowFluteContainer(windowId, inv, player, hand);
            }

            public Component getDisplayName() {
                MutableComponent mutablecomponent = Component.translatable((String)"").append(itemStack.getHoverName());
                return mutablecomponent;
            }
        };
    }

    public static float wrapRad(float pValue) {
        float p = (float)Math.PI * 2;
        float d0 = pValue % p;
        if ((double)d0 >= Math.PI) {
            d0 -= p;
        }
        if ((double)d0 < -Math.PI) {
            d0 += p;
        }
        return d0;
    }

    @Override
    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand, TwoHandedItemAnimation twoHanded) {
        if (entity.getUseItemRemainingTicks() > 0 && entity.getUseItem().getItem() == this) {
            this.animateHands(model, entity, false);
            twoHanded.bool = true;
            return true;
        }
        return false;
    }

    @Override
    public <T extends LivingEntity> boolean poseRightArmMixin(ItemStack stack, AgeableListModel<T> model, T entity, HumanoidArm mainHand, TwoHandedItemAnimation twoHanded) {
        return IThirdPersonItemAnimation.super.poseRightArmMixin(stack, model, entity, mainHand, twoHanded);
    }

    @Override
    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand, TwoHandedItemAnimation twoHanded) {
        if (entity.getUseItemRemainingTicks() > 0 && entity.getUseItem().getItem() == this) {
            this.animateHands(model, entity, true);
            twoHanded.bool = true;
            return true;
        }
        return false;
    }

    @Override
    public <T extends LivingEntity> boolean poseleftArmMixin(ItemStack stack, AgeableListModel<T> model, T entity, HumanoidArm mainHand, TwoHandedItemAnimation twoHanded) {
        return IThirdPersonItemAnimation.super.poseleftArmMixin(stack, model, entity, mainHand, twoHanded);
    }

    @Override
    public boolean isTwoHanded() {
        return IThirdPersonItemAnimation.super.isTwoHanded();
    }

    private <T extends LivingEntity> void animateHands(HumanoidModel<T> model, T entity, boolean leftHand) {
        float yRot;
        ModelPart mainHand = leftHand ? model.leftArm : model.rightArm;
        ModelPart offHand = leftHand ? model.rightArm : model.leftArm;
        Vec3 bx = new Vec3(1.0, 0.0, 0.0);
        Vec3 by = new Vec3(0.0, 1.0, 0.0);
        Vec3 bz = new Vec3(0.0, 0.0, 1.0);
        float headXRot = CrowFluteItem.wrapRad(model.head.xRot);
        float headYRot = CrowFluteItem.wrapRad(model.head.yRot);
        float downFacingRot = Mth.clamp((float)headXRot, (float)0.0f, (float)0.8f);
        float xRot = CrowFluteItem.getMaxHeadXRot(headXRot) - (entity.isCrouching() ? 1.0f : 0.0f) - 0.3f + downFacingRot * 0.5f;
        bx = bx.xRot(xRot);
        by = by.xRot(xRot);
        bz = bz.xRot(xRot);
        Vec3 armVec = new Vec3(0.0, 0.0, 1.0);
        float mirror = leftHand ? 1.0f : -1.0f;
        armVec = armVec.yRot(-0.99f * mirror);
        Vec3 newV = bx.scale(armVec.x).add(by.scale(armVec.y)).add(bz.scale(armVec.z));
        float yaw = (float)Math.atan2(-newV.x, newV.z);
        float len = (float)newV.length();
        float pitch = (float)Math.asin(newV.y / (double)len);
        mainHand.yRot = yRot = yaw + headYRot * 0.8f - 1.6f * mirror - 0.5f * downFacingRot * mirror;
        mainHand.xRot = (float)((double)pitch - 1.5707963267948966);
        offHand.yRot = yRot;
        offHand.xRot = CrowFluteItem.wrapRad(mainHand.xRot - 0.06f);
        float offset = leftHand ? -Mth.clamp((float)headYRot, (float)-1.0f, (float)0.0f) : Mth.clamp((float)headYRot, (float)0.0f, (float)1.0f);
        mainHand.z = -offset * 0.95f;
        AnimationUtils.bobModelPart((ModelPart)model.leftArm, (float)entity.tickCount, (float)1.0f);
        AnimationUtils.bobModelPart((ModelPart)model.rightArm, (float)entity.tickCount, (float)-1.0f);
    }

    public static float getMaxHeadXRot(float xRot) {
        return Mth.clamp((float)xRot, (float)-1.2566371f, (float)1.5707964f);
    }

    @Override
    public <T extends Player, M extends EntityModel<T> & HeadedModel> void renderThirdPersonItem(M parentModel, LivingEntity entity, ItemStack stack, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        if (!stack.isEmpty()) {
            ItemDisplayContext transform;
            boolean leftHand;
            poseStack.pushPose();
            boolean bl = leftHand = humanoidArm == HumanoidArm.LEFT;
            if (entity.getUseItem() == stack) {
                ModelPart head = ((HeadedModel)parentModel).getHead();
                float oldRot = head.xRot;
                head.xRot = CrowFluteItem.getMaxHeadXRot(CrowFluteItem.wrapRad(oldRot));
                poseStack.translate(head.x / 16.0f, head.y / 16.0f, head.z / 16.0f);
                if (head.zRot != 0.0f) {
                    poseStack.mulPose(Axis.ZP.rotation(head.zRot / 1.75f));
                }
                if (head.yRot != 0.0f) {
                    poseStack.mulPose(Axis.YP.rotation(head.yRot));
                }
                if (head.xRot != 0.0f) {
                    poseStack.mulPose(Axis.XP.rotation(head.xRot / 1.75f));
                }
                head.xRot = oldRot;
                CustomHeadLayer.translateToHead((PoseStack)poseStack, (boolean)false);
                poseStack.translate((float)(leftHand ? -1 : 1) * 4.0f / 16.0f, -0.375f, -0.75f);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f + head.yRot * ((float)Math.PI * 2) * 10.0f + (float)((leftHand ? -1 : 1) * 10)));
                poseStack.mulPose(Axis.ZP.rotationDegrees((float)((leftHand ? 1 : -1) * 23)));
                poseStack.mulPose(Axis.XP.rotationDegrees((float)((leftHand ? 1 : 0) * -90)));
                poseStack.translate(0.0f, 0.4375f, 0.5f);
                transform = ItemDisplayContext.HEAD;
            } else {
                ((ArmedModel)parentModel).translateToHand(humanoidArm, poseStack);
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.translate((double)((float)(leftHand ? -1 : 1) / 16.0f), 0.125, -0.625);
                transform = leftHand ? ItemDisplayContext.THIRD_PERSON_LEFT_HAND : ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
            }
            Minecraft.getInstance().gameRenderer.itemInHandRenderer.renderItem(entity, stack, transform, leftHand, poseStack, bufferSource, light);
            poseStack.popPose();
        }
    }

    @Override
    public void animateItemFirstPerson(LivingEntity entity, ItemStack stack, InteractionHand hand, PoseStack matrixStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (entity.isUsingItem() && entity.getUseItemRemainingTicks() > 0 && entity.getUsedItemHand() == hand) {
            int mirror = entity.getMainArm() == HumanoidArm.RIGHT ^ hand == InteractionHand.MAIN_HAND ? -1 : 1;
            matrixStack.translate(-0.4 * (double)mirror, 0.2, 0.0);
            float timeLeft = (float)stack.getUseDuration(entity) - ((float)entity.getUseItemRemainingTicks() - partialTicks + 1.0f);
            float sin = Mth.sin((float)((timeLeft - 0.1f) * 1.3f));
            matrixStack.translate(0.0f, sin * 0.0038f, 0.0f);
            matrixStack.mulPose(Axis.ZN.rotationDegrees(90.0f));
            matrixStack.scale(1.0f * (float)mirror, -1.0f * (float)mirror, -1.0f);
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="hexerei", bus=EventBusSubscriber.Bus.MOD)
    private static class ColorRegisterHandler {
        private ColorRegisterHandler() {
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerFluteColors(RegisterColorHandlersEvent.Item event) {
            ItemHandlerConsumer items = (arg_0, arg_1) -> ((ItemColors)event.getItemColors()).register(arg_0, arg_1);
            items.register((s, t) -> t == 1 ? CrowFluteItem.getColor1(s).getTextureDiffuseColor() : (t == 2 ? CrowFluteItem.getColor2(s).getTextureDiffuseColor() : -1), (ItemLike)ModItems.CROW_FLUTE.get());
        }
    }

    public static interface ItemHandlerConsumer {
        public void register(ItemColor var1, ItemLike ... var2);
    }
}

