/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.Altar;
import net.joefoxe.hexerei.data.books.HexereiBookItem;
import net.joefoxe.hexerei.data.books.PageDrawing;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.item.ModDataComponents;
import net.joefoxe.hexerei.item.custom.CustomItemRenderer;
import net.joefoxe.hexerei.item.data_components.BookData;
import net.joefoxe.hexerei.tileentity.BookOfShadowsAltarTile;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;

public class HexereiBookItemRenderer
extends CustomItemRenderer {
    float degreesOpened;
    float degreesOpened2;
    float yPos;
    float xPos;
    float zPos;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderTileStuff(stack, transformType, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    public static BookOfShadowsAltarTile loadBlockEntityFromItem(ItemStack item) {
        if (item.getItem() instanceof HexereiBookItem) {
            BookOfShadowsAltarTile te = new BookOfShadowsAltarTile(BlockPos.ZERO, ((Altar)ModBlocks.BOOK_OF_SHADOWS_ALTAR.get()).defaultBlockState());
            te.itemHandler.setStackInSlot(0, item);
            return te;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTileStuff(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BookOfShadowsAltarTile altarTile = HexereiBookItemRenderer.loadBlockEntityFromItem(stack);
        if (altarTile == null) {
            return;
        }
        altarTile.tickCount = ClientEvents.getClientTicks();
        if (altarTile.itemHandler.getStackInSlot(0).getItem() instanceof HexereiBookItem) {
            BookData bookData = (BookData)stack.getOrDefault(ModDataComponents.BOOK, (Object)BookData.EMPTY);
            boolean isBookOfShadows = bookData.book().equals((Object)HexereiUtil.getResource("book_of_shadows"));
            this.yPos = 0.0f;
            this.xPos = 0.0f;
            this.zPos = 0.0f;
            this.degreesOpened2 = 0.0f;
            this.degreesOpened = 45.0f;
            matrixStackIn.pushPose();
            altarTile.degreesOpened = 90.0f;
            altarTile.degreesFlopped = 90.0f;
            if (bookData.isOpened()) {
                altarTile.degreesOpened = 18.0f;
                altarTile.degreesFlopped = 0.0f;
                this.degreesOpened = -10.0f;
                altarTile.degreesSpun = 270.0f;
            }
            altarTile.degreesSpunRender = altarTile.degreesSpun;
            altarTile.degreesFloppedRender = altarTile.degreesFlopped;
            altarTile.degreesOpenedRender = altarTile.degreesOpened;
            altarTile.pageOneRotationRender = altarTile.pageOneRotation;
            altarTile.pageTwoRotationRender = altarTile.pageTwoRotation;
            if (altarTile.degreesOpened != 90.0f) {
                altarTile.drawing.drawPages(altarTile, 0.0f, 0.0f, 0.0f, 0.0f, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, PageDrawing.DrawingType.GUI, transformType, ClientEvents.getPartial());
            }
            this.yPos = 0.0f;
            this.xPos = 0.0f;
            this.zPos = 0.0f;
            this.degreesOpened2 = 0.0f;
            this.degreesOpened = 45.0f;
            if (bookData.isOpened()) {
                altarTile.degreesOpened = 18.0f;
                altarTile.degreesFlopped = 0.0f;
                this.degreesOpened = -10.0f;
                altarTile.degreesSpun = 270.0f;
            } else {
                altarTile.degreesOpened = 90.0f;
                altarTile.degreesFlopped = 90.0f;
                if (transformType == ItemDisplayContext.GUI) {
                    this.yPos = 0.375f;
                    this.xPos = 0.125f;
                    this.zPos = -0.375f;
                    matrixStackIn.scale(1.35f, 1.35f, 1.35f);
                }
                if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
                    this.degreesOpened2 = 90.0f;
                    this.xPos = 0.25f;
                    this.zPos = -0.375f;
                }
                if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
                    this.degreesOpened2 = 90.0f;
                    this.xPos = 0.25f;
                    this.zPos = -0.03125f;
                }
            }
            altarTile.degreesSpunRender = altarTile.degreesSpun;
            altarTile.degreesFloppedRender = altarTile.degreesFlopped;
            altarTile.degreesOpenedRender = altarTile.degreesOpened;
            altarTile.pageOneRotationRender = altarTile.pageOneRotation;
            altarTile.pageTwoRotationRender = altarTile.pageTwoRotation;
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5f + this.xPos, 1.125f + this.yPos, 0.5f + this.zPos);
            matrixStackIn.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
            matrixStackIn.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpened / 2.0f + this.degreesOpened)));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(this.degreesOpened2));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
            matrixStackIn.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(altarTile.degreesOpenedRender - 90.0f));
            matrixStackIn.translate(0.03125f * (altarTile.degreesOpenedRender / 90.0f), 0.03125f * (1.0f - altarTile.degreesOpenedRender / 90.0f), 0.0f);
            DyeColor col = HexereiUtil.getDyeColorNamed(stack.getHoverName().getString());
            if (isBookOfShadows) {
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_COVER.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_COVER_CORNERS.get()).defaultBlockState(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
            } else {
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_COVER.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_COVER_CORNERS.get()).defaultBlockState(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
            }
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5f + this.xPos, 1.125f + this.yPos, 0.5f + this.zPos);
            matrixStackIn.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpenedRender / 5.0f - 12.0f));
            matrixStackIn.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpened / 2.0f + this.degreesOpened)));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(this.degreesOpened2));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
            matrixStackIn.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
            matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-(altarTile.degreesOpenedRender - 90.0f)));
            matrixStackIn.translate(-0.03125f * (altarTile.degreesOpenedRender / 90.0f), 0.03125f * (1.0f - altarTile.degreesOpenedRender / 90.0f), 0.0f);
            if (isBookOfShadows) {
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_BACK.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_BACK_CORNERS.get()).defaultBlockState(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
            } else {
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_BACK.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_BACK_CORNERS.get()).defaultBlockState(), col == null ? HexereiBookItem.getColor1(stack) : HexereiUtil.getColorValue(col));
            }
            matrixStackIn.popPose();
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5f + this.xPos, 1.125f + this.yPos, 0.5f + this.zPos);
            matrixStackIn.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f));
            matrixStackIn.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpened / 2.0f + this.degreesOpened)));
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(this.degreesOpened2));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
            matrixStackIn.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
            if (isBookOfShadows) {
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_BINDING.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
            } else {
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_BINDING.get()).defaultBlockState(), HexereiBookItem.getColor2(stack));
            }
            matrixStackIn.popPose();
            if (altarTile.degreesFloppedRender != 90.0f) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5f + this.xPos, 1.125f + this.yPos, 0.5f + this.zPos);
                matrixStackIn.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f));
                matrixStackIn.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpened / 2.0f + this.degreesOpened)));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(this.degreesOpened2));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
                matrixStackIn.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
                matrixStackIn.translate(0.0f, 0.03125f, 0.0f);
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(80.0f - altarTile.degreesOpened / 1.12f));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees((80.0f - altarTile.degreesOpened / 1.12f) / 90.0f * -altarTile.pageOneRotationRender));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees((80.0f - altarTile.degreesOpened / 1.12f) / 90.0f * (altarTile.pageTwoRotationRender / 16.0f)));
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_PAGE.get()).defaultBlockState());
                matrixStackIn.popPose();
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5f + this.xPos, 1.125f + this.yPos, 0.5f + this.zPos);
                matrixStackIn.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f));
                matrixStackIn.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpened / 2.0f + this.degreesOpened)));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(this.degreesOpened2));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
                matrixStackIn.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
                matrixStackIn.translate(0.0f, 0.03125f, 0.0f);
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(80.0f - altarTile.degreesOpened / 1.12f));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees((80.0f - altarTile.degreesOpened / 1.12f) / 90.0f * -altarTile.pageOneRotation));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees((80.0f - altarTile.degreesOpened / 1.12f) / 90.0f * (altarTile.pageTwoRotation / 16.0f)));
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_PAGE.get()).defaultBlockState());
                matrixStackIn.popPose();
            }
            if (altarTile.turnPage == 1 || altarTile.turnPage == -1) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5f + this.xPos, 1.125f + this.yPos, 0.5f + this.zPos);
                matrixStackIn.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f));
                matrixStackIn.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpened / 2.0f + this.degreesOpened)));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(this.degreesOpened2));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
                matrixStackIn.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
                matrixStackIn.translate(0.0f, 0.03125f, 0.0f);
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(80.0f - altarTile.degreesOpened / 1.12f));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees((80.0f - altarTile.degreesOpened / 1.12f) / 90.0f * (-altarTile.pageOneRotationRender / 16.0f + 11.25f)));
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_PAGE.get()).defaultBlockState());
                matrixStackIn.popPose();
            }
            if (altarTile.degreesFloppedRender != 90.0f) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5f + this.xPos, 1.125f + this.yPos, 0.5f + this.zPos);
                matrixStackIn.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f));
                matrixStackIn.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpened / 2.0f + this.degreesOpened)));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(this.degreesOpened2));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
                matrixStackIn.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
                matrixStackIn.translate(0.0f, 0.03125f, 0.0f);
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpened / 1.12f)));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpened / 1.12f) / 90.0f * -altarTile.pageTwoRotationRender));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpened / 1.12f) / 90.0f * (altarTile.pageOneRotationRender / 16.0f)));
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_PAGE.get()).defaultBlockState());
                matrixStackIn.popPose();
            }
            if (altarTile.turnPage == 2 || altarTile.turnPage == -1) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.5f + this.xPos, 1.125f + this.yPos, 0.5f + this.zPos);
                matrixStackIn.translate((float)Math.sin(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f), 0.0f, (float)Math.cos(altarTile.degreesSpunRender / 57.3f) / 32.0f * (altarTile.degreesOpened / 5.0f - 12.0f));
                matrixStackIn.translate(0.0f, (BookOfShadowsAltarTile.easeFlop(1.0f - altarTile.degreesFlopped / 90.0f) - 1.0f) / 16.0f, 0.0f);
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(altarTile.degreesSpunRender));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(-(altarTile.degreesOpened / 2.0f + this.degreesOpened)));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(this.degreesOpened2));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(-altarTile.degreesFloppedRender));
                matrixStackIn.translate(0.0f, 0.0f, -(altarTile.degreesFloppedRender / 10.0f) / 32.0f);
                matrixStackIn.translate(0.0f, 0.03125f, 0.0f);
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpened / 1.12f)));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-(80.0f - altarTile.degreesOpened / 1.12f) / 90.0f * (-altarTile.pageTwoRotationRender / 16.0f + 11.25f)));
                this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BOOK_OF_SHADOWS_PAGE.get()).defaultBlockState());
                matrixStackIn.popPose();
            }
            matrixStackIn.popPose();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    float f = (float)(color >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(color & 0xFF) / 255.0f;
                    dispatcher.getModelRenderer().renderModel(poseStack.last(), p_110915_.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    poseStack.translate(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

