/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.ConnectingCarpetDyed;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class WaxBlendItem
extends Item {
    public static final BiMap<Block, Block> WAXABLES = new ImmutableBiMap.Builder().put((Object)((Block)ModBlocks.WILLOW_PLANKS.get()), (Object)((Block)ModBlocks.POLISHED_WILLOW_PLANKS.get())).put((Object)((Block)ModBlocks.POLISHED_WILLOW_CONNECTED.get()), (Object)((Block)ModBlocks.WAXED_POLISHED_WILLOW_CONNECTED.get())).put((Object)((Block)ModBlocks.POLISHED_WILLOW_PILLAR.get()), (Object)((Block)ModBlocks.WAXED_POLISHED_WILLOW_PILLAR.get())).put((Object)((Block)ModBlocks.POLISHED_WILLOW_LAYERED.get()), (Object)((Block)ModBlocks.WAXED_POLISHED_WILLOW_LAYERED.get())).put((Object)((Block)ModBlocks.WILLOW_CONNECTED.get()), (Object)((Block)ModBlocks.WAXED_WILLOW_CONNECTED.get())).put((Object)((Block)ModBlocks.POLISHED_WITCH_HAZEL_CONNECTED.get()), (Object)((Block)ModBlocks.WAXED_POLISHED_WITCH_HAZEL_CONNECTED.get())).put((Object)((Block)ModBlocks.POLISHED_WITCH_HAZEL_PILLAR.get()), (Object)((Block)ModBlocks.WAXED_POLISHED_WITCH_HAZEL_PILLAR.get())).put((Object)((Block)ModBlocks.POLISHED_WITCH_HAZEL_LAYERED.get()), (Object)((Block)ModBlocks.WAXED_POLISHED_WITCH_HAZEL_LAYERED.get())).put((Object)((Block)ModBlocks.WITCH_HAZEL_CONNECTED.get()), (Object)((Block)ModBlocks.WAXED_WITCH_HAZEL_CONNECTED.get())).put((Object)((Block)ModBlocks.POLISHED_MAHOGANY_CONNECTED.get()), (Object)((Block)ModBlocks.WAXED_POLISHED_MAHOGANY_CONNECTED.get())).put((Object)((Block)ModBlocks.POLISHED_MAHOGANY_PILLAR.get()), (Object)((Block)ModBlocks.WAXED_POLISHED_MAHOGANY_PILLAR.get())).put((Object)((Block)ModBlocks.POLISHED_MAHOGANY_LAYERED.get()), (Object)((Block)ModBlocks.WAXED_POLISHED_MAHOGANY_LAYERED.get())).put((Object)((Block)ModBlocks.MAHOGANY_CONNECTED.get()), (Object)((Block)ModBlocks.WAXED_MAHOGANY_CONNECTED.get())).put((Object)((Block)ModBlocks.MAHOGANY_WINDOW_PANE.get()), (Object)((Block)ModBlocks.WAXED_MAHOGANY_WINDOW_PANE.get())).put((Object)((Block)ModBlocks.WILLOW_WINDOW_PANE.get()), (Object)((Block)ModBlocks.WAXED_WILLOW_WINDOW_PANE.get())).put((Object)((Block)ModBlocks.WITCH_HAZEL_WINDOW_PANE.get()), (Object)((Block)ModBlocks.WAXED_WITCH_HAZEL_WINDOW_PANE.get())).put((Object)((Block)ModBlocks.MAHOGANY_WINDOW.get()), (Object)((Block)ModBlocks.WAXED_MAHOGANY_WINDOW.get())).put((Object)((Block)ModBlocks.WILLOW_WINDOW.get()), (Object)((Block)ModBlocks.WAXED_WILLOW_WINDOW.get())).put((Object)((Block)ModBlocks.WITCH_HAZEL_WINDOW.get()), (Object)((Block)ModBlocks.WAXED_WITCH_HAZEL_WINDOW.get())).put((Object)((Block)ModBlocks.INFUSED_FABRIC_CARPET.get()), (Object)((Block)ModBlocks.WAXED_INFUSED_FABRIC_CARPET.get())).put((Object)((Block)ModBlocks.INFUSED_FABRIC_CARPET_SLAB.get()), (Object)((Block)ModBlocks.WAXED_INFUSED_FABRIC_CARPET_SLAB.get())).put((Object)((Block)ModBlocks.INFUSED_FABRIC_CARPET_STAIRS.get()), (Object)((Block)ModBlocks.WAXED_INFUSED_FABRIC_CARPET_STAIRS.get())).put((Object)((Block)ModBlocks.INFUSED_FABRIC_CARPET_ORNATE.get()), (Object)((Block)ModBlocks.WAXED_INFUSED_FABRIC_CARPET_ORNATE.get())).put((Object)((Block)ModBlocks.INFUSED_FABRIC_CARPET_ORNATE_SLAB.get()), (Object)((Block)ModBlocks.WAXED_INFUSED_FABRIC_CARPET_ORNATE_SLAB.get())).put((Object)((Block)ModBlocks.INFUSED_FABRIC_CARPET_ORNATE_STAIRS.get()), (Object)((Block)ModBlocks.WAXED_INFUSED_FABRIC_CARPET_ORNATE_STAIRS.get())).put((Object)((Block)ModBlocks.STONE_WINDOW.get()), (Object)((Block)ModBlocks.WAXED_STONE_WINDOW.get())).put((Object)((Block)ModBlocks.STONE_WINDOW_PANE.get()), (Object)((Block)ModBlocks.WAXED_STONE_WINDOW_PANE.get())).put((Object)((Block)ModBlocks.INFUSED_FABRIC_BLOCK_ORNATE.get()), (Object)((Block)ModBlocks.WAXED_INFUSED_FABRIC_BLOCK_ORNATE.get())).put((Object)((Block)ModBlocks.INFUSED_FABRIC_BLOCK.get()), (Object)((Block)ModBlocks.WAXED_INFUSED_FABRIC_BLOCK.get())).build();
    public static final Supplier<BiMap<Block, Block>> WAX_OFF_BY_BLOCK = Suppliers.memoize(() -> WAXABLES.inverse());

    public WaxBlendItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        BlockState blockstate = level.getBlockState(blockpos);
        return WaxBlendItem.getWaxed(blockstate).map(newBlockstate -> {
            if (blockstate.hasProperty(ConnectingCarpetDyed.COLOR)) {
                newBlockstate.setValue(ConnectingCarpetDyed.COLOR, (Comparable)((DyeColor)blockstate.getValue(ConnectingCarpetDyed.COLOR)));
            }
            Player player = pContext.getPlayer();
            ItemStack itemstack = pContext.getItemInHand();
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockpos, itemstack);
            }
            itemstack.shrink(1);
            if (blockstate.getBlock() instanceof CrossCollisionBlock) {
                BlockState changeTo = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)newBlockstate.setValue((Property)CrossCollisionBlock.NORTH, (Comparable)((Boolean)blockstate.getValue((Property)CrossCollisionBlock.NORTH)))).setValue((Property)CrossCollisionBlock.SOUTH, (Comparable)((Boolean)blockstate.getValue((Property)CrossCollisionBlock.SOUTH)))).setValue((Property)CrossCollisionBlock.EAST, (Comparable)((Boolean)blockstate.getValue((Property)CrossCollisionBlock.EAST)))).setValue((Property)CrossCollisionBlock.WEST, (Comparable)((Boolean)blockstate.getValue((Property)CrossCollisionBlock.WEST)))).setValue((Property)CrossCollisionBlock.WATERLOGGED, (Comparable)((Boolean)blockstate.getValue((Property)CrossCollisionBlock.WATERLOGGED)));
                level.setBlockAndUpdate(blockpos, changeTo);
            } else {
                level.setBlock(blockpos, newBlockstate, 11);
            }
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockpos, GameEvent.Context.of((Entity)player, (BlockState)newBlockstate));
            level.levelEvent(player, 3003, blockpos, 0);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }).orElse(InteractionResult.PASS);
    }

    public static Optional<BlockState> getWaxed(BlockState pState) {
        return Optional.ofNullable((Block)WAXABLES.get((Object)pState.getBlock())).map(p_150877_ -> p_150877_.withPropertiesOf(pState));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.wax_blend").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

