/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.List;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.Nullable;

public class WitchArmorItem
extends ArmorItem {
    public WitchArmorItem(Holder<ArmorMaterial> materialIn, ArmorItem.Type type, Item.Properties builder) {
        super(materialIn, type, builder);
    }

    public int getColor(ItemStack stack) {
        String name = stack.getHoverName().getString();
        DyeColor col = HexereiUtil.getDyeColorNamed(name, 0);
        if (col != null) {
            float f3 = ClientEvents.getClientTicks() / 10.0f * 4.0f % 16.0f / 16.0f;
            DyeColor col2 = HexereiUtil.getDyeColorNamed(name, 1);
            float[] afloat1 = HexereiUtil.rgbIntToFloatArray(col.getTextureDiffuseColor());
            float[] afloat2 = HexereiUtil.rgbIntToFloatArray(col2.getTextureDiffuseColor());
            float f = afloat1[0] * (1.0f - f3) + afloat2[0] * f3;
            float f1 = afloat1[1] * (1.0f - f3) + afloat2[1] * f3;
            float f2 = afloat1[2] * (1.0f - f3) + afloat2[2] * f3;
            return HexereiUtil.getColorValueAlpha(f, f1, f2, 1.0f);
        }
        return ((DyedItemColor)stack.getOrDefault(DataComponents.DYED_COLOR, (Object)new DyedItemColor(-1, true))).rgb();
    }

    @javax.annotation.Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        if (HexereiUtil.getDyeColor(stack) != 4337438 && layer.dyeable()) {
            return ResourceLocation.fromNamespaceAndPath((String)"hexerei", (String)"textures/models/armor/witch_armor_layer1_dyed.png");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"hexerei", (String)"textures/models/armor/witch_armor_layer1.png");
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return super.getEquipmentSlot(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            boolean boots;
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            Player player = null;
            if (context.level() != null && context.level().isClientSide) {
                player = Hexerei.proxy.getPlayer();
            }
            int num = 0;
            boolean hat = player != null && player.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof WitchArmorItem;
            boolean robe = player != null && player.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof WitchArmorItem;
            boolean bl = boots = player != null && player.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof WitchArmorItem;
            if (hat) {
                ++num;
            }
            if (robe) {
                ++num;
            }
            if (boots) {
                ++num;
            }
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.witch_armor_shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.witch_armor_pieces").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)(num < 2 ? 5184536 : 2396416)))));
            tooltipComponents.add((Component)Component.translatable((String)"").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)" %s - %s", (Object[])new Object[]{Component.translatable((String)"item.hexerei.witch_helmet"), Component.translatable((String)"item.hexerei.mushroom_witch_hat")}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)(hat ? (num < 2 ? 1863748 : 3261557) : 0x333333)))));
            tooltipComponents.add((Component)Component.translatable((String)" %s", (Object[])new Object[]{Component.translatable((String)"item.hexerei.witch_chestplate")}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)(robe ? (num < 2 ? 1863748 : 3261557) : 0x333333)))));
            tooltipComponents.add((Component)Component.translatable((String)" %s", (Object[])new Object[]{Component.translatable((String)"item.hexerei.witch_boots")}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)(boots ? (num < 2 ? 1863748 : 3261557) : 0x333333)))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.witch_armor_bonus", (Object[])new Object[]{num, 2}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)(num < 2 ? 5184536 : 2396416)))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.witch_armor_bonus_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)(num < 2 ? 0x333333 : 3261557)))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.witch_armor_bonus_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)(num < 2 ? 0x333333 : 3261557)))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.witch_armor_bonus", (Object[])new Object[]{num, 3}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)(num < 3 ? 5184536 : 2396416)))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.witch_armor_bonus_3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)(num < 3 ? 0x333333 : 3261557)))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.witch_armor_bonus_4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)(num < 3 ? 0x333333 : 3261557)))));
        } else {
            boolean boots;
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            Player player = null;
            if (context.level() != null && context.level().isClientSide) {
                player = Hexerei.proxy.getPlayer();
            }
            int num = 0;
            boolean hat = player != null && player.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof WitchArmorItem;
            boolean robe = player != null && player.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof WitchArmorItem;
            boolean bl = boots = player != null && player.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof WitchArmorItem;
            if (hat) {
                ++num;
            }
            if (robe) {
                ++num;
            }
            if (boots) {
                ++num;
            }
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.witch_armor_bonus", (Object[])new Object[]{num, 2}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)(num < 2 ? 5184536 : 2396416)))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

