/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.joefoxe.hexerei.client.renderer.IThirdPersonItemRenderer;
import net.joefoxe.hexerei.events.GlassesZoomKeyPressEvent;
import net.joefoxe.hexerei.item.custom.GlassesItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.PlayerItemInHandLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={PlayerItemInHandLayer.class})
public abstract class PlayerItemInHandLayerMixin<T extends Player, M extends EntityModel<T> & HeadedModel>
extends ItemInHandLayer<T, M> {
    public PlayerItemInHandLayerMixin(RenderLayerParent<T, M> parent, ItemInHandRenderer renderer) {
        super(parent, renderer);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Inject(method={"renderArmWithItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void poseRightArm(LivingEntity entity, ItemStack stack, ItemDisplayContext transformType, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource bufferSource, int light, CallbackInfo ci) {
        Item item = stack.getItem();
        if (item instanceof IThirdPersonItemRenderer) {
            IThirdPersonItemRenderer item2 = (IThirdPersonItemRenderer)item;
            item2.renderThirdPersonItem(this.getParentModel(), entity, stack, humanoidArm, poseStack, bufferSource, light);
            ci.cancel();
        }
        if (stack.getItem() instanceof GlassesItem && GlassesZoomKeyPressEvent.zoomWithItemToggled) {
            this.renderArmWithGlasses(entity, stack, humanoidArm, poseStack, bufferSource, light);
            ci.cancel();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderArmWithGlasses(LivingEntity p_174518_, ItemStack p_174519_, HumanoidArm p_174520_, PoseStack p_174521_, MultiBufferSource p_174522_, int p_174523_) {
        p_174521_.pushPose();
        ModelPart modelpart = ((HeadedModel)this.getParentModel()).getHead();
        float f = modelpart.xRot;
        modelpart.translateAndRotate(p_174521_);
        modelpart.xRot = f;
        CustomHeadLayer.translateToHead((PoseStack)p_174521_, (boolean)false);
        Minecraft.getInstance().gameRenderer.itemInHandRenderer.renderItem(p_174518_, p_174519_, ItemDisplayContext.HEAD, false, p_174521_, p_174522_, p_174523_);
        p_174521_.popPose();
    }
}

