/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.Coffer;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.container.CofferContainer;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.tileentity.CofferTile;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.CofferCycleWhitelistButtonToServer;
import net.joefoxe.hexerei.util.message.CofferInvCycleWhitelistButtonToServer;
import net.joefoxe.hexerei.util.message.CofferInvUpdateWhitelistToServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CofferScreen
extends AbstractContainerScreen<CofferContainer> {
    private final ResourceLocation GUI = HexereiUtil.getResource("textures/gui/coffer_gui.png");
    private final ResourceLocation INVENTORY = HexereiUtil.getResource("textures/gui/inventory.png");
    public int mouseX;
    public int mouseY;

    public CofferScreen(CofferContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.titleLabelY = -27;
        this.titleLabelX = 4;
        this.inventoryLabelY = 107;
        this.mouseX = 0;
        this.mouseY = 0;
    }

    protected void init() {
        super.init();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderButtonTooltip(guiGraphics, mouseX, mouseY);
    }

    public Component getTitle() {
        return super.getTitle();
    }

    public boolean getToggled() {
        return ((CofferContainer)this.menu).getToggled() == 1;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        int i2;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.leftPos;
        int j = this.topPos - 28;
        guiGraphics.blit(this.GUI, i, j - 3, 0, 0, 214, 157);
        guiGraphics.blit(this.GUI, i + 94, j - 30, 230, 0, 26, 26);
        if (((CofferContainer)this.menu).getToggled() == 1) {
            guiGraphics.blit(this.GUI, i + 188, j + 130, 230, 44, 18, 18);
            guiGraphics.blit(this.GUI, i + 211, j + 62, 2, 159, 62, 62);
            CofferTile.WhitelistMode mode = CofferTile.WhitelistMode.WHITELIST_INV;
            if (((CofferContainer)this.getMenu()).inWorld) {
                BlockEntity blockEntity = ((CofferContainer)this.menu).tileEntity;
                if (blockEntity instanceof CofferTile) {
                    CofferTile coffer = (CofferTile)blockEntity;
                    mode = coffer.mode;
                }
            } else {
                CompoundTag tag;
                ItemStack handStack = ItemStack.EMPTY;
                if (Inventory.isHotbarSlot((int)((CofferContainer)this.menu).slotIndex)) {
                    if (Minecraft.getInstance().player.getInventory().selected == ((CofferContainer)this.menu).slotIndex) {
                        handStack = Minecraft.getInstance().player.getMainHandItem();
                    }
                } else {
                    handStack = Minecraft.getInstance().player.getOffhandItem();
                }
                if ((tag = ((CustomData)handStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag()).contains("WhitelistMode")) {
                    mode = CofferTile.WhitelistMode.byId(tag.getInt("WhitelistMode"));
                }
            }
            guiGraphics.blit(this.GUI, i + 216, j + 126, 65 + 18 * mode.ordinal(), 159, 18, 18);
            for (i2 = 0; i2 < 9; ++i2) {
                int ix = i2 % 3;
                int iy = i2 / 3;
                if (!this.hovering(216 + ix * 18, 66 + iy * 18, 18.0, 18.0)) continue;
                CofferScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(i + 216 + ix * 18), (int)(j + 66 + iy * 18 + 1), (int)0);
            }
        }
        guiGraphics.blit(this.INVENTORY, i + 3, j + 129, 0, 0, 176, 100);
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.disableDepthTest();
        guiGraphics.renderItem(new ItemStack((ItemLike)((Coffer)ModBlocks.COFFER.get()).asItem()), this.leftPos + 99, this.topPos - 25 - 28);
        if (((CofferContainer)this.menu).getToggled() == 1) {
            for (i2 = 0; i2 < 9; ++i2) {
                ItemStack stackInSlot = ItemStack.EMPTY;
                if (((CofferContainer)this.getMenu()).inWorld) {
                    BlockEntity blockEntity = ((CofferContainer)this.menu).tileEntity;
                    if (blockEntity instanceof CofferTile) {
                        CofferTile coffer = (CofferTile)blockEntity;
                        stackInSlot = ((ItemStack)coffer.whitelist.get(i2)).copy();
                    }
                } else {
                    ListTag itemsTag;
                    CompoundTag tag;
                    ItemStack handStack = ItemStack.EMPTY;
                    if (Inventory.isHotbarSlot((int)((CofferContainer)this.menu).slotIndex)) {
                        if (Minecraft.getInstance().player.getInventory().selected == ((CofferContainer)this.menu).slotIndex) {
                            handStack = Minecraft.getInstance().player.getMainHandItem();
                        }
                    } else {
                        handStack = Minecraft.getInstance().player.getOffhandItem();
                    }
                    if ((tag = ((CustomData)handStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag()).contains("WhitelistItems", 9) && !(itemsTag = tag.getList("WhitelistItems", 10)).getCompound(i2).getCompound("Item").isEmpty()) {
                        stackInSlot = ItemStack.parse((HolderLookup.Provider)Hexerei.DynamicRegistries.get(), (Tag)itemsTag.getCompound(i2).getCompound("Item")).orElse(ItemStack.EMPTY);
                    }
                }
                int ix = i2 % 3;
                int iy = i2 / 3;
                guiGraphics.renderItem(stackInSlot, i + 216 + ix * 18, j + 67 + iy * 18);
            }
        }
        if (minecraft.player != null) {
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(i + 107 - 26), (int)(j + 8 + 35), (int)(i + 107 + 26), (int)(j + 78 + 15), (int)22, (float)0.0625f, (float)x, (float)y, (LivingEntity)minecraft.player);
        }
        RenderSystem.enableDepthTest();
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        boolean insideWhitelist = this.hovering(211.0, 62.0, 62.0, 62.0);
        boolean insideWhitelistButton = this.hovering(216.0, 126.0, 18.0, 18.0);
        boolean insideCoffer = this.hovering(0.0, -3.0, 214.0, 157.0);
        return super.hasClickedOutside(mouseX, mouseY, guiLeft, guiTop, mouseButton) && !insideWhitelist && !insideWhitelistButton && !insideCoffer;
    }

    public boolean mouseClicked(double x, double y, int button) {
        boolean mouseClicked = super.mouseClicked(x, y, button);
        if (((CofferContainer)this.menu).getToggled() == 1) {
            if (this.hovering(216.0, 126.0, 18.0, 18.0)) {
                if (((CofferContainer)this.menu).inWorld) {
                    BlockEntity blockEntity = ((CofferContainer)this.menu).tileEntity;
                    if (blockEntity instanceof CofferTile) {
                        CofferTile coffer = (CofferTile)blockEntity;
                        HexereiPacketHandler.sendToServer(new CofferCycleWhitelistButtonToServer(coffer));
                    }
                } else {
                    HexereiPacketHandler.sendToServer(new CofferInvCycleWhitelistButtonToServer(((CofferContainer)this.menu).slotIndex));
                }
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
            for (int i2 = 0; i2 < 9; ++i2) {
                int ix = i2 % 3;
                int iy = i2 / 3;
                if (!this.hovering(216 + ix * 18, 66 + iy * 18, 18.0, 18.0)) continue;
                if (!((CofferContainer)this.menu).getCarried().isEmpty()) {
                    ItemStack stack = ((CofferContainer)this.menu).getCarried();
                    if (!(((List)HexConfig.COFFER_BLACKLIST.get()).contains(HexereiUtil.getRegistryName(stack.getItem()).toString()) || stack.is(ModItems.COFFER) || stack.is(ModItems.ENTANGLED_COFFER))) {
                        if (((CofferContainer)this.menu).inWorld) {
                            BlockEntity blockEntity = ((CofferContainer)this.menu).tileEntity;
                            if (blockEntity instanceof CofferTile) {
                                CofferTile cofferTile = (CofferTile)blockEntity;
                                cofferTile.setWhitelistSlot(i2, ((CofferContainer)this.menu).getCarried().copyWithCount(1));
                            }
                        } else {
                            HexereiPacketHandler.sendToServer(new CofferInvUpdateWhitelistToServer(((CofferContainer)this.menu).slotIndex, i2, ((CofferContainer)this.menu).getCarried().copyWithCount(1)));
                        }
                    }
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    continue;
                }
                if (((CofferContainer)this.menu).inWorld) {
                    BlockEntity blockEntity = ((CofferContainer)this.menu).tileEntity;
                    if (blockEntity instanceof CofferTile) {
                        CofferTile cofferTile = (CofferTile)blockEntity;
                        cofferTile.setWhitelistSlot(i2, ItemStack.EMPTY);
                    }
                } else {
                    HexereiPacketHandler.sendToServer(new CofferInvUpdateWhitelistToServer(((CofferContainer)this.menu).slotIndex, i2, ItemStack.EMPTY));
                }
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        }
        if (x > (double)(this.leftPos + 188) && x < (double)(this.leftPos + 188 + 18) && y > (double)(this.topPos + 129 - 28) && y < (double)(this.topPos + 129 + 18 - 28)) {
            ((CofferContainer)this.menu).setToggled(1 - ((CofferContainer)this.menu).getToggled());
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        }
        return mouseClicked;
    }

    public boolean hovering(double x, double y, double width, double height) {
        return (double)this.mouseX >= (double)this.leftPos + x && (double)this.mouseX < (double)this.leftPos + x + width && (double)this.mouseY >= (double)(this.topPos - 28) + y && (double)this.mouseY < (double)(this.topPos - 28) + y + height;
    }

    public void renderButtonTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        if (this.hovering(188.0, 130.0, 18.0, 18.0)) {
            components.add(Component.translatable((String)"tooltip.hexerei.gather_to_here_button"));
            if (Screen.hasShiftDown()) {
                components.add(Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.gather_to_here_button_0").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.gather_to_here_button_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.gather_to_here_button_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.gather_to_here_button_3").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
                components.add(Component.translatable((String)"tooltip.hexerei.gather_to_here_button_4").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            } else {
                components.add(Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            }
            guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
        }
        components = new ArrayList();
        if (this.hovering(216.0, 126.0, 18.0, 18.0)) {
            CofferTile.WhitelistMode mode = CofferTile.WhitelistMode.WHITELIST_INV;
            if (((CofferContainer)this.getMenu()).inWorld) {
                BlockEntity blockEntity = ((CofferContainer)this.menu).tileEntity;
                if (blockEntity instanceof CofferTile) {
                    CofferTile coffer = (CofferTile)blockEntity;
                    mode = coffer.mode;
                }
            } else {
                CompoundTag tag;
                ItemStack handStack = ItemStack.EMPTY;
                if (Inventory.isHotbarSlot((int)((CofferContainer)this.menu).slotIndex)) {
                    if (Minecraft.getInstance().player.getInventory().selected == ((CofferContainer)this.menu).slotIndex) {
                        handStack = Minecraft.getInstance().player.getMainHandItem();
                    }
                } else {
                    handStack = Minecraft.getInstance().player.getOffhandItem();
                }
                if ((tag = ((CustomData)handStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag()).contains("WhitelistMode")) {
                    mode = CofferTile.WhitelistMode.byId(tag.getInt("WhitelistMode"));
                }
            }
            components.add(Component.translatable((String)("tooltip.hexerei.coffer_" + mode.getName())));
            components.add(Component.translatable((String)"tooltip.hexerei.coffer_whitelist_match").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            components.add(Component.translatable((String)("tooltip.hexerei.coffer_" + mode.getName() + "_1")).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600))));
            guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), mouseX, mouseY);
        }
        for (int i2 = 0; i2 < 9; ++i2) {
            int ix = i2 % 3;
            int iy = i2 / 3;
            if (!this.hovering(216 + ix * 18, 66 + iy * 18, 18.0, 18.0)) continue;
            ItemStack stackInSlot = ItemStack.EMPTY;
            if (((CofferContainer)this.getMenu()).inWorld) {
                BlockEntity blockEntity = ((CofferContainer)this.menu).tileEntity;
                if (blockEntity instanceof CofferTile) {
                    CofferTile coffer = (CofferTile)blockEntity;
                    stackInSlot = ((ItemStack)coffer.whitelist.get(i2)).copy();
                }
            } else {
                ListTag itemsTag;
                CompoundTag tag;
                ItemStack handStack = ItemStack.EMPTY;
                if (Inventory.isHotbarSlot((int)((CofferContainer)this.menu).slotIndex)) {
                    if (Minecraft.getInstance().player.getInventory().selected == ((CofferContainer)this.menu).slotIndex) {
                        handStack = Minecraft.getInstance().player.getMainHandItem();
                    }
                } else {
                    handStack = Minecraft.getInstance().player.getOffhandItem();
                }
                if ((tag = ((CustomData)handStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag()).contains("WhitelistItems", 9) && !(itemsTag = tag.getList("WhitelistItems", 10)).getCompound(i2).getCompound("Item").isEmpty()) {
                    stackInSlot = ItemStack.parse((HolderLookup.Provider)Hexerei.DynamicRegistries.get(), (Tag)itemsTag.getCompound(i2).getCompound("Item")).orElse(ItemStack.EMPTY);
                }
            }
            if (stackInSlot.isEmpty()) continue;
            List tooltip = stackInSlot.getTooltipLines(Item.TooltipContext.EMPTY, Hexerei.proxy.getPlayer(), (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
            guiGraphics.renderTooltip(Minecraft.getInstance().font, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }
}

