/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.CourierLetterUpdatePacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class CourierLetterScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation GUI = HexereiUtil.getResource("textures/gui/courier_letter_gui.png");
    private final String[] messages;
    private OwlEntity.MessageText text = new OwlEntity.MessageText();
    private static final Vector3f TEXT_SCALE = new Vector3f(0.9765628f, 0.9765628f, 0.9765628f);
    @Nullable
    private TextFieldHelper messageField;
    int frame;
    int line;
    int img_width = 172;
    int img_height = 164;
    int left;
    int top;
    int slotIndex;
    InteractionHand hand;
    boolean dirty = false;
    boolean clicked = false;
    int clickedTicks = 0;
    int clickedTicksOld = 0;
    boolean sealed = false;

    public CourierLetterScreen(int slotIndex, InteractionHand hand, ItemStack stack) {
        super((Component)Component.translatable((String)"screen.hexerei.letter"));
        CustomData tag = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (tag != null) {
            if (tag.contains("Message")) {
                OwlEntity.MessageText.DIRECT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.copyTag().getCompound("Message")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(message -> {
                    this.text = this.loadLines((OwlEntity.MessageText)message);
                });
            }
            if (tag.contains("Sealed")) {
                this.sealed = tag.copyTag().getBoolean("Sealed");
            }
        }
        this.minecraft = Minecraft.getInstance();
        this.messages = (String[])IntStream.range(0, 12).mapToObj(p_277214_ -> this.text.getMessage(p_277214_)).map(Component::getString).toArray(String[]::new);
        this.frame = 0;
        this.line = 0;
        this.slotIndex = slotIndex;
        this.hand = hand;
    }

    public boolean isEmpty() {
        for (String str : this.messages) {
            if (str.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private OwlEntity.MessageText loadLines(OwlEntity.MessageText pText) {
        for (int i = 0; i < 12; ++i) {
            Component component = pText.getMessage(i);
            pText = pText.setMessage(i, component);
        }
        return pText;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setChanged() {
        this.setDirty(true);
    }

    public boolean mouseClicked(double x, double y, int pButton) {
        if (pButton == 0) {
            for (int i = 0; i < 12; ++i) {
                if (!(x > (double)(this.left + 5)) || !(x < (double)(this.left + 5 + 162)) || !(y > (double)(this.top + 25 + this.getTextLineHeight() * i)) || !(y < (double)(this.top + 25 + this.getTextLineHeight() + this.getTextLineHeight() * i))) continue;
                this.line = i;
                this.messageField.setCursorToEnd();
                return true;
            }
            if (!this.sealed && x > (double)(this.left + 71) && x < (double)(this.left + 71 + 30) && y > (double)(this.top + 151) && y < (double)(this.top + 151 + 15) && !this.isEmpty()) {
                this.clicked = true;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f, (float)0.25f));
                return true;
            }
        }
        return super.mouseClicked(x, y, pButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (!this.sealed && this.clicked && pButton == 0 && !this.isEmpty()) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)0.85f, (float)0.25f));
            this.clicked = false;
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double x, double y, int pButton, double pDragX, double pDragY) {
        if (!(this.sealed || !this.clicked || pButton != 0 || this.isEmpty() || x > (double)(this.left + 71) && x < (double)(this.left + 71 + 30) && y > (double)(this.top + 151) && y < (double)(this.top + 151 + 15))) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)0.85f, (float)0.25f));
            this.clicked = false;
        }
        return super.mouseDragged(x, y, pButton, pDragX, pDragY);
    }

    protected void init() {
        this.left = this.width / 2 - this.img_width / 2;
        this.top = this.height / 2 - this.img_height / 2;
        this.messageField = new TextFieldHelper(() -> this.messages[this.line], this::setMessage, TextFieldHelper.createClipboardGetter((Minecraft)this.minecraft), TextFieldHelper.createClipboardSetter((Minecraft)this.minecraft), string -> this.minecraft.font.width(string) <= this.getMaxTextLineWidth());
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == this.minecraft.options.keyInventory.getKey().getValue() && this.sealed) {
            this.onClose();
            return true;
        }
        if (pKeyCode == 265) {
            this.line = (this.line - 1 + 12) % 12;
            this.messageField.setCursorToEnd();
            return true;
        }
        if (pKeyCode == 258) {
            this.messageField.insertText("    ");
            return true;
        }
        if (pKeyCode != 264 && pKeyCode != 257 && pKeyCode != 335) {
            return this.messageField.keyPressed(pKeyCode) ? true : super.keyPressed(pKeyCode, pScanCode, pModifiers);
        }
        this.line = (this.line + 1 + 12) % 12;
        this.messageField.setCursorToEnd();
        return true;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        this.messageField.charTyped(pCodePoint);
        return true;
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Lighting.setupForFlatItems();
        this.renderTransparentBackground(pGuiGraphics);
        pGuiGraphics.drawCenteredString(this.font, this.title, this.width / 2, this.top + 4, 0x333333);
        pGuiGraphics.blit(this.GUI, this.left, this.top, 0, 0, this.img_width, this.img_height);
        if (!this.sealed) {
            if (!this.isEmpty()) {
                if (this.clicked) {
                    pGuiGraphics.blit(this.GUI, this.left + 71, this.top + 151, 1, 224, 30, 15);
                } else if (pMouseX > this.left + 71 && pMouseX < this.left + 71 + 30 && pMouseY > this.top + 151 && pMouseY < this.top + 151 + 15) {
                    pGuiGraphics.blit(this.GUI, this.left + 71, this.top + 151, 1, 240, 30, 15);
                } else {
                    pGuiGraphics.blit(this.GUI, this.left + 71, this.top + 151, 1, 192, 30, 15);
                }
                float alpha = 1.0f - Mth.clamp((float)(Mth.lerp((float)pPartialTick, (float)this.clickedTicksOld, (float)this.clickedTicks) / 15.0f), (float)0.0f, (float)1.0f);
                if (alpha > 0.05f) {
                    pGuiGraphics.pose().pushPose();
                    pGuiGraphics.pose().translate((float)this.left, (float)this.top, 2.0f);
                    pGuiGraphics.drawString(this.font, (Component)Component.translatable((String)"hexerei.package_letter.seal"), 75, 155, HexereiUtil.getColorValueAlpha(0.2f, 0.2f, 0.2f, alpha), false);
                    pGuiGraphics.pose().popPose();
                }
                float xOffset = Mth.clamp((float)(31.0f * (Mth.lerp((float)pPartialTick, (float)this.clickedTicksOld, (float)this.clickedTicks) / 12.0f)), (float)0.0f, (float)30.0f);
                float xOffset2 = Mth.clamp((float)(7.0f * (Mth.lerp((float)pPartialTick, (float)(this.clickedTicksOld - 12), (float)(this.clickedTicks - 12)) / 3.0f)), (float)0.0f, (float)6.0f);
                float xOffset3 = Mth.clamp((float)(7.0f * (Mth.lerp((float)pPartialTick, (float)(this.clickedTicksOld - 5), (float)(this.clickedTicks - 5)) / 5.0f)), (float)0.0f, (float)6.0f);
                float yOffset = Mth.clamp((float)(10.0f * (Mth.lerp((float)pPartialTick, (float)(this.clickedTicksOld - 16), (float)(this.clickedTicks - 16)) / 2.0f)), (float)0.0f, (float)9.0f);
                this.floatBlit(pGuiGraphics, this.GUI, this.left + 71, (float)(this.left + 71) + xOffset, this.top + 151, this.top + 160, 3.0f, 0.00390625f, (1.0f + xOffset) / 256.0f, 0.66796875f, 0.703125f);
                this.floatBlit(pGuiGraphics, this.GUI, (float)(this.left + 92 + 6) - xOffset2, this.left + 92 + 6, this.top + 159, this.top + 164, 4.0f, (23.0f - xOffset2) / 256.0f, 0.08984375f, 0.7109375f, 0.73046875f);
                this.floatBlit(pGuiGraphics, this.GUI, this.left + 91 - 17, (float)(this.left + 91 - 17) + xOffset3, this.top + 158, (float)(this.top + 158) + xOffset3, 4.0f, 0.0390625f, (10.0f + xOffset3) / 256.0f, 0.7109375f, (182.0f + xOffset3) / 256.0f);
                this.floatBlit(pGuiGraphics, this.GUI, this.left + 82, this.left + 82 + 8, this.top + 154, (float)(this.top + 154) + yOffset, 5.0f, 0.00390625f, 0.03515625f, 0.7109375f, (182.0f + yOffset) / 256.0f);
            } else {
                pGuiGraphics.pose().pushPose();
                pGuiGraphics.pose().translate((float)this.left, (float)this.top, 2.0f);
                pGuiGraphics.drawString(this.font, (Component)Component.translatable((String)"hexerei.package_letter.seal"), 75, 155, 0x333333, false);
                pGuiGraphics.pose().popPose();
                pGuiGraphics.blit(this.GUI, this.left + 71, this.top + 151, 1, 208, 30, 15);
            }
        }
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)(this.left + 86), (float)(this.top + 85), 4.0f);
        pGuiGraphics.pose().scale(TEXT_SCALE.x(), TEXT_SCALE.y(), TEXT_SCALE.z());
        int col = DyeColor.BLACK.getTextColor();
        boolean flag = this.frame / 6 % 2 == 0;
        int cursorPos = this.messageField.getCursorPos();
        int selectionPos = this.messageField.getSelectionPos();
        int l = 12 * this.getTextLineHeight() / 2;
        int i1 = this.line * this.getTextLineHeight() - l;
        for (int i = 0; i < this.messages.length; ++i) {
            String str = this.messages[i];
            if (str == null) continue;
            if (this.font.isBidirectional()) {
                str = this.font.bidirectionalShaping(str);
            }
            pGuiGraphics.drawString(this.font, str, -75, i * this.getTextLineHeight() - l, col, false);
            if (i != this.line || cursorPos < 0 || !flag || this.sealed || cursorPos < str.length()) continue;
            pGuiGraphics.drawString(this.font, "_", this.font.width(str.substring(0, Math.max(Math.min(cursorPos, str.length()), 0))) - 75, i1, col, false);
        }
        for (int k3 = 0; k3 < this.messages.length; ++k3) {
            String s1 = this.messages[k3];
            if (s1 == null || k3 != this.line || cursorPos < 0) continue;
            int l3 = this.font.width(s1.substring(0, Math.max(Math.min(cursorPos, s1.length()), 0)));
            int i4 = l3 - 75;
            if (flag && cursorPos < s1.length() && !this.sealed) {
                pGuiGraphics.fill(i4, i1 - 1, i4 + 1, i1 + this.getTextLineHeight(), 0xFF000000 | col);
            }
            if (selectionPos == cursorPos) continue;
            int j4 = Math.min(cursorPos, selectionPos);
            int j2 = Math.max(cursorPos, selectionPos);
            int k2 = this.font.width(s1.substring(0, j4)) - 75;
            int l2 = this.font.width(s1.substring(0, j2)) - 75;
            int i3 = Math.min(k2, l2);
            int j3 = Math.max(k2, l2);
            pGuiGraphics.fill(RenderType.guiTextHighlight(), i3, i1, j3, i1 + this.getTextLineHeight(), -16776961);
        }
        pGuiGraphics.pose().popPose();
        ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
        if (!this.clicked && !this.sealed && pMouseX > this.left + 71 && pMouseX < this.left + 71 + 30 && pMouseY > this.top + 151 && pMouseY < this.top + 151 + 15) {
            tooltipLines.add(Component.translatable((String)"hexerei.package_letter.letter_seal_tooltip").withStyle(ChatFormatting.DARK_GRAY));
            tooltipLines.add(Component.translatable((String)"hexerei.package_letter.letter_seal_tooltip2").withStyle(ChatFormatting.DARK_GRAY));
        }
        if (!tooltipLines.isEmpty()) {
            pGuiGraphics.renderTooltip(this.font, tooltipLines, Optional.empty(), pMouseX, pMouseY);
        }
        Lighting.setupFor3DItems();
    }

    void floatBlit(GuiGraphics guiGraphics, ResourceLocation pAtlasLocation, float pX1, float pX2, float pY1, float pY2, float pBlitOffset, float pMinU, float pMaxU, float pMinV, float pMaxV) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)pAtlasLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, pX1, pY1, pBlitOffset).setUv(pMinU, pMinV);
        bufferbuilder.addVertex(matrix4f, pX1, pY2, pBlitOffset).setUv(pMinU, pMaxV);
        bufferbuilder.addVertex(matrix4f, pX2, pY2, pBlitOffset).setUv(pMaxU, pMaxV);
        bufferbuilder.addVertex(matrix4f, pX2, pY1, pBlitOffset).setUv(pMaxU, pMinV);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    public Component getTitle() {
        return super.getTitle();
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextLineWidth() {
        return 150;
    }

    private void onDone() {
        this.minecraft.setScreen(null);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
        ++this.frame;
        if (!this.sealed) {
            this.clickedTicksOld = this.clickedTicks--;
            if (this.clicked) {
                if (this.clickedTicks % 8 == 0) {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BUNDLE_INSERT, (float)1.5f, (float)0.75f));
                }
                ++this.clickedTicks;
                if (this.clickedTicks > 25) {
                    this.clicked = false;
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BUNDLE_DROP_CONTENTS, (float)1.8f, (float)0.75f));
                    OwlEntity.MessageText.DIRECT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.text).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> HexereiPacketHandler.sendToServer(new CourierLetterUpdatePacket(this.slotIndex, (CompoundTag)tag, true)));
                    this.onClose();
                    return;
                }
            } else if (this.clickedTicks < 0) {
                this.clickedTicks = 0;
            }
            if (this.frame % 5 == 0 && this.dirty) {
                OwlEntity.MessageText.DIRECT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.text).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> HexereiPacketHandler.sendToServer(new CourierLetterUpdatePacket(this.slotIndex, (CompoundTag)tag, false)));
                this.dirty = false;
            }
        }
        if (!this.isValid()) {
            this.onDone();
        }
    }

    private boolean isValid() {
        if (this.minecraft != null && this.minecraft.player != null && Inventory.isHotbarSlot((int)this.slotIndex)) {
            return this.minecraft.player.getInventory().selected == this.slotIndex;
        }
        return false;
    }

    private void setMessage(String string) {
        if (!this.sealed) {
            this.messages[this.line] = string;
            this.text = this.text.setMessage(this.line, (Component)Component.literal((String)string));
            this.setChanged();
        }
    }
}

