/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.custom.Candle;
import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CandleTile
extends BlockEntity {
    public NonNullList<CandleData> candles = NonNullList.withSize((int)4, (Object)new CandleData());
    public boolean litStateOld;
    public int redstoneAnalogSignal;
    public int redstoneBases;
    private boolean startupFlag;
    public Component customName;
    public int tickCount = 0;

    public CandleTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
        this.candles.replaceAll(ignored -> new CandleData());
        this.startupFlag = false;
        this.litStateOld = false;
    }

    public CandleTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.CANDLE_TILE.get(), blockPos, blockState);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("candle0", 10)) {
            if (tag.contains("candle0")) {
                ((CandleData)this.candles.get(0)).load(tag.getCompound("candle0"), registries);
            }
            if (tag.contains("candle1")) {
                ((CandleData)this.candles.get(1)).load(tag.getCompound("candle1"), registries);
            }
            if (tag.contains("candle2")) {
                ((CandleData)this.candles.get(2)).load(tag.getCompound("candle2"), registries);
            }
            if (tag.contains("candle3")) {
                ((CandleData)this.candles.get(3)).load(tag.getCompound("candle3"), registries);
            }
        }
        this.setOffsetPos(true);
        super.loadAdditional(tag, registries);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("effectCooldown", ((CandleData)this.candles.get((int)0)).cooldown);
        compound.put("candle0", (Tag)((CandleData)this.candles.get(0)).save(registries));
        compound.put("candle1", (Tag)((CandleData)this.candles.get(1)).save(registries));
        compound.put("candle2", (Tag)((CandleData)this.candles.get(2)).save(registries));
        compound.put("candle3", (Tag)((CandleData)this.candles.get(3)).save(registries));
    }

    public int getNumberOfCandles() {
        int num = 0;
        for (CandleData candleData : this.candles) {
            if (!candleData.hasCandle) continue;
            ++num;
        }
        return num;
    }

    public Component getCustomName() {
        return this.getCustomName(0);
    }

    public Component getCustomName(int slot) {
        return ((CandleData)this.candles.get((int)slot)).customName;
    }

    public int getDyeColor(int slot) {
        return ((CandleData)this.candles.get((int)slot)).dyeColor;
    }

    public int getDyeColor() {
        return this.getDyeColor(0);
    }

    public boolean hasCustomName() {
        return this.customName != null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (tag, registryAccess) -> this.getUpdateTag((HolderLookup.Provider)registryAccess));
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.getX() - (double)pos.getX();
        double deltaY = entity.getY() - (double)pos.getY();
        double deltaZ = entity.getZ() - (double)pos.getZ();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public void sync() {
        if (this.level != null) {
            if (!this.level.isClientSide) {
                CompoundTag tag = new CompoundTag();
                this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
                HexereiPacketHandler.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new TESyncPacket(this.worldPosition, tag));
            }
            if (this.level != null) {
                this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 2);
            }
        }
    }

    public void setDyeColor(int dyeColor) {
        ((CandleData)this.candles.get((int)0)).dyeColor = dyeColor;
    }

    public void setHeight(int height) {
        ((CandleData)this.candles.get((int)0)).height = height;
    }

    public void setDyeColor(int candle, int dyeColor) {
        ((CandleData)this.candles.get((int)Math.max((int)0, (int)Math.min((int)candle, (int)3)))).dyeColor = dyeColor;
    }

    public void setHeight(int candle, int height) {
        ((CandleData)this.candles.get((int)Math.max((int)0, (int)Math.min((int)candle, (int)3)))).height = height;
    }

    public void setChanged() {
        super.setChanged();
        this.sync();
    }

    public int updateAnalog() {
        int temp = 0;
        int level_of_candles = 0;
        for (int i = 0; i < 4; ++i) {
            if (!((CandleData)this.candles.get((int)i)).hasCandle) continue;
            level_of_candles += ((CandleData)this.candles.get((int)i)).height;
        }
        float candles = level_of_candles;
        float max = 28.0f;
        float percent = candles / max;
        if (this.redstoneAnalogSignal != (temp += (int)Math.ceil(percent * 15.0f))) {
            this.redstoneAnalogSignal = temp;
            for (Direction direction : Direction.values()) {
                this.level.updateNeighborsAt(this.getBlockPos().relative(direction), this.getBlockState().getBlock());
            }
        }
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 2);
        }
        return temp;
    }

    public void entityInside(Entity entity) {
        BlockPos blockpos = this.getBlockPos();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            if (Shapes.joinIsNotEmpty((VoxelShape)Shapes.create((AABB)entity.getBoundingBox().move((double)(-blockpos.getX()), (double)(-blockpos.getY()), (double)(-blockpos.getZ()))), (VoxelShape)Candle.getShape(this.getBlockState()), (BooleanOp)BooleanOp.AND) && projectile.isOnFire() && this.level != null) {
                if (((CandleData)this.candles.get((int)0)).hasCandle) {
                    ((CandleData)this.candles.get((int)0)).lit = true;
                }
                if (((CandleData)this.candles.get((int)1)).hasCandle) {
                    ((CandleData)this.candles.get((int)1)).lit = true;
                }
                if (((CandleData)this.candles.get((int)2)).hasCandle) {
                    ((CandleData)this.candles.get((int)2)).lit = true;
                }
                if (((CandleData)this.candles.get((int)3)).hasCandle) {
                    ((CandleData)this.candles.get((int)3)).lit = true;
                }
            }
        }
    }

    public void tick() {
        Random random = new Random();
        int candlesLit = 0;
        ++this.tickCount;
        for (CandleData candleData2 : this.candles) {
            candleData2.setOldPos();
            candleData2.move();
            if (candleData2.getEffect() != null) {
                candleData2.getEffect().tick(this.level, this, candleData2);
            }
            if (!candleData2.lit) continue;
            ++candlesLit;
        }
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (state.hasProperty((Property)Candle.CANDLES_LIT)) {
            this.level.setBlock(this.worldPosition, (BlockState)((BlockState)state.setValue((Property)Candle.CANDLES_LIT, (Comparable)Integer.valueOf(candlesLit))).setValue((Property)Candle.LIT, (Comparable)Boolean.valueOf(candlesLit > 0)), 3);
        }
        int temp = 0;
        int level_of_candles = 0;
        for (int i = 0; i < 4; ++i) {
            if (!((CandleData)this.candles.get((int)i)).hasCandle) continue;
            level_of_candles += ((CandleData)this.candles.get((int)i)).height;
        }
        float candles = level_of_candles;
        float max = 28.0f;
        float percent = candles / max;
        if (this.redstoneAnalogSignal != (temp += (int)Math.ceil(percent * 15.0f))) {
            this.redstoneAnalogSignal = temp;
            for (Direction direction : Direction.values()) {
                this.level.updateNeighborsAt(this.getBlockPos().relative(direction), this.getBlockState().getBlock());
            }
        }
        int hasRedstoneBase = 0;
        for (int i = 0; i < 4; ++i) {
            if (((CandleData)this.candles.get((int)i)).base.layer == null || !((CandleData)this.candles.get((int)i)).base.layer.toString().equals("minecraft:redstone_block")) continue;
            ++hasRedstoneBase;
        }
        if (this.redstoneBases != hasRedstoneBase) {
            this.redstoneBases = hasRedstoneBase;
            float percent2 = (float)hasRedstoneBase / 4.0f;
            int redstoneValue = (int)Math.ceil(percent2 * 15.0f);
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)Candle.POWER, (Comparable)Integer.valueOf(redstoneValue)), 3);
            for (Direction direction : Direction.values()) {
                this.level.updateNeighborsAt(this.getBlockPos().relative(direction), this.getBlockState().getBlock());
            }
        }
        if (!this.startupFlag) {
            if (!this.getBlockState().getBlock().asItem().equals(ModItems.CANDLE.get())) {
                ((CandleData)this.candles.get((int)0)).height = 7;
                ((CandleData)this.candles.get((int)0)).hasCandle = true;
            }
            ((CandleData)this.candles.get((int)0)).hasCandle = true;
            ((CandleData)this.candles.get((int)0)).meltTimer = CandleData.meltTimerMAX;
            this.startupFlag = true;
            for (int i = 0; i < 4; ++i) {
                CandleData candleData3 = (CandleData)this.candles.get(i);
                if (!candleData3.returnToBlock) continue;
                candleData3.moveInstantlyToTarget();
            }
        }
        this.setOffsetPos();
        if (this.level.isClientSide) {
            for (CandleData candleData4 : this.candles) {
                if (!candleData4.hasCandle || !candleData4.lit) continue;
                if (random.nextInt(40) == 0 && candleData4.getEffect() != null && candleData4.getEffect().getParticleType() != null) {
                    this.level.addParticle((ParticleOptions)(candleData4.getEffect().getParticleType() != null ? candleData4.getEffect().getParticleType() : ParticleTypes.FLAME), (double)((float)this.worldPosition.getX() + 0.5f + candleData4.x), (double)((float)this.worldPosition.getY() + 0.1875f + (float)candleData4.height / 16.0f + candleData4.y + (float)candleData4.baseHeight / 16.0f), (double)((float)this.worldPosition.getZ() + 0.5f + candleData4.z), (random.nextDouble() - 0.5) / 100.0, (random.nextDouble() + 0.5) * 0.015, (random.nextDouble() - 0.5) / 100.0);
                }
                if (random.nextInt(10) == 0) {
                    this.level.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)this.worldPosition.getX() + 0.5f + candleData4.x), (double)((float)this.worldPosition.getY() + 0.1875f + (float)candleData4.height / 16.0f + candleData4.y + (float)candleData4.baseHeight / 16.0f), (double)((float)this.worldPosition.getZ() + 0.5f + candleData4.z), (random.nextDouble() - 0.5) / 50.0, (random.nextDouble() + 0.5) * 0.015, (random.nextDouble() - 0.5) / 50.0);
                }
                if (random.nextInt(10) != 0) continue;
                this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)this.worldPosition.getX() + 0.5f + candleData4.x), (double)((float)this.worldPosition.getY() + 0.1875f + (float)candleData4.height / 16.0f + candleData4.y + (float)candleData4.baseHeight / 16.0f), (double)((float)this.worldPosition.getZ() + 0.5f + candleData4.z), (random.nextDouble() - 0.5) / 50.0, (random.nextDouble() + 0.5) * 0.045, (random.nextDouble() - 0.5) / 50.0);
            }
        } else {
            boolean shouldSync = false;
            for (CandleData candleData5 : this.candles) {
                if (!candleData5.hasCandle || !candleData5.lit) continue;
                candleData5.meltTimer -= candleData5.getMeltingSpeedMultiplier();
                if (!(candleData5.meltTimer <= 0.0f)) continue;
                candleData5.meltTimer = CandleData.meltTimerMAX;
                --candleData5.height;
                if (candleData5.height <= 0) {
                    candleData5.hasCandle = false;
                    this.updateCandleSlots();
                    BlockState blockstate = this.getLevel().getBlockState(this.getBlockPos());
                    if (!this.level.isClientSide()) {
                        this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)Candle.CANDLES, (Comparable)Integer.valueOf(Math.max(1, (Integer)blockstate.getValue((Property)Candle.CANDLES) - 1))), 1);
                    }
                    this.level.playSound(null, this.worldPosition, SoundEvents.STONE_BREAK, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.4f + 1.0f);
                }
                shouldSync = true;
            }
            if (shouldSync) {
                this.sync();
            }
        }
        for (CandleData candleData6 : this.candles) {
            if (this.tickCount - candleData6.returnToBlockLastTick <= 10) continue;
            candleData6.returnToBlock = true;
        }
        if (this.candles.stream().allMatch(candleData -> !candleData.hasCandle) && this.getLevel() != null) {
            this.getLevel().destroyBlock(this.getBlockPos(), false);
        }
        this.litStateOld = (Boolean)this.getBlockState().getValue((Property)Candle.LIT);
    }

    public void setOffsetPos(int index) {
        switch (index) {
            case 0: {
                float zOffset;
                float xOffset;
                if (((CandleData)this.candles.get((int)0)).hasCandle) {
                    xOffset = 0.0f;
                    zOffset = 0.0f;
                    if (this.getNumberOfCandles() == 4) {
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                            xOffset = 0.1875f;
                            zOffset = 0.1875f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                            xOffset = -0.125f;
                            zOffset = -0.125f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                            xOffset = -0.125f;
                            zOffset = 0.1875f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                            xOffset = 0.125f;
                            zOffset = -0.1875f;
                        }
                    } else if (this.getNumberOfCandles() == 3) {
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                            xOffset = -0.0625f;
                            zOffset = 0.1875f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                            xOffset = 0.0625f;
                            zOffset = -0.1875f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                            xOffset = -0.1875f;
                            zOffset = -0.0625f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                            xOffset = 0.1875f;
                            zOffset = 0.0625f;
                        }
                    } else if (this.getNumberOfCandles() == 2) {
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                            xOffset = 0.1875f;
                            zOffset = -0.125f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                            xOffset = -0.1875f;
                            zOffset = 0.125f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                            xOffset = 0.125f;
                            zOffset = 0.1875f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                            xOffset = -0.125f;
                            zOffset = -0.1875f;
                        }
                    } else if (this.getNumberOfCandles() == 1) {
                        xOffset = 0.0f;
                        zOffset = 0.0f;
                    }
                    ((CandleData)this.candles.get((int)0)).xTarget = xOffset;
                    ((CandleData)this.candles.get((int)0)).yTarget = 0.0f;
                    ((CandleData)this.candles.get((int)0)).zTarget = zOffset;
                }
            }
            case 1: {
                float zOffset;
                float xOffset;
                if (((CandleData)this.candles.get((int)1)).hasCandle) {
                    xOffset = 0.0f;
                    zOffset = 0.0f;
                    if (this.getNumberOfCandles() == 4) {
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                            xOffset = -0.125f;
                            zOffset = -0.1875f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                            xOffset = 0.1875f;
                            zOffset = 0.1875f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                            xOffset = 0.1875f;
                            zOffset = -0.125f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                            xOffset = -0.1875f;
                            zOffset = 0.125f;
                        }
                    } else if (this.getNumberOfCandles() == 3) {
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                            xOffset = 0.1875f;
                            zOffset = 0.0625f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                            xOffset = -0.1875f;
                            zOffset = -0.0625f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                            xOffset = -0.0625f;
                            zOffset = 0.1875f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                            xOffset = 0.0625f;
                            zOffset = -0.1875f;
                        }
                    } else if (this.getNumberOfCandles() == 2) {
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                            xOffset = -0.1875f;
                            zOffset = 0.1875f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                            xOffset = 0.1875f;
                            zOffset = -0.1875f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                            xOffset = -0.1875f;
                            zOffset = -0.1875f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                            xOffset = 0.1875f;
                            zOffset = 0.1875f;
                        }
                    } else if (this.getNumberOfCandles() == 1) {
                        xOffset = 0.0f;
                        zOffset = 0.0f;
                    }
                    ((CandleData)this.candles.get((int)1)).xTarget = xOffset;
                    ((CandleData)this.candles.get((int)1)).yTarget = 0.0f;
                    ((CandleData)this.candles.get((int)1)).zTarget = zOffset;
                }
            }
            case 2: {
                float zOffset;
                float xOffset;
                if (((CandleData)this.candles.get((int)2)).hasCandle) {
                    xOffset = 0.0f;
                    zOffset = 0.0f;
                    if (this.getNumberOfCandles() == 4) {
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                            xOffset = -0.125f;
                            zOffset = 0.125f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                            xOffset = 0.1875f;
                            zOffset = -0.125f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                            xOffset = 0.125f;
                            zOffset = 0.125f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                            xOffset = -0.125f;
                            zOffset = -0.125f;
                        }
                    } else if (this.getNumberOfCandles() == 3) {
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                            xOffset = -0.125f;
                            zOffset = -0.1875f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                            xOffset = 0.125f;
                            zOffset = 0.1875f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                            xOffset = 0.1875f;
                            zOffset = -0.125f;
                        }
                        if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                            xOffset = -0.1875f;
                            zOffset = 0.125f;
                        }
                    }
                    ((CandleData)this.candles.get((int)2)).xTarget = xOffset;
                    ((CandleData)this.candles.get((int)2)).yTarget = 0.0f;
                    ((CandleData)this.candles.get((int)2)).zTarget = zOffset;
                }
            }
            case 3: {
                if (!((CandleData)this.candles.get((int)3)).hasCandle) break;
                float xOffset = 0.0f;
                float zOffset = 0.0f;
                if (this.getNumberOfCandles() == 4) {
                    if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                        xOffset = 0.1875f;
                        zOffset = -0.125f;
                    }
                    if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                        xOffset = -0.1875f;
                        zOffset = 0.125f;
                    }
                    if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                        xOffset = -0.125f;
                        zOffset = -0.1875f;
                    }
                    if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                        xOffset = 0.125f;
                        zOffset = 0.1875f;
                    }
                }
                ((CandleData)this.candles.get((int)3)).xTarget = xOffset;
                ((CandleData)this.candles.get((int)3)).yTarget = 0.0f;
                ((CandleData)this.candles.get((int)3)).zTarget = zOffset;
            }
        }
    }

    public void setOffsetPos() {
        this.setOffsetPos(false);
    }

    public void setOffsetPos(boolean force) {
        float zOffset;
        float xOffset;
        if (((CandleData)this.candles.get((int)0)).hasCandle) {
            xOffset = 0.0f;
            zOffset = 0.0f;
            if (this.getNumberOfCandles() == 4) {
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                    xOffset = 0.1875f;
                    zOffset = 0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                    xOffset = -0.125f;
                    zOffset = -0.125f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                    xOffset = -0.125f;
                    zOffset = 0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                    xOffset = 0.125f;
                    zOffset = -0.1875f;
                }
            } else if (this.getNumberOfCandles() == 3) {
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                    xOffset = -0.0625f;
                    zOffset = 0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                    xOffset = 0.0625f;
                    zOffset = -0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                    xOffset = -0.1875f;
                    zOffset = -0.0625f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                    xOffset = 0.1875f;
                    zOffset = 0.0625f;
                }
            } else if (this.getNumberOfCandles() == 2) {
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                    xOffset = 0.1875f;
                    zOffset = -0.125f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                    xOffset = -0.1875f;
                    zOffset = 0.125f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                    xOffset = 0.125f;
                    zOffset = 0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                    xOffset = -0.125f;
                    zOffset = -0.1875f;
                }
            } else if (this.getNumberOfCandles() == 1) {
                xOffset = 0.0f;
                zOffset = 0.0f;
            }
            if (((CandleData)this.candles.get((int)0)).returnToBlock || force) {
                ((CandleData)this.candles.get((int)0)).xTarget = xOffset;
                ((CandleData)this.candles.get((int)0)).yTarget = 0.0f;
                ((CandleData)this.candles.get((int)0)).zTarget = zOffset;
            }
        }
        if (((CandleData)this.candles.get((int)1)).hasCandle) {
            xOffset = 0.0f;
            zOffset = 0.0f;
            if (this.getNumberOfCandles() == 4) {
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                    xOffset = -0.125f;
                    zOffset = -0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                    xOffset = 0.1875f;
                    zOffset = 0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                    xOffset = 0.1875f;
                    zOffset = -0.125f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                    xOffset = -0.1875f;
                    zOffset = 0.125f;
                }
            } else if (this.getNumberOfCandles() == 3) {
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                    xOffset = 0.1875f;
                    zOffset = 0.0625f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                    xOffset = -0.1875f;
                    zOffset = -0.0625f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                    xOffset = -0.0625f;
                    zOffset = 0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                    xOffset = 0.0625f;
                    zOffset = -0.1875f;
                }
            } else if (this.getNumberOfCandles() == 2) {
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                    xOffset = -0.1875f;
                    zOffset = 0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                    xOffset = 0.1875f;
                    zOffset = -0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                    xOffset = -0.1875f;
                    zOffset = -0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                    xOffset = 0.1875f;
                    zOffset = 0.1875f;
                }
            } else if (this.getNumberOfCandles() == 1) {
                xOffset = 0.0f;
                zOffset = 0.0f;
            }
            if (((CandleData)this.candles.get((int)1)).returnToBlock || force) {
                ((CandleData)this.candles.get((int)1)).xTarget = xOffset;
                ((CandleData)this.candles.get((int)1)).yTarget = 0.0f;
                ((CandleData)this.candles.get((int)1)).zTarget = zOffset;
            }
        }
        if (((CandleData)this.candles.get((int)2)).hasCandle) {
            xOffset = 0.0f;
            zOffset = 0.0f;
            if (this.getNumberOfCandles() == 4) {
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                    xOffset = -0.125f;
                    zOffset = 0.125f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                    xOffset = 0.1875f;
                    zOffset = -0.125f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                    xOffset = 0.125f;
                    zOffset = 0.125f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                    xOffset = -0.125f;
                    zOffset = -0.125f;
                }
            } else if (this.getNumberOfCandles() == 3) {
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                    xOffset = -0.125f;
                    zOffset = -0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                    xOffset = 0.125f;
                    zOffset = 0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                    xOffset = 0.1875f;
                    zOffset = -0.125f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                    xOffset = -0.1875f;
                    zOffset = 0.125f;
                }
            }
            if (((CandleData)this.candles.get((int)2)).returnToBlock || force) {
                ((CandleData)this.candles.get((int)2)).xTarget = xOffset;
                ((CandleData)this.candles.get((int)2)).yTarget = 0.0f;
                ((CandleData)this.candles.get((int)2)).zTarget = zOffset;
            }
        }
        if (((CandleData)this.candles.get((int)3)).hasCandle) {
            xOffset = 0.0f;
            zOffset = 0.0f;
            if (this.getNumberOfCandles() == 4) {
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH) {
                    xOffset = 0.1875f;
                    zOffset = -0.125f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH) {
                    xOffset = -0.1875f;
                    zOffset = 0.125f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.EAST) {
                    xOffset = -0.125f;
                    zOffset = -0.1875f;
                }
                if (this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.WEST) {
                    xOffset = 0.125f;
                    zOffset = 0.1875f;
                }
            }
            if (((CandleData)this.candles.get((int)3)).returnToBlock || force) {
                ((CandleData)this.candles.get((int)3)).xTarget = xOffset;
                ((CandleData)this.candles.get((int)3)).yTarget = 0.0f;
                ((CandleData)this.candles.get((int)3)).zTarget = zOffset;
            }
        }
    }

    public void updateCandleSlots() {
        if (!((CandleData)this.candles.get((int)0)).hasCandle) {
            this.updateCandleSlot(0);
        }
        if (!((CandleData)this.candles.get((int)1)).hasCandle) {
            this.updateCandleSlot(1);
        }
        if (!((CandleData)this.candles.get((int)2)).hasCandle) {
            this.updateCandleSlot(2);
        }
    }

    public void updateCandleSlot(int slot) {
        CandleData newData = new CandleData();
        newData.load(((CandleData)this.candles.get(slot + 1)).save((HolderLookup.Provider)this.level.registryAccess()), (HolderLookup.Provider)this.level.registryAccess());
        this.candles.set(slot, (Object)newData);
        this.candles.set(slot + 1, (Object)new CandleData());
    }
}

