/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.TreeCutter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class CuttingCrystalTile
extends BlockEntity {
    public List<BlockPos> boundPos = new ArrayList<BlockPos>();
    public boolean isParent;
    public static final AtomicInteger NEXT_BREAKER_ID = new AtomicInteger();
    protected int ticksUntilNextProgress;
    protected float destroyProgress;
    protected int breakerId = -NEXT_BREAKER_ID.incrementAndGet();
    protected BlockPos breakingPos;

    public CuttingCrystalTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    public void cutTree(Level level, BlockPos breakingPos) {
        TreeCutter.findTree((BlockGetter)level, breakingPos).destroyBlocks(level, null, this::dropItemFromCutTree);
    }

    public void dropItemFromCutTree(BlockPos pos, ItemStack stack) {
        float distance = (float)Math.sqrt(pos.distSqr((Vec3i)this.breakingPos));
        Vec3 dropPos = new Vec3((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f));
        ItemEntity entity = new ItemEntity(this.level, dropPos.x, dropPos.y, dropPos.z, stack);
        this.level.addFreshEntity((Entity)entity);
    }

    protected boolean shouldRun() {
        if (this.isParent) {
            return true;
        }
        return !this.boundPos.isEmpty() && this.boundPos.get(0) != null;
    }

    protected BlockPos getBreakingPos() {
        return this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING));
    }

    public void destroyNextTick() {
        this.ticksUntilNextProgress = 1;
    }

    private boolean posEquals(BlockPos pos, BlockPos pos2) {
        return pos.getX() == pos2.getX() && pos.getY() == pos2.getY() && pos.getZ() == pos2.getZ();
    }

    public void tick() {
        float blockHardness;
        if (this.shouldRun() && this.ticksUntilNextProgress < 0) {
            this.destroyNextTick();
        }
        if (!this.shouldRun()) {
            return;
        }
        BlockPos lastPos = this.breakingPos;
        this.breakingPos = null;
        if (this.ticksUntilNextProgress < 0) {
            return;
        }
        if (this.ticksUntilNextProgress-- > 0) {
            return;
        }
        BlockPos thisPos = this.getBlockPos();
        for (BlockPos pos : this.boundPos) {
            if (this.posEquals(thisPos, pos)) continue;
            Vec3 vec3_1 = HexereiUtil.getCenterOf((Vec3i)thisPos);
            Vec3 vec3_2 = HexereiUtil.getCenterOf((Vec3i)pos);
            Vec3 vec3_3 = vec3_2.subtract(vec3_1).normalize();
            Vec3 vec3_4 = vec3_1.subtract(vec3_2).normalize();
            BlockHitResult result = this.level.clip(new ClipContext(vec3_1.add(vec3_3), HexereiUtil.getCenterOf((Vec3i)pos).subtract(vec3_4), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, CollisionContext.empty()));
            if (result.getType() == HitResult.Type.BLOCK && !this.posEquals(result.getBlockPos(), pos) && !this.posEquals(result.getBlockPos(), thisPos)) {
                this.breakingPos = result.getBlockPos();
                this.level.addParticle((ParticleOptions)ModParticleTypes.EXTINGUISH.get(), (double)((float)thisPos.getX() + 0.5f), (double)((float)thisPos.getY() + 0.5f), (double)((float)thisPos.getZ() + 0.5f), (double)((float)(pos.getX() - thisPos.getX()) / 50.0f), (double)((float)(pos.getY() - thisPos.getY()) / 50.0f), (double)((float)(pos.getZ() - thisPos.getZ()) / 50.0f));
            }
            if (this.posEquals(pos, thisPos)) continue;
            this.level.addParticle((ParticleOptions)ModParticleTypes.EXTINGUISH.get(), (double)((float)thisPos.getX() + 0.5f), (double)((float)thisPos.getY() + 0.5f), (double)((float)thisPos.getZ() + 0.5f), (double)((float)(pos.getX() - thisPos.getX()) / 50.0f), (double)((float)(pos.getY() - thisPos.getY()) / 50.0f), (double)((float)(pos.getZ() - thisPos.getZ()) / 50.0f));
        }
        if (this.breakingPos == null) {
            this.destroyProgress = 0.0f;
            return;
        }
        BlockState stateToBreak = this.level.getBlockState(this.breakingPos);
        if (!this.canBreak(stateToBreak, blockHardness = stateToBreak.getDestroySpeed((BlockGetter)this.level, this.breakingPos))) {
            if (this.destroyProgress != 0.0f) {
                this.destroyProgress = 0.0f;
                if (!this.level.isClientSide) {
                    this.level.destroyBlockProgress(this.breakerId, this.breakingPos, -1);
                }
            }
            return;
        }
        float breakSpeed = this.getBreakSpeed();
        this.destroyProgress += Mth.clamp((float)(breakSpeed / blockHardness), (float)0.0f, (float)(10.0f - this.destroyProgress));
        if (!this.level.isClientSide) {
            this.level.playSound(null, this.worldPosition, stateToBreak.getSoundType().getHitSound(), SoundSource.NEUTRAL, 0.25f, 1.0f);
        }
        if (this.destroyProgress >= 10.0f) {
            if (!this.level.isClientSide) {
                this.onBlockBroken(stateToBreak);
            }
            this.destroyProgress = 0.0f;
            this.ticksUntilNextProgress = -1;
            if (!this.level.isClientSide) {
                this.level.destroyBlockProgress(this.breakerId, this.breakingPos, -1);
            }
            return;
        }
        this.ticksUntilNextProgress = (int)(blockHardness / breakSpeed);
        if (!this.level.isClientSide) {
            this.level.destroyBlockProgress(this.breakerId, this.breakingPos, (int)this.destroyProgress);
        }
    }

    public boolean canBreak(BlockState stateToBreak, float blockHardness) {
        return CuttingCrystalTile.isBreakable(stateToBreak, blockHardness);
    }

    public static boolean isBreakable(BlockState stateToBreak, float blockHardness) {
        return !(stateToBreak.getBlock() instanceof AirBlock) && blockHardness != -1.0f && (stateToBreak.is(BlockTags.LOGS) || stateToBreak.is(BlockTags.LEAVES));
    }

    public void onBlockBroken(BlockState stateToBreak) {
        BlockPos pos = this.getBlockPos();
        Vec3 vec = HexereiUtil.offsetRandomly(HexereiUtil.getCenterOf((Vec3i)this.breakingPos), this.level.random, 0.125f);
        HexereiUtil.destroyBlock(this.level, this.breakingPos, 1.0f, stack -> {
            if (stack.isEmpty()) {
                return;
            }
            if (!this.level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
                return;
            }
            if (this.level.restoringBlockSnapshots) {
                return;
            }
            ItemEntity itementity = new ItemEntity(this.level, vec.x, vec.y, vec.z, stack);
            itementity.setDefaultPickUpDelay();
            itementity.setDeltaMovement(Vec3.ZERO);
            this.level.addFreshEntity((Entity)itementity);
        });
        if (stateToBreak.is(BlockTags.LOGS)) {
            TreeCutter.findTree((BlockGetter)this.level, this.breakingPos).destroyBlocks(this.level, null, this::dropItemFromCutTree);
        }
    }

    protected float getBreakSpeed() {
        return Math.abs(1.0f);
    }

    public void setChanged() {
        super.setChanged();
    }

    public CuttingCrystalTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.CUTTING_CRYSTAL_TILE.get(), blockPos, blockState);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return super.getUpdateTag(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (tag, registryAccess) -> this.getUpdateTag((HolderLookup.Provider)registryAccess));
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.position().x() - (double)pos.getX() - 0.5;
        double deltaY = entity.position().y() - (double)pos.getY() - 0.5;
        double deltaZ = entity.position().z() - (double)pos.getZ() - 0.5;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public static double getDistance(float x1, float y1, float x2, float y2) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public float getAngle(Vec3 pos) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.z() - (double)this.getBlockPos().getZ() - 0.5, pos.x() - (double)this.getBlockPos().getX() - 0.5));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public Vec3 rotateAroundVec(Vec3 vector3dCenter, float rotation, Vec3 vector3d) {
        Vec3 newVec = vector3d.subtract(vector3dCenter);
        newVec = newVec.yRot(rotation / 180.0f * (float)Math.PI);
        newVec = newVec.add(vector3dCenter);
        return newVec;
    }
}

