/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.owl.ClientOwlCourierDepotData;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotData;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotSavedData;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.OpenOwlCourierDepotNameEditorPacket;
import net.joefoxe.hexerei.util.message.TESyncPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class OwlCourierDepotTile
extends RandomizableContainerBlockEntity
implements Clearable,
MenuProvider {
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);

    public OwlCourierDepotTile(BlockEntityType<?> tileEntityTypeIn, BlockPos blockPos, BlockState blockState) {
        super(tileEntityTypeIn, blockPos, blockState);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider reg) {
        return this.save(new CompoundTag(), reg);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (tag, registryAccess) -> this.getUpdateTag((HolderLookup.Provider)registryAccess));
    }

    public void setChanged() {
        super.setChanged();
        this.sync();
    }

    public void sync() {
        if (this.level != null) {
            if (!this.level.isClientSide) {
                CompoundTag tag = new CompoundTag();
                this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
                HexereiPacketHandler.sendToNearbyClient(this.level, this.worldPosition, (CustomPacketPayload)new TESyncPacket(this.worldPosition, tag));
            }
            if (this.level != null) {
                this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 2);
            }
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider reg) {
        super.saveAdditional(tag, reg);
        return tag;
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider reg) {
        super.saveAdditional(pTag, reg);
        ContainerHelper.saveAllItems((CompoundTag)pTag, this.items, (HolderLookup.Provider)reg);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemInteractionResult interact(Player player, InteractionHand handIn) {
        GlobalPos globalPos = GlobalPos.of((ResourceKey)this.getLevel().dimension(), (BlockPos)this.getBlockPos());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (OwlCourierDepotSavedData.get().getDepots().containsKey(globalPos)) {
                OwlCourierDepotData depot = OwlCourierDepotSavedData.get().getDepots().get(globalPos);
                if (((ItemStack)depot.items.get(0)).isEmpty()) return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                ItemStack stack = depot.takeFirstSlotAndSlide();
                if (player.getItemInHand(handIn).isEmpty()) {
                    player.setItemInHand(handIn, stack);
                } else {
                    player.getInventory().placeItemBackInInventory(stack);
                }
                OwlCourierDepotSavedData.get().syncInvToClient(globalPos);
                OwlCourierDepotSavedData.get().setDirty();
                return ItemInteractionResult.SUCCESS;
            }
            HexereiPacketHandler.sendToPlayerClient(new OpenOwlCourierDepotNameEditorPacket(this.getBlockPos()), serverPlayer);
            return ItemInteractionResult.SUCCESS;
        }
        if (!ClientOwlCourierDepotData.getDepots().containsKey(globalPos)) return ItemInteractionResult.SUCCESS;
        OwlCourierDepotData depot = ClientOwlCourierDepotData.getDepots().get(globalPos);
        if (((ItemStack)depot.items.get(0)).isEmpty()) return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        return ItemInteractionResult.SUCCESS;
    }

    protected Component getDefaultName() {
        return null;
    }

    protected AbstractContainerMenu createMenu(int i, Inventory inventory) {
        return null;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack itemstack;
        this.unpackLootTable(null);
        ItemStack itemStack = itemstack = index >= 0 && index < this.items.size() && !((ItemStack)this.items.get(index)).isEmpty() && count > 0 ? ((ItemStack)this.getItems().get(index)).split(count) : ItemStack.EMPTY;
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ContainerHelper.takeItem(this.items, (int)index);
    }

    public ItemStack getItem(int index) {
        this.unpackLootTable(null);
        return (ItemStack)this.items.get(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.unpackLootTable(null);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.items.set(index, (Object)stack);
        this.setChanged();
    }

    protected void setItems(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
        this.setChanged();
    }

    public void clearContent() {
        super.clearContent();
        this.setChanged();
    }

    public OwlCourierDepotTile(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)ModTileEntities.OWL_COURIER_DEPOT_TILE.get(), blockPos, blockState);
    }

    public float getAngle(Vec3 pos) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.z() - (double)this.worldPosition.getZ() - 0.5, pos.x() - (double)this.worldPosition.getX() - 0.5));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public void tick() {
    }

    public int getContainerSize() {
        return 1;
    }
}

