/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;

public class AskForSyncPacket
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, AskForSyncPacket> CODEC = StreamCodec.ofMember(AskForSyncPacket::encode, AskForSyncPacket::new);
    public static final CustomPacketPayload.Type<AskForSyncPacket> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("ask_for_sync"));
    int sourceId;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public AskForSyncPacket(Entity entity) {
        this.sourceId = entity.getId();
    }

    public AskForSyncPacket(RegistryFriendlyByteBuf buf) {
        this.sourceId = buf.readInt();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.sourceId);
    }

    @Override
    public void onServerReceived(MinecraftServer server, ServerPlayer player) {
        TamableAnimal crow;
        Entity entity = player.level().getEntity(this.sourceId);
        if (entity instanceof CrowEntity) {
            crow = (CrowEntity)entity;
            crow.sync();
        }
        if ((entity = player.level().getEntity(this.sourceId)) instanceof OwlEntity) {
            crow = (OwlEntity)entity;
            crow.sync();
        }
    }
}

