/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import net.joefoxe.hexerei.tileentity.CofferTile;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CofferSyncCrowButtonToServer
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, CofferSyncCrowButtonToServer> CODEC = StreamCodec.ofMember(CofferSyncCrowButtonToServer::encode, CofferSyncCrowButtonToServer::new);
    public static final CustomPacketPayload.Type<CofferSyncCrowButtonToServer> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("coffer_sync_crow_button"));
    BlockPos cofferTile;
    int toggled;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public CofferSyncCrowButtonToServer(CofferTile cofferTile, int toggled) {
        this.cofferTile = cofferTile.getBlockPos();
        this.toggled = toggled;
    }

    public CofferSyncCrowButtonToServer(RegistryFriendlyByteBuf buf) {
        this.cofferTile = buf.readBlockPos();
        this.toggled = buf.readInt();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.cofferTile);
        buffer.writeInt(this.toggled);
    }

    @Override
    public void onServerReceived(MinecraftServer server, ServerPlayer player) {
        BlockEntity blockEntity = player.level().getBlockEntity(this.cofferTile);
        if (blockEntity instanceof CofferTile) {
            CofferTile coffer = (CofferTile)blockEntity;
            coffer.setButtonToggled(this.toggled);
        }
    }
}

