/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.UUID;
import net.joefoxe.hexerei.item.ModDataComponents;
import net.joefoxe.hexerei.item.data_components.FluteData;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CrowFluteCommandSyncToServer
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, CrowFluteCommandSyncToServer> CODEC = StreamCodec.ofMember(CrowFluteCommandSyncToServer::encode, CrowFluteCommandSyncToServer::new);
    public static final CustomPacketPayload.Type<CrowFluteCommandSyncToServer> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("crow_flute_command_server"));
    ItemStack flute;
    int command;
    UUID entityId;
    int hand;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public CrowFluteCommandSyncToServer(ItemStack flute, int command, UUID entityId, int hand) {
        this.flute = flute;
        this.command = command;
        this.entityId = entityId;
        this.hand = hand;
    }

    public CrowFluteCommandSyncToServer(RegistryFriendlyByteBuf buf) {
        this.flute = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
        this.command = buf.readInt();
        this.entityId = buf.readUUID();
        this.hand = buf.readInt();
    }

    public void encode(RegistryFriendlyByteBuf buffer) {
        ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)this.flute);
        buffer.writeInt(this.command);
        buffer.writeUUID(this.entityId);
        buffer.writeInt(this.hand);
    }

    public static CrowFluteCommandSyncToServer decode(RegistryFriendlyByteBuf buffer) {
        return new CrowFluteCommandSyncToServer(buffer);
    }

    @Override
    public void onServerReceived(MinecraftServer server, ServerPlayer player) {
        Player player2 = player.level().getPlayerByUUID(this.entityId);
        if (player2 instanceof Player) {
            Player player1 = player2;
            if (this.hand == 0) {
                stack = player1.getMainHandItem();
                if (stack.getItem() == this.flute.getItem()) {
                    FluteData fluteData = (FluteData)stack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.empty());
                    fluteData = new FluteData(this.command, fluteData.helpCommandSelected(), fluteData.commandMode(), fluteData.crowList(), fluteData.dyeColor1(), fluteData.dyeColor2());
                    stack.set(ModDataComponents.FLUTE, (Object)fluteData);
                    player1.setItemInHand(InteractionHand.MAIN_HAND, stack);
                }
            } else {
                stack = player1.getOffhandItem();
                if (player1.getOffhandItem().getItem() == this.flute.getItem()) {
                    FluteData fluteData = (FluteData)stack.getOrDefault(ModDataComponents.FLUTE, (Object)FluteData.empty());
                    fluteData = new FluteData(this.command, fluteData.helpCommandSelected(), fluteData.commandMode(), fluteData.crowList(), fluteData.dyeColor1(), fluteData.dyeColor2());
                    stack.set(ModDataComponents.FLUTE, (Object)fluteData);
                    player1.setItemInHand(InteractionHand.OFF_HAND, stack);
                }
            }
        }
    }
}

