/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import net.joefoxe.hexerei.events.CrowWhitelistEvent;
import net.joefoxe.hexerei.util.AbstractPacket;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerWhitelistingForCrowSyncToServer
extends AbstractPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayerWhitelistingForCrowSyncToServer> CODEC = StreamCodec.ofMember(PlayerWhitelistingForCrowSyncToServer::encode, PlayerWhitelistingForCrowSyncToServer::new);
    public static final CustomPacketPayload.Type<PlayerWhitelistingForCrowSyncToServer> TYPE = new CustomPacketPayload.Type(HexereiUtil.getResource("player_whitelisting_crow_server"));
    boolean whitelisting;

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public PlayerWhitelistingForCrowSyncToServer(boolean whitelisting) {
        this.whitelisting = whitelisting;
    }

    public PlayerWhitelistingForCrowSyncToServer(RegistryFriendlyByteBuf buf) {
        this.whitelisting = buf.readBoolean();
    }

    public static void encode(PlayerWhitelistingForCrowSyncToServer object, FriendlyByteBuf buffer) {
        buffer.writeBoolean(object.whitelisting);
    }

    @Override
    public void onServerReceived(MinecraftServer server, ServerPlayer player) {
        if (this.whitelisting) {
            CrowWhitelistEvent.playersActivelyWhitelisting.add((Player)player);
        } else {
            CrowWhitelistEvent.playersActivelyWhitelisting.remove(player);
        }
    }
}

