/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.processor;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MahoganyLog;
import net.joefoxe.hexerei.block.custom.WillowLog;
import net.joefoxe.hexerei.world.processor.ModStructureProcessors;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@MethodsReturnNonnullByDefault
public class WitchHutLegProcessor
extends StructureProcessor {
    public static final MapCodec<WitchHutLegProcessor> CODEC = MapCodec.unit(WitchHutLegProcessor::new);

    @ParametersAreNonnullByDefault
    public StructureTemplate.StructureBlockInfo process(LevelReader worldReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData, @Nullable StructureTemplate template) {
        block9: {
            WorldGenRegion worldGenRegion;
            block11: {
                WorldGenRegion worldGenRegion2;
                block10: {
                    WorldGenRegion worldGenRegion3;
                    block8: {
                        WorldGenRegion worldGenRegion4;
                        if (blockInfoGlobal.state().getBlock() != Blocks.WHITE_STAINED_GLASS_PANE) break block8;
                        BlockPos worldPos = blockInfoGlobal.pos();
                        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().set((Vec3i)worldPos);
                        if (worldReader instanceof WorldGenRegion && !(worldGenRegion4 = (WorldGenRegion)worldReader).getCenter().equals((Object)new ChunkPos((BlockPos)currentPos))) {
                            return WitchHutLegProcessor.getReturnBlock(worldPos, blockInfoGlobal.state());
                        }
                        ChunkPos currentChunkPos = new ChunkPos(blockInfoGlobal.pos());
                        ChunkAccess currentChunk = worldReader.getChunk(currentChunkPos.x, currentChunkPos.z);
                        RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
                        currentChunk.setBlockState(blockInfoGlobal.pos(), Blocks.SPRUCE_LOG.defaultBlockState(), false);
                        blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.SPRUCE_LOG.defaultBlockState(), blockInfoGlobal.nbt());
                        BlockPos.MutableBlockPos mutable = blockInfoGlobal.pos().below().mutable();
                        BlockState currBlock = worldReader.getBlockState((BlockPos)mutable);
                        while (mutable.getY() > worldReader.getMinBuildHeight() && (currBlock.canBeReplaced() || currBlock.isAir() || currBlock.is(BlockTags.LEAVES) || currBlock.is(Blocks.WATER) || currBlock.is(Blocks.LAVA))) {
                            currentChunk.setBlockState((BlockPos)mutable, Blocks.SPRUCE_LOG.defaultBlockState(), false);
                            mutable.move(Direction.DOWN);
                            currBlock = worldReader.getBlockState((BlockPos)mutable);
                        }
                        break block9;
                    }
                    if (blockInfoGlobal.state().getBlock() != Blocks.RED_STAINED_GLASS_PANE) break block10;
                    BlockPos worldPos = blockInfoGlobal.pos();
                    BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().set((Vec3i)worldPos);
                    if (worldReader instanceof WorldGenRegion && !(worldGenRegion3 = (WorldGenRegion)worldReader).getCenter().equals((Object)new ChunkPos((BlockPos)currentPos))) {
                        return WitchHutLegProcessor.getReturnBlock(worldPos, blockInfoGlobal.state());
                    }
                    ChunkPos currentChunkPos = new ChunkPos(blockInfoGlobal.pos());
                    ChunkAccess currentChunk = worldReader.getChunk(currentChunkPos.x, currentChunkPos.z);
                    RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
                    currentChunk.setBlockState(blockInfoGlobal.pos(), ((MahoganyLog)((Object)ModBlocks.MAHOGANY_LOG.get())).defaultBlockState(), false);
                    blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), ((MahoganyLog)((Object)ModBlocks.MAHOGANY_LOG.get())).defaultBlockState(), blockInfoGlobal.nbt());
                    BlockPos.MutableBlockPos mutable = blockInfoGlobal.pos().below().mutable();
                    BlockState currBlock = worldReader.getBlockState((BlockPos)mutable);
                    while (mutable.getY() > 0 && (currBlock.canBeReplaced() || currBlock.isAir() || currBlock.is(BlockTags.LEAVES) || currBlock.is(Blocks.WATER) || currBlock.is(Blocks.LAVA))) {
                        currentChunk.setBlockState((BlockPos)mutable, ((MahoganyLog)((Object)ModBlocks.MAHOGANY_LOG.get())).defaultBlockState(), false);
                        mutable.move(Direction.DOWN);
                        currBlock = worldReader.getBlockState((BlockPos)mutable);
                    }
                    break block9;
                }
                if (blockInfoGlobal.state().getBlock() != Blocks.YELLOW_STAINED_GLASS_PANE) break block11;
                BlockPos worldPos = blockInfoGlobal.pos();
                BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().set((Vec3i)worldPos);
                if (worldReader instanceof WorldGenRegion && !(worldGenRegion2 = (WorldGenRegion)worldReader).getCenter().equals((Object)new ChunkPos((BlockPos)currentPos))) {
                    return WitchHutLegProcessor.getReturnBlock(worldPos, blockInfoGlobal.state());
                }
                ChunkPos currentChunkPos = new ChunkPos(blockInfoGlobal.pos());
                ChunkAccess currentChunk = worldReader.getChunk(currentChunkPos.x, currentChunkPos.z);
                RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
                currentChunk.setBlockState(blockInfoGlobal.pos(), Blocks.AIR.defaultBlockState(), false);
                blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.AIR.defaultBlockState(), blockInfoGlobal.nbt());
                BlockPos.MutableBlockPos mutable = blockInfoGlobal.pos().below().mutable();
                BlockState currBlock = worldReader.getBlockState((BlockPos)mutable);
                while (mutable.getY() > 0 && (currBlock.canBeReplaced() || currBlock.isAir() || currBlock.is(BlockTags.LEAVES) || currBlock.is(Blocks.WATER) || currBlock.is(Blocks.LAVA))) {
                    currentChunk.setBlockState((BlockPos)mutable, Blocks.OAK_LOG.defaultBlockState(), false);
                    mutable.move(Direction.DOWN);
                    currBlock = worldReader.getBlockState((BlockPos)mutable);
                }
                break block9;
            }
            if (blockInfoGlobal.state().getBlock() != Blocks.PURPLE_STAINED_GLASS_PANE) break block9;
            BlockPos worldPos = blockInfoGlobal.pos();
            BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().set((Vec3i)worldPos);
            if (worldReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)worldReader).getCenter().equals((Object)new ChunkPos((BlockPos)currentPos))) {
                return WitchHutLegProcessor.getReturnBlock(worldPos, blockInfoGlobal.state());
            }
            ChunkPos currentChunkPos = new ChunkPos(blockInfoGlobal.pos());
            ChunkAccess currentChunk = worldReader.getChunk(currentChunkPos.x, currentChunkPos.z);
            RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
            currentChunk.setBlockState(blockInfoGlobal.pos(), ((WillowLog)((Object)ModBlocks.WILLOW_LOG.get())).defaultBlockState(), false);
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), ((WillowLog)((Object)ModBlocks.WILLOW_LOG.get())).defaultBlockState(), blockInfoGlobal.nbt());
            BlockPos.MutableBlockPos mutable = blockInfoGlobal.pos().below().mutable();
            BlockState currBlock = worldReader.getBlockState((BlockPos)mutable);
            while (mutable.getY() > 0 && (currBlock.canBeReplaced() || currBlock.isAir() || currBlock.is(BlockTags.LEAVES) || currBlock.is(Blocks.WATER) || currBlock.is(Blocks.LAVA))) {
                currentChunk.setBlockState((BlockPos)mutable, ((WillowLog)((Object)ModBlocks.WILLOW_LOG.get())).defaultBlockState(), false);
                mutable.move(Direction.DOWN);
                currBlock = worldReader.getBlockState((BlockPos)mutable);
            }
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)ModStructureProcessors.WITCH_HUT_LEG_PROCESSOR.get();
    }

    private static StructureTemplate.StructureBlockInfo getReturnBlock(BlockPos worldPos, BlockState originalReplacementState) {
        return originalReplacementState == null || originalReplacementState.is(Blocks.STRUCTURE_VOID) ? null : new StructureTemplate.StructureBlockInfo(worldPos, originalReplacementState, null);
    }
}

