/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.config;

import java.util.HashSet;
import me.ichun.mods.ichunutil.client.key.KeyBind;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.iChunUtil;

public abstract class ConfigHandler {
    private static final HashSet<ConfigHandler> SERVER_CONFIGS = new HashSet();
    public final ConfigBase config;

    protected ConfigHandler(ConfigBase config) {
        this.config = config;
        this.config.compile();
        this.init();
        if (this.config.getConfigType() == ConfigBase.Type.SERVER) {
            SERVER_CONFIGS.add(this);
        }
    }

    public abstract void init();

    public abstract Object getEventBus();

    protected void registerKeybinds() {
        for (ConfigBase.Category cat : this.config.categories) {
            for (ConfigBase.Category.Entry e : cat.getEntries()) {
                Class<?> clz = e.field.getType();
                String fieldName = e.field.getName();
                if (!clz.equals(KeyBind.class)) continue;
                try {
                    KeyBind keyBind = (KeyBind)e.field.get(this.config);
                    keyBind.register(this.getEventBus());
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    iChunUtil.LOGGER.error("Error registering keybind {} for config {}", new Object[]{fieldName, this.config.getFileName(), ex});
                }
            }
        }
    }

    protected void checkForChangesFromFile(boolean reload) {
    }

    public static void onServerConnect() {
        for (ConfigHandler handler : SERVER_CONFIGS) {
            handler.config.cache();
            handler.checkForChangesFromFile(true);
        }
    }

    public static void onServerDisconnect() {
        for (ConfigHandler handler : SERVER_CONFIGS) {
            handler.config.restoreFromCache();
        }
    }
}

