/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.misc.tile;

import com.buuz135.industrial.block.misc.MobDetectorBlock;
import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.misc.MobDetectorConfig;
import com.buuz135.industrial.module.ModuleMisc;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MobDetectorTile
extends IndustrialAreaWorkingTile<MobDetectorTile> {
    private int redstoneSignal = 0;
    private int maxProgress = MobDetectorConfig.maxProgress;
    private int powerPerOperation = MobDetectorConfig.powerPerOperation;

    public MobDetectorTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleMisc.MOB_DETECTOR, RangeManager.RangeType.BEHIND, true, 0, blockPos, blockState);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        if (this.level != null && this.level.getBlockState(this.worldPosition).getBlock() instanceof MobDetectorBlock) {
            if (this.hasEnergy(this.powerPerOperation)) {
                List living = this.level.getEntitiesOfClass(LivingEntity.class, this.getWorkingArea().bounds());
                this.redstoneSignal = Math.min(living.size(), 15);
                this.level.updateNeighborsAt(this.worldPosition, (Block)this.getBasicTileBlock());
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.powerPerOperation);
            }
            this.redstoneSignal = 0;
            this.level.updateNeighborsAt(this.worldPosition, (Block)this.getBasicTileBlock());
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Nonnull
    public MobDetectorTile getSelf() {
        return this;
    }

    public int getRedstoneSignal() {
        return this.redstoneSignal;
    }

    protected EnergyStorageComponent<MobDetectorTile> createEnergyStorage() {
        return new EnergyStorageComponent(MobDetectorConfig.maxStoredPower, 10, 20);
    }
}

