/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.generator;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.addon.SlotsScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class MycelialGeneratorCategory
implements IRecipeCategory<MycelialGeneratorRecipe> {
    private final IGuiHelper guiHelper;
    private final IMycelialGeneratorType type;
    private final RecipeType<MycelialGeneratorRecipe> recipeType;
    private final IDrawable smallTank;

    public MycelialGeneratorCategory(IMycelialGeneratorType type, IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.type = type;
        this.recipeType = RecipeType.create((String)"industrialforegoing", (String)("mycelial_" + type.getName()), MycelialGeneratorRecipe.class);
        this.smallTank = guiHelper.createDrawable(DefaultAssetProvider.DEFAULT_LOCATION, 238, 4, 12, 13);
    }

    public RecipeType<MycelialGeneratorRecipe> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return Component.translatable((String)("industrialforegoing.jei.category." + this.type.getName()));
    }

    public IDrawable getBackground() {
        int n = 20 * this.type.getInputs().length + 110;
        Objects.requireNonNull(Minecraft.getInstance().font);
        return this.guiHelper.createBlankDrawable(n, 9 * 3);
    }

    public IDrawable getIcon() {
        return null;
    }

    public IMycelialGeneratorType getType() {
        return this.type;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MycelialGeneratorRecipe recipe, IFocusGroup focuses) {
        for (int i = 0; i < this.type.getInputs().length; ++i) {
            IMycelialGeneratorType.Input input = this.type.getInputs()[i];
            if (input == IMycelialGeneratorType.Input.SLOT) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                builder.addSlot(RecipeIngredientRole.INPUT, 20 * i + 1, 9 / 2 + 1).addItemStacks(recipe.getInputItems().get(i).stream().map(ingredient -> Arrays.asList(ingredient.getItems())).flatMap(Collection::stream).collect(Collectors.toList()));
                continue;
            }
            if (input != IMycelialGeneratorType.Input.TANK) continue;
            Objects.requireNonNull(Minecraft.getInstance().font);
            builder.addSlot(RecipeIngredientRole.INPUT, 20 * i + 3, 3 + 9 / 2).setFluidRenderer(1000L, false, 12, 13).setOverlay(this.smallTank, 0, 0).addIngredients((IIngredientType)NeoForgeTypes.FLUID_STACK, recipe.getFluidItems().get(i));
        }
    }

    public void draw(MycelialGeneratorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        for (int i = 0; i < this.type.getInputs().length; ++i) {
            if (this.type.getInputs()[i] == IMycelialGeneratorType.Input.SLOT) {
                int finalI = i;
                Screen screen = Minecraft.getInstance().screen;
                Objects.requireNonNull(Minecraft.getInstance().font);
                SlotsScreenAddon.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAssetProvider)DefaultAssetProvider.DEFAULT_PROVIDER, (int)(20 * i), (int)(9 / 2), (int)0, (int)0, (int)1, integer -> Pair.of((Object)1, (Object)1), integer -> ItemStack.EMPTY, (boolean)true, integer -> new Color(this.type.getInputColors()[finalI].getFireworkColor()), integer -> true, (int)1);
                continue;
            }
            if (this.type.getInputs()[i] != IMycelialGeneratorType.Input.TANK) continue;
            Screen screen = Minecraft.getInstance().screen;
            IAsset iAsset = DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.TANK_SMALL);
            Objects.requireNonNull(Minecraft.getInstance().font);
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)iAsset, (int)(20 * i), (int)(9 / 2));
        }
        int x = 20 * this.type.getInputs().length + 3;
        Font font = Minecraft.getInstance().font;
        String string = String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.jei.recipe.time").getString() + String.valueOf(ChatFormatting.DARK_AQUA) + new DecimalFormat().format((double)recipe.getTicks() / 20.0) + String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"tooltip.industrialforegoing.sec_short").getString();
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.drawString(font, string, x, 9 * 0, -1, false);
        Font font2 = Minecraft.getInstance().font;
        String string2 = String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.jei.recipe.production").getString() + String.valueOf(ChatFormatting.DARK_AQUA) + recipe.getPowerTick() + String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"tooltip.industrialforegoing.fe_t").getString();
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.drawString(font2, string2, x, 9 * 1, -1, false);
        Font font3 = Minecraft.getInstance().font;
        String string3 = String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.jei.recipe.total").getString() + String.valueOf(ChatFormatting.DARK_AQUA) + new DecimalFormat().format(recipe.getTicks() * recipe.getPowerTick()) + String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.display._fe").getString();
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.drawString(font3, string3, x, 9 * 2, -1, false);
    }
}

