/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponentCategoryType;
import org.cyclops.cyclopscore.datastructure.DistinctIterator;
import org.cyclops.cyclopscore.datastructure.MultitransformIterator;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientMapMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientHashMap;
import org.cyclops.cyclopscore.ingredient.collection.IngredientMapSingleClassified;
import org.cyclops.integratedcrafting.api.recipe.IRecipeIndexModifiable;

public class RecipeIndexDefault
implements IRecipeIndexModifiable {
    private final Map<IngredientComponent<?, ?>, IIngredientMapMutable<?, ?, Set<IRecipeDefinition>>> recipeComponentIndexes = Maps.newIdentityHashMap();
    private final Set<IRecipeDefinition> recipes = Sets.newHashSet();

    @Override
    public Set<IRecipeDefinition> getRecipes() {
        return Collections.unmodifiableSet(this.recipes);
    }

    @Override
    public <T, M> Iterator<IRecipeDefinition> getRecipes(IngredientComponent<T, M> outputType, T output, M matchCondition) {
        IIngredientMapMutable<?, ?, Set<IRecipeDefinition>> index = this.recipeComponentIndexes.get(outputType);
        if (index == null) {
            return Iterators.forArray((Object[])new IRecipeDefinition[0]);
        }
        return new DistinctIterator(MultitransformIterator.flattenIterableIterator((Iterator)Iterators.transform((Iterator)index.iterator(output, matchCondition), entry -> (Set)entry.getValue())), true);
    }

    @Nullable
    protected <T, M> IIngredientMapMutable<T, M, Set<IRecipeDefinition>> initializeIndex(IngredientComponent<T, M> recipeComponent) {
        if (recipeComponent.getCategoryTypes().size() == 1) {
            return new IngredientHashMap(recipeComponent);
        }
        return new IngredientMapSingleClassified(recipeComponent, () -> new IngredientHashMap(recipeComponent), (IngredientComponentCategoryType)recipeComponent.getCategoryTypes().get(0));
    }

    @Override
    public void addRecipe(IRecipeDefinition prioritizedRecipe) {
        this.recipes.add(prioritizedRecipe);
        for (IngredientComponent recipeComponent : prioritizedRecipe.getOutput().getComponents()) {
            IIngredientMapMutable index = this.recipeComponentIndexes.computeIfAbsent(recipeComponent, this::initializeIndex);
            if (index == null) continue;
            this.addRecipeForComponent(index, prioritizedRecipe);
        }
    }

    protected <T, M> void addRecipeForComponent(IIngredientMapMutable<T, M, Set<IRecipeDefinition>> index, IRecipeDefinition prioritizedRecipe) {
        for (Object instance : prioritizedRecipe.getOutput().getInstances(index.getComponent())) {
            Set set = (Set)index.get(instance);
            if (set == null) {
                set = Sets.newLinkedHashSet();
                index.put(instance, (Object)set);
            }
            set.add(prioritizedRecipe);
        }
    }

    @Override
    public void removeRecipe(IRecipeDefinition prioritizedRecipe) {
        this.recipes.remove(prioritizedRecipe);
        for (IngredientComponent recipeComponent : prioritizedRecipe.getOutput().getComponents()) {
            IIngredientMapMutable<?, ?, Set<IRecipeDefinition>> index = this.recipeComponentIndexes.get(recipeComponent);
            if (index == null) continue;
            this.removeRecipeForComponent(index, prioritizedRecipe);
        }
    }

    protected <T, M> void removeRecipeForComponent(IIngredientMapMutable<T, M, Set<IRecipeDefinition>> index, IRecipeDefinition prioritizedRecipe) {
        for (Object instance : prioritizedRecipe.getOutput().getInstances(index.getComponent())) {
            Set set = (Set)index.get(instance);
            if (set == null || !set.remove(prioritizedRecipe) || !set.isEmpty()) continue;
            index.remove(instance);
        }
    }
}

